#include "stdafx.h"
#include "XMLElement.h"

CArchive& operator<<(CArchive& rArchive, const CXMLElement& rXMLElement)
{
    CXMLElement& rElement = const_cast<CXMLElement&>(rXMLElement);

	CString strFormattedOutput  = "";
    CString strElementName      = "";
    CString strElementValue     = "";

    if (rElement.m_stlStrElementName != _FSI_STL::string(""))
    {
        strElementName.Format("%s",
                               rElement.m_stlStrElementName.c_str());
    }

    if (rElement.m_stlStrElementValue != _FSI_STL::string(""))
    {
        strElementValue.Format("%s",
                               rElement.m_stlStrElementValue.c_str());
    }

    if (strstr(strElementName,"HELP") != NULL)
    {
        return (rArchive);
    }

    strFormattedOutput.Format("<%s", strElementName);

    if (rElement.m_pmapXMLAttributes != NULL)
    {
        STRING2STRING_MAP::iterator str2StrMapIt = 
                                        rElement.m_pmapXMLAttributes->begin();

        STRING2STRING_MAP::iterator endStrMapIt = 
                                        rElement.m_pmapXMLAttributes->end();

        CString strAttribute;
        while (str2StrMapIt != endStrMapIt)
        {
            strAttribute.Format(" %s=\"%s\"",(*str2StrMapIt).first.c_str(),
                                             (*str2StrMapIt).second.c_str());
            strFormattedOutput += strAttribute;
            str2StrMapIt++;
        }
    }

    strFormattedOutput += ">" + strElementValue + "</" + strElementName + 
                            ">\r\n";

	rArchive.WriteString(strFormattedOutput);

	return (rArchive);
}

/*
CArchive& operator>>(CArchive& rArchive, CXMLElement& rXMLElement)
{
	return (rArchive);
}
*/

CXMLElement::CXMLElement() :    m_stlStrElementName(""), 
                                m_stlStrElementValue(""),
                                m_pmapXMLAttributes(NULL)
{
}
                         
CXMLElement::CXMLElement(const _FSI_STL::string& stlStrName,
                         const _FSI_STL::string& stlStrValue)  :
                                   m_stlStrElementName(stlStrName), 
                                   m_stlStrElementValue(stlStrValue),
                                   m_pmapXMLAttributes(NULL)
{
}

CXMLElement::CXMLElement(const CXMLElement& rXMLElement) :   
                                m_stlStrElementName(""), 
                                m_stlStrElementValue(""),
                                m_pmapXMLAttributes(NULL)
{
    *this = rXMLElement;
}

CXMLElement::~CXMLElement()
{
    if (m_pmapXMLAttributes != NULL)
    { 
        m_pmapXMLAttributes->clear();
        delete m_pmapXMLAttributes;
        m_pmapXMLAttributes = NULL;
    }
}

CXMLElement& CXMLElement::operator=(const CXMLElement& rXMLElement)
{
	// no work if they are the same
	if (this != &rXMLElement)
	{
        if (m_pmapXMLAttributes != NULL)
        {
            m_pmapXMLAttributes->clear();

            if (rXMLElement.m_pmapXMLAttributes == NULL)
            {
                delete m_pmapXMLAttributes;
                m_pmapXMLAttributes = NULL;
            }
            else
            {
                // Copy attributes one by one.
                STRING2STRING_MAP::const_iterator mIt = 
                                     rXMLElement.m_pmapXMLAttributes->begin();
                STRING2STRING_MAP::const_iterator mendIt = 
                                     rXMLElement.m_pmapXMLAttributes->end();
                while (mIt != mendIt)
                {
                    (*m_pmapXMLAttributes)[(*mIt).first] = (*mIt).second;
                    mIt++;
                }
            }
        }
        else
        {
            if (rXMLElement.m_pmapXMLAttributes != NULL)
            {
                m_pmapXMLAttributes = new STRING2STRING_MAP;

                // Copy attributes one by one.
                STRING2STRING_MAP::const_iterator mIt = 
                                     rXMLElement.m_pmapXMLAttributes->begin();
                STRING2STRING_MAP::const_iterator mendIt = 
                                     rXMLElement.m_pmapXMLAttributes->end();
                while (mIt != mendIt)
                {
                    (*m_pmapXMLAttributes)[(*mIt).first] = (*mIt).second;
                    mIt++;
                }
            }
        }

        m_stlStrElementName = rXMLElement.m_stlStrElementName;

        m_stlStrElementValue = rXMLElement.m_stlStrElementValue;
	}

	return *this;
}

bool CXMLElement::operator==(const CXMLElement& rXMLElement)
{
    if (m_pmapXMLAttributes != NULL && rXMLElement.m_pmapXMLAttributes != NULL)
    {
        if (m_pmapXMLAttributes->size() == rXMLElement.m_pmapXMLAttributes->size())
        {
            STRING2STRING_MAP::iterator m1It = m_pmapXMLAttributes->begin();
            STRING2STRING_MAP::iterator m1endIt = m_pmapXMLAttributes->end();
            STRING2STRING_MAP::const_iterator m2It = 
                                            rXMLElement.m_pmapXMLAttributes->begin();
            while (m1It != m1endIt)
            {
                if ((*m1It).first   != (*m2It).first ||
                    (*m1It).second  != (*m2It).second)
                {
                    return false;
                }
                m1It++;
                m2It++;
            }
        }
        else
        {
            // Different size
            return false;
        }
    }
    else if (m_pmapXMLAttributes != rXMLElement.m_pmapXMLAttributes)
    {
        return false;
    }

    if (m_stlStrElementName != rXMLElement.m_stlStrElementName)
    {
        return false;
    }

    if (m_stlStrElementValue != rXMLElement.m_stlStrElementValue)
    {
        return false;
    }

    return true;
}

void CXMLElement::AddElementValue(const _FSI_STL::string& rstlStrElementValue)
{
    m_stlStrElementValue = rstlStrElementValue;
}

void CXMLElement::SetAttributes(STRING2STRING_MAP* pMapXMLAttributes)
{
    if (m_pmapXMLAttributes != NULL)
    {
        delete m_pmapXMLAttributes;
    }

    m_pmapXMLAttributes = pMapXMLAttributes;
}

STRING2STRING_MAP CXMLElement::GetAttributes()
{
    STRING2STRING_MAP s2smap;
    if (m_pmapXMLAttributes != NULL)
    {
        s2smap = *m_pmapXMLAttributes;
    }

    return s2smap;
}

const _FSI_STL::string& CXMLElement::ElementName() 
{ 
    return m_stlStrElementName; 
}

const _FSI_STL::string& CXMLElement::ElementValue() 
{ 
    return m_stlStrElementValue; 
}

bool CXMLElement::FindAttribute(STRING2STRING_MAP::iterator& s2sIt,
                                const _FSI_STL::string& rstlStrAttributeName)
{
    if (m_pmapXMLAttributes == NULL)
    {
        return false;
    }

    s2sIt = m_pmapXMLAttributes->find(rstlStrAttributeName);

    if ( s2sIt == m_pmapXMLAttributes->end())
    {
        return false;
    }

    return true;
}

void CXMLElement::AddAttribute(const _FSI_STL::string& rstlStrAttributeName, 
                               const _FSI_STL::string& rstlStrAttributeValue)
{
    if (m_pmapXMLAttributes == NULL)
    {
        m_pmapXMLAttributes = new STRING2STRING_MAP;
    }

    (*m_pmapXMLAttributes)[rstlStrAttributeName] = rstlStrAttributeValue;
}
