/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : Widget.h
//
// Date             : 07 September 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.16 $
//
// Description      : Widget.h contains the definition of the 
//                    CWidget class.  This is the class that makes it 
//                    all happen.  It has data members that tell things 
//                    like the size of the widget on the screen, the 
//                    parent and base widgets for a series of widgets 
//                    stacked one on top of another, a list of 
//                    attributes that can have custom colors, a list of 
//                    variables that the widget expects to function 
//                    correctly, a map of widget pointers to the HWND 
//                    for the CWnd object that gets created when the 
//                    widget gets created, a map of the ultimate parent 
//                    windows (view, overlay, collars) to whether they 
//                    are redrawing, and a map of component names to a 
//                    map of directory aliases.  This is a small list 
//                    of what actually goes on in the CWidget class.  
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : _FSI_STL::map, _FSI_STL::list, _FSI_STL::string,
//                    Core::CColor, Core::CExtentsPoint, Core::CVariant,
//                    Core::CColorPage, Core::CExtentsPage, Core::CHelpPage,
//                    Core::COverlayDlg, 
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3, 4, or 5
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: Widget.h $                                                                   
// Revision 1.16  2000/06/16 20:52:55  billyb                                                                   
// Removed unneeded comma.                                                                   
// Revision 1.15  2000/06/08 06:44:55  billyb                                                                   
// Added flag to tell if a widget can be reused.                                                                   
// Revision 1.14  2000/05/03 22:37:32  billyb                                                                   
// Added member and accessor for whether the widget draws                                                                   
// with OpenGL.                                                                   
// Added member and accessor for the HWND of the parent                                                                   
// frame for use with screen dependent variables.                                                                   
// Revision 1.13  2000/03/31 22:50:15  billyb                                                                   
// Removed help variables.  Changed RectTracker to a pointer                                                                   
// that is only used when editing.  Removed brush.  Added bool                                                                   
// for telling if a repaint was needed.  Added data structures for                                                                   
// global fonts and whether an OpenGL swap is needed.  Added                                                                   
// data structure for reusable widgets.  Added InitReinit().                                                                    
// Revision 1.12  2000/03/07 07:16:54  billyb                                                                   
// Changed function signatures to eliminate warnings.                                                                   
// Revision 1.11  2000/02/08 18:38:19  billyb                                                                   
// Removed two overlay related messages.                                                                   
// Revision 1.10  2000/01/21 10:12:59  billyb                                                                   
// Restructured code to hopefully have better alignment.  Added                                                                   
// virtual Draw method.                                                                   
// Revision 1.9  1999/11/26 20:11:59  billyb                                                                   
// Disabled warning 4503 about long function names.  Added                                                                   
// virtual AddRangeData.  The default does nothing.                                                                     
// CComboWidget is the only child that overrides this.                                                                   
// Revision 1.8  1999/11/01 23:10:35  billyb                                                                   
// Removed unused variable.                                                                   
// Revision 1.7  1999/10/20 18:40:44  billyb                                                                   
// Added map of variable name to range limits.  Changed                                                                    
// accessors and mutators for range data to accept a                                                                    
// string to tell which variable to get or set range data.                                                                   
// Revision 1.6  1999/10/04 00:38:52  billyb                                                                   
// Removed m_variant_cv.  The m_variant member should                                                                   
// only be used in GetValue or a OnLButtontUp or other                                                                   
// key action handler.                                                                   
// Revision 1.5  1999/09/11 18:43:03  billyb                                                                   
// Added WM_CHANGE_VERT_COLLAR.                                                                   
// Revision 1.4  1999/09/08 04:39:27  billyb                                                                   
// Added comments and removed variables for foreground                                                                   
// and background color.  Added new map of color attribute                                                                   
// name to two CColors--one for rendering and one for                                                                    
// ChangeValue.                                                                   
/////////////////////////////////////////////////////////////////////////////
#ifndef _WIDGET_H_
#define _WIDGET_H_

#include "Color.h"
#include "ExtentsPoint.h"
#include "XMLWidget.h"
#include "BasePage.h"
#include "Action.h"
#include "ChangeValue.h"

#include "FSISuiteRectTracker.h"

#include <afxmt.h>

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

enum
{
    IDC_WIDGET = 37000
};

enum
{
    WM_DISPLAY_WIDGET_PROPS = WM_APP + 1,
    WM_DISPLAY_OVERLAY      = WM_APP + 2,
    WM_UPDATE_EDIT_VIEW     = WM_APP + 3,
    WM_OVERLAY_CLOSED       = WM_APP + 4,
    WM_CHANGE_PAGE          = WM_APP + 5,
    WM_GET_NEXT_TAB         = WM_APP + 6,
    WM_GET_PREV_TAB         = WM_APP + 7,
    WM_UPDATE_SCREEN        = WM_APP + 8,
    WM_DIALOG_HELP          = WM_APP + 9,
    WM_CHANGE_VERT_COLLAR   = WM_APP + 10,
    WM_FILE_READ_COMPLETE   = WM_APP + 11 
};

enum
{
    PERSIST     = 1,
    OK          = 2,
    CANCEL      = 4,
    APPLY       = 8,
    HORIZONTAL  = 16,
    VERTICAL    = 32,
    BOTH        = 64,
    LEFT_UP     = 128,
    RIGHT_DOWN  = 256,
    SIMPLE      = 512,
    DROPLIST    = 1024
};

enum ADDRESS_STATE
{
    VALID           = 0,
    VALID_ADDRESS   = 1,
    INVALID         = 2
};

struct ColorsWithChangeValue
{
    CColor      s_color;
    CColor      s_color_cv;
};

typedef CBasePage* (*CreatePage)();

class CRange;

class DLLAPI CWidget  
{
protected:
    // Pointer for return the CWnd part of a CWnd derived
    // widget.
    CWnd*                        m_pWnd;

    // Pointer for the property sheet for a widget and all
    // of its children.
    CWnd*                        m_pWidgetProps;

    // Pointer to an overlay that is created by an
    // action.  Currently only used by the General::COverlayAction.
    CWnd*                        m_pOverlayDlg;

    // Pointer to the absolute base CWidget for stacking of 
    // widgets and actions.
    CWidget*                     m_pBaseWidget;

    // The immediate parent widget.
    CWidget*                     m_pParentWidget;

    CWnd*                        m_pParentWnd;

    // The XMLWidget with all of the data to create the 
    // widget.
    CXMLWidget*                  m_pXMLWidget;

    // Whether the widget was created while in edit mode.
    bool                         m_bEditing;

    // Whether the left button is down.
    bool                         m_bLButtonDown;

    // Whether the left button was down during the last pass.
    bool                         m_bLButtonDownLastPass;

    // Whether the widget has focus.
    bool                         m_bFocus;

    // Pointer for return of CAction part of an action
    // since it also derives from CWidget for drag and drop
    // support.
    CAction*                     m_pAction;

    // The ID for a widget.  Used by CWnd derived widgets in
    // their Create(Ex) calls.
    long                         m_lID;

    // Whether the widget needs to be redrawn.
    bool                         m_bRedraw;

    // Whether the widget is being redrawn as part of
    // a stacked redraw.
    bool                         m_bTraverseUpdate;

    // Whether the widget is enabled.  Changed in ChangeValue.
    bool                         m_bEnabled_cv;

    // Whether the widget is enabled.  Changed in UpdateRenderVariables
    // and used during drawing.
    bool                         m_bEnabled;


    // Whether the widget is displayed.  Changed in ChangeValue.
    bool                         m_bDisplay_cv;

    // Whether the widget is enabled.  Changed in UpdateRenderVariables
    // and used during drawing.
    bool                         m_bDisplay;

    CFSISuiteRectTracker*        m_pTracker;

    bool                         m_bDrawThisPass;

    bool                         m_bRepaint;

    // Whether the widget is about to be deleted.
    bool                         m_bDeleting;

    bool                         m_bDrawsOpenGL;

    HWND                         m_hwndMainFrame;

    bool                         m_bCanBeReused;

    CCriticalSection             m_sync;
    static CCriticalSection      m_syncValidAddress;

    // The extents of the bounding rectangle for the widget.
    CExtentsPoint                m_exPtUpperLeft, m_exPtLowerRight;

    // The name given to the widget--i.e. Latitude Display.
    _FSI_STL::string             m_stlStrName;

    // The name of the widget--i.e. Text, Button, GroupBox,
    // ADI Gauge, Page, EHSI Gauge, Area Map, etc.
    _FSI_STL::string             m_stlStrWidgetName;

    _FSI_STL::list<CreatePage>   m_listWidgetPropPages;
    _FSI_STL::list<CAction*>     m_listActions;
    _FSI_STL::list<CWidget*>     m_listSubWidgets;
    STRING_LIST                  m_listGraphicalElementVars;
    STRING_LIST                  m_listColorSelectable;
    _FSI_STL::map<_FSI_STL::string, ColorsWithChangeValue> m_mapColorSelectables;
    STRING_LIST                  m_listOverlays;

    CVariant                     m_variant; 

    _FSI_STL::string             m_stlStrGlobalFont;

    // CVariants that hold the absolute min and max for
    // the ranges on the widget.
    typedef  struct   symbolLabelInfo
    {
        CVariant    s_varHigh;
        CVariant    s_varLow;
    }  RangeData;

    _FSI_STL::map<_FSI_STL::string, RangeData>     m_mapRangeData;

    static _FSI_STL::map<CWidget*, HWND> m_mapValidAddresses;
    static _FSI_STL::map<HWND, bool>     m_mapRedrawStates;
    static _FSI_STL::map<HWND, bool>     m_mapSwapNeeded;
    static _FSI_STL::map<_FSI_STL::string, STRING2STRING_MAP> m_mapDirAlias;
    static _FSI_STL::map<_FSI_STL::string, _FSI_STL::string>  m_mapGlobalFonts;

    void TraverseBaseWidgets(CWidget* pWidget, bool bMove);

    CWidget();

    virtual void InitReinit();

public:
    // 
    CWidget(const CWidget& rWidget);
    
    // Destructor
    virtual ~CWidget();
    
    // Assignment overload
    CWidget& operator=(const CWidget& rWidget);
    
    // Equals overload
    bool operator==(const CWidget& rWidget);

    virtual void Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                            const long int lId, bool bEditMode);

    virtual void Scale(CExtentsPoint& rextPt, bool bPageLoadScale);//, long lXNewRes, 
//                       long lYNewRes);

    virtual bool UpdateRenderVariables();
    virtual void Draw();

    virtual void AddRangeData(const CRange* pRange, const _FSI_STL::string stlStrVariable);

    void AddColorPage(void);
    void ExtentsProperties(void);

    // Accessor
    CExtentsPoint&  UpperLeft();
    CExtentsPoint&  LowerRight();
    CWnd*           Wnd();
    CXMLWidget*     XMLWidget();
    CWidget*        BaseWidget();
    CWidget*        ParentWidget();
	virtual _FSI_STL::list<CreatePage>* WidgetPropPages();
    CWidget* GetNextAction(_FSI_STL::list<CAction*>::iterator& wlIt);
    CWidget* GetNextSubWidget(_FSI_STL::list<CWidget*>::iterator& wlIt);
    _FSI_STL::string WidgetName();
    _FSI_STL::string Name();
    CColor Background();
    CColor Foreground();
    CWnd* WidgetProps();
    CWnd* OverlayDlg();
    CAction* Action();
    STRING_LIST Vars();
    long ID();
    CVariant RangeLow(const _FSI_STL::string& rstlStrVariable);
    CVariant RangeHigh(const _FSI_STL::string& rstlStrVariable);
    CWnd* FrameworkParent();
    static bool ScreenRedrawing(const HWND hWnd);
    STRING_LIST& ColorSelectable();
    STRING_LIST& Overlays();
    static bool  SwapNeeded(const HWND hWnd);
    HWND MainFrameHwnd();
    
    // Mutators
    void UpperLeft(const CExtentsPoint& rexPtUpperLeft);
    void LowerRight(const CExtentsPoint& rexPtLowerRight);
    void Background(const CColor& rcolorBackground);
    void Foreground(const CColor& rcolorBackground);
    void XMLWidget(CXMLWidget* pXMLWidget);
    void WidgetProps(CWnd* pWnd);
    void OverlayDlg(CWnd* pWnd);
    virtual void Deleting(bool bDeleting);
    void RangeLow(const _FSI_STL::string& rstlStrVariable, 
                  const CVariant& rvarRangeLow);
    void RangeHigh(const _FSI_STL::string& rstlStrVariable, 
                   const CVariant& rvarRangeHigh);
    void FrameworkParent(const CWnd* pFrameworkWnd);
    static void ScreenRedrawing(const HWND hWnd, const bool bScreenRedrawing);
    static void SwapNeeded(const HWND hWnd, bool bSwapNeeded);

    void Track(CPoint point);
    void PosChanged(const CRect& rWindowRect);
    void BaseWidget(CWidget* pBaseWidget);
    void ParentWidget(CWidget* pParentWidget);
    void AddWidget(const CWidget* pWidget);
    void AddAction(const CAction* pAction);

    static void Directories(const _FSI_STL::string& rstlStrComponentName, 
                            STRING2STRING_MAP* pmapDir);

    void DeleteWidget(const CWidget* pWidget);
    void DeleteAction(const CAction* pAction);
    static void ExpandPath(CString& strCompressedPath);

    static ADDRESS_STATE IsValidAddress(const CWidget* pWidget);
    static void ResetFonts();

    virtual void ResetProperties();
    virtual void ChangeValue(const CString& rstrElementVar, 
                             CChangeValue* pCV);

    virtual bool DrawsOpenGL();

    virtual CVariant* GetValue(const CString& rstrElementVar);
	void RButtonUp(UINT nFlags, CPoint point);

    static _FSI_STL::map<_FSI_STL::string, _FSI_STL::map<HWND, _FSI_STL::list<CWidget*> > > m_mapReusableWidgets;

    bool GetEditing(void);
};

#endif // #ifnder _WIDGET_H_


