/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : Widget.cpp
//
// Date             : 07 September 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.18 $
//
// Description      : Widget.cpp contains the implementation of the 
//                    CWidget class.  This is the class that makes it 
//                    all happen.  It has data members that tell things 
//                    like the size of the widget on the screen, the 
//                    parent and base widgets for a series of widgets 
//                    stacked one on top of another, a list of 
//                    attributes that can have custom colors, a list of 
//                    variables that the widget expects to function 
//                    correctly, a map of widget pointers to the HWND 
//                    for the CWnd object that gets created when the 
//                    widget gets created, a map of the ultimate parent 
//                    windows (view, overlay, collars) to whether they 
//                    are redrawing, and a map of component names to a 
//                    map of directory aliases.  This is a small list 
//                    of what actually goes on in the CWidget class.  
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : _FSI_STL::map, _FSI_STL::list, _FSI_STL::string,
//                    Core::CColor, Core::CExtentsPoint, Core::CVariant,
//                    Core::CColorPage, Core::CExtentsPage, Core::CHelpPage,
//                    Core::COverlayDlg, 
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3, 4, or 5
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: Widget.cpp $                                                                   
// Revision 1.18  2000/06/08 06:45:19  billyb                                                                   
// Added flag to tell if a widget can be reused.                                                                   
// Revision 1.17  2000/05/26 16:34:38  billyb                                                                   
// Commented out offset move of widgets on top of widgets.                                                                   
// Revision 1.16  2000/05/04 17:46:20  billyb                                                                   
// Fixed editor problem with widgets always in upper left.                                                                   
// Added parent frame HWND.  Added whether draws OpenGL.                                                                   
// Added guard for setting name of widget in Initialize.                                                                   
// Revision 1.15  2000/03/31 22:52:35  billyb                                                                   
// Removed help variables.  Changed RectTracker to a pointer                                                                   
// that is only used when editing.  Removed brush.  Added bool                                                                   
// for telling if a repaint was needed.  Added data structures for                                                                   
// global fonts and whether an OpenGL swap is needed.  Added                                                                   
// data structure for reusable widgets.  Added InitReinit().  Deleting                                                                   
// will reuse widgets from the view.  Global fonts are read once from                                                                   
// the registry.  Moved EnableWindow out of UpdateRenderVariables.                                                                    
// Revision 1.14  2000/03/07 07:17:36  billyb                                                                   
// Changed function signatures to eliminate warnings.                                                                   
// Changed call to AddElementValue.                                                                   
// Revision 1.13  2000/01/21 10:13:53  billyb                                                                   
// Added virtual draw method.  Prevented multiple draws during                                                                   
// a single redraw pass.                                                                   
// Revision 1.12  1999/11/26 20:11:47  billyb                                                                   
// Disabled warning 4503 about long function names.  Added                                                                   
// virtual AddRangeData.  The default does nothing.                                                                     
// CComboWidget is the only child that overrides this.                                                                   
// Revision 1.11  1999/11/04 20:10:17  billyb                                                                   
// Changed for loops to while to decrease calls to data structure                                                                   
// end().  Commented out lines when a widget is destroyed that                                                                   
// are not currently needed (and may never be).                                                                   
// Revision 1.10  1999/10/24 20:33:34  billyb                                                                   
// Changed uppercase code in Initialize.                                                                   
// Revision 1.9  1999/10/23 23:44:21  billyb                                                                   
// Changed STRING2STRING_MAP variables to pointers                                                                   
// in ResetProperties to prevent extra copying of maps.                                                                   
// Revision 1.8  1999/10/20 18:41:24  billyb                                                                   
// Changed RangeHigh and RangeLow methods to work with                                                                   
// the new map of variable name to range data.                                                                   
// Revision 1.7  1999/10/04 00:38:50  billyb                                                                   
// Removed m_variant_cv.  The m_variant member should                                                                   
// only be used in GetValue or a OnLButtontUp or other                                                                   
// key action handler.                                                                   
// Revision 1.6  1999/09/13 19:38:55  billyb                                                                   
// Made sure that widget name was upper case when                                                                    
// creating a CXMLWidget in Initialize.  This fixed a                                                                    
// problem with Undo.                                                                   
// Revision 1.5  1999/09/08 04:41:29  billyb                                                                   
// Added comments and removed variables for foreground                                                                   
// and background color.  Added new map of color attribute                                                                   
// name to two CColors--one for rendering and one for                                                                    
// ChangeValue.  Removed unused variables for global                                                                   
// color, foreground and background colors.                                                                   
/////////////////////////////////////////////////////////////////////////////
#include "stdafx.h"
#pragma warning(disable:4503) 

#include "Widget.h"

#include "ExtentsPage.h"
#include "HelpPage.h"
#include "ColorPage.h"

#include "OverlayDlg.h"

#include <algorithm>

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

_FSI_STL::map<CWidget*, HWND>    CWidget::m_mapValidAddresses;
_FSI_STL::map<HWND, bool>        CWidget::m_mapRedrawStates;
_FSI_STL::map<HWND, bool>        CWidget::m_mapSwapNeeded;
_FSI_STL::map<_FSI_STL::string, STRING2STRING_MAP> CWidget::m_mapDirAlias;
_FSI_STL::map<_FSI_STL::string, _FSI_STL::string>  CWidget::m_mapGlobalFonts;
_FSI_STL::map<_FSI_STL::string, _FSI_STL::map<HWND, _FSI_STL::list<CWidget*> > > CWidget::m_mapReusableWidgets;
CCriticalSection                                    CWidget::m_syncValidAddress;

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CWidget::CWidget() : m_exPtUpperLeft(CPoint(0,0)), m_exPtLowerRight(CPoint(100,60)),
                     m_stlStrName("*Untitled*")
{
    m_listWidgetPropPages.push_back(CExtentsPage::CreateObject);
//    m_listWidgetPropPages.push_back(CHelpPage::CreateObject);
//    m_listWidgetPropPages.push_back(CColorPage::CreateObject);

    m_listGraphicalElementVars.push_back("Default");
    m_listGraphicalElementVars.push_back("Enable/Disable");
    m_listGraphicalElementVars.push_back("Show/Hide");

    m_listColorSelectable.push_back("Background");
    m_listColorSelectable.push_back("Foreground");

    m_listOverlays.push_back("Default_Overlay");

    // Must be set once for the InitReinit code to work
    // correctly.
    m_pTracker          = NULL;

    // Only needed once.  The parent widget should be reset before
    // a widget is reused.
    m_pParentWidget     = NULL;

    CWidget::InitReinit();
}

void CWidget::InitReinit()
{
    m_bCanBeReused                  = false;
    m_bDrawsOpenGL                  = false;
    m_bDeleting                     = false;
    m_bDrawThisPass                 = true;
    m_bEditing                      = false;
    m_bEnabled                      = true;
    m_bEnabled_cv                   = m_bEnabled;
    m_bDisplay                      = true;
    m_bDisplay_cv                   = m_bDisplay;
    m_bFocus                        = false;
    m_bLButtonDown                  = false;
    m_bLButtonDownLastPass          = false;
    m_bRedraw                       = false;
    m_bRepaint                      = false;
    m_bTraverseUpdate               = false;

    m_hwndMainFrame                 = NULL;

    m_lID                           = 0;
    
    m_listActions.clear();
    m_mapColorSelectables.clear();
    m_listSubWidgets.clear();
    m_mapRangeData.clear();

    m_pAction                       = NULL;
    m_pBaseWidget                   = NULL;
    m_pOverlayDlg                   = NULL;
    m_pParentWnd                    = NULL;

    if (m_pTracker != NULL)
    {
        delete m_pTracker;
    }

    m_pTracker                      = NULL;
    m_pWidgetProps                  = NULL;
    m_pWnd                          = NULL;
    m_pXMLWidget                    = NULL;

    m_stlStrGlobalFont              = "Not Used";

    m_variant                       = CVariant();
}

CWidget::CWidget(const CWidget& rWidget)
{
    *this = rWidget;
}

CWidget::~CWidget()
{
    m_listWidgetPropPages.clear();
    m_listColorSelectable.clear();
    m_listOverlays.clear();
    m_listGraphicalElementVars.clear();

    m_mapColorSelectables.clear();
    m_mapRangeData.clear();
    m_listSubWidgets.clear();

    if (m_pTracker != NULL)
    {
        delete m_pTracker;
        m_pTracker = NULL;
    }
}

CWidget& CWidget::operator=(const CWidget& rWidget)
{
    // not complete
    if (this != &rWidget)
    {
        m_listColorSelectable       = rWidget.m_listColorSelectable;
        m_listGraphicalElementVars  = rWidget.m_listGraphicalElementVars;
        m_listWidgetPropPages       = rWidget.m_listWidgetPropPages;
        m_exPtUpperLeft             = rWidget.m_exPtUpperLeft;
        m_exPtLowerRight            = rWidget.m_exPtLowerRight;
        m_pWnd                      = rWidget.m_pWnd;
    }

    return *this;
}
        
bool CWidget::operator==(const CWidget& rWidget)
{
    bool bRetVal = false;

    // not complete
    if (m_exPtUpperLeft == rWidget.m_exPtUpperLeft &&
        m_exPtLowerRight == rWidget.m_exPtLowerRight &&
        m_pWnd == rWidget.m_pWnd)
    {
        bRetVal = true;
    }

    return bRetVal;
}

void CWidget::Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd,
                         const long int lId, bool bEditMode)
{
    CWidget::InitReinit();

    m_lID = lId;

    m_bEditing = bEditMode;

    if (rpXMLWidget == NULL)
    {
        if (m_stlStrName == "*Untitled*")
        {
            m_stlStrName = m_stlStrName + " " + m_stlStrWidgetName.c_str();
        }

        strupr((char*)m_stlStrWidgetName.c_str());

        rpXMLWidget = new CXMLWidget(m_stlStrWidgetName);
    }

    m_pXMLWidget = rpXMLWidget;

    if (m_pBaseWidget != NULL)
    {
        if (m_pBaseWidget->Wnd() != NULL)
        {
            m_pParentWnd = m_pBaseWidget->Wnd()->GetParent();
            m_hwndMainFrame = m_pParentWnd->GetParentFrame()->GetSafeHwnd();
        }
    }

    m_syncValidAddress.Lock();

    m_mapValidAddresses[this] = NULL;

    m_syncValidAddress.Unlock();
}

void CWidget::Track(CPoint point)
{
    if (m_pWnd != NULL && m_pTracker != NULL)
    {
        CDC* pDC = m_pWnd->GetDC();
        m_pTracker->Draw(pDC);

        if (m_pTracker->HitTest(point) < 0)
        {
            if (m_pTracker->TrackRubberBand(m_pWnd, point))
            {
                CRect rect = m_pTracker->m_rect;
                m_pTracker->Draw(pDC);
            }
        }
        else if (m_pTracker->Track(m_pWnd, point))
        {
            CRect rectWidget;

            m_pWnd->GetWindowRect(rectWidget);
            rectWidget.left += m_pTracker->m_rect.left;
            rectWidget.top += m_pTracker->m_rect.top;
            rectWidget.right = rectWidget.left + m_pTracker->m_rect.Width();
            rectWidget.bottom = rectWidget.top + m_pTracker->m_rect.Height();
            m_pWnd->GetParent()->ScreenToClient(rectWidget);

            m_pWnd->MoveWindow(rectWidget);
            m_pTracker->m_rect = CRect(0,0,rectWidget.Width(),rectWidget.Height());

            if (m_pParentWidget != NULL)
            {
                if (m_pParentWidget->Wnd() != NULL)
                {
                    m_pParentWidget->Wnd()->Invalidate(FALSE);
                }
            }
            else
            {
                m_pWnd->GetParent()->Invalidate(FALSE);
            }
        }

        m_pWnd->ReleaseDC(pDC);
    }
}

void CWidget::PosChanged(const CRect& rWindowRect)
{
    if (m_bEditing == true)
    {
        CExtentsPoint exPtNewUpper = CExtentsPoint(CPoint(rWindowRect.left,
                                               rWindowRect.top));
        CExtentsPoint exPtNewLower = CExtentsPoint(CPoint(rWindowRect.right, 
                                                rWindowRect.bottom));

        // Make sure and update is needed.
        if (!(exPtNewUpper == m_exPtUpperLeft) || 
            !(exPtNewLower == m_exPtLowerRight))
        {
            m_exPtUpperLeft = exPtNewUpper;
            m_exPtLowerRight = exPtNewLower;
            if (m_pXMLWidget != NULL)
            {
                CXMLElement* pXMLElement = NULL;
                POSITION pos = NULL;
                if (m_pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("POINT")) != 
                                                                         false)
                {
                    CString strElementValue;
                    strElementValue.Format("%d,%d",m_exPtUpperLeft.X(),
                                                   m_exPtUpperLeft.Y());
                    pXMLElement->AddElementValue(
                                      _FSI_STL::string((LPCTSTR)strElementValue));

                    if (m_pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("POINT")) !=
                                                    false)
                    {
                        strElementValue.Format("%d,%d",m_exPtLowerRight.X(),
                                                       m_exPtLowerRight.Y());
                        pXMLElement->AddElementValue(
                                      _FSI_STL::string((LPCTSTR)strElementValue));
                    }
                }
            }

            if (m_pWnd != NULL)
            {
                if (m_pWnd->GetSafeHwnd() != NULL)
                {
                    NMHDR nmhdr;
                    nmhdr.idFrom = m_pWnd->GetDlgCtrlID();
                    nmhdr.hwndFrom = m_pWnd->GetSafeHwnd();
                    nmhdr.code = WM_WINDOWPOSCHANGED;
                    m_pWnd->GetParentFrame()->SendMessage(WM_NOTIFY, 
                                                          nmhdr.idFrom, 
                                                          (long)&nmhdr);
                }
            }
        }
    }
}

void CWidget::BaseWidget(CWidget* pBaseWidget)
{
    m_sync.Lock();
    m_pBaseWidget = pBaseWidget;

    // m_pWnd == NULL means that this is an action that
    // doesn't really need to know about the framework parent.
    if (m_pBaseWidget != NULL)
    {
        if (m_pBaseWidget->Wnd() != NULL)
        {
            m_pParentWnd = m_pBaseWidget->Wnd()->GetParent();
            m_hwndMainFrame = m_pParentWnd->GetParentFrame()->GetSafeHwnd();
        }
    }

    m_sync.Unlock();
}

/////////////////////////////////////////////////////////////////////////////
//
// _FSI_STL::list<FsiSuite::CBasePage*>* CWidget::WidgetPropPages()
//
// Inputs           : None.
//
// Return Values    : A memory location for a list of pointer to methods.
//
// Date             : 6 November 1998
//
// Engineer         : Billy Baker
//
// Description      : WidgetPropPages return a pointer to a list of methods
//                    for creating property pages.
//
/////////////////////////////////////////////////////////////////////////////
_FSI_STL::list<CreatePage>* CWidget::WidgetPropPages()
{
	return &m_listWidgetPropPages;
}

CWidget* CWidget::GetNextAction(_FSI_STL::list<CAction*>::iterator& alIt) 
{
    _FSI_STL::list<CAction*>::iterator nullIt = NULL;
    if (alIt == nullIt && m_listActions.size() > 0)
    {
        alIt = m_listActions.begin();
    }
    else if (alIt == m_listActions.end() ||
             m_listActions.size() == 0)
    {
        return NULL;
    }

    CWidget* pWidget = ((CWidget*)(*alIt)->Widget());
    alIt++;
    return pWidget;
}

CWidget* CWidget::GetNextSubWidget(_FSI_STL::list<CWidget*>::iterator& wlIt) 
{ 
    _FSI_STL::list<CWidget*>::iterator nullIt = NULL;
    if (wlIt == nullIt && m_listSubWidgets.size() > 0)
    {
        wlIt = m_listSubWidgets.begin();
    }
    else if (wlIt == m_listSubWidgets.end() ||
             m_listSubWidgets.size() == 0)
    {
        return NULL;
    }

    CWidget* pWidget = *wlIt;
    wlIt++;
    return pWidget;
}

void CWidget::AddWidget(const CWidget* pWidget)
{
    if (pWidget != NULL)
    {
        m_listSubWidgets.push_back((CWidget*)pWidget);
    }
}

void CWidget::AddAction(const CAction* pAction)
{
    if (pAction != NULL)
    {
        m_listActions.push_back((CAction*)pAction);
    }
}

void CWidget::AddRangeData(const CRange* pRange, const _FSI_STL::string stlStrVariable)
{
}

void CWidget::Draw()
{
    if (m_pWnd && m_bDrawThisPass == true)
    {
        m_bDrawThisPass = false;

        m_pWnd->RedrawWindow(NULL, NULL, 
                             RDW_INTERNALPAINT | RDW_UPDATENOW | RDW_INVALIDATE);
    }
}

void CWidget::DeleteWidget(const CWidget* pWidget)
{
    if (pWidget != NULL)
    {
        _FSI_STL::list<CWidget*>::iterator lIt = 
                                        _FSI_STL::find(m_listSubWidgets.begin(), 
                                                  m_listSubWidgets.end(), 
                                                  pWidget);

        if (lIt != m_listSubWidgets.end())
        {
            m_listSubWidgets.erase(lIt);
        }
    }
}

void CWidget::DeleteAction(const CAction* pAction)
{
    if (pAction != NULL)
    {
        _FSI_STL::list<CAction*>::iterator lIt = 
                                        _FSI_STL::find(m_listActions.begin(), 
                                                  m_listActions.end(), 
                                                  pAction);

        if (lIt != m_listActions.end())
        {
            m_listActions.erase(lIt);
        }
    }
}

void CWidget::Deleting(bool bDeleting)
{
    m_bDeleting = bDeleting;

    if (m_bDeleting == true)
    {
/*
        if (m_bEditing == false)
        {
            _FSI_STL::list<CAction*>::iterator lIt = m_listActions.begin();
            _FSI_STL::list<CAction*>::iterator lendIt = m_listActions.end();
            while (lIt != lendIt)
            {
//                ((CWidget*)(*lIt)->Widget())->ParentWidget(NULL);

//                (*lIt)->OnUnload();
                lIt++;
            }
        }
*/

        // Delete the memory.  Since the valid address is not set until
        // Initialize() is called but CWidget derived classes can still
        // be created without calling Initialize, the following delete 
        // is not contained in the previous conditional.  Make sure that
        // the widget has the m_bCanBeReused flag set.
        bool bDelete    = true;
        if (true == m_bCanBeReused)
        {
            CWnd* pWnd      = NULL;
            if (m_pBaseWidget != NULL   && m_pAction == NULL && 
                m_pParentWnd != NULL    && m_bEditing == false)
            {
                if (IsWindow(m_pParentWnd->GetSafeHwnd()))
                {
                    if (dynamic_cast<CView*>(m_pParentWnd) != NULL)
                    {
                        bDelete = false;
                    }
                }
            }
        }

        m_syncValidAddress.Lock();

        if (m_mapValidAddresses.find(this) != m_mapValidAddresses.end())
        {
            m_mapValidAddresses.erase(m_mapValidAddresses.find(this));
        }
        else
        {
            // If the widget was not valid then it needs to be deleted.
            bDelete = true;
        }

        m_syncValidAddress.Unlock();

        if (true == bDelete)
        {
            delete this;
        }
        else
        {
            char cName[256];
            strcpy(cName, m_stlStrWidgetName.c_str());
            strupr(cName);
            m_mapReusableWidgets[cName][m_pParentWnd->GetSafeHwnd()].push_back(this);
        }
    }
}

/////////////////////////////////////////////////////////////////////////////
//
// bool CWidget::ScreenRedrawing()
//
// Inputs           : HWND hWnd - the window whose redraw state is desired.
//
// Return Values    : the state of the screen redraw process for the pass HWND.
//
// Date             : 07 July 1999
//
// Engineer         : Billy Baker
//
// Description      : ScreenRedrawing returns whether the passed HWND is
//                    currently in the process of updating the screen.
//
/////////////////////////////////////////////////////////////////////////////
bool CWidget::ScreenRedrawing(const HWND hWnd)
{ 
    return m_mapRedrawStates[(HWND)hWnd];
}

/////////////////////////////////////////////////////////////////////////////
//
// void CWidget::ScreenRedrawing()
//
// Inputs           : const HWND hWnd - the window whose redraw state needs
//                                      to be set.
//                    const bool bScreenRedrawing - the new redraw state.
//
// Return Values    : None.
//
// Date             : 07 July 1999
//
// Engineer         : Billy Baker
//
// Description      : ScreenRedrawing returns whether the passed HWND is
//                    currently in the process of updating the screen.
//
/////////////////////////////////////////////////////////////////////////////
void CWidget::ScreenRedrawing(const HWND hWnd, const bool bScreenRedrawing)
{
    m_mapRedrawStates[(HWND)hWnd] = (bool)bScreenRedrawing;
}

void CWidget::RButtonUp(UINT nFlags, CPoint point) 
{
    if (m_bEditing == true)
    {
        if (m_pBaseWidget->WidgetProps() == NULL)
        {
            m_pWnd->GetParentFrame()->PostMessage(WM_DISPLAY_WIDGET_PROPS, 
                                          (long)(CWidget*)this, 
                                          (long)m_pBaseWidget);
        }
    }
}

void CWidget::ResetProperties()
{
    if (true == m_mapGlobalFonts.empty())
    {
        HKEY hKey;
        RegOpenKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\FlightSafety\\FSISuite\\Settings"), 0, KEY_READ, &hKey);
        if (hKey != NULL)
        {
            long int lGlobalFontCount = 0;
            long int lGlobalFontStep = 1;
            unsigned long int ulData = 0;
            DWORD dwSize = sizeof (unsigned long int);
            RegQueryValueEx(hKey, _T("GlobalFontCount"), NULL, NULL, (BYTE*)&ulData, 
                            &dwSize);
            lGlobalFontCount = ulData;

            CString strGlobalFontXXX;
            CString strGlobalFontData;
            CString strGlobalFontName;

            for (; lGlobalFontStep <= lGlobalFontCount; lGlobalFontStep++)
            {
                strGlobalFontXXX.Format("GlobalFont%d",lGlobalFontStep);

                // Get the name of the GlobalFont.
		        CString strValue;
		        DWORD dwType, dwCount;
		        LONG lResult = RegQueryValueEx(hKey, (LPCTSTR)strGlobalFontXXX, 
                                               NULL, &dwType, NULL, &dwCount);
		        if (lResult == ERROR_SUCCESS)
		        {
			        ASSERT(dwType == REG_SZ);
			        lResult = RegQueryValueEx(hKey, (LPCTSTR)strGlobalFontXXX, 
                                              NULL, &dwType,
				                 (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)),
                                              &dwCount);

			        strValue.ReleaseBuffer();
		        }

                strGlobalFontName = strValue;

                // Get the DATA for the GlobalFont
                if (strGlobalFontName != "")
                {
                    // Code copied from GetProfileString() in CWinApp 
                    // implementation.
		            lResult = RegQueryValueEx(hKey, (LPCTSTR)strGlobalFontName, 
                                                   NULL, &dwType, NULL, &dwCount);
		            if (lResult == ERROR_SUCCESS)
		            {
			            ASSERT(dwType == REG_SZ);
			            lResult = RegQueryValueEx(hKey, (LPCTSTR)strGlobalFontName, 
                                                  NULL, &dwType,
				                 (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)),
                                                  &dwCount);

			            strValue.ReleaseBuffer();
		            }

                    strGlobalFontData = strValue;

                    m_mapGlobalFonts[(LPCTSTR)strGlobalFontName] = 
                                            _FSI_STL::string((LPCTSTR)strGlobalFontData);
                }

            }

            RegCloseKey(hKey);
        }
    }

    CXMLElement* pXMLElement    = NULL;
    POSITION pos                = NULL;

    pXMLElement = NULL;
    if (m_pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("NAME")) == true)
    {
        m_stlStrName = pXMLElement->ElementValue();
    }
    else
    {
        m_pXMLWidget->AddElement(_FSI_STL::string("NAME"), m_stlStrName, NULL);
    }
}

void CWidget::TraverseBaseWidgets(CWidget* pWidget, bool bMove)
{
    if (pWidget != NULL) 
    {
        if (pWidget != this)
        {
            pWidget->m_bTraverseUpdate = true;
            if (bMove == true)
            {
//                CRect rectChild;

//                CWnd* pWnd = pWidget->Wnd();

//                pWnd->GetWindowRect(rectChild);

//                pWidget->Wnd()->GetParent()->ScreenToClient(rectChild);

                if (m_bLButtonDown == true)
                {
//                    pWnd->MoveWindow(rectChild.left + 1, rectChild.top + 1,
//                                 rectChild.Width(), rectChild.Height(),FALSE);
                }
                else
                {
//                    pWnd->MoveWindow(rectChild.left - 1, rectChild.top - 1,
//                                 rectChild.Width(), rectChild.Height(),FALSE);
                }
            }
            pWidget->Draw();
//            pWnd->Invalidate(FALSE);
        }
    }

    _FSI_STL::list<CWidget*>::iterator wIt = NULL;
    CWidget* pSubWidget = pWidget->GetNextSubWidget(wIt);
    while (pSubWidget != NULL)
    {
        TraverseBaseWidgets(pSubWidget, bMove);
        pSubWidget = pWidget->GetNextSubWidget(wIt);
    }
}

void CWidget::ChangeValue(const CString& rstrElementVar, CChangeValue* pCV)
{
    if (pCV == NULL)
    {
        return;
    }

    CVariant *pVariant = pCV->Variant();

    if (pVariant == NULL)
    {
        return;
    }


    if (memcmp((LPCTSTR)rstrElementVar, "Show/Hide", __min(rstrElementVar.GetLength(), 9)) == 0)
    {
       if (pCV->UseRange())
       {
          m_bDisplay_cv = pCV->TrueOrFalseValue();
       }
       else
       {
          if ((long)*pVariant != 0)
          {
             m_bDisplay_cv = true;
          }
          else
          {
             m_bDisplay_cv = false;
          }
       }
    }


    if (memcmp((LPCTSTR)rstrElementVar, "Enable/Disable", __min(rstrElementVar.GetLength(), 14)) == 0)
    {
        if ((long)*pVariant != 0)
        {
            m_bEnabled_cv = true;
        }
        else
        {
            m_bEnabled_cv = false;
        }
    }
}

CVariant* CWidget::GetValue(const CString& rstrElementVar)
{
    return NULL;
}

void CWidget::Scale(CExtentsPoint &rextPt, bool bPageLoadScale)
{
    // page was loaded and a scaling may be needed if the 
    // extents of the page is different from the current
    // monitor resolution.
    long int lXOldRes = rextPt.X();
    long int lYOldRes = rextPt.Y();

    long int lXNewRes = GetSystemMetrics(SM_CXSCREEN);
    long int lYNewRes = GetSystemMetrics(SM_CYSCREEN);
    if (m_pBaseWidget != NULL)
    {
        if (m_pBaseWidget->Wnd() != NULL)
        {
            CRect rectView;
            if (m_pBaseWidget->Wnd() != NULL)
            {
                // Get the size of the view.
                CFrameWnd* pWnd = m_pBaseWidget->Wnd()->GetParentFrame();
                CView* pView = pWnd->GetActiveView();

                pView->GetWindowRect(&rectView);

                lXNewRes = rectView.Width();
                lYNewRes = rectView.Height();
            }
        }
    }

    if (lXNewRes == lXOldRes && lYNewRes == lYOldRes)
    {
        return;
    }

    if (m_pWnd == NULL)
    {
        return;
    }

    if (m_pWnd->GetSafeHwnd() == NULL)
    {
        return;
    }

    if (bPageLoadScale == true)
    {

        m_exPtUpperLeft.X(m_exPtUpperLeft.X() * lXNewRes / lXOldRes);
        m_exPtUpperLeft.Y(m_exPtUpperLeft.Y() * lYNewRes / lYOldRes);
        m_exPtLowerRight.X(m_exPtLowerRight.X() * lXNewRes / lXOldRes);
        m_exPtLowerRight.Y(m_exPtLowerRight.Y() * lYNewRes / lYOldRes);

        m_pWnd->SetWindowPos(NULL, 
                             m_exPtUpperLeft.X(), 
                             m_exPtUpperLeft.Y(), 
                             m_exPtLowerRight.X() - m_exPtUpperLeft.X(), 
                             m_exPtLowerRight.Y() - m_exPtUpperLeft.Y(), 
                             SWP_NOZORDER | SWP_NOOWNERZORDER);

        if (m_pXMLWidget != NULL)
        {
            CString strValue;
            CXMLElement* pXMLElement = NULL;
            POSITION pos = NULL;
            if (m_pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("POINT")) == true)
            {
                strValue.Format("%d,%d", m_exPtUpperLeft.X(), 
                                         m_exPtUpperLeft.Y());
                pXMLElement->AddElementValue(_FSI_STL::string((LPCTSTR)strValue));
            }

            // Don't reset elIt here because you will get the previous point
            // back.
            if (m_pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("POINT")) == true)
            {
                strValue.Format("%d,%d", m_exPtLowerRight.X(), 
                                         m_exPtLowerRight.Y());
                pXMLElement->AddElementValue(_FSI_STL::string((LPCTSTR)strValue));
            }
        }
    }
    else
    {
    }
}

bool CWidget::UpdateRenderVariables()
{
    m_bDrawThisPass = true;

    m_syncValidAddress.Lock();

    if (m_bDeleting == false && ::IsWindow(m_mapValidAddresses[this]) == TRUE)
    {
        m_syncValidAddress.Unlock();

        _FSI_STL::map<_FSI_STL::string, ColorsWithChangeValue>::iterator mIt = 
                                                  m_mapColorSelectables.begin();
        _FSI_STL::map<_FSI_STL::string, ColorsWithChangeValue>::iterator mendIt = 
                                                  m_mapColorSelectables.end();

        while (mIt != mendIt)
        {
            (*mIt).second.s_color = (*mIt).second.s_color_cv;
            mIt++;
        }

        if (m_bEnabled != m_bEnabled_cv)
        {
            m_bEnabled = m_bEnabled_cv;
        }


        if (m_bDisplay != m_bDisplay_cv)
        {
            m_bDisplay = m_bDisplay_cv;
        }


        return true;
    }

    m_syncValidAddress.Unlock();

    return false;
}

/////////////////////////////////////////////////////////////////////////////
//
// ADDRESS_STATE CWidget::IsValidAddress()
//
// Inputs           : const CWidget* pWidget - the address of a CWidget 
//                                             instance to check the 
//                                             validity of the Wnd and the
//                                             actual address.
//
// Return Values    : VALID         - if both the Wnd and the address are
//                                    ok
//                    VALID_ADDRESS - if the Wnd is not valid but the   
//                                    address is
//                    INVALID       - neither the Wnd nor the address is
//                                    valid
//
// Date             : 14 July 1999
//
// Engineer         : Billy Baker
//
// Description      : CWidget::IsValidAddress() is a static member 
//                    method that checks the validity of the Wnd member 
//                    variable and the validity of the address that is 
//                    passed.
//
/////////////////////////////////////////////////////////////////////////////
ADDRESS_STATE CWidget::IsValidAddress(const CWidget* pWidget)
{
    if (pWidget == NULL)
    {
        return INVALID;
    }

    m_syncValidAddress.Lock();

    _FSI_STL::map<CWidget*, HWND>::iterator mIt = 
                                   m_mapValidAddresses.find((CWidget*)pWidget);

    if (mIt != m_mapValidAddresses.end())
    {
        if (::IsWindow((*mIt).second) == TRUE)
        {
            m_syncValidAddress.Unlock();

            return VALID;
        }
        else
        {
            m_syncValidAddress.Unlock();

            return VALID_ADDRESS;
        }
    }
    
    m_syncValidAddress.Unlock();

    return INVALID;
}

void CWidget::ExpandPath(CString& strCompressedPath)
{
    CString strComponent = "";
    CString strSubComponent = "";
    CString strFile = "";
    CString strFileName = "";

    if (strCompressedPath.Find("^") > -1)
    {
        strComponent = strCompressedPath.Left(strCompressedPath.Find("^"));
        strSubComponent = strCompressedPath.Mid(strCompressedPath.Find("^")+1);
    }

    if (strSubComponent.Find("^") > -1)
    {
        strFile = strSubComponent.Mid(strSubComponent.Find("^") + 1);
        strSubComponent = strSubComponent.Left(strSubComponent.Find("^"));
    }

    CString strPath = "";

    STRING2STRING_MAP* pmapDir = NULL;
    if (m_mapDirAlias.find((LPCTSTR)strComponent) != m_mapDirAlias.end())
    {
        pmapDir = &( *(m_mapDirAlias.find((LPCTSTR)strComponent)) ).second;
        if (pmapDir->find((LPCTSTR)strSubComponent) != pmapDir->end())
        {
            strPath = (*pmapDir)[(LPCTSTR)strSubComponent].c_str();
        }
    }
    strFileName = strPath + "\\" + strFile;

    // Check to see if more expanding need to be done...  CCB added 01/03/2001.
    if (strFileName.Find("^") > -1)
    {
        ExpandPath(strFileName);
    }

    strCompressedPath = strFileName;
}

void CWidget::Directories(const _FSI_STL::string& rstlStrComponentName, 
                          STRING2STRING_MAP* pmapDir)
{
    if (pmapDir == NULL)
    {
        return;
    }

    m_mapDirAlias[rstlStrComponentName] = *pmapDir;
}


void CWidget::ResetFonts()
{
    m_mapGlobalFonts.clear();
}

//////////////////////////////////////////////////////////////////////
// Accessors
//////////////////////////////////////////////////////////////////////

CWidget* CWidget::BaseWidget()
{
    return m_pBaseWidget;
}

_FSI_STL::string CWidget::WidgetName()
{
    return m_stlStrWidgetName;
}

long CWidget::ID()
{
    return m_lID;
}

_FSI_STL::string CWidget::Name()
{
    return m_stlStrName;
}

CExtentsPoint& CWidget::UpperLeft()
{
    return m_exPtUpperLeft;
}

CExtentsPoint& CWidget::LowerRight()
{
    return m_exPtLowerRight;
}

CWnd* CWidget::Wnd()
{
    return m_pWnd;
}

CAction* CWidget::Action()
{
    return m_pAction;
}

STRING_LIST CWidget::Vars()
{
    return m_listGraphicalElementVars;
}

CXMLWidget* CWidget::XMLWidget()
{
    return m_pXMLWidget;
}

CVariant CWidget::RangeLow(const _FSI_STL::string& rstlStrVariable)
{
    return m_mapRangeData[rstlStrVariable].s_varLow;
}

CVariant CWidget::RangeHigh(const _FSI_STL::string& rstlStrVariable)
{
    return m_mapRangeData[rstlStrVariable].s_varHigh;
}

CWnd* CWidget::FrameworkParent()
{
    return m_pParentWnd;
}

CColor CWidget::Background()
{
    return m_mapColorSelectables["BACKGROUND"].s_color;
}

CColor CWidget::Foreground()
{
    return m_mapColorSelectables["FOREGROUND"].s_color;
}

CWnd* CWidget::WidgetProps()
{
    return m_pWidgetProps;
}

CWnd* CWidget::OverlayDlg()
{
    return m_pOverlayDlg;
}

STRING_LIST& CWidget::ColorSelectable()
{
    return m_listColorSelectable;
}

STRING_LIST& CWidget::Overlays()
{
    return m_listOverlays;
}

CWidget* CWidget::ParentWidget()
{
    return m_pParentWidget;
}

bool CWidget::SwapNeeded(const HWND hWnd)
{
    return m_mapSwapNeeded[(HWND)hWnd];
}

bool CWidget::DrawsOpenGL()
{
    return m_bDrawsOpenGL;
}

HWND CWidget::MainFrameHwnd()
{
    return m_hwndMainFrame;
}

/////////////////////////////////////////////////////////////////////
// Mutators
//////////////////////////////////////////////////////////////////////

void CWidget::XMLWidget(CXMLWidget* pXMLWidget)
{
    m_pXMLWidget = pXMLWidget;
}

void CWidget::UpperLeft(const CExtentsPoint &rexPtUpperLeft)
{
    m_exPtUpperLeft = rexPtUpperLeft;
}

void CWidget::LowerRight(const CExtentsPoint &rexPtLowerRight)
{
    m_exPtLowerRight = rexPtLowerRight;
}

void CWidget::RangeLow(const _FSI_STL::string& rstlStrVariable, 
                       const CVariant& rvarRangeLow)
{
    m_mapRangeData[rstlStrVariable].s_varLow = rvarRangeLow;
}

void CWidget::RangeHigh(const _FSI_STL::string& rstlStrVariable, 
                        const CVariant& rvarRangeHigh)
{
    m_mapRangeData[rstlStrVariable].s_varHigh = rvarRangeHigh;
}

void CWidget::FrameworkParent(const CWnd* pFrameworkWnd)
{
    m_pParentWnd = const_cast<CWnd*>(pFrameworkWnd);
    m_hwndMainFrame = m_pParentWnd->GetParentFrame()->GetSafeHwnd();
}

void CWidget::Background(const CColor& rcolorBackground)
{
    m_mapColorSelectables["BACKGROUND"].s_color = rcolorBackground;
    m_mapColorSelectables["BACKGROUND"].s_color_cv = rcolorBackground;
}

void CWidget::Foreground(const CColor& rcolorForeground)
{
    m_mapColorSelectables["FOREGROUND"].s_color = rcolorForeground;
    m_mapColorSelectables["FOREGROUND"].s_color_cv = rcolorForeground;
}

void CWidget::WidgetProps(CWnd* pWnd)
{
    m_pWidgetProps = pWnd;
}

void CWidget::OverlayDlg(CWnd* pWnd)
{
    m_pOverlayDlg = pWnd;
}

void CWidget::ParentWidget(CWidget* pParentWidget)
{
    m_pParentWidget = pParentWidget;
}

void CWidget::SwapNeeded(const HWND hWnd, bool bSwapNeeded)
{
    m_mapSwapNeeded[(HWND)hWnd] = bSwapNeeded;
}

void CWidget::AddColorPage(void)
{
   m_listWidgetPropPages.push_back(CColorPage::CreateObject);
}


void CWidget::ExtentsProperties(void)
{
   CXMLElement *pXMLElement   =  NULL;
   POSITION    pos            =  NULL;
   bool        bHaveUpper     =  false;
   bool        bHaveLower     =  false;
   CString     strValue;

   // Get any extents data
   if (m_pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("POINT")) == true)
   {
      m_exPtUpperLeft   =  CExtentsPoint(pXMLElement->ElementValue());
      bHaveUpper        =  true;
   }

   if (m_pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("POINT")) == true)
   {
      m_exPtLowerRight  =  CExtentsPoint(pXMLElement->ElementValue());
      bHaveLower        =  true;
   }

   // Make sure the extents are good (actually an upper left and a lower right).
   if (bHaveUpper && bHaveLower)
   {
      if (m_exPtUpperLeft.X() > m_exPtLowerRight.X() ||  m_exPtUpperLeft.Y() > m_exPtLowerRight.Y())
      {
         CExtentsPoint  exPt(m_exPtUpperLeft);
         m_exPtUpperLeft   =  m_exPtLowerRight;
         m_exPtLowerRight  =  exPt;
      }
   }

   // Add any missing extents data.
   STRING2STRING_MAP*  mapXMLAttributes;
   if (false == bHaveUpper)
   {
      mapXMLAttributes  =  new   STRING2STRING_MAP;

      strValue.Format("%d,%d",m_exPtUpperLeft.X(),m_exPtUpperLeft.Y());
      m_pXMLWidget->AddElement(_FSI_STL::string("POINT"), _FSI_STL::string((LPCTSTR)strValue), mapXMLAttributes);
   }

   if (false == bHaveLower)
   {
      mapXMLAttributes  =  new   STRING2STRING_MAP;

      strValue.Format("%d,%d",m_exPtLowerRight.X(),m_exPtLowerRight.Y());
      m_pXMLWidget->AddElement(_FSI_STL::string("POINT"), _FSI_STL::string((LPCTSTR)strValue), mapXMLAttributes);
   }

   if (true == m_bEditing)
   {
      if (m_pTracker == NULL)
      {
         m_pTracker  =  new   CFSISuiteRectTracker;
      }

      if (m_pTracker != NULL)
      {
         m_pTracker->m_nHandleSize         = 7;
         m_pTracker->m_nStyle &= ~CRectTracker::solidLine;
         m_pTracker->m_nStyle ^= CRectTracker::dottedLine;
         m_pTracker->m_nStyle |= CRectTracker::resizeInside;

         CRect rectWnd(m_exPtUpperLeft, m_exPtLowerRight);
         CRect rectCtrl(0,0,rectWnd.Width(),rectWnd.Height());
         m_pTracker->m_rect = rectCtrl;
      }
   }
}

bool CWidget::GetEditing(void)
{
   return   m_bEditing;
}