/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : Variant.cpp
//
// Date             : 07 February 2000
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.14 $
//
// Description      : Variant.cpp contains the implementation of the 
//                    CVariant class.  This class is used to store data 
//                    and provide conversions between the different 
//                    types of data.  The data may be singular values 
//                    in which case the data is stored in a union.  Or, 
//                    the data may be an array in which case dynamic 
//                    memory is used to store the data.  This class 
//                    also has a dynamic list/deque for storing historical 
//                    data.  Comparison operators are implemented as is 
//                    operator [] for getting an index from a stored array.
//                    The copy constructor uses reference counting to share
//                    any dynamic historical data rather than making copies
//                    of the data.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : _FSI_STL::deque.
//
// Components Used  : None.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3, 4, or 5
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: Variant.cpp $                                                                  
// Revision 1.14  2000/03/30 08:07:15  billyb                                                                  
// Revision 1.11.1.2  2000/03/30 07:57:51  billyb                                                                  
// Moved deletion of memory after removal of pointer from                                                                   
// data structure.  Prevented a zero length array for the data                                                                  
// changed array.                                                                  
// Revision 1.13  2000/03/07 15:49:48  billyb                                                                  
// Revision 1.11.1.1  2000/03/07 15:49:36  billyb                                                                  
// Changed function signatures to eliminate warnings.                                                                  
// Revision 1.11  2000/02/09 19:56:58  billyb                                                                  
// Removed unsigned char type.  Made VAR_STRING and                                                                  
// VAR_CHAR work in similar manners.                                                                  
// Revision 1.10  2000/02/07 07:47:29  billyb                                                                  
// Changed operator [] to return an entire string if it is called for                                                                  
// a CVariant that is a string.                                                                  
/////////////////////////////////////////////////////////////////////////////
#include "stdafx.h"
#include "Variant.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

_FSI_STL::map<long, long>    CVariant::m_mapReferenceListCount;
unsigned char                CVariant::m_ucSizes[VAR_TOTAL_TYPES] = {sizeof(char),
                                                                     sizeof(unsigned char),
                                                                     sizeof(short),
                                                                     sizeof(unsigned short),
                                                                     sizeof(long),
                                                                     sizeof(unsigned long),
                                                                     sizeof(float),
                                                                     sizeof(double),
                                                                     sizeof(bool),
                                                                     sizeof(char)};

double round[10] = {5e-1, 5e-2, 5e-3, 5e-4, 5e-5, 5e-6, 5e-7, 5e-8, 5e-9, 5e-10};
double prec_mul[10] = {1,     1e1,  1e2,  1e3,  1e4,  1e5,  1e6,  1e7,  1e8,  1e9};

void local_ftoa(char* c, int prec, float value)
{
    char cN[32];
    float f = 0.0f;
    if (value  <  0.0f)
      f =  value - round[prec];
    else
      f =  value + round[prec];

    int i = (int)f;
    itoa(i, c, 10);

    if (prec > 0)
    {
        int remain = (f - (float)i) * prec_mul[prec];
        if (remain < 0) remain *= -1;
        strcat(c, ".");
        itoa(remain, cN, 10);

        int j = 0;
        while (j < prec)
        {
            if (cN[j] == '\0')
                break;

            ++j;
        }

        int zeros = prec - j;
        while (zeros)
        {
            strcat(c, "0");
            --zeros;
        }

        strncat(c, cN, j);
    }
}

void local_dtoa(char* c, int prec, double value)
{
    char cN[32];
    double d = 0;
    
    if (value  <  0)
      d  =  value - round[prec];
    else
      d  =  value + round[prec];

    int i = (int)d;
    itoa(i, c, 10);

    if (prec > 0)
    {
        int remain = (d - (double)i) * prec_mul[prec];
        if (remain < 0) remain *= -1;
        strcat(c, ".");
        itoa(remain, cN, 10);

        int j = 0;
        while (j < prec)
        {
            if (cN[j] == '\0')
                break;

            ++j;
        }

        int zeros = prec - j;
        while (zeros)
        {
            strcat(c, "0");
            --zeros;
        }

        strncat(c, cN, j);
    }
}

/////////////////////////////////////////////////////////////////////////////
//
// CVariant::CVariant()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 09 February 2000
//
// Engineer         : Billy Baker
//
// Description      : Default constructor.  A CVariant instance is 
//                    initially set to have an unknown data type and no 
//                    dynamic memory.  There is no list of historical data.
//
/////////////////////////////////////////////////////////////////////////////
CVariant::CVariant() :
    m_lType(VAR_UNKNOWN),
    m_ulMaxList(0),
    m_pdequeValues(NULL),
    m_pbDataChanged(NULL),
    m_unLength(0),
    m_pcValue(NULL),
    m_bAnyPieceChanged(false),
    m_bIsList(false),
    m_bLimitFloating(false),
    m_ucPrecision(0),
    m_stlStrValue("")
{
    m_varTypeData.u_dValue = 0.0;
}

/////////////////////////////////////////////////////////////////////////////
//
// CVariant::CVariant()
//
// Inputs           : const CVariant& rVariant - another instance of CVariant
//                                               used to initialize this.
//
// Return Values    : None.
//
// Date             : 09 February 2000
//
// Engineer         : Billy Baker
//
// Description      : Copy constructor.  A CVariant instance is 
//                    initially set to have an unknown data type and no 
//                    dynamic memory.  There is no list of historical data.
//                    The data from the passed instance is then used to 
//                    initialize the members of this.
//
/////////////////////////////////////////////////////////////////////////////
CVariant::CVariant(const CVariant& rVariant)
{
    if (this != &rVariant)
    {
        m_lType                     = VAR_UNKNOWN;
        m_pbDataChanged             = NULL;
        m_pdequeValues              = NULL;
        m_pcValue                   = NULL;
        m_ulMaxList                 = 0;
        m_unLength                  = 0;
        m_bAnyPieceChanged          = false;
        m_bLimitFloating            = false;
        m_bIsList                   = false;
        m_ucPrecision               = 0;
        m_varTypeData.u_dValue      = 0.0;
        m_stlStrValue               = "";

        *this = rVariant;
    }
}

/////////////////////////////////////////////////////////////////////////////
//
// CVariant::~CVariant()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 09 February 2000
//
// Engineer         : Billy Baker
//
// Description      : Default destructor.  If the m_pdequeValues member is
//                    not NULL, then the reference count for the pointer is
//                    decreased.  If the count is less than 1, then the
//                    deque is deleted.  If m_ucLength is greater than 1,
//                    then it points to dynamic memory rather than the
//                    internal union.  Thus, the data needs to be deleted.
//
/////////////////////////////////////////////////////////////////////////////
CVariant::~CVariant()
{
    if (m_pdequeValues != NULL)
    {
        // Decrease the reference count.
        m_mapReferenceListCount[(long)m_pdequeValues] -= 1;
        if (m_mapReferenceListCount[(long)m_pdequeValues] < 1)
        {
            // Last instance using the deque.  Delete all of the data
            // and the deque.
            _FSI_STL::deque<VariantListData>::iterator dIt    = m_pdequeValues->begin();
            _FSI_STL::deque<VariantListData>::iterator dendIt = m_pdequeValues->end();
            while (dIt != dendIt)
            {
                if ((*dIt).s_pcValue != NULL)
                    delete [] (*dIt).s_pcValue;

                dIt++;
            }

            m_pdequeValues->clear();
            m_mapReferenceListCount.erase(m_mapReferenceListCount.find((long)m_pdequeValues));
            delete m_pdequeValues;
        }
    }

    if (m_unLength > 1)
    {
        // m_pcValue does not point to the internal union.  Delete
        // the dynamic memory.
        delete [] m_pcValue;
    }

    if (m_pbDataChanged != NULL)
        delete [] m_pbDataChanged;
}

/////////////////////////////////////////////////////////////////////////////
//
// CVariant& CVariant::operator =()
//
// Inputs           : const CVariant& rVariant - the CVariant instance 
//                                               from which data will be 
//                                               copied.
//
// Return Values    : A reference to an instance of CVariant with 
//                    values copied from the CVariant instance that is 
//                    passed.
//
// Date             : 08 July 1999
//
// Engineer         : Billy Baker
//
// Description      : Override of the copy constructor to prevent the 
//                    assignment of the pointer for the list from one 
//                    instance to another which could lead to the same 
//                    address being deleted more than once.
//
/////////////////////////////////////////////////////////////////////////////
CVariant& CVariant::operator =(const CVariant& rVariant)
{
    if (this != &rVariant)
    {
        unsigned int ulSize = Size(rVariant.m_lType) * rVariant.m_unLength;
        unsigned int ulSizeThis = Size(m_lType) * m_unLength;

        if (m_pbDataChanged != NULL && m_unLength < rVariant.m_unLength)
        {
            // Not this and not from the copy constructor.
            delete [] m_pbDataChanged;
            m_pbDataChanged = NULL;
        }

        if (m_pcValue != NULL && m_unLength > 1 &&
           (m_unLength < rVariant.m_unLength || ulSizeThis < ulSize || rVariant.m_unLength == 1))
        {
            // Not this and not from the copy constructor.
            delete [] m_pcValue;
            m_pcValue = NULL;
        }
        else if (m_pcValue != NULL && m_unLength == 1 && (m_unLength < rVariant.m_unLength || ulSizeThis < ulSize))
        {
            m_pcValue = NULL;
        }

        m_varTypeData.u_dValue      = 0.0;
        m_lType                     = rVariant.m_lType;
        if (rVariant.m_unLength > 0 && m_pbDataChanged == NULL)
            m_pbDataChanged         = new bool[rVariant.m_unLength];

        unsigned int un = rVariant.m_unLength;
        while (un)
        {
            --un;

            // Not this and not from the copy constructor.
            m_pbDataChanged[un]      = rVariant.m_pbDataChanged[un];
        }

        if (m_pdequeValues != NULL)
        {
            // Not this and not from the copy constructor.
            m_mapReferenceListCount[(long)m_pdequeValues] -= 1;
        }

        m_pdequeValues              = rVariant.m_pdequeValues;

        if (m_pdequeValues != NULL)
        {
            // Not this and not from the copy constructor.
            m_mapReferenceListCount[(long)m_pdequeValues] += 1;
        }

        if (rVariant.m_unLength > 1 && m_pcValue == NULL)
            m_pcValue               = new char[ulSize];
        else if (rVariant.m_unLength == 1)
            m_pcValue               = (char *)&m_varTypeData;

        memcpy(m_pcValue, rVariant.m_pcValue, ulSize); 

        m_ulMaxList                 = rVariant.m_ulMaxList;
        m_unLength                  = rVariant.m_unLength;
        m_bAnyPieceChanged          = rVariant.m_bAnyPieceChanged;
        m_bLimitFloating            = rVariant.m_bLimitFloating;
        m_bIsList                   = rVariant.m_bIsList;
        m_ucPrecision               = rVariant.m_ucPrecision;
//        m_stlStrValue               = rVariant.m_stlStrValue;
    }

    return *this;
}

CVariant CVariant::operator [](unsigned int unIndex) const
{
    if (m_unLength == 1)
        return *this;

    CVariant variant(*this);
    if (unIndex >= 0)
    {
        if (unIndex < m_unLength)
        {
            switch(m_lType)
            {
            case VAR_STRING:
            case VAR_CHAR:
                {
                    variant.Value(m_pcValue[unIndex]);
                }
                break;
/*            case VAR_UNSIGNED_CHAR:
                {
                    variant.Value(((unsigned char*)m_pcValue)[unIndex]);
                }
                break;*/
            case VAR_SHORT_INT:
                {
                    variant.Value(((short *)m_pcValue)[unIndex]);
                }
                break;
            case VAR_UNSIGNED_SHORT_INT:
                {
                    variant.Value(((unsigned short *)m_pcValue)[unIndex]);
                }
                break;
            case VAR_LONG_INT:
                {
                    variant.Value(((long int*)m_pcValue)[unIndex]);
                }
                break;
            case VAR_UNSIGNED_LONG_INT:
                {
                    variant.Value(((unsigned long int*)m_pcValue)[unIndex]);
                }
                break;
            case VAR_FLOAT:
                {
                    variant.Value(((float *)m_pcValue)[unIndex]);
                }
                break;
            case VAR_DOUBLE:
                {
                    variant.Value(((double*)m_pcValue)[unIndex]);
                }
                break;
            case VAR_BOOL:
                {
                    variant.Value(((bool*)m_pcValue)[unIndex]);
                }
                break;
            };
        }
    }

    return variant;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Conversion method to standard data types
//
/////////////////////////////////////////////////////////////////////////////

CVariant::operator bool() const
{
    if (m_pcValue == NULL || m_unLength < 1)
    {
        // No data.
        return false;
    }

    if (m_lType == VAR_BOOL)
    {
        return ((bool*)m_pcValue)[0];
    }
    else
    {
        ToString();
        if (atoi(m_stlStrValue.c_str()) != 0)
            return true;
        else
            return false;
    }
}

CVariant::operator char() const
{
    if (m_pcValue == NULL || m_unLength < 1)
    {
        // No data.
        return 0;
    }

    if (m_lType == VAR_CHAR)
        return m_pcValue[0];
    else
    {
        ToString();
        return (m_stlStrValue.c_str())[0];
    }
}

CVariant::operator double() const
{
    if (m_pcValue == NULL || m_unLength < 1)
    {
        // No data.
        return 0.0;
    }

    if (m_lType == VAR_DOUBLE)
    {
        return ((double *)m_pcValue)[0];
    }
    else
    {
        ToString();
        return (double)atof(m_stlStrValue.c_str());
    }
}

CVariant::operator float() const
{
    if (m_pcValue == NULL || m_unLength < 1)
    {
        // No data.
        return 0.0f;
    }

    if (m_lType == VAR_FLOAT)
    {
        return ((float*)m_pcValue)[0];
    }
    else
    {
        ToString();
        return (float)atof(m_stlStrValue.c_str());
    }
}

CVariant::operator long() const
{
    if (m_pcValue == NULL || m_unLength < 1)
    {
        // No data.
        return 0;
    }

    if (m_lType == VAR_LONG_INT)
    {
        return ((long *)m_pcValue)[0];
    }
    else
    {
        ToString();
        return (long int)atol(m_stlStrValue.c_str());
    }
}

CVariant::operator short() const
{
    if (m_pcValue == NULL || m_unLength < 1)
    {
        // No data.
        return 0;
    }

    if (m_lType == VAR_SHORT_INT)
    {
        return ((short *)m_pcValue)[0];
    }
    else
    {
        ToString();
        return (short int)atoi(m_stlStrValue.c_str());
    }
}

CVariant::operator _FSI_STL::string() const
{
    if (m_pcValue == NULL || m_unLength < 1)
    {
        // No data.
        return _FSI_STL::string("");
    }

    if (m_lType == VAR_STRING)
    {
        const_cast<CVariant*>(this)->m_stlStrValue.assign(m_pcValue, m_unLength);
        return m_stlStrValue;
    }
    else
    {
        ToString();
        return m_stlStrValue;
    }
}


CVariant::operator unsigned char() const
{
    OutputDebugString("Another problem with CVariant::unsigned char\n");
    return 0;

    if (m_pcValue == NULL || m_unLength < 1)
    {
        // No data.
        return 0;
    }

    if (m_lType == VAR_UNSIGNED_CHAR)
    {
        return ((unsigned char*)m_pcValue)[0];
    }
    else
    {
        ToString();
        return (unsigned char)atoi(m_stlStrValue.c_str());
    }
}

CVariant::operator unsigned long() const
{
    if (m_pcValue == NULL || m_unLength < 1)
    {
        // No data.
        return 0;
    }

    if (m_lType == VAR_UNSIGNED_LONG_INT)
    {
        return ((unsigned long *)m_pcValue)[0];
    }
    else
    {
        ToString();
        return (unsigned long)atol(m_stlStrValue.c_str());
    }
}

CVariant::operator unsigned short() const
{
    if (m_pcValue == NULL || m_unLength < 1)
    {
        // No data.
        return 0;
    }

    if (m_lType == VAR_UNSIGNED_SHORT_INT)
    {
        return ((unsigned short*)m_pcValue)[0];
    }
    else
    {
        ToString();
        return (unsigned short)atoi(m_stlStrValue.c_str());
    }
}

/////////////////////////////////////////////////////////////////////////////
//
//  Conditional operators to compare two CVariants.
//
/////////////////////////////////////////////////////////////////////////////

bool CVariant::operator <(const CVariant& rvar1)
{
    switch(m_lType)
    {
    case VAR_CHAR:
        {
            return (this->operator char() < rvar1.operator char());
        }
        break;
/*    case VAR_UNSIGNED_CHAR:
        {
            return ((unsigned char)(*this) < (unsigned char)rvar1);
        }
        break;*/
    case VAR_SHORT_INT:
        {
            return ((short)(*this) < (short)rvar1);
        }
        break;
    case VAR_UNSIGNED_SHORT_INT:
        {
            return ((unsigned short int)(*this) < (unsigned short int)rvar1);
        }
        break;
    case VAR_LONG_INT:
        {
            return ((long int)(*this) < (long int)rvar1);
        }
        break;
    case VAR_UNSIGNED_LONG_INT:
        {
            return ((unsigned long int)(*this) < (unsigned long int)rvar1);
        }
        break;
    case VAR_FLOAT:
        {
            return ((float)(*this) < (float)rvar1);
        }
        break;
    case VAR_DOUBLE:
        {
            return ((double)(*this) < (double)rvar1);
        }
        break;
    case VAR_BOOL:
        {
            return ((bool)(*this) < (bool)rvar1);
        }
        break;
    default:
        {
            return false;
        }
        break;
    }

    // Currently no support for strings.
}

bool CVariant::operator <=(const CVariant& rvar1)
{
    switch(m_lType)
    {
    case VAR_CHAR:
        {
            return ((char)(*this) <= (char)rvar1);
        }
        break;
/*    case VAR_UNSIGNED_CHAR:
        {
            return ((unsigned char)(*this) <= (unsigned char)rvar1);
        }
        break;*/
    case VAR_SHORT_INT:
        {
            return ((short int)(*this) <= (short int)rvar1);
        }
        break;
    case VAR_UNSIGNED_SHORT_INT:
        {
            return ((unsigned short int)(*this) <= (unsigned short int)rvar1);
        }
        break;
    case VAR_LONG_INT:
        {
            return ((long int)(*this) <= (long int)rvar1);
        }
        break;
    case VAR_UNSIGNED_LONG_INT:
        {
            return ((unsigned long int)(*this) <= (unsigned long int)rvar1);
        }
        break;
    case VAR_FLOAT:
        {
            return ((float)(*this) <= (float)rvar1);
        }
        break;
    case VAR_DOUBLE:
        {
            return ((double)(*this) <= (double)rvar1);
        }
        break;
    case VAR_BOOL:
        {
            return ((bool)(*this) <= (bool)rvar1);
        }
        break;
    default:
        {
            return false;
        }
        break;
    }

    // Currently no support for strings.
}

bool CVariant::operator ==(const CVariant& rvar1)
{
    if (m_pcValue != NULL && rvar1.m_pcValue != NULL)
    {
        if (m_lType == rvar1.m_lType)
        {
            if (m_unLength == rvar1.m_unLength)
            {
                if (memcmp(m_pcValue, rvar1.m_pcValue, Size(m_lType) * m_unLength) == 0)
                    return true;
            }
        }
    }

    return false;
}

bool CVariant::operator !=(const CVariant& rvar1)
{
    if (!(*this == rvar1))
        return true;

    return false;
}

bool CVariant::operator >=(const CVariant& rvar1)
{
    switch(m_lType)
    {
    case VAR_CHAR:
        {
            return ((char)(*this) >= (char)rvar1);
        }
        break;
/*    case VAR_UNSIGNED_CHAR:
        {
            return ((unsigned char)(*this) >= (unsigned char)rvar1);
        }
        break;*/
    case VAR_SHORT_INT:
        {
            return ((short int)(*this) >= (short int)rvar1);
        }
        break;
    case VAR_UNSIGNED_SHORT_INT:
        {
            return ((unsigned short int)(*this) >= (unsigned short int)rvar1);
        }
        break;
    case VAR_LONG_INT:
        {
            return ((long int)(*this) >= (long int)rvar1);
        }
        break;
    case VAR_UNSIGNED_LONG_INT:
        {
            return ((unsigned long int)(*this) >= (unsigned long int)rvar1);
        }
        break;
    case VAR_FLOAT:
        {
            return ((float)(*this) >= (float)rvar1);
        }
        break;
    case VAR_DOUBLE:
        {
            return ((double)(*this) >= (double)rvar1);
        }
        break;
    case VAR_BOOL:
        {
            return ((bool)(*this) >= (bool)rvar1);
        }
        break;
    default:
        {
            return false;
        }
        break;
    }

    // Currently no support for strings.
}

bool CVariant::operator >(const CVariant& rvar1)
{
    switch(m_lType)
    {
    case VAR_CHAR:
        {
            return ((char)(*this) > (char)rvar1);
        }
        break;
/*    case VAR_UNSIGNED_CHAR:
        {
            return ((unsigned char)(*this) > (unsigned char)rvar1);
        }
        break;*/
    case VAR_SHORT_INT:
        {
            return ((short int)(*this) > (short int)rvar1);
        }
        break;
    case VAR_UNSIGNED_SHORT_INT:
        {
            return ((unsigned short int)(*this) > (unsigned short int)rvar1);
        }
        break;
    case VAR_LONG_INT:
        {
            return ((long int)(*this) > (long int)rvar1);
        }
        break;
    case VAR_UNSIGNED_LONG_INT:
        {
            return ((unsigned long int)(*this) > (unsigned long int)rvar1);
        }
        break;
    case VAR_FLOAT:
        {
            return ((float)(*this) > (float)rvar1);
        }
        break;
    case VAR_DOUBLE:
        {
            return ((double)(*this) > (double)rvar1);
        }
        break;
    case VAR_BOOL:
        {
            return ((bool)(*this) > (bool)rvar1);
        }
        break;
    default:
        {
            return false;
        }
        break;
    }

    // Currently no support for strings.
}

void CVariant::ToString(_FSI_STL::string& str) const
{

    if (m_pcValue == NULL || m_unLength < 1)
    {
        str = "";

        return;
    }

    char cNumber[32] = "";

    switch(m_lType)
    {
    case VAR_STRING:
    case VAR_CHAR:
        {
            str.assign(m_pcValue, m_unLength);
            return;
        }
        break;
/*    case VAR_UNSIGNED_CHAR:
        {
            sprintf(cNumber, "%d\0", ((unsigned char *)m_pcValue)[0]);
            return _FSI_STL::string(cNumber);
        }
        break;*/
    case VAR_SHORT_INT:
        {
            itoa(((short *)m_pcValue)[0], cNumber, 10);
        }
        break;
    case VAR_UNSIGNED_SHORT_INT:
        {
            itoa(((unsigned short *)m_pcValue)[0], cNumber, 10);
        }
        break;
    case VAR_LONG_INT:
        {
            itoa(((long *)m_pcValue)[0], cNumber, 10);
        }
        break;
    case VAR_UNSIGNED_LONG_INT:
        {
            itoa(((unsigned long *)m_pcValue)[0], cNumber, 10);
        }
        break;
    case VAR_FLOAT:
        {
            if (m_bLimitFloating == true)
            {
//                sprintf(cNumber, "%.*f\0", m_ucPrecision, ((float *)m_pcValue)[0]);
                local_ftoa(cNumber, m_ucPrecision, ((float *)m_pcValue)[0]);
            }
            else
            {
//                sprintf(cNumber, "%f\0", ((float *)m_pcValue)[0]);
                local_ftoa(cNumber, 6, ((float *)m_pcValue)[0]);
            }
        }
        break;
    case VAR_DOUBLE:
        {
            if (m_bLimitFloating == true)
            {
//                sprintf(cNumber, "%.*lf\0", m_ucPrecision, ((double *)m_pcValue)[0]);
                local_dtoa(cNumber, m_ucPrecision, ((double *)m_pcValue)[0]);
            }
            else
            {
//                sprintf(cNumber, "%lf\0", ((double *)m_pcValue)[0]);
                local_dtoa(cNumber, 6, ((double *)m_pcValue)[0]);
            }
        }
        break;
    case VAR_BOOL:
        {
            itoa(((bool *)m_pcValue)[0], cNumber, 10);
        }
        break;
    }

    str.assign(cNumber, 32);
}

void CVariant::ToString() const
{

    if (m_pcValue == NULL || m_unLength < 1)
    {
        const_cast<CVariant*>(this)->m_stlStrValue = "";

        return;
    }

    char cNumber[32] = "";

    switch(m_lType)
    {
    case VAR_STRING:
    case VAR_CHAR:
        {
            const_cast<CVariant*>(this)->m_stlStrValue.assign(m_pcValue, m_unLength);
            return;
        }
        break;
/*    case VAR_UNSIGNED_CHAR:
        {
            sprintf(cNumber, "%d\0", ((unsigned char *)m_pcValue)[0]);
            return _FSI_STL::string(cNumber);
        }
        break;*/
    case VAR_SHORT_INT:
        {
            itoa(((short *)m_pcValue)[0], cNumber, 10);
        }
        break;
    case VAR_UNSIGNED_SHORT_INT:
        {
            itoa(((unsigned short *)m_pcValue)[0], cNumber, 10);
        }
        break;
    case VAR_LONG_INT:
        {
            itoa(((long *)m_pcValue)[0], cNumber, 10);
        }
        break;
    case VAR_UNSIGNED_LONG_INT:
        {
            itoa(((unsigned long *)m_pcValue)[0], cNumber, 10);
        }
        break;
    case VAR_FLOAT:
        {
            if (m_bLimitFloating == true)
            {
//                sprintf(cNumber, "%.*f\0", m_ucPrecision, ((float *)m_pcValue)[0]);
                local_ftoa(cNumber, m_ucPrecision, ((float *)m_pcValue)[0]);
            }
            else
            {
//                sprintf(cNumber, "%f\0", ((float *)m_pcValue)[0]);
                local_dtoa(cNumber, 6, ((float *)m_pcValue)[0]);
            }
        }
        break;
    case VAR_DOUBLE:
        {
            if (m_bLimitFloating == true)
            {
//                sprintf(cNumber, "%.*lf\0", m_ucPrecision, ((double *)m_pcValue)[0]);
                local_dtoa(cNumber, m_ucPrecision, ((double *)m_pcValue)[0]);
            }
            else
            {
//                sprintf(cNumber, "%lf\0", ((double *)m_pcValue)[0]);
                local_dtoa(cNumber, 6, ((double *)m_pcValue)[0]);
            }
        }
        break;
    case VAR_BOOL:
        {
            itoa(((bool *)m_pcValue)[0], cNumber, 10);
        }
        break;
    }

    const_cast<CVariant*>(this)->m_stlStrValue.assign(cNumber, 32);
}

void CVariant::ChangeType(long int lVarType)
{
    // If no type change is needed, then return.
    if (lVarType == m_lType)
    {
        return;
    }

    unsigned int un = 0;
    switch(lVarType)
    {
    case VAR_STRING:
        {
            if (m_lType != VAR_CHAR)
            {
                Value((_FSI_STL::string)(*this));
            }
            else
            {
                m_lType = VAR_STRING;
            }
        }
        break;
    case VAR_CHAR:
        {
            Value((_FSI_STL::string)(*this));
        }
        break;
/*    case VAR_UNSIGNED_CHAR:
        {
            unsigned char * pucValue = new unsigned char[m_unLength];
            while (un < m_unLength)
            {
                pucValue[un] = (unsigned char)(*this)[un];
                un++;
            }
            Value((char *)pucValue, VAR_UNSIGNED_CHAR, m_unLength);
            delete [] pucValue;
        }
        break;*/
    case VAR_SHORT_INT:
        {
            if (m_lType == VAR_STRING || m_lType == VAR_CHAR)
            {
                short s = (short)(*this);
                Value((char*)&s, VAR_SHORT_INT, 1);
            }
            else
            {
                short * pshValue = new short[m_unLength];
                while (un < m_unLength)
                {
                    pshValue[un] = (short)(*this)[un];
                    un++;
                }
                Value((char *)pshValue, VAR_SHORT_INT, m_unLength);
                delete [] pshValue;
            }
        }
        break;
    case VAR_UNSIGNED_SHORT_INT:
        {
            if (m_lType == VAR_STRING || m_lType == VAR_CHAR)
            {
                unsigned short us = (unsigned short)(*this);
                Value((char*)&us, VAR_UNSIGNED_SHORT_INT, 1);
            }
            else
            {
                unsigned short * pushValue = new unsigned short[m_unLength];
                while (un < m_unLength)
                {
                    pushValue[un] = (unsigned short)(*this)[un];
                    un++;
                }
                Value((char *)pushValue, VAR_UNSIGNED_SHORT_INT, m_unLength);
                delete [] pushValue;
            }
        }
        break;
    case VAR_LONG_INT:
        {
            if (m_lType == VAR_STRING || m_lType == VAR_CHAR)
            {
                long l = (long)(*this);
                Value((char*)&l, VAR_LONG_INT, 1);
            }
            else
            {
                long * plValue = new long[m_unLength];
                while (un < m_unLength)
                {
                    plValue[un] = (long)(*this)[un];
                    un++;
                }
                Value((char *)plValue, VAR_LONG_INT, m_unLength);
                delete [] plValue;
            }
        }
        break;
    case VAR_UNSIGNED_LONG_INT:
        {
            if (m_lType == VAR_STRING || m_lType == VAR_CHAR)
            {
                unsigned long ul = (unsigned long)(*this);
                Value((char*)&ul, VAR_UNSIGNED_LONG_INT, 1);
            }
            else
            {
                unsigned long * pulValue = new unsigned long[m_unLength];
                while (un < m_unLength)
                {
                    pulValue[un] = (unsigned long)(*this)[un];
                    un++;
                }
                Value((char *)pulValue, VAR_UNSIGNED_LONG_INT, m_unLength);
                delete [] pulValue;
            }
        }
        break;
    case VAR_FLOAT:
        {
            if (m_lType == VAR_STRING || m_lType == VAR_CHAR)
            {
                float f = (float)(*this);
                Value((char*)&f, VAR_FLOAT, 1);
            }
            else
            {
                float * pfValue = new float[m_unLength];
                while (un < m_unLength)
                {
                    pfValue[un] = (float)(*this)[un];
                    un++;
                }
                Value((char *)pfValue, VAR_FLOAT, m_unLength);
                delete [] pfValue;
            }
        }
        break;
    case VAR_DOUBLE:
        {
            if (m_lType == VAR_STRING || m_lType == VAR_CHAR)
            {
                double d = (double)(*this);
                Value((char*)&d, VAR_DOUBLE, 1);
            }
            else
            {
                double * pdValue = new double[m_unLength];
                while (un < m_unLength)
                {
                    pdValue[un] = (double)(*this)[un];
                    un++;
                }
                Value((char *)pdValue, VAR_DOUBLE, m_unLength);
                delete [] pdValue;
            }
        }
        break;
    case VAR_BOOL:
        {
            if (m_lType == VAR_STRING || m_lType == VAR_CHAR)
            {
                bool b = (bool)(*this);
                Value((char*)&b, VAR_BOOL, 1);
            }
            else
            {
                bool * pbValue = new bool[m_unLength];
                while (un < m_unLength)
                {
                    pbValue[un] = (bool)(*this)[un];
                    un++;
                }
                Value((char *)pbValue, VAR_BOOL, m_unLength);
                delete [] pbValue;
            }
        }
        break;
    }
}

void CVariant::Value(char* pcValue, long int lType, unsigned int unLength)
{
    m_bAnyPieceChanged = false;

    if (unLength < 1 || pcValue == NULL)
    {
        if (m_unLength > 1)
        {
            delete [] m_pcValue;
        }

        if (m_pbDataChanged != NULL) 
        {
            delete [] m_pbDataChanged;
        }

        m_pcValue       = NULL;
        m_pbDataChanged = NULL;
        m_unLength      = 0;
        m_lType         = lType;
        
        return;
    }

    int nElementSize        = Size(lType);
    unsigned long ulSize    = nElementSize * unLength;
    unsigned int un         = unLength;

    if (m_pcValue != NULL)
    {
        if (m_unLength == unLength)
        {
            if (lType == m_lType)
            {
                // Same length and same type.  Compare to see if all same.
                if (memcmp(m_pcValue, pcValue, ulSize) == 0)
                    memset(m_pbDataChanged, false, m_unLength);
                else
                {
                    // Not all same, step through each value and compare.
                    int offset              = ulSize;
                    do
                    {
                        --un;
                        offset -= nElementSize;

                        if (memcmp(m_pcValue + offset, pcValue + offset, 
                                   nElementSize) == 0)
                        {
                            m_pbDataChanged[un] = false;
                        }
                        else
                        {
                            m_pbDataChanged[un] = true;
                            m_bAnyPieceChanged = true;
                        }
                    }
                    while (un);
                }
            }
            else
            {
                // Same length but different types.
                // All data must be different.
                m_bAnyPieceChanged = true;
                memset(m_pbDataChanged, true, m_unLength);
            }

            if(m_bAnyPieceChanged == true && m_lType == lType)
            {
                memcpy(m_pcValue, pcValue, ulSize);
            }
            else if (m_lType != lType)
            {
                if (unLength > 1 && ulSize != m_unLength * Size(m_lType))
                {
                    delete [] m_pcValue;
                    m_pcValue = NULL;

                    m_pcValue = new char[ulSize];
                }

                m_lType = lType;

                memcpy(m_pcValue, pcValue, ulSize);
            }
        }
        else
        {
            m_lType = lType;

            if (m_unLength > 1)
            {
                delete [] m_pcValue;
                m_pcValue = NULL;
            }

            if (m_unLength < unLength)
            {
                delete [] m_pbDataChanged;
                m_pbDataChanged = new bool[unLength];
            }

            m_bAnyPieceChanged = true;

            do
            {
                --un;

                m_pbDataChanged[un] = true;
            }
            while (un);

            if (unLength == 1)
                m_pcValue = (char*)&m_varTypeData;
            else
                m_pcValue = new char[ulSize];

            memcpy(m_pcValue, pcValue, ulSize);
            m_unLength = unLength;
        }
    }
    else
    {
        m_lType = lType;

        if (m_pbDataChanged != NULL)
            delete [] m_pbDataChanged;

        m_pbDataChanged = new bool[unLength];

        m_bAnyPieceChanged = true;

        do
        {
            --un;

            m_pbDataChanged[un] = true;
        }
        while (un);

        if (unLength == 1)
            m_pcValue = (char*)&m_varTypeData;
        else
            m_pcValue = new char[ulSize];

        memcpy(m_pcValue, pcValue, ulSize);
        m_unLength = unLength;
    }
}

void CVariant::Value(char cValue, unsigned int unLength)
{
    Value(&cValue, VAR_CHAR, unLength);
}

void CVariant::Value(unsigned char ucValue, unsigned int unLength)
{
//    Value((char *)&ucValue, VAR_UNSIGNED_CHAR, unLength);
}

void CVariant::Value(short int shValue, unsigned int unLength)
{
    Value((char *)&shValue, VAR_SHORT_INT, unLength);
}

void CVariant::Value(unsigned short int ushValue, unsigned int unLength)
{
    Value((char *)&ushValue, VAR_UNSIGNED_SHORT_INT, unLength);
}

void CVariant::Value(long int lValue, unsigned int unLength)
{
    Value((char *)&lValue, VAR_LONG_INT, unLength);
}

void CVariant::Value(unsigned long int ulValue, unsigned int unLength)
{
    Value((char *)&ulValue, VAR_UNSIGNED_LONG_INT, unLength);
}

void CVariant::Value(float fValue, unsigned int unLength)
{
    Value((char *)&fValue, VAR_FLOAT, unLength);
}

void CVariant::Value(double dValue, unsigned int unLength)
{
    Value((char *)&dValue, VAR_DOUBLE, unLength);
}

void CVariant::Value(bool bValue, unsigned int unLength)
{
    Value((char *)&bValue, VAR_BOOL, unLength);
}

void CVariant::Value(const _FSI_STL::string& stlStrData)
{
    Value(const_cast<char *>(stlStrData.c_str()), VAR_STRING, strlen(stlStrData.c_str()));
}

unsigned char CVariant::Size(long lVarType)
{
    if (lVarType > VAR_UNKNOWN &&
        lVarType != VAR_UNSIGNED_CHAR &&
        lVarType < VAR_TOTAL_TYPES)
    {
        return m_ucSizes[lVarType];
    }

    return 0;
}

void* CVariant::CreateVar()
{
    return (void*)m_pcValue;
}

void CVariant::AddValue(CVariant* pVariant)
{
    if (m_ulMaxList < 1)
        return;

    if (pVariant->CreateVar() == NULL ||  pVariant->m_unLength < 1)
        return;

    if (m_pdequeValues != NULL)
    {
        unsigned long ulSize    = Size(pVariant->m_lType) * pVariant->m_unLength;
        VariantListData vld; 
        vld.s_pcValue           = new char[ulSize];
        vld.s_lType             = pVariant->m_lType;
        vld.s_unLength          = pVariant->m_unLength;

        memcpy(vld.s_pcValue, pVariant->CreateVar(), ulSize);

        if (m_pdequeValues->size() == m_ulMaxList)
        {
            if ((*m_pdequeValues)[0].s_pcValue != NULL)
                delete [] (*m_pdequeValues)[0].s_pcValue;

            m_pdequeValues->pop_front();
        }

        m_pdequeValues->push_back(vld);
    }
}

//////////////////////////////////////////////////////////////////////
// Accessors
//////////////////////////////////////////////////////////////////////

bool CVariant::List()
{
    return m_bIsList;
}

unsigned long int CVariant::MaxSize()
{
    return m_ulMaxList;
}

unsigned char CVariant::Precision()
{
    return m_ucPrecision;
}

bool CVariant::LimitFloating()
{
    return m_bLimitFloating;
}

long int CVariant::Type()
{
    return m_lType;
}

unsigned int CVariant::Length()
{
    return m_unLength;
}

bool CVariant::WasChanged(const int nIndex)
{
    if (nIndex >= 0)
    {
        if (nIndex < m_unLength)
            return m_pbDataChanged[nIndex];
    }

    return m_bAnyPieceChanged;
}

_FSI_STL::deque<VariantListData>* CVariant::DataList()
{
    return m_pdequeValues;
}

//////////////////////////////////////////////////////////////////////
// Mutators
//////////////////////////////////////////////////////////////////////

void CVariant::List(bool bList)
{
    m_bIsList = bList;
}

void CVariant::MaxSize(unsigned long int ulMaxSize)
{
    if (m_pdequeValues == NULL)
    {
        m_pdequeValues = new _FSI_STL::deque<VariantListData>;
        m_mapReferenceListCount[(long)m_pdequeValues] = 1;
    }

    if (m_pdequeValues != NULL)
    {
        _FSI_STL::deque<VariantListData>::iterator dIt    = m_pdequeValues->begin();
        _FSI_STL::deque<VariantListData>::iterator dendIt = m_pdequeValues->end();
        while (dIt != dendIt)
        {
            if ((*dIt).s_pcValue != NULL)
                delete [] (*dIt).s_pcValue;

            dIt++;
        }
        m_pdequeValues->clear();

        m_ulMaxList = ulMaxSize;
    }
}

void CVariant::Precision(const unsigned char ucPrecision)
{
    m_ucPrecision = ucPrecision;
}

void CVariant::LimitFloating(const bool bLimitFloating)
{
    m_bLimitFloating = bLimitFloating;
}

void CVariant::WasChanged(const int nIndex, const bool bWasChanged)
{
    if (m_pbDataChanged == NULL)
        return;

    if (bWasChanged == true)
        m_bAnyPieceChanged = true;

    if (nIndex >= 0)
    {
        if (nIndex < m_unLength)
        {
            m_pbDataChanged[nIndex] = bWasChanged;
            return;
        }
    }
}