/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : VariableData.h
//
// Date             : 07 February 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.8 $
//
// Description      : VariableData.h contains the definition of 
//                    the CVariableData class.  It is meant to be 
//                    used by comms systems that use an FML file for 
//                    defining the symbols used in simulation.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : string, CVariant.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3
//                                          Microsoft Windows NT 5.0
//
//                    Compiler(s) - Visual C++ 5.0 with VisC++ service pack 3
//                                  Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: VariableData.h $
// Revision 1.8  2000/06/16 20:52:36  billyb
// Fix type problems with ArrayOffset.  Added FailureData methods.
// Revision 1.7  2000/05/18 20:56:03  billyb
// Added FailureType accessor and mutator.
// Revision 1.6  2000/03/07 15:50:22  billyb
// Removed unused methods.
// Revision 1.4  2000/01/27 08:13:22  billyb
// Added support for an array length and array offset.
// Revision 1.3  1999/09/24 17:26:50  billyb
// Added m_bScreenDependent variable and an accessor
// and a mutator for the variable.
// Revision 1.2  1999/09/02 20:08:03  billyb
// Added initial data format member and accessor and 
// mutator for the new member.
/////////////////////////////////////////////////////////////////////////////
#if !defined(_VARIABLEDATA_H_)
#define _VARIABLEDATA_H_

#ifdef CORE
#define DLLAPI __declspec( dllexport )
#else
#define DLLAPI __declspec( dllimport )
#endif

#include <string>

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class DLLAPI CVariableData  
{
protected:
    // The ID number used in the mappings
    unsigned long int   m_ulVarID;      

    // The CVariant type
    long int            m_lVarType;     

    // Offset into the block of data for this variable; 
    unsigned long int   m_ulOffset;     
                                        
    // The address of the symbol.  May not be used.
    long int            m_lAddress;     

    // size of a list of variants.
    unsigned long int   m_ulListSize;

    // the type of reading to do.
    unsigned long int   m_ulReadMode;

    // Array element number.
    long int            m_lElement;

    // Initial data format;
    long int            m_lDataFormat;

    // Array length
    long int            m_lArrayLength;

    // Whether to record for debriefing
    bool                m_bDebrief;     

    // Boolean for determining if a valid address has been assigned;
    bool                m_bAddressValid;

    // An error occurred on the host.
    short               m_shHostError;

    // The offset index for getting a value from an array.  If
    // they want the 1st element, this value would be 0, 2nd element,
    // 1, etc.
    long int            m_lArrayOffset;

    long int            m_lFailureType;

    // An initial value.  Probably used with local variables.
    _FSI_STL::string    m_stlStrInitialValue; 

    // YES or NO as to whether the variable persists.
    _FSI_STL::string    m_stlStrPersist;

    // The simulation variable name
    _FSI_STL::string         m_stlStrSimVarName; 

    // The failure data string
    _FSI_STL::string         m_stlStrFailureData; 

    // Whether a variable is screen dependent.
    bool                m_bScreenDependent;

public:
	CVariableData();

    // Accessors
    inline unsigned long int    ID();
    inline long int             Type();
    inline _FSI_STL::string     SimVarName();
    inline bool                 Debrief();
    inline unsigned long int    Offset();
    inline long int             Address();
    inline bool                 AddressValid();
    inline _FSI_STL::string     InitialValue();
    inline _FSI_STL::string     Persist();
    inline unsigned long int    ListSize();
    inline unsigned long int    ReadMode();
    inline long int             Element();
    inline short int            HostError();
    inline long int             InitialDataFormat();
    inline bool                 ScreenDependent();
    inline long int             ArrayLength();
    inline long int             ArrayOffset();
    inline long int             FailureType();
    inline _FSI_STL::string     FailureData();

    // Mutators
    inline void ID(const unsigned long int lID);
    inline void Type(const long int lType);
    inline void SimVarName(const _FSI_STL::string& rstlStrVarName);
    inline void Debrief(const bool bDebrief);
    inline void Offset(const unsigned long int ulOffset);
    inline void Address(const long int lAddress);
    inline void AddressValid(const bool bAddressValid);
    inline void InitialValue(const _FSI_STL::string& rstlStrInitialValue);
    inline void Persist(const _FSI_STL::string& rstlStrPersist);
    inline void ListSize(const unsigned long int ulListSize);
    inline void ReadMode(const unsigned long int ulReadMode);
    inline void Element(const long int lElement);
    inline void HostError(const short int shHostError);
    inline void InitialDataFormat(const long int lInitialDataFormat);
    inline void ScreenDependent(const bool bScreenDependent);
    inline void ArrayLength(const long int lArrayLength);
    inline void ArrayOffset(const long int lArrayOffset);
    inline void FailureType(const long int lFailureType);
    inline void FailureData(const _FSI_STL::string& rstlStrData);
};

#endif // !defined(_VARIABLEDATA_H_)
