/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : VariableData.cpp
//
// Date             : 07 February 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.8 $
//
// Description      : VariableData.cpp contains the implementation of 
//                    the CVariableData class.  It is meant to be 
//                    used by comms systems that use an FML file for 
//                    defining the symbols used in simulation.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : string, CVariant.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3
//                                          Microsoft Windows NT 5.0
//
//                    Compiler(s) - Visual C++ 5.0 with VisC++ service pack 3
//                                  Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: VariableData.cpp $
// Revision 1.8  2000/06/16 20:52:29  billyb
// Fix type problems with ArrayOffset.  Added FailureData methods.
// Revision 1.7  2000/05/18 20:56:17  billyb
// Revision 1.4.1.1  2000/05/18 20:55:54  billyb
// Added FailureType accessor and mutator.
// Revision 1.6  2000/03/07 15:50:31  billyb
// Removed unused methods.
// Revision 1.4  2000/01/27 08:13:21  billyb
// Added support for an array length and array offset.
// Revision 1.3  1999/09/24 17:27:14  billyb
// Added m_bScreenDependent variable and an accessor
// and a mutator for the variable.
// Revision 1.2  1999/09/02 20:08:45  billyb
// Added initial data format member and accessor and mutator 
// for the new member.
/////////////////////////////////////////////////////////////////////////////
#include "stdafx.h"
#include "VariableData.h"
#include "Variant.h"
#include "DataConversion.h"


// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CVariableData::CVariableData() :
    m_ulVarID(0),
    m_lVarType(VAR_UNKNOWN),
    m_ulOffset(0),
    m_ulListSize(0),
    m_ulReadMode(1),
    m_lElement(0),
    m_lDataFormat(Generic_No_Conversions),
    m_lArrayLength(1),
    m_bDebrief(false),
    m_bAddressValid(false),
    m_shHostError(0),
    m_lArrayOffset(0),
    m_lFailureType(-1),
    m_stlStrInitialValue("0"),
    m_stlStrPersist("NO"),
    m_stlStrSimVarName("unknown"),
    m_bScreenDependent(false)
{
}

//////////////////////////////////////////////////////////////////////
// Accessors
//////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
// unsigned long int CVariableData::ID()
//
// Inputs           : None.
//
// Return Values    : The ID value for the variable represented by the
//                    current instance of CVariableData.
//
// Date             : 07 February 1999
//
// Engineer         : Billy Baker
//
// Description      : CVariableData::ID is an accessor method for the 
//                    m_ulVarID member of CVariableData.
//
/////////////////////////////////////////////////////////////////////////////
unsigned long int CVariableData::ID()
{
    return m_ulVarID;
}

/////////////////////////////////////////////////////////////////////////////
//
// unsigned long int CVariableData::Type()
//
// Inputs           : None.
//
// Return Values    : The CVariant type value for the variable represented by 
//                    the current instance of CVariableData.
//
// Date             : 07 February 1999
//
// Engineer         : Billy Baker
//
// Description      : CVariableData::Type is an accessor method for the 
//                    m_lType member of CVariableData.
//
/////////////////////////////////////////////////////////////////////////////
long int CVariableData::Type()
{
    return m_lVarType;
}

/////////////////////////////////////////////////////////////////////////////
//
// unsigned long int CVariableData::SimVarName()
//
// Inputs           : None.
//
// Return Values    : The SimVarName value for the variable represented by the
//                    current instance of CVariableData.
//
// Date             : 07 February 1999
//
// Engineer         : Billy Baker
//
// Description      : CVariableData::VarName is an accessor method for the 
//                    m_stlStrSimVarName member of CVariableData.
//
/////////////////////////////////////////////////////////////////////////////
_FSI_STL::string CVariableData::SimVarName()
{
    return m_stlStrSimVarName;
}

/////////////////////////////////////////////////////////////////////////////
//
// unsigned long int CVariableData::Debrief()
//
// Inputs           : None.
//
// Return Values    : The Debrief value for the variable represented by the
//                    current instance of CVariableData.
//
// Date             : 07 February 1999
//
// Engineer         : Billy Baker
//
// Description      : CVariableData::Debrief is an accessor method for the 
//                    m_bDebrief member of CVariableData.
//
/////////////////////////////////////////////////////////////////////////////
bool CVariableData::Debrief()
{
    return m_bDebrief;
}

/////////////////////////////////////////////////////////////////////////////
//
// unsigned long int CVariableData::Offset()
//
// Inputs           : None.
//
// Return Values    : the Offset value for the variable into the
//                    block of memory from the source.
//
// Date             : 12 February 1999
//
// Engineer         : Billy Baker
//
// Description      : CVariableData::Offset is a accessor method for the 
//                    m_ulOffset member of CVariableData.
//
/////////////////////////////////////////////////////////////////////////////
unsigned long int CVariableData::Offset()
{
    return m_ulOffset;
}

/////////////////////////////////////////////////////////////////////////////
//
// unsigned long int CVariableData::Address()
//
// Inputs           : None.
//
// Return Values    : The address of the variable represented by the current
//                    instance of CVariableData.  This value was obtained from 
//                    a symbol table file.
//
// Date             : 07 February 1999
//
// Engineer         : Billy Baker
//
// Description      : CVariableData::Address is an accessor method for the 
//                    m_lAddress member.
//
/////////////////////////////////////////////////////////////////////////////
long int CVariableData::Address()
{
    return m_lAddress;
}

/////////////////////////////////////////////////////////////////////////////
//
// bool CVariableData::AddressValid()
//
// Inputs           : None.
//
// Return Values    : Boolean for whether the address has been set.
//
// Date             : 03 March 1999
//
// Engineer         : Billy Baker
//
// Description      : CVariableData::AddressValid is an accessor method for the 
//                    m_bAddressValid member.
//
/////////////////////////////////////////////////////////////////////////////
bool CVariableData::AddressValid()
{
    return m_bAddressValid;
}

/////////////////////////////////////////////////////////////////////////////
//
// _FSI_STL::string CVariableData::InitialValue()
//
// Inputs           : None.
//
// Return Values    : String with an initial value.
//
// Date             : 16 March 1999
//
// Engineer         : Billy Baker
//
// Description      : CVariableData::InitialValue is an accessor method for the 
//                    m_stlStrInitialValue member.
//
/////////////////////////////////////////////////////////////////////////////
_FSI_STL::string CVariableData::InitialValue()
{
    return m_stlStrInitialValue;
}

/////////////////////////////////////////////////////////////////////////////
//
// _FSI_STL::string CVariableData::Persist()
//
// Inputs           : None.
//
// Return Values    : String with YES or NO.
//
// Date             : 24 March 1999
//
// Engineer         : Billy Baker
//
// Description      : CVariableData::Persist is an accessor method for the 
//                    m_stlStrPersist member.
//
/////////////////////////////////////////////////////////////////////////////
_FSI_STL::string CVariableData::Persist()
{
    return m_stlStrPersist;
}

/////////////////////////////////////////////////////////////////////////////
//
// unsigned long int CVariableData::ListSize()
//
// Inputs           : None.
//
// Return Values    : the size of a list of variants
//
// Date             : 24 March 1999
//
// Engineer         : Billy Baker
//
// Description      : CVariableData::ListSize is an accessor method for the 
//                    m_ulListSize member of CVariableData.
//
/////////////////////////////////////////////////////////////////////////////
unsigned long int CVariableData::ListSize()
{
    return m_ulListSize;
}

/////////////////////////////////////////////////////////////////////////////
//
// unsigned long int CVariableData::ReadMode()
//
// Inputs           : None.
//
// Return Values    : the type of reading to perform
//
// Date             : 24 March 1999
//
// Engineer         : Billy Baker
//
// Description      : CVariableData::ReadMode is an accessor method for the 
//                    m_ulReadMode member of CVariableData.
//
/////////////////////////////////////////////////////////////////////////////
unsigned long int CVariableData::ReadMode()
{
    return m_ulReadMode;
}

/////////////////////////////////////////////////////////////////////////////
//
// long int CVariableData::Element()
//
// Inputs           : None.
//
// Return Values    : array index.
//
// Date             : 24 March 1999
//
// Engineer         : Billy Baker
//
// Description      : CVariableData::Element is an accessor method for the 
//                    m_lElement member of CVariableData.
//
/////////////////////////////////////////////////////////////////////////////
long int CVariableData::Element()
{
    return m_lElement;
}

/////////////////////////////////////////////////////////////////////////////
//
// short int CVariableData::HostError()
//
// Inputs           : None.
//
// Return Values    : command ID for last host error.
//
// Date             : 24 March 1999
//
// Engineer         : Billy Baker
//
// Description      : CVariableData::HostError is an accessor method for the 
//                    m_shHostError member of CVariableData.
//
/////////////////////////////////////////////////////////////////////////////
short int CVariableData::HostError()
{
    return m_shHostError;
}

/////////////////////////////////////////////////////////////////////////////
//
// long int CVariableData::InitialDataFormat()
//
// Inputs           : None.
//
// Return Values    : The initial data format which should correspond to a
//                    value in DATA_FORMATS in CDataConversion.
//
// Date             : 31 August 1999
//
// Engineer         : Billy Baker
//
// Description      : CVariableData::InitialDataFormat is an accessor method 
//                    for the m_lDataFormat member.
//
/////////////////////////////////////////////////////////////////////////////
long int CVariableData::InitialDataFormat()
{
    return m_lDataFormat;
}

/////////////////////////////////////////////////////////////////////////////
//
// long int CVariableData::ScreenDependent()
//
// Inputs           : None.
//
// Return Values    : Whether the variable is screen dependent.
//
// Date             : 23 September 1999
//
// Engineer         : Billy Baker
//
// Description      : CVariableData::ScreenDependent is an accessor method 
//                    for the m_bScreenDependent member.
//
/////////////////////////////////////////////////////////////////////////////
bool CVariableData::ScreenDependent()
{
    return m_bScreenDependent;
}

/////////////////////////////////////////////////////////////////////////////
//
// long int CVariableData::ArrayLength()
//
// Inputs           : None.
//
// Return Values    : Length of a host array.
//
// Date             : 28 December 1999
//
// Engineer         : Billy Baker
//
// Description      : CVariableData::ArrayLength is an accessor method 
//                    for the m_lArrayLength member.
//
/////////////////////////////////////////////////////////////////////////////
long int CVariableData::ArrayLength()
{
    return m_lArrayLength;
}

/////////////////////////////////////////////////////////////////////////////
//
// unsigned long int CVariableData::ArrayOffset()
//
// Inputs           : None.
//
// Return Values    : Offset index from beginning of an array.
//
// Date             : 23 January 2000
//
// Engineer         : Billy Baker
//
// Description      : CVariableData::ArrayOffset is an accessor method 
//                    for the m_ulArrayOffset member.  If the 1st index is
//                    desired, then m_ulArrayOffset should be 0. if the 2nd
//                    then m_ulArrayOffset should be 1.  Etc.
//
/////////////////////////////////////////////////////////////////////////////
long int CVariableData::ArrayOffset()
{
    return m_lArrayOffset;
}

/////////////////////////////////////////////////////////////////////////////
//
// long int CVariableData::FailureType()
//
// Inputs           : None.
//
// Return Values    : Type of failure for a variable.  -1 for none.  See 
//                    Comms::CFailureSummarySystemInterface.
//
// Date             : 15 May 2000
//
// Engineer         : Billy Baker
//
// Description      : CVariableData::FailureType is an accessor method 
//                    for the m_lFailureType member.  
//
/////////////////////////////////////////////////////////////////////////////
long int CVariableData::FailureType()
{
    return m_lFailureType;
}

/////////////////////////////////////////////////////////////////////////////
//
// _FSI_STL::string CVariableData::FailureData()
//
// Inputs           : None.
//
// Return Values    : Data for failure
//
// Date             : 12 June 2000
//
// Engineer         : Billy Baker
//
// Description      : CVariableData::FailureData is an accessor method 
//                    for the m_stlStrFailureData member.  
//
/////////////////////////////////////////////////////////////////////////////
_FSI_STL::string CVariableData::FailureData()
{
    return m_stlStrFailureData;
}

//////////////////////////////////////////////////////////////////////
// Mutators
//////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
// void CVariableData::ID()
//
// Inputs           : const unsigned long ID - the ID value for the variable 
//                                             represented by the current 
//                                             instance of CVariableData.
//
// Return Values    : None.
//
// Date             : 07 February 1999
//
// Engineer         : Billy Baker
//
// Description      : CVariableData::ID is a mutator method for the 
//                    m_ulVarID member of CVariableData.
//
/////////////////////////////////////////////////////////////////////////////
void CVariableData::ID(const unsigned long lID)
{
    m_ulVarID = lID;
}

/////////////////////////////////////////////////////////////////////////////
//
// void CVariableData::Type()
//
// Inputs           : const long int lType - the CVariant type value for the 
//                                           variable represented by the 
//                                           current instance of CVariableData.
//
// Return Values    : None.
//
// Date             : 07 February 1999
//
// Engineer         : Billy Baker
//
// Description      : CVariableData::Type is a mutator method for the 
//                    m_lType member of CVariableData.
//
/////////////////////////////////////////////////////////////////////////////
void CVariableData::Type(const long int lType)
{
    m_lVarType = lType;
}

/////////////////////////////////////////////////////////////////////////////
//
// void CVariableData::SimVarName()
//
// Inputs           : const _FSI_STL::string& rstlStrVarName - The VarName value for
//                                           the variable represented by the
//                                           current instance of CVariableData.
//
// Return Values    : None.
//
// Date             : 07 February 1999
//
// Engineer         : Billy Baker
//
// Description      : CVariableData::SimVarName is a mutator method for the 
//                    m_stlStrSimVarName member of CVariableData.
//
/////////////////////////////////////////////////////////////////////////////
void CVariableData::SimVarName(const _FSI_STL::string& rstlStrVarName)
{
    m_stlStrSimVarName = rstlStrVarName;
}

/////////////////////////////////////////////////////////////////////////////
//
// void CVariableData::Debrief()
//
// Inputs           : const bool bDebrief - the Debrief value for the variable 
//                                          represented by the current instance
//                                          of CVariableData.
//
// Return Values    : None.
//
// Date             : 12 February 1999
//
// Engineer         : Billy Baker
//
// Description      : CVariableData::Debrief is a mutator method for the 
//                    m_bDebrief member of CVariableData.
//
/////////////////////////////////////////////////////////////////////////////
void CVariableData::Debrief(const bool bDebrief)
{
    m_bDebrief = bDebrief;
}

/////////////////////////////////////////////////////////////////////////////
//
// void CVariableData::Offset()
//
// Inputs           : const unsigned long int ulOffset - the Offset value for 
//                                                       the variable into the
//                                                       block of memory from
//                                                       the source.
//
// Return Values    : None.
//
// Date             : 12 February 1999
//
// Engineer         : Billy Baker
//
// Description      : CVariableData::Offset is a mutator method for the 
//                    m_ulOffset member of CVariableData.
//
/////////////////////////////////////////////////////////////////////////////
void CVariableData::Offset(const unsigned long int ulOffset)
{
    m_ulOffset = ulOffset;
}

/////////////////////////////////////////////////////////////////////////////
//
// void CVariableData::Address()
//
// Inputs           : const long int lAddress - the address of the variable 
//                                              represented by the current
//                                              instance of CVariableData.  
//                                              This value was obtained from 
//                                              a symbol table file.
//
// Return Values    : None.
//
// Date             : 07 February 1999
//
// Engineer         : Billy Baker
//
// Description      : CVariableData::Address is a mutator method for the 
//                    m_lAddress member.
//
/////////////////////////////////////////////////////////////////////////////
void CVariableData::Address(const long int lAddress)
{
    m_lAddress = lAddress;
}

/////////////////////////////////////////////////////////////////////////////
//
// void CVariableData::AddressValid()
//
// Inputs           : bool bAddressValid - whether the address is valid.
//
// Return Values    : None.
//
// Date             : 03 March 1999
//
// Engineer         : Billy Baker
//
// Description      : CVariableData::AddressValid is a mutator method for the 
//                    m_bAddressValid member.
//
/////////////////////////////////////////////////////////////////////////////
void CVariableData::AddressValid(const bool bAddressValid)
{
    m_bAddressValid = bAddressValid;
}

/////////////////////////////////////////////////////////////////////////////
//
// void CVariableData::InitialValue()
//
// Inputs           : _FSI_STL::string& rstlStrInitialValue - an initial value.
//
// Return Values    : None.
//
// Date             : 16 March 1999
//
// Engineer         : Billy Baker
//
// Description      : CVariableData::InitialValue is a mutator method for the 
//                    m_stlStrInitialValue member.
//
/////////////////////////////////////////////////////////////////////////////
void CVariableData::InitialValue(const _FSI_STL::string& rstlStrInitialValue)
{
    m_stlStrInitialValue = rstlStrInitialValue;
}

/////////////////////////////////////////////////////////////////////////////
//
// void CVariableData::Persist()
//
// Inputs           : _FSI_STL::string& rstlStrPersit - whether the variable persists
//
// Return Values    : None.
//
// Date             : 24 March 1999
//
// Engineer         : Billy Baker
//
// Description      : CVariableData::Persist is a mutator method for the 
//                    m_stlStrPersist member.
//
/////////////////////////////////////////////////////////////////////////////
void CVariableData::Persist(const _FSI_STL::string& rstlStrPersist)
{
    m_stlStrPersist = rstlStrPersist;
}

/////////////////////////////////////////////////////////////////////////////
//
// void CVariableData::ListSize()
//
// Inputs           : const unsigned long int ulListSize - size of a list of 
//                                                       variants.
//
// Return Values    : None.
//
// Date             : 24 March 1999
//
// Engineer         : Billy Baker
//
// Description      : CVariableData::ListSize is a mutator method for the 
//                    m_ulListSize member of CVariableData.
//
/////////////////////////////////////////////////////////////////////////////
void CVariableData::ListSize(const unsigned long int ulListSize)
{
    m_ulListSize = ulListSize;
}

/////////////////////////////////////////////////////////////////////////////
//
// void CVariableData::ReadMode()
//
// Inputs           : const unsigned long int ulReadMode - type of reading.
//
// Return Values    : None.
//
// Date             : 24 March 1999
//
// Engineer         : Billy Baker
//
// Description      : CVariableData::ReadMode is a mutator method for the 
//                    m_ulReadMode member of CVariableData.
//
/////////////////////////////////////////////////////////////////////////////
void CVariableData::ReadMode(const unsigned long int ulReadMode)
{
    m_ulReadMode = ulReadMode;
}

/////////////////////////////////////////////////////////////////////////////
//
// void CVariableData::Element()
//
// Inputs           : const long int lElement - array index.
//
// Return Values    : None.
//
// Date             : 1 April 1999
//
// Engineer         : Billy Baker
//
// Description      : CVariableData::Element is a mutator method for the 
//                    m_lElement member of CVariableData.
//
/////////////////////////////////////////////////////////////////////////////
void CVariableData::Element(const long int lElement)
{
    m_lElement = lElement;
}

/////////////////////////////////////////////////////////////////////////////
//
// void CVariableData::HostError()
//
// Inputs           : const short int shHostError - command ID of last error.
//
// Return Values    : None.
//
// Date             : 1 April 1999
//
// Engineer         : Billy Baker
//
// Description      : CVariableData::HostError is a mutator method for the 
//                    m_shHostError member of CVariableData.
//
/////////////////////////////////////////////////////////////////////////////
void CVariableData::HostError(const short int shHostError)
{
    m_shHostError = shHostError;
}

/////////////////////////////////////////////////////////////////////////////
//
// void CVariableData::InitialDataFormat()
//
// Inputs           : const long int lInitialDataFormat - initial data format.
//
// Return Values    : None.
//
// Date             : 31 August 1999
//
// Engineer         : Billy Baker
//
// Description      : CVariableData::InitialDataFormat is a mutator method for
//                    the m_lDataFormat member.
//
/////////////////////////////////////////////////////////////////////////////
void CVariableData::InitialDataFormat(const long int lInitialDataFormat)
{
    if (lInitialDataFormat < Generic_No_Conversions ||
        lInitialDataFormat >= Total_Data_Formats)
    {
        m_lDataFormat = Generic_No_Conversions;
    }
    else
    {
        m_lDataFormat = lInitialDataFormat;
    }
}

/////////////////////////////////////////////////////////////////////////////
//
// void CVariableData::ScreenDependent()
//
// Inputs           : const bool bScreenDependent - whether a variable is
//                                                  screen dependent
//
// Return Values    : None.
//
// Date             : 23 September 1999
//
// Engineer         : Billy Baker
//
// Description      : CVariableData::ScreenDependent is a mutator method for
//                    the m_bScreenDependent member.
//
/////////////////////////////////////////////////////////////////////////////
void CVariableData::ScreenDependent(const bool bScreenDependent)
{
    m_bScreenDependent = bScreenDependent;
}

/////////////////////////////////////////////////////////////////////////////
//
// void CVariableData::ArrayLength()
//
// Inputs           : const long int lArrayLength - length of a host array
//
// Return Values    : None.
//
// Date             : 28 December 1999
//
// Engineer         : Billy Baker
//
// Description      : CVariableData::ArrayLength() is a mutator method for
//                    the m_lArrayLength member.
//
/////////////////////////////////////////////////////////////////////////////
void CVariableData::ArrayLength(const long int lArrayLength)
{
    m_lArrayLength = lArrayLength;
}

/////////////////////////////////////////////////////////////////////////////
//
// void CVariableData::ArrayOffset()
//
// Inputs           : const unsigned long int ulArrayOffset - offset index
//                                                  from beginning of array.
//
// Return Values    : None.
//
// Date             : 23 January 2000
//
// Engineer         : Billy Baker
//
// Description      : CVariableData::ArrayOffset is a mutator method 
//                    for the m_ulArrayOffset member.  If the 1st index is
//                    desired, then m_ulArrayOffset should be 0. if the 2nd
//                    then m_ulArrayOffset should be 1.  Etc.
//
/////////////////////////////////////////////////////////////////////////////
void CVariableData::ArrayOffset(const long int lArrayOffset)
{
    m_lArrayOffset = lArrayOffset;
}

/////////////////////////////////////////////////////////////////////////////
//
// void CVariableData::FailureType()
//
// Inputs           : const long int ulFailureType - type of failure possible.
//
// Return Values    : None.
//
// Date             : 15 May 2000
//
// Engineer         : Billy Baker
//
// Description      : CVariableData::FailureType is a mutator method 
//                    for the m_lFailureType member.  -1 is the default for
//                    no failure.  See Comms::CFailureSummarySystemInterface
//                    for other possible values.
//
/////////////////////////////////////////////////////////////////////////////
void CVariableData::FailureType(const long int lFailureType)
{
    m_lFailureType = lFailureType;
}

/////////////////////////////////////////////////////////////////////////////
//
// void CVariableData::FailureData()
//
// Inputs           : const _FSI_STL::string& rstlStrData - data for failure.
//
// Return Values    : None.
//
// Date             : 12 June 2000
//
// Engineer         : Billy Baker
//
// Description      : CVariableData::FailureData is a mutator method 
//                    for the m_stlStrFailureData member.  
//
/////////////////////////////////////////////////////////////////////////////
void CVariableData::FailureData(const _FSI_STL::string& rstlStrData)
{
    m_stlStrFailureData = rstlStrData;
}

