/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : ValuePage.cpp
//
// Date             : 26 August 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.5 $
//
// Description      : ValuePage.cpp contains the implementation of the 
//                    CValuePage class.  This class is used in the page 
//                    editor to enter information about what should be 
//                    displayed on a widget such as a text widget.  
//                    Alignment values may be entered here as well.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : _FSI_STL::string, Core::CBasePage, Core::CXMLElement,
//                    Core::CXMLWidget, Core::CWidget, STRING2STRING_MAP.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3, 4, or 5
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: ValuePage.cpp $                                                                   //
// Revision 1.5  2000/03/07 15:39:51  billyb                                                                   //
// Removed unused methods.  Changed calls to AddElementValue.                                                                   //
// Revision 1.4  2000/02/11 18:31:45  billyb                                                                   //
// Changed include for stdafx.h.                                                                   //
// Revision 1.3  1999/08/26 19:33:24  billyb                                                                   //
// Corrected problem of pWnd not being defined in OnInitDialog.                                                                   //
/////////////////////////////////////////////////////////////////////////////
#include "stdafx.h"
#include "ValuePage.h"

#include "..\core\widget.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CValuePage::CValuePage() : CBasePage(CValuePage::IDD)
{
	//{{AFX_DATA_INIT(CValuePage)
	m_strValue = _T("");
	m_nAlign = -1;
	m_nVAlign = -1;
	m_nTextMaxMin = 0;
	//}}AFX_DATA_INIT
    m_stlStrPageName = _FSI_STL::string("Default Value");
}

void CValuePage::DoDataExchange(CDataExchange* pDX)
{
	CBasePage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CValuePage)
	DDX_Text(pDX, IDC_VALUE, m_strValue);
	DDX_Radio(pDX, IDC_LEFT_RADIO, m_nAlign);
	DDX_Radio(pDX, IDC_TOP_RADIO, m_nVAlign);
	DDX_Radio(pDX, IDC_USE_TEXT_VALUE, m_nTextMaxMin);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CValuePage, CBasePage)
	//{{AFX_MSG_MAP(CValuePage)
	ON_BN_CLICKED(IDC_USE_TEXT_VALUE, OnUseTextValue)
	ON_BN_CLICKED(IDC_SHOW_MAX_VALUE, OnShowMaxValue)
	ON_BN_CLICKED(IDC_SHOW_MIN_VALUE, OnShowMinValue)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CValuePage message handlers
CBasePage* CValuePage::CreateObject()
{
    return new CValuePage;
}

void CValuePage::SetProperties(void* pWidget)
{
    CXMLWidget* pXMLWidget = ((CWidget*)pWidget)->XMLWidget();
    if (pXMLWidget != NULL)
    {
        CXMLElement* pXMLElement = NULL;
        POSITION pos = NULL;
        if (pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("VALUE")) == true)
        {
            m_strValue = (pXMLElement->ElementValue().c_str());
//            m_strValue.Replace("&nbsp;"," ");
            STRING2STRING_MAP::iterator s2sIt = NULL;
            if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("ALIGN")) == true)
            {
                m_nAlign = atoi((*s2sIt).second.c_str());
            }

            if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("VALIGN")) == true)
            {
                m_nVAlign = atoi((*s2sIt).second.c_str());
            }

            if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("STYLE")) == true)
            {
                m_nTextMaxMin = atoi((*s2sIt).second.c_str());
            }
        }
    }
}

void CValuePage::UpdateProperties(void* pWidget)
{
    CXMLWidget* pXMLWidget = ((CWidget*)pWidget)->XMLWidget();
    if (pXMLWidget != NULL && GetSafeHwnd() != NULL)
    {
        UpdateData(TRUE);
        CXMLElement* pXMLElement = NULL;
        POSITION pos = NULL;
        if (pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("VALUE")) == true)
        {
//            m_strValue.Replace(" ", "&nbsp;");
            pXMLElement->AddElementValue(_FSI_STL::string((LPCTSTR)m_strValue));
            STRING2STRING_MAP::iterator s2sIt = NULL;
            CString strValue;
            if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("ALIGN")) == true)
            {
                strValue.Format("%d",m_nAlign);
                (*s2sIt).second = _FSI_STL::string((LPCTSTR)strValue);
            }

            if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("VALIGN")) == true)
            {
                strValue.Format("%d",m_nVAlign);
                (*s2sIt).second = _FSI_STL::string((LPCTSTR)strValue);
            }

            if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("STYLE")) == true)
            {
                strValue.Format("%d",m_nTextMaxMin);
                (*s2sIt).second = _FSI_STL::string((LPCTSTR)strValue);
            }
//            m_strValue.Replace("&nbsp;", " ");
        }
    }
}

void CValuePage::OnUseTextValue() 
{
    CWnd* pWnd = GetDlgItem(IDC_VALUE);
    if (pWnd == NULL)
    {
        return;
    }

	pWnd->EnableWindow(TRUE);
}

void CValuePage::OnShowMaxValue() 
{
    CWnd* pWnd = GetDlgItem(IDC_VALUE);
    if (pWnd == NULL)
    {
        return;
    }

	pWnd->EnableWindow(FALSE);
}

void CValuePage::OnShowMinValue() 
{
    CWnd* pWnd = GetDlgItem(IDC_VALUE);
    if (pWnd == NULL)
    {
        return;
    }

	pWnd->EnableWindow(FALSE);
}

BOOL CValuePage::OnInitDialog() 
{
	CBasePage::OnInitDialog();
	
    CWnd* pWnd = GetDlgItem(IDC_VALUE);
    if (pWnd == NULL)
    {
        return TRUE;
    }

    if (m_nTextMaxMin == 0)
    {
	    pWnd->EnableWindow(TRUE);
    }
    else
    {
	    pWnd->EnableWindow(FALSE);
    }

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
