/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : UpdateList.h
//
// Date             : 28 November 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.5 $
//
// Description      : UpdateList.h contains the definition of the 
//                    CUpdateList class.  This class is used to keep track
//                    of the lists of widgets to be updated on the screen.
//                    Each unique HWND has a unique list of widgets.  This
//                    list is used by both the COMMS thread and the 
//                    threads that have a document, view, and mainframe.
//                    This class may actually become obsolete if 
//                    everything attached to the HWND is redrawn every
//                    pass.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : _FSI_STL::map, _FSI_STL::list, Core::CWidget.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3, 4, or 5
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: UpdateList.h $                                                                   
// Revision 1.5  2000/04/07 05:23:21  billyb                                                                   
// Added support for better FPS display in comms stats.                                                                   
// Revision 1.4  2000/03/30 08:06:07  billyb                                                                   
// Deleted unused code and data structures.  Added better                                                                   
// thread safety.                                                                   
// Revision 1.3  2000/01/27 08:12:20  billyb                                                                   
// Contains test code for multithreaded drawing and support                                                                   
// for drawing widgets that received WM_PAINT messages.                                                                   
// Revision 1.2  1999/11/28 22:04:56  billyb                                                                   
// Added comments.  Exported class for use by COMMS trhead.                                                                   
// Added GetList and Cleanup methods.  Added map data                                                                   
// structure for keeping track of the lists and their associated                                                                   
// hWnds.                                                                   
/////////////////////////////////////////////////////////////////////////////
#if !defined(_UPDATELIST_H_)
#define _UPDATELIST_H_

#ifdef CORE
#define DLLAPI __declspec( dllexport )
#else
#define DLLAPI __declspec( dllimport )
#endif

#include <map>
#include <list>
#include <string>
#include <afxmt.h>

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CWidget;
class CEvent;

class DLLAPI CUpdateList  
{
private:
    static CCriticalSection                                     m_syncRefresh;
    static _FSI_STL::map<HWND, _FSI_STL::map<long, CWidget*> >  m_mapLists;
    static _FSI_STL::map<HWND, _FSI_STL::map<CWidget*, bool> >  m_mapPaintWidgets;

    static CCriticalSection                                     m_syncPaintList;

protected:
    static _FSI_STL::map<HWND, _FSI_STL::string>                m_mapUpdateWindowText;

public:
    static _FSI_STL::map<long, CWidget*> GetList(const HWND hWnd);

    static void SetList(HWND hWnd, _FSI_STL::map<long, CWidget*>& mapRefresh);

    static _FSI_STL::map<HWND, _FSI_STL::map<CWidget*, bool> > GetPaintMap();

    static void     Cleanup(const HWND hWnd);

    static void     AddPaintWidget(const HWND hWnd, CWidget* pWidget);

    static _FSI_STL::string UpdateWindowText(const HWND hWnd);
};

#endif // !defined(_UPDATELIST_H_)
