/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : UpdateList.cpp
//
// Date             : 28 November 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.8 $
//
// Description      : UpdateList.cpp contains the implementation of the 
//                    CUpdateList class.  This class is used to keep track
//                    of the lists of widgets to be updated on the screen.
//                    Each unique HWND has a unique list of widgets.  This
//                    list is used by both the COMMS thread and the 
//                    threads that have a document, view, and mainframe.
//                    This class may actually become obsolete if 
//                    everything attached to the HWND is redrawn every
//                    pass.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : _FSI_STL::map, _FSI_STL::list, Core::CWidget.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3, 4, or 5
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: UpdateList.cpp $                                                                   
// Revision 1.8  2000/06/16 20:51:05  billyb                                                                   
// Moved code out of Lock area.                                                                   
// Revision 1.7  2000/05/04 17:47:41  billyb                                                                   
// Fixed freeze on areamap.  Locks are locked for less time now.                                                                   
// Revision 1.6  2000/04/07 05:23:21  billyb                                                                   
// Added support for better FPS display in comms stats.                                                                   
// Revision 1.5  2000/03/31 22:47:11  billyb                                                                   
// Removed debugging code.                                                                   
// Revision 1.4  2000/03/30 08:05:44  billyb                                                                   
// Deleted unused code and data structures.  Added better                                                                   
// thread safety.                                                                   
// Revision 1.3  2000/01/27 08:12:15  billyb                                                                   
// Contains test code for multithreaded drawing and support                                                                   
// for drawing widgets that received WM_PAINT messages.                                                                   
// Revision 1.2  1999/11/28 22:04:44  billyb                                                                   
// Added comments.  Exported class for use by COMMS trhead.                                                                   
// Added GetList and Cleanup methods.  Added map data                                                                   
// structure for keeping track of the lists and their associated                                                                   
// hWnds.                                                                   
/////////////////////////////////////////////////////////////////////////////
#include "stdafx.h"
#include <afxmt.h>
#include "UpdateList.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

_FSI_STL::map<HWND, _FSI_STL::map<long, CWidget*> > CUpdateList::m_mapLists;
_FSI_STL::map<HWND, _FSI_STL::map<CWidget*, bool> > CUpdateList::m_mapPaintWidgets;
CCriticalSection                                    CUpdateList::m_syncRefresh;
_FSI_STL::map<HWND, _FSI_STL::string>               CUpdateList::m_mapUpdateWindowText;
CCriticalSection                                    CUpdateList::m_syncPaintList;

/////////////////////////////////////////////////////////////////////////////
//
// _FSI_STL::list<CWidget*>* CUpdateList::GetList()
//
// Inputs           : const HWND hWnd - the HWND that needs to be updated
//                    .
//
// Return Values    : A pointer to a list that contains pointers to 
//                    CWidget instances that are attached to the HWND 
//                    that 
//                    is passed.
//
// Date             : 28 November 1999
//
// Engineer         : Billy Baker
//
// Description      : CUpdateList::GetList should be used to get the list 
//                    data structure that is used by both the COMMS thread 
//                    and the display threads.  For each HWND, a list 
//                    is only created once.  When the HWND is about to 
//                    be destroyed, it should call Cleanup to delete 
//                    the memory for the list.
//
/////////////////////////////////////////////////////////////////////////////
_FSI_STL::map<long, CWidget*> CUpdateList::GetList(const HWND hWnd)
{
    _FSI_STL::map<long, CWidget*> mapRefresh;

    // Make sure there is a valid window
    if (hWnd != NULL)
    {
        if (m_mapLists.find(hWnd) != m_mapLists.end())
        {
            m_syncRefresh.Lock();

            mapRefresh  = m_mapLists[hWnd];

            m_mapLists[hWnd].clear();

            m_syncRefresh.Unlock();
        }
    }

    // Return the existing list.
    return mapRefresh;
}

void CUpdateList::SetList(HWND hWnd, _FSI_STL::map<long, CWidget*>& mapRefresh)
{
    if (hWnd != NULL)
    {
        m_syncRefresh.Lock();

        m_mapLists[hWnd] = mapRefresh;

        m_syncRefresh.Unlock();
    }
}

_FSI_STL::map<HWND, _FSI_STL::map<CWidget*, bool> > CUpdateList::GetPaintMap()
{
    _FSI_STL::map<HWND, _FSI_STL::map<CWidget*, bool> > mapPaintWidgets;

    _FSI_STL::map<HWND, _FSI_STL::map<CWidget*, bool> >::iterator mIt = NULL;
    _FSI_STL::map<HWND, _FSI_STL::map<CWidget*, bool> >::iterator mendIt = NULL;

    m_syncPaintList.Lock();

    mapPaintWidgets = m_mapPaintWidgets;

    mIt = m_mapPaintWidgets.begin();
    mendIt = m_mapPaintWidgets.end();

    while (mIt != mendIt)
    {
        (*mIt).second.clear();

        mIt++;
    }

    m_mapPaintWidgets.clear();

    m_syncPaintList.Unlock();

    // Return the existing list.
    return mapPaintWidgets;
}

/////////////////////////////////////////////////////////////////////////////
//
// void CUpdateList::Cleanup()
//
// Inputs           : const HWND hWnd - the HWND that needs to be updated
//
// Return Values    : None.
//
// Date             : 28 November 1999
//
// Engineer         : Billy Baker
//
// Description      : CUpdateList::Cleanup should be called when a 
//                    window that is associated with a list is 
//                    destroyed.  Invoking Cleanup will delete the 
//                    memory for the list.
//
/////////////////////////////////////////////////////////////////////////////
void CUpdateList::Cleanup(const HWND hWnd)
{
}

void CUpdateList::AddPaintWidget(const HWND hWnd, CWidget* pWidget)
{
    if (pWidget != NULL && hWnd != NULL)
    {
        m_syncPaintList.Lock();

        (m_mapPaintWidgets[hWnd])[pWidget] = true;

        m_syncPaintList.Unlock();
    }
}

_FSI_STL::string CUpdateList::UpdateWindowText(HWND hWnd)
{
    if (m_mapUpdateWindowText.find(hWnd) != m_mapUpdateWindowText.end())
        return m_mapUpdateWindowText[hWnd];

    return _FSI_STL::string("Window not found");
}