// Ticks.h: interface for the CTicks class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_TICKS_H__E02411D1_6AC9_11D2_AD4F_006008B0E0C3__INCLUDED_)
#define AFX_TICKS_H__E02411D1_6AC9_11D2_AD4F_006008B0E0C3__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#ifdef CORE
#define DLLAPI __declspec( dllexport )
#else
#define DLLAPI __declspec( dllimport )
#endif


#include <afxtempl.h>
#include <gl\gl.h>              // OpenGL
#include <gl\glu.h>             // GLU library
#include "..\core\OpenGLtext.h"
#include "..\core\OpenGLCircle.h"

typedef  enum  tick_type
{
   NO_TICK,
   MAJOR,
   MINOR,
   INTERMEDIATE,
   MAJOR_CIRCLE,
   MINOR_CIRCLE,
   INTERMEDIATE_CIRCLE,
   MAJOR_DIAMOND,
   MINOR_DIAMOND,
   INTERMEDIATE_DIAMOND,
   MAJOR_RECTANGLE,
   MINOR_RECTANGLE,
   INTERMEDIATE_RECTANGLE
};

typedef  struct
{
   float       location;
   tick_type   type;
   char        ident[8];
}  TICK_INFO;

// Tick layout
#define  ARC         true
#define  LINEAR      false

#define  HORIZONTAL  true     // Only meaningful when Tick layout is LINEAR.
#define  VERTICAL    false    // Only meaningful when Tick layout is LINEAR.

class DLLAPI CTicks  
{
public:
	CTicks();
	virtual ~CTicks();

   virtual  void  Initialize(void);
   virtual  void  Draw(void);

   void  DrawTickMarks(bool draw_ticks_from_outer_radius_toward_label_radius  =  true);
   void  DrawTickLabels(void);
   void  DrawArc(bool inner, float start_angle, float end_angle, float arc_weight = 1.0f);
   void  SetLabelProperties(float size, float weight, bool rotate = false);
   void  SetLabelRadius(float radius);
   void  SetOuterRadius(float radius);
   void  SetTickColor(int red, int green, int blue);
	void  SetTickLengths(float major, float intermediate, float minor);

   void  SetTickStyle(bool tick_layout = ARC, bool orientation = HORIZONTAL);

   void  DrawLinearTickMarks(void);
   void  DrawLinearTickLabels(void);

   void  GenerateLists();

   CList <TICK_INFO, TICK_INFO>  TickList;

private:
   int         m_list_outer;
   int         m_list_inner;
   int         m_list_labels;
   int         m_list_linear_labels;
   int         m_list_linear_marks;

   COpenGLtext theLabel;
   GLUquadricObj  *pquad;

   float m_OuterRadius;
   float m_LabelRadius;

   bool  m_labels_rotated;
   float m_label_size;
   float m_label_weight;
   float m_major_length;
   float m_minor_length;
   float m_intermediate_length;

   int   m_red;
   int   m_green;
   int   m_blue;

   bool  m_tick_layout;
   bool  m_orientation;
   COpenGLCircle  m_arc;
};

#endif // !defined(AFX_TICKS_H__E02411D1_6AC9_11D2_AD4F_006008B0E0C3__INCLUDED_)
