// Ticks.cpp: implementation of the CTicks class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Ticks.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


#define  glRGB(x, y, z) glColor3ub((GLubyte)x, (GLubyte)y, (GLubyte)z)


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CTicks::CTicks()
{
   pquad = NULL;
   m_list_outer = -1;
   m_list_inner = -1;
   m_list_labels = -1;
   m_list_linear_labels = -1;
   m_list_linear_marks = -1;
   m_arc.ArraySize(360);
}

CTicks::~CTicks()
{
   if (pquad != NULL)
      gluDeleteQuadric(pquad);

   if (m_list_outer != -1)
      glDeleteLists(m_list_outer, 1);

   if (m_list_inner != -1)
      glDeleteLists(m_list_inner, 1);

   if (m_list_labels != -1)
      glDeleteLists(m_list_labels, 1);

   if (m_list_linear_labels != -1)
      glDeleteLists(m_list_linear_labels, 1);

   if (m_list_linear_marks != -1)
      glDeleteLists(m_list_linear_marks, 1);
}


void  CTicks::Initialize(void)
{
   if (m_list_outer != -1)
      glDeleteLists(m_list_outer, 1);

   if (m_list_inner != -1)
      glDeleteLists(m_list_inner, 1);

   if (m_list_labels != -1)
      glDeleteLists(m_list_labels, 1);

   if (m_list_linear_labels != -1)
      glDeleteLists(m_list_linear_labels, 1);

   if (m_list_linear_marks != -1)
      glDeleteLists(m_list_linear_marks, 1);

   m_list_outer = -1;
   m_list_inner = -1;
   m_list_labels = -1;
   m_list_linear_labels = -1;
   m_list_linear_marks = -1;

   m_tick_layout           =  ARC;
   m_orientation           =  HORIZONTAL;
   m_label_size            =  1.0f;
   m_label_weight          =  1.0f;
   m_labels_rotated        =  false;

   m_major_length          =  0.15f;
   m_intermediate_length   =  0.11f;
   m_minor_length          =  0.07f;
   m_LabelRadius           =  m_major_length;
   m_OuterRadius           =  m_major_length;
   m_red                   =  255;
   m_green                 =  255;
   m_blue                  =  255;

   TickList.RemoveAll();

   pquad =  gluNewQuadric();
   gluQuadricDrawStyle(pquad, GLU_LINE);
}

void  CTicks::SetLabelProperties(float size, float weight, bool rotate)
{
   m_label_size      =  size;
   m_label_weight    =  weight;
   m_labels_rotated  =  rotate;
}

void  CTicks::SetLabelRadius(float radius)
{
   m_LabelRadius     =  radius;
}

void  CTicks::SetOuterRadius(float radius)
{
   m_OuterRadius     =  radius;
}

void  CTicks::SetTickColor(int red, int green, int blue)
{
   m_red    =  red;
   m_green  =  green;
   m_blue   =  blue;
}


void CTicks::SetTickLengths(float major, float intermediate, float minor)
{
   m_major_length          =  major;
   m_intermediate_length   =  intermediate;
   m_minor_length          =  minor;
}


void  CTicks::Draw(void)
{
   if (m_tick_layout == ARC)
   {
      DrawTickMarks();
      DrawTickLabels();
   }
   else
   {
      DrawLinearTickMarks();
      DrawLinearTickLabels();
   }
}


void  CTicks::DrawTickMarks(bool draw_ticks_from_outer_radius_toward_label_radius)
{
   if (draw_ticks_from_outer_radius_toward_label_radius)
   {
      glCallList(m_list_outer);
   }
   else
   {
      glCallList(m_list_inner);
   }
}

void  CTicks::DrawTickLabels(void)
{
   glCallList(m_list_labels);
}

void CTicks::DrawArc(bool inner, float start_angle, float end_angle, float arc_weight) 
{
   glPushMatrix();
   glRGB(m_red, m_green, m_blue);

   if (arc_weight == 0.0f)
      arc_weight = 1.0f;

   if (arc_weight != 1.0f)
      glLineWidth(arc_weight);

   float outer_radius   =  m_OuterRadius;
   float sweep_angle    =  end_angle   -  start_angle;

   if (inner)
   {
      outer_radius   -= (m_major_length   *  0.98f /  arc_weight);
   }

   // OpenGLCircle has a radius of 1.0
   glScalef(outer_radius, outer_radius, 1.0f);

   // Move the arc to the correct starting position.
   glRotated(-start_angle, 0.0, 0.0, 1.0);

   // Rotate so that the arc coordinates match a quadric.
   glRotated(180.0, 1.0, 0.0, 0.0);
   glRotated(-90.0, 0.0, 0.0, 1.0);

   // Draw a correctly sized arc.
   m_arc.DrawArc(0.0, sweep_angle);

   if (arc_weight != 1.0f)
      glLineWidth(1.0f);

   glPopMatrix();
}

void  CTicks::SetTickStyle(bool tick_layout, bool orientation)
{
   m_tick_layout  =  tick_layout;
   m_orientation  =  orientation;
}


void  CTicks::DrawLinearTickMarks(void)
{
   glCallList(m_list_linear_marks);
}

void  CTicks::DrawLinearTickLabels(void)
{
   glCallList(m_list_linear_labels);
}

void CTicks::GenerateLists()
{
   if (m_list_outer != -1)
      glDeleteLists(m_list_outer, 1);

   if (m_list_inner != -1)
      glDeleteLists(m_list_inner, 1);

   if (m_list_labels != -1)
      glDeleteLists(m_list_labels, 1);

   if (m_list_linear_labels != -1)
      glDeleteLists(m_list_linear_labels, 1);

   if (m_list_linear_marks != -1)
      glDeleteLists(m_list_linear_marks, 1);

   m_list_outer = glGenLists(1);
   m_list_inner = glGenLists(1);
   m_list_labels = glGenLists(1);
   m_list_linear_labels = glGenLists(1);
   m_list_linear_marks = glGenLists(1);

   glNewList(m_list_outer, GL_COMPILE);
   {
      glPushMatrix();
      glRGB(m_red, m_green, m_blue);
      if (TickList.GetCount())
      {
         POSITION    pos   =  TickList.GetHeadPosition();

         while (pos)
         {
            TICK_INFO   &tick_info  =  TickList.GetNext(pos);

            glPushMatrix();
            {
               glRotatef(-tick_info.location, 0.0f, 0.0f, 1.0f);     // Rotate ClockWise.

               glLineWidth(m_label_weight);  // Apply the line width factor.
               switch (tick_info.type)
               {
                  case  MAJOR:         // Major
                     glBegin(GL_LINES);
                        glVertex2f(0.0f,  m_OuterRadius - m_major_length);
                        glVertex2f(0.0f,  m_OuterRadius);
                     glEnd();
                     break;

                  case  MINOR:         // Minor
                     glBegin(GL_LINES);
                        glVertex2f(0.0f,  m_OuterRadius - m_minor_length);
                        glVertex2f(0.0f,  m_OuterRadius);
                     glEnd();
                     break;

                  case  INTERMEDIATE:  // Intermediate
                     glBegin(GL_LINES);
                        glVertex2f(0.0f,  m_OuterRadius - m_intermediate_length);
                        glVertex2f(0.0f,  m_OuterRadius);
                     glEnd();
                     break;


                  case  MAJOR_CIRCLE:
                        glTranslatef(0.0f, m_OuterRadius, 0.0f);
                        gluDisk(pquad, m_major_length,   m_major_length *  1.025f, 30, 1);
                        break;

                  case  MINOR_CIRCLE:
                        glTranslatef(0.0f, m_OuterRadius, 0.0f);
                        gluDisk(pquad, m_minor_length,   m_minor_length *  1.025f, 30, 1);
                        break;

                  case  INTERMEDIATE_CIRCLE:
                        glTranslatef(0.0f, m_OuterRadius, 0.0f);
                        gluDisk(pquad, m_intermediate_length,  m_intermediate_length   *  1.025f, 30, 1);
                        break;


                  case  MAJOR_DIAMOND:         // Major
                        glTranslatef(0.0f, m_OuterRadius, 0.0f);
                        glRotatef(45.0, 0.0f, 0.0f, 1.0f);
                        glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
                        glBegin(GL_POLYGON);
                           glVertex2f(0.0f,  -m_major_length);
                           glVertex2f( m_major_length,   0.0f);
                           glVertex2f(0.0f,   m_major_length);
                           glVertex2f(-m_major_length,   0.0f);
                        glEnd();
                        glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
                        break;

                  case  MINOR_DIAMOND:         // Minor
                        glTranslatef(0.0f, m_OuterRadius, 0.0f);
                        glRotatef(45.0, 0.0f, 0.0f, 1.0f);
                        glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
                        glBegin(GL_POLYGON);
                           glVertex2f(0.0f,  -m_minor_length);
                           glVertex2f( m_minor_length,   0.0f);
                           glVertex2f(0.0f,   m_minor_length);
                           glVertex2f(-m_minor_length,   0.0f);
                        glEnd();
                        glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
                        break;

                  case  INTERMEDIATE_DIAMOND:  // Intermediate
                        glTranslatef(0.0f, m_OuterRadius, 0.0f);
                        glRotatef(45.0, 0.0f, 0.0f, 1.0f);
                        glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
                        glBegin(GL_POLYGON);
                           glVertex2f(0.0f,  -m_intermediate_length);
                           glVertex2f( m_intermediate_length,  0.0f);
                           glVertex2f(0.0f,   m_intermediate_length);
                           glVertex2f(-m_intermediate_length,  0.0f);
                        glEnd();
                        glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
                        break;


                  case  MAJOR_RECTANGLE:         // Major
                        glTranslatef(0.0f, m_OuterRadius -  m_major_length, 0.0f);
                        glRotatef(tick_info.location, 0.0f, 0.0f, 1.0f);
                        glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
                        if (tick_info.location  == 0.0f  || tick_info.location   == 180.0f)
                        {
                           glBegin(GL_POLYGON);
                              glVertex2f(-m_major_length/3.0f,  -m_major_length);
                              glVertex2f(-m_major_length/3.0f,   m_major_length);
                              glVertex2f( m_major_length/3.0f,   m_major_length);
                              glVertex2f( m_major_length/3.0f,  -m_major_length);
                           glEnd();
                        }
                        else
                        {
                           glBegin(GL_POLYGON);
                              glVertex2f(-m_major_length,  -m_major_length/3.0f);
                              glVertex2f(-m_major_length,   m_major_length/3.0f);
                              glVertex2f( m_major_length,   m_major_length/3.0f);
                              glVertex2f( m_major_length,  -m_major_length/3.0f);
                           glEnd();
                        }
                        glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
                        break;

                  case  MINOR_RECTANGLE:         // Minor
                        glTranslatef(0.0f, m_OuterRadius -  m_minor_length, 0.0f);
                        glRotatef(tick_info.location, 0.0f, 0.0f, 1.0f);
                        glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
                        if (tick_info.location  == 0.0f  || tick_info.location   == 180.0f)
                        {
                           glBegin(GL_POLYGON);
                              glVertex2f(-m_minor_length/3.0f,  -m_minor_length);
                              glVertex2f(-m_minor_length/3.0f,   m_minor_length);
                              glVertex2f( m_minor_length/3.0f,   m_minor_length);
                              glVertex2f( m_minor_length/3.0f,  -m_minor_length);
                           glEnd();
                        }
                        else
                        {
                           glBegin(GL_POLYGON);
                              glVertex2f(-m_minor_length,  -m_minor_length/3.0f);
                              glVertex2f(-m_minor_length,   m_minor_length/3.0f);
                              glVertex2f( m_minor_length,   m_minor_length/3.0f);
                              glVertex2f( m_minor_length,  -m_minor_length/3.0f);
                           glEnd();
                        }
                        glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
                        break;

                  case  INTERMEDIATE_RECTANGLE:  // Intermediate
                        glTranslatef(0.0f, m_OuterRadius -  m_intermediate_length, 0.0f);
                        glRotatef(tick_info.location, 0.0f, 0.0f, 1.0f);
                        glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
                        if (tick_info.location  == 0.0f  || tick_info.location   == 180.0f)
                        {
                           glBegin(GL_POLYGON);
                              glVertex2f(-m_intermediate_length/3.0f,  -m_intermediate_length);
                              glVertex2f(-m_intermediate_length/3.0f,   m_intermediate_length);
                              glVertex2f( m_intermediate_length/3.0f,   m_intermediate_length);
                              glVertex2f( m_intermediate_length/3.0f,  -m_intermediate_length);
                           glEnd();
                        }
                        else
                        {
                           glBegin(GL_POLYGON);
                              glVertex2f(-m_intermediate_length,  -m_intermediate_length/3.0f);
                              glVertex2f(-m_intermediate_length,   m_intermediate_length/3.0f);
                              glVertex2f( m_intermediate_length,   m_intermediate_length/3.0f);
                              glVertex2f( m_intermediate_length,  -m_intermediate_length/3.0f);
                           glEnd();
                        }
                        glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
                        break;
               }
               glLineWidth(1.0f);            // Restore the line width factor.
            }
            glPopMatrix();
         }
      }
      glPopMatrix();
   }
   glEndList();

   glNewList(m_list_inner, GL_COMPILE);
   {
      glPushMatrix();
      glRGB(m_red, m_green, m_blue);
      if (TickList.GetCount())
      {
         POSITION    pos   =  TickList.GetHeadPosition();

         while (pos)
         {
            TICK_INFO& tick_info   =  TickList.GetNext(pos);

            glPushMatrix();
               glRotatef(-tick_info.location, 0.0f, 0.0f, 1.0f);     // Rotate ClockWise.

               glLineWidth(m_label_weight);  // Apply the line width factor.

               glBegin(GL_LINES);
                  if (tick_info.type   == MAJOR)            // Major
                  {
                     glVertex2f(0.0f,  m_LabelRadius + m_major_length);
                     glVertex2f(0.0f,  m_LabelRadius);
                  }
                  else if (tick_info.type == MINOR)         // Minor
                  {
                     glVertex2f(0.0f,  m_LabelRadius + m_minor_length);
                     glVertex2f(0.0f,  m_LabelRadius);
                  }
                  else if (tick_info.type == INTERMEDIATE)  // Intermediate
                  {
                     glVertex2f(0.0f,  m_LabelRadius + m_intermediate_length);
                     glVertex2f(0.0f,  m_LabelRadius);
                  }
               glEnd();
               glLineWidth(1.0f);            // Restore the line width factor.
            glPopMatrix();
         }
      }
      glPopMatrix();
   }
   glEndList();

   glNewList(m_list_labels, GL_COMPILE);
   {
      glPushMatrix();
      theLabel.SetForegroundColor(m_red, m_green, m_blue);
      if (TickList.GetCount())
      {
         POSITION    pos   =  TickList.GetHeadPosition();

         while (pos)
         {
            TICK_INFO& tick_info   =  TickList.GetNext(pos);

            if (tick_info.ident)                                        // If there is an ident to be displayed.
            {
               glPushMatrix();
                  glRotatef(-tick_info.location, 0.0f, 0.0f, 1.0f);     // Rotate ClockWise.
                  glTranslatef(0.0f, m_LabelRadius, 0.0f);              // Move to appropriate radius.

                  if (!m_labels_rotated)
                     glRotatef(tick_info.location, 0.0f, 0.0f, 1.0f);   // Rotate CounterClockWise.

                  CString  ident(tick_info.ident);
                  theLabel.Draw(ident, true, 0.0f, m_label_size, m_label_weight);
               glPopMatrix();
            }
         }
      }
      glPopMatrix();
   }
   glEndList();

   glNewList(m_list_linear_labels, GL_COMPILE);
   {
      glPushMatrix();
      theLabel.SetForegroundColor(m_red, m_green, m_blue);
      if (TickList.GetCount())
      {
         POSITION    pos   =  TickList.GetHeadPosition();

         while (pos)
         {
            TICK_INFO& tick_info   =  TickList.GetNext(pos);

            if (tick_info.ident)                                        // If there is an ident to be displayed.
            {
               glPushMatrix();
                  if (m_orientation == HORIZONTAL)
                     glTranslatef(tick_info.location, 0.0f, 0.0f);
                  else
                     glTranslatef(0.0f, tick_info.location, 0.0f);

                  if (tick_info.ident[0]  == '^')                    // Place text above the tick.
                  {
                     glTranslatef(0.0f, m_LabelRadius,  0.0f);
                     CString  ident(&tick_info.ident[1]);
                     theLabel.Draw(ident, true, 0.0f, m_label_size, m_label_weight);
                  }
                  else if (tick_info.ident[0]  == '<')               // Place text to the left of the tick.
                  {
                     glTranslatef(-m_LabelRadius,  0.0f, 0.0f);
                     CString  ident(&tick_info.ident[1]);
                     theLabel.Draw(ident, true, 0.0f, m_label_size, m_label_weight);
                  }
                  else if (tick_info.ident[0]  == '>')               // Place text to the right of the tick.
                  {
                     glTranslatef(m_LabelRadius,  0.0f, 0.0f);
                     CString  ident(&tick_info.ident[1]);
                     theLabel.Draw(ident, true, 0.0f, m_label_size, m_label_weight);
                  }
                  else                                               // Place text below the tick.
                  {
                     glTranslatef(0.0f, -m_LabelRadius,  0.0f);
                     CString  ident(tick_info.ident);
                     theLabel.Draw(ident, true, 0.0f, m_label_size, m_label_weight);
                  }
               glPopMatrix();
            }
         }
      }
      glPopMatrix();
   }
   glEndList();


   glNewList(m_list_linear_marks, GL_COMPILE);
   {
      glPushMatrix();
      {
         if (TickList.GetCount())
         {
            POSITION       pos   =  TickList.GetHeadPosition();

            glRGB(m_red, m_green, m_blue);

            while (pos)
            {
               TICK_INFO& tick_info   =  TickList.GetNext(pos);

               glPushMatrix();
               {
                  glLineWidth(m_label_weight);  // Apply the line width factor.
                  if (m_orientation == HORIZONTAL)
                  {
                     glTranslatef(tick_info.location, 0.0f, 0.0f);

                     switch (tick_info.type)
                     {
                        case  MAJOR:         // Major
                              glBegin(GL_LINES);
                                 glVertex2f(0.0f,  -m_major_length);
                                 glVertex2f(0.0f,   m_major_length);
                              glEnd();
                              break;

                        case  MINOR:         // Minor
                              glBegin(GL_LINES);
                                 glVertex2f(0.0f,  -m_minor_length);
                                 glVertex2f(0.0f,   m_minor_length);
                              glEnd();
                              break;

                        case  INTERMEDIATE:  // Intermediate
                              glBegin(GL_LINES);
                                 glVertex2f(0.0f,  -m_intermediate_length);
                                 glVertex2f(0.0f,   m_intermediate_length);
                              glEnd();
                              break;

                        case  MAJOR_CIRCLE:
                              gluDisk(pquad, m_major_length,   m_major_length *  1.025f, 30, 1);
                              break;

                        case  MINOR_CIRCLE:
                              gluDisk(pquad, m_minor_length,   m_minor_length *  1.025f, 30, 1);
                              break;

                        case  INTERMEDIATE_CIRCLE:
                              gluDisk(pquad, m_intermediate_length,  m_intermediate_length   *  1.025f, 30, 1);
                              break;

                        case  MAJOR_DIAMOND:         // Major
                              glBegin(GL_LINE_LOOP);
                                 glVertex2f(0.0f,  -m_major_length);
                                 glVertex2f( m_major_length,   0.0f);
                                 glVertex2f(0.0f,   m_major_length);
                                 glVertex2f(-m_major_length,   0.0f);
                              glEnd();
                              break;

                        case  MINOR_DIAMOND:         // Minor
                              glBegin(GL_LINE_LOOP);
                                 glVertex2f(0.0f,  -m_minor_length);
                                 glVertex2f( m_minor_length,   0.0f);
                                 glVertex2f(0.0f,   m_minor_length);
                                 glVertex2f(-m_minor_length,   0.0f);
                              glEnd();
                              break;

                        case  INTERMEDIATE_DIAMOND:  // Intermediate
                              glBegin(GL_LINE_LOOP);
                                 glVertex2f(0.0f,  -m_intermediate_length);
                                 glVertex2f( m_intermediate_length,  0.0f);
                                 glVertex2f(0.0f,   m_intermediate_length);
                                 glVertex2f(-m_intermediate_length,  0.0f);
                              glEnd();
                              break;


                        case  MAJOR_RECTANGLE:         // Major
                              glBegin(GL_LINE_LOOP);
                                 glVertex2f(-m_major_length,  -m_major_length/3.0f);
                                 glVertex2f(-m_major_length,   m_major_length/3.0f);
                                 glVertex2f( m_major_length,   m_major_length/3.0f);
                                 glVertex2f( m_major_length,  -m_major_length/3.0f);
                              glEnd();
                              break;

                        case  MINOR_RECTANGLE:         // Minor
                              glBegin(GL_LINE_LOOP);
                                 glVertex2f(-m_minor_length,  -m_minor_length/3.0f);
                                 glVertex2f(-m_minor_length,   m_minor_length/3.0f);
                                 glVertex2f( m_minor_length,   m_minor_length/3.0f);
                                 glVertex2f( m_minor_length,  -m_minor_length/3.0f);
                              glEnd();
                              break;

                        case  INTERMEDIATE_RECTANGLE:  // Intermediate
                              glBegin(GL_LINE_LOOP);
                                 glVertex2f(-m_intermediate_length,  -m_intermediate_length/3.0f);
                                 glVertex2f(-m_intermediate_length,   m_intermediate_length/3.0f);
                                 glVertex2f( m_intermediate_length,   m_intermediate_length/3.0f);
                                 glVertex2f( m_intermediate_length,  -m_intermediate_length/3.0f);
                              glEnd();
                              break;
                     }
                  }
                  else
                  {
                     glTranslatef(0.0f, tick_info.location, 0.0f);

                     switch (tick_info.type)
                     {
                        case  MAJOR:         // Major
                              glBegin(GL_LINES);
                                 glVertex2f(-m_major_length,   0.0f);
                                 glVertex2f( m_major_length,   0.0f);
                              glEnd();
                              break;

                        case  MINOR:         // Minor
                              glBegin(GL_LINES);
                                 glVertex2f(-m_minor_length,   0.0f);
                                 glVertex2f( m_minor_length,   0.0f);
                              glEnd();
                              break;

                        case  INTERMEDIATE:  // Intermediate
                              glBegin(GL_LINES);
                                 glVertex2f(-m_intermediate_length,  0.0f);
                                 glVertex2f( m_intermediate_length,  0.0f);
                              glEnd();
                              break;

                        case  MAJOR_CIRCLE:
                              gluDisk(pquad, m_major_length,   m_major_length *  1.025f, 30, 1);
                              break;

                        case  MINOR_CIRCLE:
                              gluDisk(pquad, m_minor_length,   m_minor_length *  1.025f, 30, 1);
                              break;

                        case  INTERMEDIATE_CIRCLE:
                              gluDisk(pquad, m_intermediate_length,  m_intermediate_length   *  1.025f, 30, 1);
                              break;

                        case  MAJOR_DIAMOND:         // Major
                              glBegin(GL_LINE_LOOP);
                                 glVertex2f(0.0f,  -m_major_length);
                                 glVertex2f( m_major_length,   0.0f);
                                 glVertex2f(0.0f,   m_major_length);
                                 glVertex2f(-m_major_length,   0.0f);
                              glEnd();
                              break;

                        case  MINOR_DIAMOND:         // Minor
                              glBegin(GL_LINE_LOOP);
                                 glVertex2f(0.0f,  -m_minor_length);
                                 glVertex2f( m_minor_length,   0.0f);
                                 glVertex2f(0.0f,   m_minor_length);
                                 glVertex2f(-m_minor_length,   0.0f);
                              glEnd();
                              break;

                        case  INTERMEDIATE_DIAMOND:  // Intermediate
                              glBegin(GL_LINE_LOOP);
                                 glVertex2f(0.0f,  -m_intermediate_length);
                                 glVertex2f( m_intermediate_length,  0.0f);
                                 glVertex2f(0.0f,   m_intermediate_length);
                                 glVertex2f(-m_intermediate_length,  0.0f);
                              glEnd();
                              break;
                     }
                  }
                  glLineWidth(1.0f);            // Restore the line width factor.
               }
               glPopMatrix();
            }
         }
      }
      glPopMatrix();
   }
   glEndList();
}