#include "stdafx.h"
#include "stringsplit.h"

#include <string>
#include <vector>


void StringSplit(_FSI_STL::vector<_FSI_STL::string> &output, 
                 const _FSI_STL::string   &input, 
                 const _FSI_STL::string   &delim,
                 bool           allowEmpty)
{
    size_t start = 0;
    size_t end = 0;

    // locate the first token (it may not be at the beginning of the string)
    start = input.find_first_not_of(delim);
    
    // work through all the tokens
    while( end != _FSI_STL::string::npos && start != _FSI_STL::string::npos )
    {
        // find the end of the current token, search for any member of delim
        end = input.find_first_of(delim, start);

        // push the result on the output vector using a substring of the input from 'start' to 'end'
        // If at end, use length=maxLength, else use length=end-start.
        output.push_back(input.substr(start, (end == _FSI_STL::string::npos) ? _FSI_STL::string::npos : end - start));

        // update the start of the next token
        start = input.find_first_not_of(delim, end);

        // If we are allowing empty tokens, there may be multiple tokens between the one we just added
        // and the next one.  Artificially add them now.
        if (allowEmpty)
        {
            // determine the end of the empty tokens (if any)
            size_t endOfEmpty(0);
            if (end != start && start == _FSI_STL::string::npos)
            {
                // end of empty tokens happens at the end of the string
                endOfEmpty = input.length();
            }
            else
            {
                // end of empty tokens happens in the middle of the string
                endOfEmpty = start-1;
            }

            // add the proper number of empty tokens
            for( size_t i = end; i < endOfEmpty; ++i )
                    output.push_back("");
        }
    }
}