#include "stdafx.h"
#include "RangePage.h"

#include "..\core\Widget.h"
#include "..\core\IOAction.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CRangePage property page
CRangePage::CRangePage() : CBasePage(CRangePage::IDD)
{
	//{{AFX_DATA_INIT(CRangePage)
	m_nRangeType = -1;
	//}}AFX_DATA_INIT
    m_stlStrPageName = _FSI_STL::string("Ranges");
    m_nRangeIndex = -1;
}

void CRangePage::DoDataExchange(CDataExchange* pDX)
{
	CBasePage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CRangePage)
	DDX_Control(pDX, IDC_RANGES, m_ctrlRangesCombo);
	DDX_Radio(pDX, IDC_RANGES_NOT_USED, m_nRangeType);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CRangePage, CBasePage)
	//{{AFX_MSG_MAP(CRangePage)
	ON_BN_CLICKED(IDC_RANGES_SPECIFIC, OnRangesSpecific)
	ON_BN_CLICKED(IDC_RANGES_GENERIC, OnRangesGeneric)
	ON_BN_CLICKED(IDC_RANGES_NOT_USED, OnRangesNotUsed)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CRangePage message handlers
CBasePage* CRangePage::CreateObject()
{
    return new CRangePage;
}

void CRangePage::SetProperties(void* pWidget)
{
    CXMLWidget* pXMLWidget = ((CWidget*)pWidget)->XMLWidget();
    if (pXMLWidget != NULL)
    {
        CXMLElement* pXMLElement = NULL;
        POSITION pos = NULL;
		// Get all of the VARIABLES.
        if (pXMLWidget->FindElement(pXMLElement, pos,
                                    _FSI_STL::string("RANGE_DATA")) == true)
        {
            STRING2STRING_MAP::iterator s2sIt = NULL;

            CString strValue = pXMLElement->ElementValue().c_str();
            strValue.MakeUpper();
            if (strValue == "GENERIC")
            {
                m_nRangeType = 1;
            }
            else if (strValue == "SPECIFIC")
            {
                m_nRangeType = 2;
            }
            else
            {
                m_nRangeType = 0;
            }

            if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("RANGE_NUM")) == true)
            {
                m_nRangeIndex = atoi((*s2sIt).second.c_str());
            }
            else
            {
                m_nRangeIndex = -1;
            }
        }
    }

    CIOAction* pIOAction = (CIOAction*)((CWidget*)pWidget)->Action();
    if (pIOAction != NULL)
    {
        m_vectRanges = pIOAction->Ranges();
    }
}

void CRangePage::UpdateProperties(void* pWidget)
{
    CXMLWidget* pXMLWidget = ((CWidget*)pWidget)->XMLWidget();
    if (pXMLWidget != NULL && GetSafeHwnd() != NULL)
    {
        UpdateData(TRUE);

        CXMLElement* pXMLElement = NULL;
        POSITION pos = NULL;
        if (pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("RANGE_DATA")) == true)
        {
            if (m_nRangeType == 1)
            {
                pXMLElement->AddElementValue(_FSI_STL::string("GENERIC"));
            }
            else if (m_nRangeType == 2)
            {
                pXMLElement->AddElementValue(_FSI_STL::string("SPECIFIC"));
            }
            else
            {
                pXMLElement->AddElementValue(_FSI_STL::string("NONE"));
            }

            STRING2STRING_MAP::iterator s2sIt = NULL;
            if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("RANGE_NUM")) == true)
            {
                if (m_ctrlRangesCombo.GetCurSel() != CB_ERR)
                {
                    CString strEntry;
                    m_ctrlRangesCombo.GetLBText(m_ctrlRangesCombo.GetCurSel(), 
                                                strEntry);

                    strEntry = strEntry.Left(3);
                    m_nRangeIndex = atoi((LPCTSTR)strEntry);
                }
                else
                {
                    m_nRangeIndex = -1;
                }
                CString strValue;
                strValue.Format("%d",m_nRangeIndex);
                (*s2sIt).second = _FSI_STL::string((LPCTSTR)strValue);
            }
        }
    }
}

BOOL CRangePage::OnInitDialog() 
{
	CBasePage::OnInitDialog();
	
	// TODO: Add extra initialization here
    m_ctrlRangesCombo.ResetContent();

    _FSI_STL::vector<CRange*>::iterator vIt = m_vectRanges.begin();
    for (; vIt != m_vectRanges.end(); vIt++)
    {
        CString strRangeEntry;
        strRangeEntry.Format("%03d %s", (*vIt)->ID(), (*vIt)->Conditional().c_str());
        m_ctrlRangesCombo.AddString(strRangeEntry);
    }

    if (m_nRangeType == 2 && m_nRangeIndex != -1)
    {
        m_ctrlRangesCombo.SetCurSel(m_nRangeIndex);
    }
    else if (m_nRangeType != 2)
    {
        m_ctrlRangesCombo.EnableWindow(FALSE);
    }


	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}


void CRangePage::OnRangesSpecific() 
{
    m_ctrlRangesCombo.EnableWindow(TRUE);	
}

void CRangePage::OnRangesGeneric() 
{
    m_ctrlRangesCombo.EnableWindow(FALSE);	
}

void CRangePage::OnRangesNotUsed() 
{
    m_ctrlRangesCombo.EnableWindow(FALSE);	
}
