/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : Range.h
//
// Date             : 08 February 2000
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.5 $
//
// Description      : Range.h contains the definition of the 
//                    CRange class.  This class store information about 
//                    possible values that a variable may have.  The 
//                    possible values are represented as conditional 
//                    statements.  For an enumeration, a variable might 
//                    have several ranges each one checking if the 
//                    current value of the varible is equal to both the 
//                    lower and upper conditional value which would be 
//                    the same.
//                    
//                    For each conditional range, true and false color 
//                    and text values are possible.  Also, an action 
//                    may be performed when the range is true.  Each 
//                    range may also have a custom message that will be 
//                    logged if the range is true.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : _FSI_STL::string, CWinApp, CWnd, Core::CVariant, Co
//                    re::CColor.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3, 4, or 5
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: Range.h $                                                                   
// Revision 1.5  2000/05/04 16:56:53  billyb                                                                   
// Added code to determine if the value sent to Evaluate has                                                                   
// crossed the bounds of the range since the last call to Evaluate.                                                                   
// Prevents extra messages in the message log when a value                                                                   
// changes but stays in the same range.                                                                   
// Revision 1.4  2000/03/07 07:19:06  billyb                                                                   
// Removed unused methods.                                                                   
// Revision 1.3  2000/02/08 19:38:13  billyb                                                                   
// Added comments.  Changed enum values.  Added static                                                                   
// members for Windows message IDs.  Removed methods                                                                   
// protected methods that were only called from Evaluate.                                                                   
/////////////////////////////////////////////////////////////////////////////
#if !defined(_RANGE_H_)
#define _RANGE_H_

#ifdef CORE
#define DLLAPI __declspec( dllexport )
#else
#define DLLAPI __declspec( dllimport )
#endif

#include <string>
#include "Variant.h"
#include "Color.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

enum
{
    LESS_THAN,
    LESS_THAN_EQUAL_TO,
    EQUAL_TO,
    NOT_EQUAL_TO,
    GREATER_THAN_EQUAL_TO,
    GREATER_THAN
};

enum RangeActionTypes
{
    NO_ACTION               = 0,
    DISPLAY_AUTO_OVERLAY    = 1,
    CLOSE_AUTO_OVERLAY      = 2
};

class DLLAPI CRange  
{
protected:
    // ID value to identify one range from another.
    long int            m_lID;

    // Type of action to perform if any.
    RangeActionTypes    m_enumActionType;

    // The conditionals that match the enumeration above.
    unsigned char       m_ucLowerConditional;
    unsigned char       m_ucUpperConditional;

    bool                m_bLowerLast;
    bool                m_bUpperLast;

    bool                m_bNewValidRange;

    // The lower and upper values for the conditional.
    CVariant            m_varLowerValue;
    CVariant            m_varUpperValue;

    // Colors for the background and foreground for a
    // conditional.
    CColor              m_colorBackgroundTrue;
    CColor              m_colorForegroundTrue;
    CColor              m_colorBackgroundFalse;
    CColor              m_colorForegroundFalse;

    // Text for the result of a conditional.
    _FSI_STL::string    m_stlStrTextTrue;
    _FSI_STL::string    m_stlStrTextFalse;

    // Log message for a conditional if it is true.
    _FSI_STL::string    m_stlStrLogMessage;

    // Any data that is needed by the action.
    _FSI_STL::string    m_stlStrActionData;

public:
	CRange();

    // Accessor
    inline CVariant         Lower();
    inline CVariant         Upper();
    inline unsigned char    LowerConditional();
    inline unsigned char    UpperConditional();
    inline CColor           BackgroundTrue();
    inline CColor           ForegroundTrue();
    inline CColor           BackgroundFalse();
    inline CColor           ForegroundFalse();
    inline _FSI_STL::string TextTrue();
    inline _FSI_STL::string TextFalse();
    inline _FSI_STL::string LogMessage();
    inline long int         ID();
    inline _FSI_STL::string Conditional();
    inline enum RangeActionTypes ActionType();
    inline _FSI_STL::string ActionData();
    inline bool             NewValidRange();

    // Mutator
    inline void Lower(const CVariant& rvarLower); 
    inline void Upper(const CVariant& rvarUpper); 
    inline void LowerConditional(const unsigned char ucConditional);
    inline void UpperConditional(const unsigned char ucConditional);
    inline void BackgroundTrue(const CColor& rcolorValue);
    inline void ForegroundTrue(const CColor& rcolorValue);
    inline void BackgroundFalse(const CColor& rcolorValue);
    inline void ForegroundFalse(const CColor& rcolorValue);
    inline void TextTrue(const _FSI_STL::string& rstlStrText);
    inline void TextFalse(const _FSI_STL::string& rstlStrText);
    inline void LogMessage(const _FSI_STL::string& rstlStrLogMessage);
    inline void ID(const long int lID);
    inline void ActionType(unsigned char ucActionType);
    inline void ActionData(const _FSI_STL::string& rstlStrActionData);

    inline bool Evaluate(CVariant& rvarValue);
    inline void PerformAction();

    static const UINT   m_WM_DISPLAY_AUTO_OVERLAY;
    static const UINT   m_WM_CLOSE_AUTO_OVERLAY;
};

#endif // !defined(_RANGE_H_)
