// PageWidget.h: interface for the CPageWidget class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(_PAGEWIDGET_H_)
#define _PAGEWIDGET_H_

#ifdef CORE
#define DLLAPI __declspec( dllexport )
#else
#define DLLAPI __declspec( dllimport )
#endif

#include "resource.h"

#include "..\core\Widget.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class DLLAPI CPageWidget : public CWidget  
{
private:
    bool                m_bGridOn;
    bool                m_bSnapOn;
    bool                m_bSnapAllVertices;
    bool                m_bInitialized;
    long int            m_lResX;
    long int            m_lResY;
    unsigned char       m_ucWindowNumber;

    _FSI_STL::string    m_stlStrHelpFile;

protected:

    virtual void InitReinit();

public:
	CPageWidget();

    virtual void Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                            const long int lId, bool bEditMode);
    virtual void ResetProperties();
    static CWidget* CreateObject();

    void UpdateExtents();

    // Accessor
    unsigned char       WindowNumber();
    _FSI_STL::string    HelpFile();

    // Mutator
    void WindowNumber(const unsigned char ucWindowNumber);
    void HelpFile(const _FSI_STL::string& rstlStrHelpFile);

};

#endif // !defined(AFX_PAGEWIDGET_H__58FFBF03_7E42_11D2_8053_00A0C9CFC6A9__INCLUDED_)
