// PageWidget.cpp: implementation of the CPageWidget class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "PageWidget.h"

#include "GridSnapPage.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CPageWidget::CPageWidget()
{
    m_stlStrWidgetName  = _FSI_STL::string("Page");

    AddColorPage();

    m_listWidgetPropPages.push_back(CGridSnapPage::CreateObject);

    CPageWidget::InitReinit();
}

void CPageWidget::InitReinit()
{
    m_bGridOn           = true;
    m_bSnapOn           = true;
    m_bSnapAllVertices  = true;
    m_lResX             = 16;
    m_lResY             = 16;
    m_bInitialized      = false;
    m_ucWindowNumber    = 0;
}

void CPageWidget::Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                               const long lId, bool bEditMode)
{
    CWidget::Initialize(rpXMLWidget,pWnd, lId, bEditMode);

    CPageWidget::InitReinit();

    m_exPtUpperLeft     = CExtentsPoint(CPoint(0,0));
    m_exPtLowerRight    = CExtentsPoint(CPoint(GetSystemMetrics(SM_CXSCREEN),
                                                GetSystemMetrics(SM_CYSCREEN)));

    if (rpXMLWidget != NULL)
    {
        ResetProperties();
    }

    m_bInitialized = true;
}

CWidget* CPageWidget::CreateObject()
{
    return new CPageWidget();
}

void CPageWidget::ResetProperties()
{
    CWidget::ResetProperties();
    CXMLElement* pXMLElement = NULL;
    POSITION pos = NULL;
    if (m_pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("GRID")) == true)
    {
        CString strGridOn(pXMLElement->ElementValue().c_str());
        strGridOn.MakeUpper();
        if (strGridOn == "YES")
        {
            m_bGridOn = true;
        }
        else
        {
            m_bGridOn = false;
        }

        STRING2STRING_MAP::iterator s2sIt = NULL;
        CString strValue;
        if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("RESX")) == true)
        {
            m_lResX = atoi((*s2sIt).second.c_str());
        }
        else
        {
            strValue.Format("%d",m_lResX);
            pXMLElement->AddAttribute(_FSI_STL::string("RESX"),
                                  _FSI_STL::string((LPCTSTR)strValue));
        }

        if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("RESY")) == true)
        {
            m_lResY = atoi((*s2sIt).second.c_str());
        }
        else
        {
            strValue.Format("%d",m_lResY);
            pXMLElement->AddAttribute(_FSI_STL::string("RESY"),
                                  _FSI_STL::string((LPCTSTR)strValue));
        }
    }
    else
    {
        m_pXMLWidget->AddElement(_FSI_STL::string("GRID"), 
                                 _FSI_STL::string("YES"),
                                 NULL);
        pXMLElement = NULL;
        if (m_pXMLWidget->FindElement(pXMLElement, pos,  _FSI_STL::string("GRID")) == true)
        {
            CString strValue = "16";
            pXMLElement->AddAttribute(_FSI_STL::string("RESX"),
                                      _FSI_STL::string((LPCTSTR)strValue));
            pXMLElement->AddAttribute(_FSI_STL::string("RESY"),
                                      _FSI_STL::string((LPCTSTR)strValue));
        }
    }

    pXMLElement = NULL;
    if (m_pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("SNAP")) == true)
    {
        CString strSnapOn(pXMLElement->ElementValue().c_str());
        strSnapOn.MakeUpper();
        if (strSnapOn == "YES")
        {
            m_bSnapOn = true;
        }
        else
        {
            m_bSnapOn = false;
        }

        STRING2STRING_MAP::iterator s2sIt = NULL;
        if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("SNAPALL")) == true)
        {
            CString strSnapAll((*s2sIt).second.c_str());
            strSnapAll.MakeUpper();
            if (strSnapAll == "YES")
            {
                m_bSnapAllVertices = true;
            }
            else
            {
                m_bSnapAllVertices = false;
            }
        }
        else
        {
            if (m_bSnapAllVertices == true)
            {
                pXMLElement->AddAttribute(_FSI_STL::string("SNAPALL"),
                                          _FSI_STL::string("YES"));
            }
            else
            {
                pXMLElement->AddAttribute(_FSI_STL::string("SNAPALL"),
                                          _FSI_STL::string("NO"));
            }
        }
    }
    else
    {
        m_pXMLWidget->AddElement(_FSI_STL::string("SNAP"), 
                                 _FSI_STL::string("YES"),
                                 NULL);
        pXMLElement = NULL;
        if (m_pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("SNAP")) == true)
        {
            pXMLElement->AddAttribute(_FSI_STL::string("SNAPALL"),
                                      _FSI_STL::string("YES"));
        }
    }

    pXMLElement = NULL;
    if (m_pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("HLPFILE")) == true)
    {
        m_stlStrHelpFile = pXMLElement->ElementValue();
    }
    else
    {
        m_stlStrHelpFile = "";
        m_pXMLWidget->AddElement(_FSI_STL::string("HLPFILE"), 
                                 _FSI_STL::string(""),
                                 NULL);
    }

    if (m_bInitialized == true)
    {
        AfxGetMainWnd()->PostMessage(WM_UPDATE_EDIT_VIEW, 0,
                                     (long)m_ucWindowNumber);
    }
}

void CPageWidget::UpdateExtents()
{
    if (m_pXMLWidget != NULL)
    {
        CString strValue;
        CXMLElement* pXMLElement = NULL;
        POSITION pos = NULL;
        if (m_pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("POINT")) == true)
        {
            strValue.Format("%d,%d", m_exPtUpperLeft.X(), 
                                     m_exPtUpperLeft.Y());
            pXMLElement->AddElementValue(_FSI_STL::string((LPCTSTR)strValue));
        }

        // Don't reset elIt here because you will get the previous point
        // back.
        if (m_pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("POINT")) == true)
        {
            strValue.Format("%d,%d", m_exPtLowerRight.X(), 
                                     m_exPtLowerRight.Y());
            pXMLElement->AddElementValue(_FSI_STL::string((LPCTSTR)strValue));
        }
    }
}

//////////////////////////////////////////////////////////////////////
// Accessors
//////////////////////////////////////////////////////////////////////

unsigned char CPageWidget::WindowNumber()
{
    return m_ucWindowNumber;
}

_FSI_STL::string CPageWidget::HelpFile()
{
    return m_stlStrHelpFile;
}

//////////////////////////////////////////////////////////////////////
// Mutators
//////////////////////////////////////////////////////////////////////

void CPageWidget::WindowNumber(const unsigned char ucWindowNumber)
{
    m_ucWindowNumber = ucWindowNumber;
}

void CPageWidget::HelpFile(const _FSI_STL::string& rstlStrHelpFile)
{
    m_stlStrHelpFile = rstlStrHelpFile;
    CXMLElement* pXMLElement = NULL;
    POSITION pos = NULL;
    if (m_pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("HLPFILE")) == true)
    {
        pXMLElement->AddElementValue(m_stlStrHelpFile);
    }
    else
    {
        m_pXMLWidget->AddElement(_FSI_STL::string("HLPFILE"), 
                                 m_stlStrHelpFile,
                                 NULL);
    }
}