/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : OverlayDlg.h
//
// Date             : 28 November 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.6 $
//
// Description      : OverlayDlg.h contains the definition of the 
//                    COverlayDlg class.  This class is used to 
//                    dyncamically create a modeless popup dialog whose
//                    layout is specified in an XML based file.  The
//                    dialog will autosize to the size of the content.
//                    OK, Apply, Cancel, and Help buttons are all possible
//                    on the dialog.  Dialogs may be persistant (a child
//                    of the main frame) or not (child of the view).  When
//                    the view page changes, the non-persistant overlays
//                    are removed.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : CString, Core::CWidget, CBrush, _FSI_STL::list.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3, 4, or 5
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: OverlayDlg.h $                                                                   
// Revision 1.6  2000/03/07 07:33:08  billyb                                                                   
// Changed function signatures to eliminate warnings.                                                                   
// Revision 1.5  2000/02/08 19:35:30  billyb                                                                   
// Added member variable and method for the the CWnd instance                                                                   
// that was passed to Create.  CWnd::GetParent will return a                                                                    
// CFrameWnd instance rather than the CWnd pass to create.                                                                   
// Revision 1.4  2000/01/21 10:14:51  billyb                                                                   
// Added CUpdateList as a parent.  Changed sizes of borders.                                                                   
// Revision 1.3  1999/11/29 00:11:51  billyb                                                                   
// Added comments.  Changed order of member variables for                                                                   
// better memory access.                                                                   
/////////////////////////////////////////////////////////////////////////////
#if !defined(_OVERLAYDLG_H_)
#define _OVERLAYDLG_H_

#ifdef CORE
#define DLLAPI __declspec( dllexport )
#else
#define DLLAPI __declspec( dllimport )
#endif

#include "resource.h"
#include "Widget.h"
#include "UpdateList.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

static const unsigned char ucDIALOG_BUTTON_WIDTH    = 64;
static const unsigned char ucDIALOG_BUTTON_HEIGHT   = 32;
static const unsigned char ucDIALOG_BORDER_WIDTH    = 16;
static const unsigned char ucDIALOG_BORDER_HEIGHT   = 24;

class CXMLPage;

class DLLAPI COverlayDlg : public CDialog, public CUpdateList
{
private:
    long int    m_lOptions;

    CWidget*    m_pPageWidget;
    CWidget*    m_pParentWidget;

    CWnd*       m_pParentWnd;

    CXMLPage*   m_pXMLPage;

    CBrush      m_brBackground;

    CString     m_strPageName;
	CString	    m_strWindowName;
    CString     m_strPathName;
	CString		m_strXMLPageName;

// Construction
public:
	COverlayDlg(CWnd* pParent = NULL);   // standard constructor
    ~COverlayDlg();

// Dialog Data
	//{{AFX_DATA(COverlayDlg)
	enum { IDD = IDD_CORE_OVERLAY_TEMPLATE };
		// NOTE: the ClassWizard will add data members here
	//}}AFX_DATA

// Attributes
protected:

public:
    _FSI_STL::list<CWidget*> m_listWidgets;

    // Accessor
    long int Options();
    CWidget* PageWidget();
    CWidget* ParentWidget();
	CString WindowName();
    CString PathName();
    CWnd*   ParentWnd();

    // Mutator
    void Options(long int lOptions);
    void PageWidget(CWidget* pPageWidget);
    void ParentWidget(CWidget* pWidget);
	void WindowName(const CString& rstrWindowName);
	void XMLPageName(const CString& rstrXMLPageName);
    void PathName(const CString& rstrPathName);
    void XMLPage(CXMLPage* pXMLPage);

    void FitToPage();
//	static UINT UpdateScreen(LPVOID param);
	LPARAM OnNextTab(WPARAM wParam, LPARAM lParam);
	LPARAM OnPreviousTab(WPARAM wParam, LPARAM lParam);


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(COverlayDlg)
	public:
	virtual BOOL Create(CWnd* pParentWnd);
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	virtual void PostNcDestroy();
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	//}}AFX_VIRTUAL

// Implementation
protected:

	// Generated message map functions
	//{{AFX_MSG(COverlayDlg)
	afx_msg void OnApplyNow();
	virtual void OnCancel();
	afx_msg void OnHelp();
	virtual void OnOK();
	afx_msg void OnClose();
	virtual BOOL OnInitDialog();
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg HBRUSH OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor);
	afx_msg void OnDestroy();
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	//}}AFX_MSG

    LPARAM OnUpdateScreen(WPARAM wParam, LPARAM lParam);

	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(_OVERLAYDLG_H_)
