/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : OverlayDlg.cpp
//
// Date             : 28 November 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.16 $
//
// Description      : OverlayDlg.cpp contains the implementation of the 
//                    COverlayDlg class.  This class is used to 
//                    dyncamically create a modeless popup dialog whose
//                    layout is specified in an XML based file.  The
//                    dialog will autosize to the size of the content.
//                    OK, Apply, Cancel, and Help buttons are all possible
//                    on the dialog.  Dialogs may be persistant (a child
//                    of the main frame) or not (child of the view).  When
//                    the view page changes, the non-persistant overlays
//                    are removed.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : CString, Core::CWidget, CBrush, _FSI_STL::list.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3, 4, or 5
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: OverlayDlg.cpp $                                                                   
// Revision 1.16  2000/05/30 22:55:55  billyb                                                                   
// Added support for specifying a help file other than the default.                                                                   
// Revision 1.15  2000/05/04 17:03:43  billyb                                                                   
// Changed updatescreen to comply with changes in                                                                    
// CUpdateList.                                                                   
// Revision 1.14  2000/04/07 05:24:19  billyb                                                                   
// Added support for better FPS displays in comms stats.                                                                   
// Revision 1.13  2000/03/30 08:03:41  billyb                                                                   
// Deleted unused code. Added code to unlock usage of                                                                   
// update list.                                                                   
// Revision 1.12  2000/03/07 07:33:18  billyb                                                                   
// Changed function signatures to eliminate warnings.                                                                   
// Revision 1.11  2000/02/11 18:31:44  billyb                                                                   
// Changed include for stdafx.h.                                                                   
// Revision 1.10  2000/02/08 19:36:24  billyb                                                                   
// Removed ADD_OVERLAY and REMOVE_OVERLAY messages.                                                                   
// Addeed keeping track of CWnd passed to Create.                                                                   
// Revision 1.9  2000/01/21 10:15:42  billyb                                                                   
// Fix precompiled header problem.  Fixed some layout sizing                                                                   
// problems.                                                                     
// Revision 1.8  1999/11/29 06:48:41  billyb                                                                   
// Changed placement of call to CUpdateList::Cleanup to make                                                                   
// sure that m_hWnd was still valid.                                                                   
// Revision 1.7  1999/11/29 00:14:55  billyb                                                                   
// Added comments.  Added Cleanup of CUpdateList.  Change                                                                   
// updating to work with CUpdateList.  Added support for                                                                   
// CMainFrame management of persistant overlays.  Changed                                                                   
// Create to add non-persistant overlays to the active view.                                                                   
/////////////////////////////////////////////////////////////////////////////
#include "stdafx.h"
#include "OverlayDlg.h"

#include "XMLPage.h"

#include "PageWidget.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

COverlayDlg::COverlayDlg(CWnd* pParent /*=NULL*/)
	: CDialog(COverlayDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(COverlayDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
    m_brBackground.CreateSolidBrush((COLORREF)GetSysColor(COLOR_3DFACE));
    m_pPageWidget   = NULL;
    m_strPageName   = "Overlay";
    m_pParentWidget = NULL;
    m_pParentWnd    = NULL;
    m_pXMLPage      = NULL;
}

COverlayDlg::~COverlayDlg()
{
    delete m_pXMLPage;

    if (m_listWidgets.size() > 0)
    {
        _FSI_STL::list<CWidget*>::iterator lwIt     = m_listWidgets.begin();
        _FSI_STL::list<CWidget*>::iterator lwendIt  = m_listWidgets.end();
        while (lwIt != lwendIt)
        {
            if (CWidget::IsValidAddress((*lwIt)) == VALID)
            {
                (*lwIt)->Wnd()->DestroyWindow();
            }

            if (CWidget::IsValidAddress((*lwIt)) != INVALID)
            {
                (*lwIt)->Deleting(true);
            }

            lwIt++;
       }
        m_listWidgets.clear();
    }

    m_brBackground.DeleteObject();
}

void COverlayDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(COverlayDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(COverlayDlg, CDialog)
	//{{AFX_MSG_MAP(COverlayDlg)
	ON_BN_CLICKED(ID_APPLY_NOW, OnApplyNow)
	ON_BN_CLICKED(IDHELP, OnHelp)
	ON_WM_CLOSE()
	ON_WM_LBUTTONDOWN()
	ON_WM_CTLCOLOR()
	ON_WM_DESTROY()
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
    ON_MESSAGE(WM_UPDATE_SCREEN, OnUpdateScreen)
    ON_MESSAGE(WM_GET_NEXT_TAB, OnNextTab)
    ON_MESSAGE(WM_GET_PREV_TAB, OnPreviousTab)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// COverlayDlg message handlers

BOOL COverlayDlg::Create(CWnd* pParentWnd) 
{
    BOOL bRetVal = FALSE;
    m_pParentWnd = pParentWnd;
    
    if ((m_lOptions & PERSIST) != 0)
    {
        if (dynamic_cast<CFrameWnd*>(pParentWnd) == NULL)
        {
            m_pParentWnd = pParentWnd->GetParentFrame();
        }
    }

    bRetVal = CDialog::Create(IDD, m_pParentWnd);

	return bRetVal;
}

void COverlayDlg::PostNcDestroy() 
{
    if (CWidget::IsValidAddress(m_pParentWidget) != INVALID)
    {
        m_pParentWidget->OverlayDlg(NULL);
    }

    delete this;
}

void COverlayDlg::FitToPage()
{
    _FSI_STL::list<CWidget*>::iterator lIt      = m_listWidgets.begin();
    _FSI_STL::list<CWidget*>::iterator lendIt   = m_listWidgets.end();
    long int lLeftX = 100000, lRightX = -100000;
    long int lLeftY = 100000, lRightY = -100000;
    while (lIt != lendIt)
    {
        if ((*lIt)->BaseWidget() == (*lIt) && (*lIt)->Wnd() != NULL)
        {
            if (lLeftX > (*lIt)->UpperLeft().X())
            {
                lLeftX = (*lIt)->UpperLeft().X();
            }

            if (lLeftY > (*lIt)->UpperLeft().Y())
            {
                lLeftY = (*lIt)->UpperLeft().Y();
            }

            if (lRightX < (*lIt)->LowerRight().X())
            {
                lRightX = (*lIt)->LowerRight().X();
            }

            if (lRightY < (*lIt)->LowerRight().Y())
            {
                lRightY = (*lIt)->LowerRight().Y();
            }
        }

        lIt++;
    }

    CRect rect;
    GetWindowRect(rect);
    ScreenToClient(&rect);
    CRect rectActual(lLeftX - ucDIALOG_BORDER_WIDTH + rect.left, 
                     lLeftY - ucDIALOG_BORDER_HEIGHT + rect.top,
                     lRightX + ucDIALOG_BORDER_WIDTH - rect.left,
                     lRightY + ucDIALOG_BORDER_HEIGHT +
                                           ucDIALOG_BUTTON_HEIGHT);
    if (rectActual.left < 0)
    {
        rectActual.right -= rectActual.left;
        rectActual.left = 0;
    }
    if (rectActual.top < 0)
    {
        rectActual.bottom -= rectActual.top;
        rectActual.top = 0;
    }

    CExtentsPoint extPoint;
    lIt = m_listWidgets.begin();
    while (lIt != lendIt)
    {
        if ((*lIt)->BaseWidget() == (*lIt) && (*lIt)->Wnd() != NULL)
        {
            extPoint = (*lIt)->UpperLeft();
            extPoint.X(extPoint.X() - lLeftX + ucDIALOG_BORDER_WIDTH);
            extPoint.Y(extPoint.Y() - lLeftY + ucDIALOG_BORDER_HEIGHT/4);
            (*lIt)->UpperLeft(extPoint);

            extPoint = (*lIt)->LowerRight();
            extPoint.X(extPoint.X() - lLeftX + ucDIALOG_BORDER_WIDTH);
            extPoint.Y(extPoint.Y() - lLeftY + ucDIALOG_BORDER_HEIGHT/4);
            (*lIt)->LowerRight(extPoint);

            CRect rect((*lIt)->UpperLeft(),(*lIt)->LowerRight());
            (*lIt)->Wnd()->MoveWindow(rect);
        }

        lIt++;
    }

    GetParentFrame()->GetActiveView()->ClientToScreen(&rectActual);

    SetWindowPos(NULL, rectActual.left, rectActual.top, rectActual.Width(),
                 rectActual.Height(), SWP_NOZORDER);
    SetWindowText(m_strWindowName);

    CRect rectClient;
    GetClientRect(rectClient);
    int nTotalButtons = 0;    // 1 for the help button
    if (m_lOptions & APPLY)
    {
        nTotalButtons++;
    }

    if (m_lOptions & CANCEL)
    {
        nTotalButtons++;
    }

    if (m_lOptions & OK)
    {
        nTotalButtons++;
    }

    if (rectClient.Width() >= nTotalButtons*ucDIALOG_BUTTON_WIDTH + 
                              2*ucDIALOG_BORDER_WIDTH + 
                              (nTotalButtons-1)*ucDIALOG_BORDER_WIDTH/2)
    {
        CFont* pFont = AfxGetMainWnd()->GetFont();
        CWnd* pWnd = GetDlgItem(IDHELP);
        if (pWnd != NULL)
        {
            CRect rectNewPos(rectClient.right - ucDIALOG_BORDER_WIDTH - 
                                                ucDIALOG_BUTTON_WIDTH, 
                             rectClient.bottom - ucDIALOG_BUTTON_HEIGHT -
                                                 ucDIALOG_BORDER_HEIGHT/2, 
                             rectClient.right - ucDIALOG_BORDER_WIDTH, 
                             rectClient.bottom - ucDIALOG_BORDER_HEIGHT/2);

            pWnd->MoveWindow(rectNewPos);
            pWnd->SetFont(pFont);
        }

        int nNumberOfButtons = 0;

        pWnd = GetDlgItem(ID_APPLY_NOW);
        if (pWnd != NULL)
        {
            CRect rectNewPos;
            if ((m_lOptions & APPLY) == 0)
            {
                rectNewPos = CRect(rectClient.right-50000, 
                                   rectClient.bottom-50000, 
                                   rectClient.right-50000, 
                                   rectClient.bottom-50000);
            }
            else
            {
                nNumberOfButtons++;
                rectNewPos = CRect(rectClient.right- ucDIALOG_BORDER_WIDTH - 
                                                   (nNumberOfButtons+1)*ucDIALOG_BUTTON_WIDTH -
                                                     nNumberOfButtons*ucDIALOG_BORDER_WIDTH/2, 
                                   rectClient.bottom - ucDIALOG_BUTTON_HEIGHT -
                                                       ucDIALOG_BORDER_HEIGHT/2, 
                                   rectClient.right - ucDIALOG_BORDER_WIDTH - 
                                                      nNumberOfButtons * ucDIALOG_BUTTON_WIDTH -
                                                      nNumberOfButtons * ucDIALOG_BORDER_WIDTH/2, 
                                   rectClient.bottom - ucDIALOG_BORDER_HEIGHT/2);
            }
            pWnd->MoveWindow(rectNewPos);
            pWnd->SetFont(pFont);
        }

        pWnd = GetDlgItem(IDCANCEL);
        if (pWnd != NULL)
        {
            CRect rectNewPos;
            if ((m_lOptions & CANCEL) == 0)
            {
                rectNewPos = CRect(rectClient.right-50000, 
                                   rectClient.bottom-50000, 
                                   rectClient.right-50000, 
                                   rectClient.bottom-50000);
            }
            else
            {
                nNumberOfButtons++;
                rectNewPos = CRect(rectClient.right- ucDIALOG_BORDER_WIDTH - 
                                                     (nNumberOfButtons+1)*ucDIALOG_BUTTON_WIDTH -
                                                     nNumberOfButtons*ucDIALOG_BORDER_WIDTH/2, 
                                   rectClient.bottom - ucDIALOG_BUTTON_HEIGHT -
                                                       ucDIALOG_BORDER_HEIGHT/2, 
                                   rectClient.right - ucDIALOG_BORDER_WIDTH - 
                                                      nNumberOfButtons*ucDIALOG_BUTTON_WIDTH -
                                                      nNumberOfButtons*ucDIALOG_BORDER_WIDTH/2, 
                                   rectClient.bottom - ucDIALOG_BORDER_HEIGHT/2);
            }
            pWnd->MoveWindow(rectNewPos);
            pWnd->SetFont(pFont);
        }

        pWnd = GetDlgItem(IDOK);
        if (pWnd != NULL)
        {
            CRect rectNewPos;
            if ((m_lOptions & OK) == 0)
            {
                rectNewPos = CRect(rectClient.right-50000, 
                                   rectClient.bottom-50000, 
                                   rectClient.right-50000, 
                                   rectClient.bottom-50000);
            }
            else
            {
                nNumberOfButtons++;
                rectNewPos = CRect(rectClient.right- ucDIALOG_BORDER_WIDTH - 
                                                     (nNumberOfButtons+1)*ucDIALOG_BUTTON_WIDTH -
                                                     nNumberOfButtons*ucDIALOG_BORDER_WIDTH/2, 
                                   rectClient.bottom - ucDIALOG_BUTTON_HEIGHT -
                                                       ucDIALOG_BORDER_HEIGHT/2, 
                                   rectClient.right - ucDIALOG_BORDER_WIDTH - 
                                                      nNumberOfButtons*ucDIALOG_BUTTON_WIDTH -
                                                      nNumberOfButtons*ucDIALOG_BORDER_WIDTH/2, 
                                   rectClient.bottom - ucDIALOG_BORDER_HEIGHT/2);
            }
            pWnd->MoveWindow(rectNewPos);
            pWnd->SetFont(pFont);
        }
    }
    ShowWindow(SW_SHOW);
}

void COverlayDlg::OnApplyNow() 
{
}

BOOL COverlayDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	if ((m_strXMLPageName == "IOS^PAGES^ejection.fml") || (m_strXMLPageName == "IOS^PAGES^crash.fml"))
	{	
		CMenu* pMenu = GetSystemMenu(FALSE);
		if (pMenu)
		{
           pMenu->EnableMenuItem(SC_CLOSE, MF_BYCOMMAND | MF_GRAYED | MF_DISABLED);
		}
	}
	return TRUE;
}

void COverlayDlg::OnCancel() 
{
	DestroyWindow();
}

void COverlayDlg::OnClose() 
{
	if ((m_strPageName == "Ejection") || (m_strPageName == "Crash"))
	{
       return;
	}
    DestroyWindow();
}

HBRUSH COverlayDlg::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor) 
{
	HBRUSH hbr = CDialog::OnCtlColor(pDC, pWnd, nCtlColor);
    if (nCtlColor == CTLCOLOR_DLG)
    {
	    return m_brBackground;
    }
    else
    {
        return hbr;
    }
}

void COverlayDlg::OnDestroy() 
{
    CWidget::ScreenRedrawing(m_hWnd, true);

    GetParentFrame()->SendMessage(WM_OVERLAY_CLOSED, (long)this, (long)&m_strPathName);

	CDialog::OnDestroy();

    CUpdateList::Cleanup(m_hWnd);
}

void COverlayDlg::OnHelp() 
{
    CPageWidget* pPageWidget = dynamic_cast<CPageWidget*>(m_pPageWidget);
    if (pPageWidget != NULL)
    {
        GetParentFrame()->SendMessage(WM_DIALOG_HELP, 0, (long)pPageWidget);
    }
}

void COverlayDlg::OnLButtonDown(UINT nFlags, CPoint point) 
{
	CDialog::OnLButtonDown(nFlags, point);

    PostMessage(WM_NCLBUTTONDOWN, HTCAPTION, MAKELPARAM(point.x,point.y));
}

void COverlayDlg::OnOK() 
{
    DestroyWindow();
}

/////////////////////////////////////////////////////////////////////////////
//
// UINT COverlayDlg::OnUpdateScreen()
//
// Inputs           : WPARAM wParam - not used.
//
// Return Values    : 0
//
// Date             : 7 July 1999
//
// Engineer         : Billy Baker
//
// Description      : Message handler to redraw the widgets that need to be
//                    redrawn.
//
/////////////////////////////////////////////////////////////////////////////
LPARAM COverlayDlg::OnUpdateScreen(WPARAM wParam, LPARAM lParam)
{
    _FSI_STL::map<long, CWidget*>  updateList = CUpdateList::GetList(m_hWnd);
    _FSI_STL::map<long, CWidget*>::iterator lIt      = updateList.begin();
    _FSI_STL::map<long, CWidget*>::iterator lendIt   = updateList.end();

    while (lIt != lendIt)
    {
        if (CWidget::IsValidAddress((*lIt).second) == VALID)
        {
            (*lIt).second->Draw();
        }

        lIt++;
    }

    CWidget::ScreenRedrawing(m_hWnd, false);

    return 0;
}

BOOL COverlayDlg::PreCreateWindow(CREATESTRUCT& cs) 
{
    cs.style      |= WS_CLIPSIBLINGS   |  WS_CLIPCHILDREN   |  CS_OWNDC;  

	return CDialog::PreCreateWindow(cs);
}

int COverlayDlg::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
    lpCreateStruct->style     |= WS_CLIPSIBLINGS   |  WS_CLIPCHILDREN   |  CS_OWNDC;  

	if (CDialog::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	return 0;
}

//////////////////////////////////////////////////////////////////////
// Accessors
//////////////////////////////////////////////////////////////////////

long int COverlayDlg::Options()
{
    return m_lOptions;
}

CWidget* COverlayDlg::PageWidget()
{
    return m_pPageWidget;
}

CWidget* COverlayDlg::ParentWidget()
{
    return m_pParentWidget;
}

CString COverlayDlg::WindowName()
{
    return m_strWindowName;
}

CString COverlayDlg::PathName()
{
    return m_strPathName;
}

CWnd* COverlayDlg::ParentWnd()
{
    return m_pParentWnd;
}

//////////////////////////////////////////////////////////////////////
// Mutators
//////////////////////////////////////////////////////////////////////

void COverlayDlg::Options(long int lOptions)
{
    m_lOptions = lOptions;
}

void COverlayDlg::PageWidget(CWidget* pPageWidget)
{
    m_pPageWidget = pPageWidget;
    if (m_pPageWidget != NULL)
    {
        CXMLWidget* pXMLWidget = m_pPageWidget->XMLWidget();
        if (pXMLWidget!= NULL)
        {
            CXMLElement* pXMLElement = NULL;
            POSITION pos = NULL;

            CString strValue;
            STRING2STRING_MAP::iterator s2sIt;
            _FSI_STL::string stlStrGlobalColor = _FSI_STL::string("");
            CColor colorGlobal;

            while (pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("COLOR")) == true)
            {
                strValue = pXMLElement->ElementValue().c_str();

                stlStrGlobalColor = _FSI_STL::string("");
                if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("GLOBALCOLOR")) == true)
                {
                    stlStrGlobalColor = (*s2sIt).second;
                    colorGlobal = CColor::GlobalColor(CString(stlStrGlobalColor.c_str()));
                }

                if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("PLANE")) == true)
                {
                    if (strstr((*s2sIt).second.c_str(), "BACKGROUND") != NULL)
                    {
                        COLORREF color = CColor(strValue);
                        if (stlStrGlobalColor != "Not Used")
                        {
                            color = colorGlobal;
                        }
                        m_brBackground.DeleteObject();

                        m_brBackground.CreateSolidBrush(color);

                        // Found the background color, leave the loop.
                        break;                    
                    }
                }
            }

            pXMLElement = NULL;
            if (pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("NAME")) == true)
            {
                m_strPageName = pXMLElement->ElementValue().c_str();
            }
        }
    }
}

void COverlayDlg::ParentWidget(CWidget* pWidget)
{
    m_pParentWidget = pWidget;
}

void COverlayDlg::WindowName(const CString& rstrWindowName)
{
	if (rstrWindowName.Find("^") > -1)
	{
		m_strWindowName = rstrWindowName.Left(rstrWindowName.Find("^"));
		m_strWindowName += " - " + m_strPageName;
	}
	else
	{
		m_strWindowName = rstrWindowName;
	}
    if (m_hWnd != NULL && m_pPageWidget != NULL)
    {
        CString str(m_strWindowName);
        str.Format("%s on screen %d.", str, ((CPageWidget*)m_pPageWidget)->WindowNumber());
        m_mapUpdateWindowText[m_hWnd] = (LPCTSTR)str;
    }
}

void COverlayDlg::XMLPageName(const CString& rstrXMLPageName)
{
	m_strXMLPageName = rstrXMLPageName;
}

void COverlayDlg::PathName(const CString& rstrPathName)
{
    m_strPathName = rstrPathName;
}

void COverlayDlg::XMLPage(CXMLPage* pXMLPage)
{
    // what is m_pXMLPage is not NULL???

    m_pXMLPage = pXMLPage;
}



LPARAM COverlayDlg::OnNextTab(WPARAM wParam, LPARAM lParam)
{
    CWnd* pWnd = (CWnd*)lParam;
    bool bUseNext = false;
    bool bFound = false;
    CWnd** pNextWnd = (CWnd**)wParam;


    // Find the next CWnd derived widget that has WS_TABSTOP.
    _FSI_STL::list<CWidget*>::iterator lIt = m_listWidgets.begin();
    while (lIt != m_listWidgets.end() && bFound == false)
    {
        if (bUseNext == true)
        {
            if ((*lIt)->Wnd() != NULL)
            {
                if ((*lIt)->Wnd()->GetStyle() & WS_TABSTOP &&
                    !((*lIt)->Wnd()->GetStyle() & BS_AUTORADIOBUTTON))
                {
                    *pNextWnd = (*lIt)->Wnd();

                    if ((*lIt)->Wnd()->IsWindowEnabled() == TRUE)
                       bFound = true;
                }
            }
        }

        if ((*lIt)->Wnd() == pWnd)
        {
            bUseNext = true;
        }

        lIt++;
    }

    CWidget* pWidget = NULL;
    lIt = m_listWidgets.begin();
    if ((bFound == false) && (pWnd != (*lIt)->Wnd()))
    {
        // A next field wasn't found from pWnd to the end.
        // Start over and search from the beginning.
        while ((*lIt)->Wnd() != pWnd && bFound == false)
        {
            pWidget = (*lIt);
            if ((*lIt)->Wnd() != NULL)
            {
                if ((*lIt)->Wnd()->GetStyle() & WS_TABSTOP &&
                    !((*lIt)->Wnd()->GetStyle() & BS_AUTORADIOBUTTON))
                {
                    *pNextWnd = (*lIt)->Wnd();
                    if ((*lIt)->Wnd()->IsWindowEnabled() == TRUE)
                       bFound = true;
                }
            }
            lIt++;
        }
    }

    return 0;
}

LPARAM COverlayDlg::OnPreviousTab(WPARAM wParam, LPARAM lParam)
{
    CWnd* pWnd = (CWnd*)lParam;
    CWnd** pNextWnd = (CWnd**)wParam;
    bool bFound = false;
    bool bUseNext = false;


    // Find the next CWnd derived widget that has WS_TABSTOP.
    _FSI_STL::list<CWidget*>::reverse_iterator lIt = m_listWidgets.rbegin();
    while (lIt != m_listWidgets.rend() && bFound == false)
    {
        if (bUseNext == true)
        {
            if ((*lIt)->Wnd() != NULL)
            {
                if ((*lIt)->Wnd()->GetStyle() & WS_TABSTOP &&
                    !((*lIt)->Wnd()->GetStyle() & BS_AUTORADIOBUTTON))
                {
                    *pNextWnd = (*lIt)->Wnd();
                    if ((*lIt)->Wnd()->IsWindowEnabled() == TRUE)
                       bFound = true;
                }
            }
        }

        if ((*lIt)->Wnd() == pWnd)
        {
            bUseNext = true;
        }

        lIt++;
    }

    CWidget* pWidget = NULL;
    lIt = m_listWidgets.rbegin();
    if ((bFound == false) && (pWnd != (*lIt)->Wnd()))
    {
        // A next field wasn't found from pWnd to the end.
        // Start over and search from the beginning.
        while ((*lIt)->Wnd() != pWnd && bFound == false)
        {
            pWidget = (*lIt);
            if ((*lIt)->Wnd() != NULL)
            {
                if ((*lIt)->Wnd()->GetStyle() & WS_TABSTOP &&
                    !((*lIt)->Wnd()->GetStyle() & BS_AUTORADIOBUTTON))
                {
                    *pNextWnd = (*lIt)->Wnd();
                    if ((*lIt)->Wnd()->IsWindowEnabled() == TRUE)
                       bFound = true;
                }
            }
            lIt++;
        }
    }

    return 0;
}
