// OpenGLtext.h: interface for the COpenGLtext class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_OPENGLTEXT_H__D7B8A012_61E2_11D2_AD4C_006008B0E0C3__INCLUDED_)
#define AFX_OPENGLTEXT_H__D7B8A012_61E2_11D2_AD4C_006008B0E0C3__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#ifdef CORE
#define DLLAPI __declspec( dllexport )
#else
#define DLLAPI __declspec( dllimport )
#endif

#include <gl\gl.h>              // OpenGL
#include <gl\glu.h>             // GLU library
#include <map>

enum
{
   SLASH_OUT               =  178,

   UPARROW                 =  203,
   DOWNARROW               =  204,
   FILLED_DIAMOND          =  205,
   VSI_AIRCRAFT_SYMBOL     =  206,
   VSI_NEEDLE              =  207,

   OMI                     =  208,

   RACETRACK_LINE          =  209,
   RACETRACK_ARC           =  210,

   OBSTACLE                =  211,
   GROUP_OBSTACLE          =  212,
   SPOT_ELEVATION          =  213,

   INNER_MARKER_SIDE_VIEW  =  214,
   MIDDLE_MARKER_SIDE_VIEW =  215,
   OUTER_MARKER_SIDE_VIEW  =  216,

   IAS_POINTER             =  217,
   BARBER_POINTER          =  218,
   CIRCLE                  =  219,
   RATE_OF_TURN            =  220,
   HEADING_BUG             =  221,
   COURSE_NEEDLE           =  222,
   LINE                    =  223,
   DOUBLE_NEEDLE           =  224,
   SINGLE_NEEDLE           =  225,
   SQUARE_CYLINDER         =  226,
   RUNWAY                  =  227,
   INNER_MARKER            =  228,
   MIDDLE_MARKER           =  229,
   OUTER_MARKER            =  230,
   AIRPORT                 =  231,
   NDB                     =  232,
   TACAN                   =  233,
   DME                     =  234,
   SQUARE                  =  DME,  // This is drawn exactly like the DME but since that's just a square I'm giving it a generic name.
   ILS_FAN                 =  235,
   VOR                     =  236,
   VORDME                  =  237,
   VORTAC                  =  238,
   WPT                     =  239,

   DIAMOND                 =  240,
   AILERON_TRIM            =  241,
   RUDDER_TRIM             =  242,
   ELEVATOR_TRIM           =  243,
   SIDE_VIEW_W_GEAR_DOWN   =  244,
   TOGGLE_SWITCH           =  245,
   AOA_NEEDLE              =  246,
   SYMBOLIC_AIRCRAFT       =  247,
   DEGREES                 =  248,
   NOMINAL_NEEDLE          =  249,
   TORQUE_NEEDLE           =  250,
   DELTA                   =  251,
   ALTIMETER_NEEDLE        =  252,
   NEG                     =  253,
   THE_PLANE               =  254,
   BACKGROUND_CELL         =  255,
   GL_DISP_LIST_SIZE       =  256
};

class COpenGLCircle;

class DLLAPI COpenGLtext  
{
public:
	COpenGLtext();
	virtual ~COpenGLtext();

   static   void  Initialize();
   static   void  Cleanup();

   void  Draw(CString &text, bool horizontal = true, float angle = 0.0f, float scale = 1.0f, float line_width = 1.0f, bool enclose = false);
   void  SetBackgroundColor(bool background_needed, int red, int green, int blue);
   void  SetForegroundColor(int red, int green, int blue);
   void  SetXtoYratio(float ratio);
   void  ComputeBoxSize(CString &text, bool horizontal, float &width, float &height);
   void  DrawBox(void);
   void  SetBoxOutlineColor(int red, int green, int blue);
   void  SetBoxFillColor(int red, int green, int blue);

   // Accessors
   CString Text();

   // Mutators
   void  Text(const CString& rstrText);

private:
   float m_font_height;
   float m_font_width;
   float m_x_to_y_ratio;

   float m_min_left;
   float m_max_right;
   float m_min_top;
   float m_min_bottom;

   static   float m_font_reducer;

   int   m_background_red;
   int   m_background_green;
   int   m_background_blue;
   int   m_foreground_red;
   int   m_foreground_green;
   int   m_foreground_blue;

   int   m_box_outline_red;
   int   m_box_outline_green;
   int   m_box_outline_blue;

   int   m_box_fill_red;
   int   m_box_fill_green;
   int   m_box_fill_blue;

   CString  m_strText;

   static   _FSI_STL::map<HANDLE, int*> m_mapLists;

   bool  m_background_needed;
   bool  m_bBoxSizeSet;
};

#endif // !defined(AFX_OPENGLTEXT_H__D7B8A012_61E2_11D2_AD4C_006008B0E0C3__INCLUDED_)

