// OpenGLtext.cpp: implementation of the COpenGLtext class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "OpenGLtext.h"
#include "dataconversion.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

#define  glRGB(x, y, z) glColor3ub((GLubyte)x, (GLubyte)y, (GLubyte)z)

float                       COpenGLtext::m_font_reducer = 175.0f;
_FSI_STL::map<HANDLE, int*> COpenGLtext::m_mapLists;


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

COpenGLtext::COpenGLtext()
{
   m_font_width   =  8.0f;
   m_font_height  =  12.0f;
   m_x_to_y_ratio =  1.0f;

   m_background_needed  =  false;
   m_foreground_red     =  255;
   m_foreground_green   =  255;
   m_foreground_blue    =  255;

   m_min_left    =  99999.0f;
   m_max_right   =  -9999.0f;
   m_min_top     =  99999.0f;
   m_min_bottom  =  99999.0f;


   m_box_outline_red    =  255;
   m_box_outline_green  =  255;
   m_box_outline_blue   =  255;

   m_box_fill_red       =  0;
   m_box_fill_green     =  0;
   m_box_fill_blue      =  0;

   m_bBoxSizeSet        = false;
}

COpenGLtext::~COpenGLtext()
{
}


void  COpenGLtext::Initialize()
{
   HANDLE hThread = AfxGetThread()->m_hThread;
   if (m_mapLists.find(hThread) != m_mapLists.end())
       return;

   m_mapLists[hThread] = new int[GL_DISP_LIST_SIZE];

   int* m_ascii_font = m_mapLists[hThread];

   if (m_ascii_font == NULL)
       return;

   memset(m_ascii_font, 0, GL_DISP_LIST_SIZE   *  sizeof(int));

   int   firstList = glGenLists(GL_DISP_LIST_SIZE);
   int   ii;
   for (ii =  0; ii < GL_DISP_LIST_SIZE; ii++)
   {
      m_ascii_font[ii]  =  firstList   +  ii;
   }

   // Black background
   glClearColor(0.0f, 0.0f, 0.0f, 1.0f);

   // Just draw the outlines of the polygons
   glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);

   glNewList(m_ascii_font['/'],   GL_COMPILE);
      glBegin(GL_LINES);
         glVertex2f(-4.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f( 4.f/m_font_reducer,  4.f/m_font_reducer);
      glEnd();
   glEndList();


   glNewList(m_ascii_font['.'],   GL_COMPILE);
      glBegin(GL_LINE_LOOP);
         glVertex2f( 0.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f(-1.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f(-1.f/m_font_reducer, -3.f/m_font_reducer);
         glVertex2f( 0.f/m_font_reducer, -3.f/m_font_reducer);
      glEnd();
   glEndList();


   glNewList(m_ascii_font[','],   GL_COMPILE);
      glBegin(GL_LINE_STRIP);
         glVertex2f(-1.f/m_font_reducer, -3.f/m_font_reducer);
         glVertex2f(-2.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f(-2.f/m_font_reducer, -3.f/m_font_reducer);
         glVertex2f(-1.f/m_font_reducer, -3.f/m_font_reducer);
         glVertex2f(-1.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f(-2.f/m_font_reducer, -5.f/m_font_reducer);
      glEnd();
   glEndList();


   glNewList(m_ascii_font['%'],   GL_COMPILE);
      glBegin(GL_LINE_LOOP);
         glVertex2f(-3.f/m_font_reducer,  2.f/m_font_reducer);
         glVertex2f(-3.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f(-1.f/m_font_reducer,  4.f/m_font_reducer);
      glEnd();
      glBegin(GL_LINE_LOOP);
         glVertex2f(-2.5f/m_font_reducer, -4.0f/m_font_reducer);
         glVertex2f(-3.0f/m_font_reducer, -4.0f/m_font_reducer);
         glVertex2f(-3.0f/m_font_reducer, -3.0f/m_font_reducer);
         glVertex2f( 2.5f/m_font_reducer,  4.0f/m_font_reducer);
         glVertex2f( 3.0f/m_font_reducer,  4.0f/m_font_reducer);
         glVertex2f( 3.0f/m_font_reducer,  3.0f/m_font_reducer);
      glEnd();
      glBegin(GL_LINE_LOOP);
         glVertex2f( 3.f/m_font_reducer, -2.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f( 1.f/m_font_reducer, -4.f/m_font_reducer);
      glEnd();
   glEndList();


   glNewList(m_ascii_font[':'],   GL_COMPILE);
      glBegin(GL_LINE_LOOP);
         glVertex2f(-0.5f/m_font_reducer,  1.5f/m_font_reducer);
         glVertex2f(-0.5f/m_font_reducer,  2.5f/m_font_reducer);
         glVertex2f( 0.5f/m_font_reducer,  2.5f/m_font_reducer);
         glVertex2f( 0.5f/m_font_reducer,  1.5f/m_font_reducer);
      glEnd();
      glBegin(GL_LINE_LOOP);
         glVertex2f(-0.5f/m_font_reducer, -1.5f/m_font_reducer);
         glVertex2f(-0.5f/m_font_reducer, -2.5f/m_font_reducer);
         glVertex2f( 0.5f/m_font_reducer, -2.5f/m_font_reducer);
         glVertex2f( 0.5f/m_font_reducer, -1.5f/m_font_reducer);
      glEnd();
   glEndList();

   // The Aileron Trim aircraft.
   glNewList(m_ascii_font[AILERON_TRIM], GL_COMPILE);
   {
      glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
         glRGB(255, 255, 255);
         glBegin(GL_TRIANGLE_FAN);
            glVertex2f(-5.00f/m_font_reducer,  -0.50f/m_font_reducer);
            glVertex2f(-5.00f/m_font_reducer,   0.00f/m_font_reducer);
            glVertex2f(-0.50f/m_font_reducer,   0.25f/m_font_reducer);
            glVertex2f( 0.50f/m_font_reducer,   0.25f/m_font_reducer);
            glVertex2f( 5.00f/m_font_reducer,   0.00f/m_font_reducer);
            glVertex2f( 5.00f/m_font_reducer,  -0.50f/m_font_reducer);
            glVertex2f( 0.50f/m_font_reducer,  -1.00f/m_font_reducer);
            glVertex2f(-0.50f/m_font_reducer,  -1.00f/m_font_reducer);
         glEnd();
         glBegin(GL_TRIANGLES);
            glVertex2f(-0.50f/m_font_reducer,   0.25f/m_font_reducer);
            glVertex2f( 0.00f/m_font_reducer,   1.50f/m_font_reducer);
            glVertex2f( 0.50f/m_font_reducer,   0.25f/m_font_reducer);

            glVertex2f(-0.50f/m_font_reducer,   0.50f/m_font_reducer);
            glVertex2f( 0.00f/m_font_reducer,  -1.50f/m_font_reducer);
            glVertex2f( 0.50f/m_font_reducer,   0.50f/m_font_reducer);
         glEnd();
      glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
   }
   glEndList();


   // The Rudder Trim aircraft.
   glNewList(m_ascii_font[RUDDER_TRIM], GL_COMPILE);
   {
      glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
         glRGB(255, 255, 255);
         glBegin(GL_TRIANGLE_FAN);
            glVertex2f(-5.00f/m_font_reducer,  -0.50f/m_font_reducer);
            glVertex2f(-5.00f/m_font_reducer,   0.00f/m_font_reducer);
            glVertex2f(-0.70f/m_font_reducer,   1.50f/m_font_reducer);
            glVertex2f( 0.70f/m_font_reducer,   1.50f/m_font_reducer);
            glVertex2f( 5.00f/m_font_reducer,   0.00f/m_font_reducer);
            glVertex2f( 5.00f/m_font_reducer,  -0.50f/m_font_reducer);
            glVertex2f( 0.70f/m_font_reducer,   0.00f/m_font_reducer);
            glVertex2f(-0.70f/m_font_reducer,   0.00f/m_font_reducer);
         glEnd();
         glBegin(GL_QUADS);
            glVertex2f(-0.70f/m_font_reducer,   1.50f/m_font_reducer);
            glVertex2f(-0.15f/m_font_reducer,   4.00f/m_font_reducer);
            glVertex2f( 0.15f/m_font_reducer,   4.00f/m_font_reducer);
            glVertex2f( 0.70f/m_font_reducer,   1.50f/m_font_reducer);

            glVertex2f(-0.70f/m_font_reducer,   0.00f/m_font_reducer);
            glVertex2f(-0.15f/m_font_reducer,  -5.00f/m_font_reducer);
            glVertex2f( 0.15f/m_font_reducer,  -5.00f/m_font_reducer);
            glVertex2f( 0.70f/m_font_reducer,   0.00f/m_font_reducer);

            glVertex2f( 0.00f/m_font_reducer,  -4.00f/m_font_reducer);
            glVertex2f( 1.00f/m_font_reducer,  -4.25f/m_font_reducer);
            glVertex2f( 1.00f/m_font_reducer,  -4.75f/m_font_reducer);
            glVertex2f( 0.00f/m_font_reducer,  -4.50f/m_font_reducer);

            glVertex2f( 0.00f/m_font_reducer,  -4.00f/m_font_reducer);
            glVertex2f(-1.00f/m_font_reducer,  -4.25f/m_font_reducer);
            glVertex2f(-1.00f/m_font_reducer,  -4.75f/m_font_reducer);
            glVertex2f( 0.00f/m_font_reducer,  -4.50f/m_font_reducer);
         glEnd();
      glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
   }
   glEndList();

   // The Elevator Trim aircraft.
   glNewList(m_ascii_font[ELEVATOR_TRIM], GL_COMPILE);
   {
      glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
         glBegin(GL_TRIANGLE_FAN);
            glVertex2f(-5.00f/m_font_reducer,  -0.25f/m_font_reducer);
            glVertex2f(-5.00f/m_font_reducer,   0.00f/m_font_reducer);
            glVertex2f(-2.00f/m_font_reducer,   1.00f/m_font_reducer);
            glVertex2f( 5.00f/m_font_reducer,   0.00f/m_font_reducer);
            glVertex2f( 5.00f/m_font_reducer,  -0.25f/m_font_reducer);
            glVertex2f(-1.00f/m_font_reducer,  -0.75f/m_font_reducer);
         glEnd();
         glBegin(GL_QUADS);
            glVertex2f( 3.50f/m_font_reducer,   0.00f/m_font_reducer);
            glVertex2f( 4.50f/m_font_reducer,   1.00f/m_font_reducer);
            glVertex2f( 5.00f/m_font_reducer,   1.00f/m_font_reducer);
            glVertex2f( 4.50f/m_font_reducer,   0.00f/m_font_reducer);
         glEnd();
      glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
   }
   glEndList();

   // The SIDE_VIEW_W_GEAR_DOWN aircraft.
   glNewList(m_ascii_font[SIDE_VIEW_W_GEAR_DOWN], GL_COMPILE);
   {
      // Draw the basic side view of the plane.
      glCallList(m_ascii_font[ELEVATOR_TRIM]);

      glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
         // Draw the main gear wheel.
         glPushMatrix();
            glTranslatef( -0.5f/m_font_reducer,      -1.25f/m_font_reducer, 0.0f);  // Move to just in front of center.
            glBegin(GL_POLYGON);
               glVertex2f( 1.f/m_font_reducer/12.f,   4.f/m_font_reducer/12.f);
               glVertex2f(-1.f/m_font_reducer/12.f,   4.f/m_font_reducer/12.f);
               glVertex2f(-3.f/m_font_reducer/12.f,   3.f/m_font_reducer/12.f);
               glVertex2f(-4.f/m_font_reducer/12.f,   1.f/m_font_reducer/12.f);
               glVertex2f(-4.f/m_font_reducer/12.f,  -1.f/m_font_reducer/12.f);
               glVertex2f(-3.f/m_font_reducer/12.f,  -3.f/m_font_reducer/12.f);
               glVertex2f(-1.f/m_font_reducer/12.f,  -4.f/m_font_reducer/12.f);
               glVertex2f( 1.f/m_font_reducer/12.f,  -4.f/m_font_reducer/12.f);
               glVertex2f( 3.f/m_font_reducer/12.f,  -3.f/m_font_reducer/12.f);
               glVertex2f( 4.f/m_font_reducer/12.f,  -1.f/m_font_reducer/12.f);
               glVertex2f( 4.f/m_font_reducer/12.f,   1.f/m_font_reducer/12.f);
               glVertex2f( 3.f/m_font_reducer/12.f,   3.f/m_font_reducer/12.f);
            glEnd();
         glPopMatrix();
         // Draw the front gear wheel.
         glPushMatrix();
            glTranslatef(-3.5f/m_font_reducer,       -1.25f/m_font_reducer, 0.0f);  // Move almost all the way to the nose.
            glBegin(GL_POLYGON);
               glVertex2f( 1.f/m_font_reducer/12.f,   4.f/m_font_reducer/12.f);
               glVertex2f(-1.f/m_font_reducer/12.f,   4.f/m_font_reducer/12.f);
               glVertex2f(-3.f/m_font_reducer/12.f,   3.f/m_font_reducer/12.f);
               glVertex2f(-4.f/m_font_reducer/12.f,   1.f/m_font_reducer/12.f);
               glVertex2f(-4.f/m_font_reducer/12.f,  -1.f/m_font_reducer/12.f);
               glVertex2f(-3.f/m_font_reducer/12.f,  -3.f/m_font_reducer/12.f);
               glVertex2f(-1.f/m_font_reducer/12.f,  -4.f/m_font_reducer/12.f);
               glVertex2f( 1.f/m_font_reducer/12.f,  -4.f/m_font_reducer/12.f);
               glVertex2f( 3.f/m_font_reducer/12.f,  -3.f/m_font_reducer/12.f);
               glVertex2f( 4.f/m_font_reducer/12.f,  -1.f/m_font_reducer/12.f);
               glVertex2f( 4.f/m_font_reducer/12.f,   1.f/m_font_reducer/12.f);
               glVertex2f( 3.f/m_font_reducer/12.f,   3.f/m_font_reducer/12.f);
            glEnd();
         glPopMatrix();
      glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
   }
   glEndList();



   // The Needle used by the Angle of Attack indicator.
   glNewList(m_ascii_font[AOA_NEEDLE], GL_COMPILE);
   {
      glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
      glBegin(GL_POLYGON);
         glVertex2f(-0.25f/m_font_reducer,  1.0f/m_font_reducer);
         glVertex2f(-0.25f/m_font_reducer,  4.0f/m_font_reducer);
         glVertex2f( 0.00f/m_font_reducer,  5.0f/m_font_reducer);
         glVertex2f( 0.25f/m_font_reducer,  4.0f/m_font_reducer);
         glVertex2f( 0.25f/m_font_reducer,  1.0f/m_font_reducer);
      glEnd();
      glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);

      glPushMatrix();
         glScalef(0.25f, 0.25f, 1.0f);
         glBegin(GL_POLYGON);
            glVertex2f( 1.f/m_font_reducer,  4.f/m_font_reducer);
            glVertex2f(-1.f/m_font_reducer,  4.f/m_font_reducer);
            glVertex2f(-3.f/m_font_reducer,  3.f/m_font_reducer);
            glVertex2f(-4.f/m_font_reducer,  1.f/m_font_reducer);
            glVertex2f(-4.f/m_font_reducer, -1.f/m_font_reducer);
            glVertex2f(-3.f/m_font_reducer, -3.f/m_font_reducer);
            glVertex2f(-1.f/m_font_reducer, -4.f/m_font_reducer);
            glVertex2f( 1.f/m_font_reducer, -4.f/m_font_reducer);
            glVertex2f( 3.f/m_font_reducer, -3.f/m_font_reducer);
            glVertex2f( 4.f/m_font_reducer, -1.f/m_font_reducer);
            glVertex2f( 4.f/m_font_reducer,  1.f/m_font_reducer);
            glVertex2f( 3.f/m_font_reducer,  3.f/m_font_reducer);
         glEnd();
      glPopMatrix();
   }
   glEndList();


   // The toggle switch.
   glNewList(m_ascii_font[TOGGLE_SWITCH], GL_COMPILE);
   {
      GLUquadricObj  *pquad   =  gluNewQuadric();
         gluCylinder(pquad, 2.0f/m_font_reducer,  4.0f/m_font_reducer, 25.0f/m_font_reducer, 60, 1);
      gluDeleteQuadric(pquad);
   }
   glEndList();


   // The Symbolic Aircraft used in the ADI Gauge.
   glNewList(m_ascii_font[SYMBOLIC_AIRCRAFT],   GL_COMPILE);
   {
      glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
         GLUquadricObj  *pquad   =  gluNewQuadric();
            gluDisk(pquad, 0.15f/m_font_reducer,  0.22f/m_font_reducer, 30, 1);
         gluDeleteQuadric(pquad);
      glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);

      glBegin(GL_LINE_STRIP);
         glVertex2f(-4.5f/m_font_reducer,  0.0f/m_font_reducer);
         glVertex2f(-2.0f/m_font_reducer,  0.0f/m_font_reducer);
         glVertex2f(-1.0f/m_font_reducer, -1.0f/m_font_reducer);
         glVertex2f( 0.0f/m_font_reducer,  0.0f/m_font_reducer);
         glVertex2f( 1.0f/m_font_reducer, -1.0f/m_font_reducer);
         glVertex2f( 2.0f/m_font_reducer,  0.0f/m_font_reducer);
         glVertex2f( 4.5f/m_font_reducer,  0.0f/m_font_reducer);
      glEnd();
   }
   glEndList();


   // The delta character.
   glNewList(m_ascii_font[DELTA], GL_COMPILE);
      glBegin(GL_TRIANGLES);
         glVertex2f(-4.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f( 0.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f( 4.f/m_font_reducer, -4.f/m_font_reducer);
      glEnd();
   glEndList();


   // A circle.
   glNewList(m_ascii_font[CIRCLE], GL_COMPILE);
   {
      glBegin(GL_POLYGON);
         glVertex2f( 1.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f(-1.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f(-3.f/m_font_reducer,  3.f/m_font_reducer);
         glVertex2f(-4.f/m_font_reducer,  1.f/m_font_reducer);
         glVertex2f(-4.f/m_font_reducer, -1.f/m_font_reducer);
         glVertex2f(-3.f/m_font_reducer, -3.f/m_font_reducer);
         glVertex2f(-1.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f( 1.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer, -3.f/m_font_reducer);
         glVertex2f( 4.f/m_font_reducer, -1.f/m_font_reducer);
         glVertex2f( 4.f/m_font_reducer,  1.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer,  3.f/m_font_reducer);
      glEnd();
   }
   glEndList();

   // A Line used to help build a race track shape.
   glNewList(m_ascii_font[RACETRACK_LINE], GL_COMPILE);
   {
      float radius   =  0.5038f;
      glBegin(GL_LINES);
         glVertex2f( 0.0f,  radius);
         glVertex2f( 0.0f, -radius);
      glEnd();
   }
   glEndList();

   // A Half-Circle used to help build a race track shape.
   glNewList(m_ascii_font[RACETRACK_ARC], GL_COMPILE);
   {
      float radius    =  0.5038f;
      glBegin(GL_LINE_STRIP);
      {
         for (int ii = 0; ii <= 180; ii += 15)
            glVertex2f(radius *  cos(ii   *  DEG_TO_RAD),   radius   *  sin(ii   *  DEG_TO_RAD));
      }
      glEnd();
   }
   glEndList();


   // The RATE_OF_TURN character.
   glNewList(m_ascii_font[RATE_OF_TURN], GL_COMPILE);
      glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
      glBegin(GL_QUADS);
         glVertex2f(-8.0f/m_font_reducer,  4.0f/m_font_reducer);
         glVertex2f( 8.0f/m_font_reducer,  4.0f/m_font_reducer);
         glVertex2f( 8.0f/m_font_reducer,  0.0f/m_font_reducer);
         glVertex2f(-8.0f/m_font_reducer,  0.0f/m_font_reducer);

         glVertex2f( 4.0f/m_font_reducer,  0.0f/m_font_reducer);
         glVertex2f( 4.0f/m_font_reducer, -4.0f/m_font_reducer);
         glVertex2f(-4.0f/m_font_reducer, -4.0f/m_font_reducer);
         glVertex2f(-4.0f/m_font_reducer,  0.0f/m_font_reducer);
      glEnd();
      glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
   glEndList();

   // The heading bug.
   glNewList(m_ascii_font[HEADING_BUG], GL_COMPILE);
   {
      glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
      glBegin(GL_QUADS);
         glVertex2f(-0.20f/m_font_reducer,  -0.10f/m_font_reducer);
         glVertex2f(-0.20f/m_font_reducer,   0.10f/m_font_reducer);
         glVertex2f(-0.10f/m_font_reducer,   0.10f/m_font_reducer);
         glVertex2f( 0.00f/m_font_reducer,  -0.10f/m_font_reducer);

         glVertex2f( 0.20f/m_font_reducer,  -0.10f/m_font_reducer);
         glVertex2f( 0.20f/m_font_reducer,   0.10f/m_font_reducer);
         glVertex2f( 0.10f/m_font_reducer,   0.10f/m_font_reducer);
         glVertex2f( 0.00f/m_font_reducer,  -0.10f/m_font_reducer);
      glEnd();
      glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
   }
   glEndList();


   // The course select needle character.
   glNewList(m_ascii_font[COURSE_NEEDLE], GL_COMPILE);
   {
      // Filled triangle.
      glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
      glBegin(GL_TRIANGLES);
         glVertex2f(-0.065f/m_font_reducer,  0.50f/m_font_reducer);
         glVertex2f( 0.00f/m_font_reducer,   0.70f/m_font_reducer);
         glVertex2f( 0.065f/m_font_reducer,  0.50f/m_font_reducer);
      glEnd();
      glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
      glBegin(GL_LINES);
         // Vertical line.
         glVertex2f( 0.00f/m_font_reducer,   0.50f/m_font_reducer);
         glVertex2f( 0.00f/m_font_reducer,   0.20f/m_font_reducer);
         // Vertical line.
         glVertex2f( 0.00f/m_font_reducer,   -0.70f/m_font_reducer);
         glVertex2f( 0.00f/m_font_reducer,   -0.20f/m_font_reducer);
      glEnd();
   }
   glEndList();


   // A simple line.
   glNewList(m_ascii_font[LINE], GL_COMPILE);
   {
      glBegin(GL_LINES);
         glVertex2f( 0.00f/m_font_reducer,    0.20f/m_font_reducer);
         glVertex2f( 0.00f/m_font_reducer,   -0.20f/m_font_reducer);
      glEnd();
   }
   glEndList();


   // The double needle character.
   glNewList(m_ascii_font[DOUBLE_NEEDLE], GL_COMPILE);
   {
      // Filled triangle.
      glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
      glBegin(GL_TRIANGLES);
         glVertex2f(-0.05f/m_font_reducer,   0.62f/m_font_reducer);
         glVertex2f( 0.00f/m_font_reducer,   0.72f/m_font_reducer);
         glVertex2f( 0.05f/m_font_reducer,   0.62f/m_font_reducer);
      glEnd();
      glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
      glBegin(GL_LINES);
         // Parallel vertical lines.
         glVertex2f( 0.02f/m_font_reducer,   0.62f/m_font_reducer);  glVertex2f( 0.02f/m_font_reducer,   0.40f/m_font_reducer);  // |           | |
         glVertex2f(-0.02f/m_font_reducer,   0.62f/m_font_reducer);  glVertex2f(-0.02f/m_font_reducer,   0.40f/m_font_reducer);  //   |         | |
         // Parallel vertical lines.
         glVertex2f( 0.02f/m_font_reducer,   -0.72f/m_font_reducer); glVertex2f( 0.02f/m_font_reducer,   -0.4f/m_font_reducer);  // |           | |
         glVertex2f(-0.02f/m_font_reducer,   -0.72f/m_font_reducer); glVertex2f(-0.02f/m_font_reducer,   -0.4f/m_font_reducer);  //   |         | |
      glEnd();
   }
   glEndList();


   // The single needle character.
   glNewList(m_ascii_font[SINGLE_NEEDLE], GL_COMPILE);
   {
      // Filled triangle.
      glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
      glBegin(GL_TRIANGLES);
         glVertex2f(-0.05f/m_font_reducer,   0.62f/m_font_reducer);
         glVertex2f( 0.00f/m_font_reducer,   0.72f/m_font_reducer);
         glVertex2f( 0.05f/m_font_reducer,   0.62f/m_font_reducer);
      glEnd();
      glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
      // Vertical line.
      glBegin(GL_LINES);
         glVertex2f( 0.00f/m_font_reducer,   0.62f/m_font_reducer);  glVertex2f( 0.00f/m_font_reducer,   0.40f/m_font_reducer);  // |            |
         glVertex2f( 0.00f/m_font_reducer,   -0.72f/m_font_reducer); glVertex2f( 0.00f/m_font_reducer,   -0.50f/m_font_reducer); // |            |
      glEnd();

      // Unfilled triangle.
      glBegin(GL_TRIANGLES);
         glVertex2f(-0.05f/m_font_reducer,   -0.50f/m_font_reducer);
         glVertex2f( 0.00f/m_font_reducer,   -0.40f/m_font_reducer);
         glVertex2f( 0.05f/m_font_reducer,   -0.50f/m_font_reducer);
      glEnd();
   }
   glEndList();


   // The square cylinder character.
   glNewList(m_ascii_font[SQUARE_CYLINDER], GL_COMPILE);
      glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
         glBegin(GL_TRIANGLE_STRIP);
            glVertex3f( 1.0f/m_font_reducer,  1.0f/m_font_reducer,  1.0f/m_font_reducer);
            glVertex3f(-1.0f/m_font_reducer,  1.0f/m_font_reducer,  1.0f/m_font_reducer);
            glVertex3f( 1.0f/m_font_reducer, -1.0f/m_font_reducer,  1.0f/m_font_reducer);
            glVertex3f(-1.0f/m_font_reducer, -1.0f/m_font_reducer,  1.0f/m_font_reducer);
            glVertex3f( 1.0f/m_font_reducer, -1.0f/m_font_reducer, -1.0f/m_font_reducer);
            glVertex3f(-1.0f/m_font_reducer, -1.0f/m_font_reducer, -1.0f/m_font_reducer);
            glVertex3f( 1.0f/m_font_reducer,  1.0f/m_font_reducer, -1.0f/m_font_reducer);
            glVertex3f(-1.0f/m_font_reducer,  1.0f/m_font_reducer, -1.0f/m_font_reducer);
         glEnd();
      glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
   glEndList();


   // The RUNWAY  character.
   glNewList(m_ascii_font[RUNWAY], GL_COMPILE);
      glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
         glBegin(GL_QUADS);
            glVertex2f(-0.5038f,  0.5038f);
            glVertex2f( 0.5038f,  0.5038f);
            glVertex2f( 0.5038f, -0.5038f);
            glVertex2f(-0.5038f, -0.5038f);
         glEnd();
      glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
   glEndList();



   glNewList(m_ascii_font[OBSTACLE],   GL_COMPILE);
      glBegin(GL_LINES);
         glVertex2f(-3.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f( 0.f/m_font_reducer,  4.f/m_font_reducer);
      glEnd();
      glBegin(GL_LINES);
         glVertex2f( 0.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer, -4.f/m_font_reducer);
      glEnd();
      glBegin(GL_LINE_LOOP);
         glVertex2f( 0.5f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f(-0.5f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f(-0.5f/m_font_reducer, -3.f/m_font_reducer);
         glVertex2f( 0.5f/m_font_reducer, -3.f/m_font_reducer);
      glEnd();
   glEndList();

   glNewList(m_ascii_font[GROUP_OBSTACLE],   GL_COMPILE);
      glBegin(GL_LINES);
         glVertex2f(-4.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f(-1.f/m_font_reducer,  4.f/m_font_reducer);
      glEnd();
      glBegin(GL_LINES);
         glVertex2f(-1.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f( 2.f/m_font_reducer, -4.f/m_font_reducer);
      glEnd();
      glBegin(GL_LINES);
         glVertex2f(-2.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f( 1.f/m_font_reducer,  4.f/m_font_reducer);
      glEnd();
      glBegin(GL_LINES);
         glVertex2f( 1.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f( 4.f/m_font_reducer, -4.f/m_font_reducer);
      glEnd();
      glBegin(GL_LINE_LOOP);
         glVertex2f( 0.5f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f(-0.5f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f(-0.5f/m_font_reducer, -3.f/m_font_reducer);
         glVertex2f( 0.5f/m_font_reducer, -3.f/m_font_reducer);
      glEnd();
   glEndList();

   glNewList(m_ascii_font[SPOT_ELEVATION],   GL_COMPILE);
      glBegin(GL_LINE_LOOP);
         glVertex2f( 0.5f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f(-0.5f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f(-0.5f/m_font_reducer, -3.f/m_font_reducer);
         glVertex2f( 0.5f/m_font_reducer, -3.f/m_font_reducer);
      glEnd();
   glEndList();



   // The INNER_MARKER_SIDE_VIEW character.
   glNewList(m_ascii_font[INNER_MARKER_SIDE_VIEW],    GL_COMPILE);
      glRGB(255, 255, 255);
      glBegin(GL_LINE_STRIP);
         glVertex2f(-0.50f/m_font_reducer,   4.0f/m_font_reducer);
         glVertex2f( 0.00f/m_font_reducer,   0.0f/m_font_reducer);
         glVertex2f( 0.50f/m_font_reducer,   4.0f/m_font_reducer);
      glEnd();
   glEndList();

   // The MIDDLE_MARKER_SIDE_VIEW character.
   glNewList(m_ascii_font[MIDDLE_MARKER_SIDE_VIEW],   GL_COMPILE);
      glRGB(255, 180, 1);
      glBegin(GL_LINE_STRIP);
         glVertex2f(-0.50f/m_font_reducer,   4.0f/m_font_reducer);
         glVertex2f( 0.00f/m_font_reducer,   0.0f/m_font_reducer);
         glVertex2f( 0.50f/m_font_reducer,   4.0f/m_font_reducer);
      glEnd();
   glEndList();

   // The OUTER_MARKER_SIDE_VIEW character.
   glNewList(m_ascii_font[OUTER_MARKER_SIDE_VIEW],    GL_COMPILE);
      glRGB(64, 64, 255);
      glBegin(GL_LINE_STRIP);
         glVertex2f(-0.50f/m_font_reducer,   4.0f/m_font_reducer);
         glVertex2f( 0.00f/m_font_reducer,   0.0f/m_font_reducer);
         glVertex2f( 0.50f/m_font_reducer,   4.0f/m_font_reducer);
      glEnd();
   glEndList();

   // The INNER_MARKER  character.
   glNewList(m_ascii_font[INNER_MARKER], GL_COMPILE);
   {
      glRGB(255, 255, 255);
      glScalef(0.5f, 2.0f, 1.0f);
      glBegin(GL_LINE_LOOP);
         glVertex2f( 1.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f(-1.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f(-3.f/m_font_reducer,  3.f/m_font_reducer);
         glVertex2f(-4.f/m_font_reducer,  1.f/m_font_reducer);
         glVertex2f(-4.f/m_font_reducer, -1.f/m_font_reducer);
         glVertex2f(-3.f/m_font_reducer, -3.f/m_font_reducer);
         glVertex2f(-1.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f( 1.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer, -3.f/m_font_reducer);
         glVertex2f( 4.f/m_font_reducer, -1.f/m_font_reducer);
         glVertex2f( 4.f/m_font_reducer,  1.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer,  3.f/m_font_reducer);
      glEnd();
      for (int jj = 0; jj < 3; jj++)
      {
         glRotatef(30.0f, 0.0f, 0.0f, 1.0f);
         for (float ii = 1.0f; ii > 0.0f; ii -= 0.25f)
         {
            glPushMatrix();
               glScalef(ii, ii, 1.0f);
               glBegin(GL_POINTS);
                  glVertex2f(-2.75f/m_font_reducer,  2.75f/m_font_reducer);
                  glVertex2f( 2.75f/m_font_reducer,  2.75f/m_font_reducer);
                  glVertex2f( 2.75f/m_font_reducer, -2.75f/m_font_reducer);
                  glVertex2f(-2.75f/m_font_reducer, -2.75f/m_font_reducer);
               glEnd();
            glPopMatrix();
         }
      }
   }
   glEndList();

   // The MIDDLE_MARKER  character.
   glNewList(m_ascii_font[MIDDLE_MARKER], GL_COMPILE);
   {
      glRGB(255, 180, 1);
      glScalef(0.5f, 2.0f, 1.0f);
      glBegin(GL_LINE_LOOP);
         glVertex2f( 1.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f(-1.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f(-3.f/m_font_reducer,  3.f/m_font_reducer);
         glVertex2f(-4.f/m_font_reducer,  1.f/m_font_reducer);
         glVertex2f(-4.f/m_font_reducer, -1.f/m_font_reducer);
         glVertex2f(-3.f/m_font_reducer, -3.f/m_font_reducer);
         glVertex2f(-1.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f( 1.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer, -3.f/m_font_reducer);
         glVertex2f( 4.f/m_font_reducer, -1.f/m_font_reducer);
         glVertex2f( 4.f/m_font_reducer,  1.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer,  3.f/m_font_reducer);
      glEnd();
      for (int jj = 0; jj < 3; jj++)
      {
         glRotatef(30.0f, 0.0f, 0.0f, 1.0f);
         for (float ii = 1.0f; ii > 0.0f; ii -= 0.25f)
         {
            glPushMatrix();
               glScalef(ii, ii, 1.0f);
               glBegin(GL_POINTS);
                  glVertex2f(-2.75f/m_font_reducer,  2.75f/m_font_reducer);
                  glVertex2f( 2.75f/m_font_reducer,  2.75f/m_font_reducer);
                  glVertex2f( 2.75f/m_font_reducer, -2.75f/m_font_reducer);
                  glVertex2f(-2.75f/m_font_reducer, -2.75f/m_font_reducer);
               glEnd();
            glPopMatrix();
         }
      }
   }
   glEndList();

   // The OUTER_MARKER  character.
   glNewList(m_ascii_font[OUTER_MARKER], GL_COMPILE);
   {
      glRGB(64, 64, 255);
      glScalef(0.5f, 2.0f, 1.0f);
      glBegin(GL_LINE_LOOP);
         glVertex2f( 1.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f(-1.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f(-3.f/m_font_reducer,  3.f/m_font_reducer);
         glVertex2f(-4.f/m_font_reducer,  1.f/m_font_reducer);
         glVertex2f(-4.f/m_font_reducer, -1.f/m_font_reducer);
         glVertex2f(-3.f/m_font_reducer, -3.f/m_font_reducer);
         glVertex2f(-1.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f( 1.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer, -3.f/m_font_reducer);
         glVertex2f( 4.f/m_font_reducer, -1.f/m_font_reducer);
         glVertex2f( 4.f/m_font_reducer,  1.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer,  3.f/m_font_reducer);
      glEnd();
      for (int jj = 0; jj < 3; jj++)
      {
         glRotatef(30.0f, 0.0f, 0.0f, 1.0f);
         for (float ii = 1.0f; ii > 0.0f; ii -= 0.25f)
         {
            glPushMatrix();
               glScalef(ii, ii, 1.0f);
               glBegin(GL_POINTS);
                  glVertex2f(-2.75f/m_font_reducer,  2.75f/m_font_reducer);
                  glVertex2f( 2.75f/m_font_reducer,  2.75f/m_font_reducer);
                  glVertex2f( 2.75f/m_font_reducer, -2.75f/m_font_reducer);
                  glVertex2f(-2.75f/m_font_reducer, -2.75f/m_font_reducer);
               glEnd();
            glPopMatrix();
         }
      }
   }
   glEndList();


   // The AIRPORT character.
   glNewList(m_ascii_font[AIRPORT], GL_COMPILE);
      glBegin(GL_LINE_LOOP);
         glVertex2f( 1.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f(-1.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f(-3.f/m_font_reducer,  3.f/m_font_reducer);
         glVertex2f(-4.f/m_font_reducer,  1.f/m_font_reducer);
         glVertex2f(-4.f/m_font_reducer, -1.f/m_font_reducer);
         glVertex2f(-3.f/m_font_reducer, -3.f/m_font_reducer);
         glVertex2f(-1.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f( 1.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer, -3.f/m_font_reducer);
         glVertex2f( 4.f/m_font_reducer, -1.f/m_font_reducer);
         glVertex2f( 4.f/m_font_reducer,  1.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer,  3.f/m_font_reducer);
      glEnd();
   glEndList();


   // The NDB character.
   glNewList(m_ascii_font[NDB], GL_COMPILE);
   {
      for (int jj = 0; jj < 3; jj++)
      {
         glRotatef(30.0f, 0.0f, 0.0f, 1.0f);
         for (float ii = 1.0f; ii > 0.0f; ii -= 0.25f)
         {
            glPushMatrix();
               glScalef(ii, ii, 1.0f);
               glBegin(GL_POINTS);
                  glVertex2f(-4.0f/m_font_reducer,  4.0f/m_font_reducer);
                  glVertex2f( 4.0f/m_font_reducer,  4.0f/m_font_reducer);
                  glVertex2f( 4.0f/m_font_reducer, -4.0f/m_font_reducer);
                  glVertex2f(-4.0f/m_font_reducer, -4.0f/m_font_reducer);
               glEnd();
            glPopMatrix();
         }
      }

   }
   glEndList();


   // The TACAN character.
   glNewList(m_ascii_font[TACAN], GL_COMPILE);
      glRGB(128, 128, 0);
      glBegin(GL_LINE_LOOP);
         glVertex2f( 0.0f/m_font_reducer,  4.5f/m_font_reducer);
         glVertex2f( 1.5f/m_font_reducer,  7.0f/m_font_reducer);
         glVertex2f( 5.5f/m_font_reducer,  5.0f/m_font_reducer);
         glVertex2f( 4.0f/m_font_reducer,  2.5f/m_font_reducer);
         glVertex2f( 4.0f/m_font_reducer, -2.5f/m_font_reducer);
         glVertex2f( 5.5f/m_font_reducer, -5.0f/m_font_reducer);
         glVertex2f( 1.5f/m_font_reducer, -7.0f/m_font_reducer);
         glVertex2f( 0.0f/m_font_reducer, -4.5f/m_font_reducer);
         glVertex2f(-4.0f/m_font_reducer, -2.5f/m_font_reducer);
         glVertex2f(-6.5f/m_font_reducer, -2.5f/m_font_reducer);
         glVertex2f(-6.5f/m_font_reducer,  2.5f/m_font_reducer);
         glVertex2f(-4.0f/m_font_reducer,  2.5f/m_font_reducer);
      glEnd();
   glEndList();


   // The DME character.
   glNewList(m_ascii_font[DME], GL_COMPILE);
      glBegin(GL_POLYGON);
         glVertex2f(-4.0f/m_font_reducer,  4.0f/m_font_reducer);
         glVertex2f( 4.0f/m_font_reducer,  4.0f/m_font_reducer);
         glVertex2f( 4.0f/m_font_reducer, -4.0f/m_font_reducer);
         glVertex2f(-4.0f/m_font_reducer, -4.0f/m_font_reducer);
      glEnd();
   glEndList();


   // The ILS character.
   glNewList(m_ascii_font[ILS_FAN], GL_COMPILE);
      glPushMatrix();
         glRotatef(90.0f, 0.0f, 0.0f, 1.0f);
         glBegin(GL_LINE_LOOP);
            glVertex2f( 0.0f/m_font_reducer, -18.0f/m_font_reducer);
            glVertex2f( 1.0f/m_font_reducer, -19.0f/m_font_reducer);
            glVertex2f( 0.0f/m_font_reducer,   0.0f/m_font_reducer);
            glVertex2f(-1.0f/m_font_reducer, -19.0f/m_font_reducer);
            glVertex2f( 0.0f/m_font_reducer, -18.0f/m_font_reducer);
            glVertex2f( 0.0f/m_font_reducer,   0.0f/m_font_reducer);
         glEnd();
      glPopMatrix();
   glEndList();


   // The VOR character.
   glNewList(m_ascii_font[VOR], GL_COMPILE);
      glBegin(GL_POLYGON);
         glVertex2f(-2.0f/m_font_reducer,  4.0f/m_font_reducer);
         glVertex2f(-4.5f/m_font_reducer,  0.0f/m_font_reducer);
         glVertex2f(-2.0f/m_font_reducer, -4.0f/m_font_reducer);
         glVertex2f( 2.0f/m_font_reducer, -4.0f/m_font_reducer);
         glVertex2f( 4.5f/m_font_reducer,  0.0f/m_font_reducer);
         glVertex2f( 2.0f/m_font_reducer,  4.0f/m_font_reducer);
      glEnd();
   glEndList();


   // The VORDME character.
   glNewList(m_ascii_font[VORDME], GL_COMPILE);
      glBegin(GL_POLYGON);
         glVertex2f(-2.0f/m_font_reducer,  4.0f/m_font_reducer);
         glVertex2f(-4.5f/m_font_reducer,  0.0f/m_font_reducer);
         glVertex2f(-2.0f/m_font_reducer, -4.0f/m_font_reducer);
         glVertex2f( 2.0f/m_font_reducer, -4.0f/m_font_reducer);
         glVertex2f( 4.5f/m_font_reducer,  0.0f/m_font_reducer);
         glVertex2f( 2.0f/m_font_reducer,  4.0f/m_font_reducer);
      glEnd();
      glBegin(GL_POLYGON);
         glVertex2f(-4.5f/m_font_reducer,  4.5f/m_font_reducer);
         glVertex2f( 4.5f/m_font_reducer,  4.5f/m_font_reducer);
         glVertex2f( 4.5f/m_font_reducer, -4.5f/m_font_reducer);
         glVertex2f(-4.5f/m_font_reducer, -4.5f/m_font_reducer);
      glEnd();
   glEndList();


   // The VORTAC character.
   glNewList(m_ascii_font[VORTAC], GL_COMPILE);
      glBegin(GL_POLYGON);
         glVertex2f( 0.0f/m_font_reducer,  4.5f/m_font_reducer);
         glVertex2f(-4.0f/m_font_reducer,  2.5f/m_font_reducer);
         glVertex2f(-4.0f/m_font_reducer, -2.5f/m_font_reducer);
         glVertex2f( 0.0f/m_font_reducer, -4.5f/m_font_reducer);
         glVertex2f( 4.0f/m_font_reducer, -2.5f/m_font_reducer);
         glVertex2f( 4.0f/m_font_reducer,  2.5f/m_font_reducer);
      glEnd();
      glBegin(GL_POLYGON);
         glVertex2f( 0.0f/m_font_reducer,  4.5f/m_font_reducer);
         glVertex2f( 1.5f/m_font_reducer,  7.0f/m_font_reducer);
         glVertex2f( 5.5f/m_font_reducer,  5.0f/m_font_reducer);
         glVertex2f( 4.0f/m_font_reducer,  2.5f/m_font_reducer);
         glVertex2f( 4.0f/m_font_reducer, -2.5f/m_font_reducer);
         glVertex2f( 5.5f/m_font_reducer, -5.0f/m_font_reducer);
         glVertex2f( 1.5f/m_font_reducer, -7.0f/m_font_reducer);
         glVertex2f( 0.0f/m_font_reducer, -4.5f/m_font_reducer);
         glVertex2f(-4.0f/m_font_reducer, -2.5f/m_font_reducer);
         glVertex2f(-6.5f/m_font_reducer, -2.5f/m_font_reducer);
         glVertex2f(-6.5f/m_font_reducer,  2.5f/m_font_reducer);
         glVertex2f(-4.0f/m_font_reducer,  2.5f/m_font_reducer);
      glEnd();
   glEndList();


   // The WPT character.
   glNewList(m_ascii_font[WPT], GL_COMPILE);
      glBegin(GL_LINE_LOOP);
         glVertex2f( 0.0f/m_font_reducer,  6.0f/m_font_reducer);
         glVertex2f( 1.5f/m_font_reducer,  1.5f/m_font_reducer);
         glVertex2f( 6.0f/m_font_reducer,  0.0f/m_font_reducer);
         glVertex2f( 1.5f/m_font_reducer, -1.5f/m_font_reducer);
         glVertex2f( 0.0f/m_font_reducer, -6.0f/m_font_reducer);
         glVertex2f(-1.5f/m_font_reducer, -1.5f/m_font_reducer);
         glVertex2f(-6.0f/m_font_reducer,  0.0f/m_font_reducer);
         glVertex2f(-1.5f/m_font_reducer,  1.5f/m_font_reducer);
      glEnd();
   glEndList();


   // The diamond character.
   glNewList(m_ascii_font[DIAMOND], GL_COMPILE);
      glBegin(GL_QUADS);
         glVertex2f(0.0f,                 -4.f/m_font_reducer);
         glVertex2f(4.f/m_font_reducer,    0.0f);
         glVertex2f(0.0f,                  4.f/m_font_reducer);
         glVertex2f(-4.f/m_font_reducer,   0.0f);
      glEnd();
   glEndList();


   // The  character.
   glNewList(m_ascii_font[DEGREES], GL_COMPILE);
      glBegin(GL_LINE_LOOP);
         glVertex2f(-1.f/m_font_reducer,  2.f/m_font_reducer);
         glVertex2f(-1.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f( 1.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f( 1.f/m_font_reducer,  2.f/m_font_reducer);
      glEnd();
   glEndList();


   // This is the special slashout character (used as the first digit of the altimeter when below 10,000 ft.).
   glNewList(m_ascii_font[SLASH_OUT],  GL_COMPILE);
      glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
         glRGB(255, 255, 255);
         glBegin(GL_QUADS);
            glVertex2f(-4.0f/m_font_reducer, -4.0f/m_font_reducer);
            glVertex2f(-4.0f/m_font_reducer,  4.0f/m_font_reducer);
            glVertex2f( 4.0f/m_font_reducer,  4.0f/m_font_reducer);
            glVertex2f( 4.0f/m_font_reducer, -4.0f/m_font_reducer);
         glEnd();
      glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);

      glLineWidth(2.2f);                                                // Double the line width.
      glRGB(0, 0, 0);
      glBegin(GL_LINES);
         glVertex2f(-4.f/m_font_reducer,  3.f/m_font_reducer);
         glVertex2f(-3.f/m_font_reducer,  4.f/m_font_reducer);

         glVertex2f(-4.f/m_font_reducer, -1.f/m_font_reducer);
         glVertex2f( 1.f/m_font_reducer,  4.f/m_font_reducer);

         glVertex2f(-4.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f( 4.f/m_font_reducer,  4.f/m_font_reducer);

         glVertex2f(-1.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f( 4.f/m_font_reducer,  1.f/m_font_reducer);

         glVertex2f( 3.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f( 4.f/m_font_reducer, -3.f/m_font_reducer);
      glEnd();
      glRGB(255, 255, 255);
      glLineWidth(1.0f);                                                // Restore the line width.
   glEndList();


   glNewList(m_ascii_font[IAS_POINTER],   GL_COMPILE);
      glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
         glBegin(GL_QUADS);
            glVertex2f(-0.5f/m_font_reducer, -8.00f/m_font_reducer);
            glVertex2f(-0.5f/m_font_reducer,  5.00f/m_font_reducer);
            glVertex2f( 0.5f/m_font_reducer,  8.00f/m_font_reducer);
            glVertex2f( 0.5f/m_font_reducer, -8.00f/m_font_reducer);
         glEnd();
      glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
   glEndList();

   glNewList(m_ascii_font[BARBER_POINTER],   GL_COMPILE);
      glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
         glBegin(GL_QUADS);
            glRGB(255, 0, 0);
            glVertex2f(-0.5f/m_font_reducer, -8.00f/m_font_reducer);
            glVertex2f(-0.5f/m_font_reducer,  8.00f/m_font_reducer);
            glVertex2f( 0.5f/m_font_reducer,  5.00f/m_font_reducer);
            glVertex2f( 0.5f/m_font_reducer, -8.00f/m_font_reducer);

            glRGB(255, 255, 255);
            glVertex2f( 0.5f/m_font_reducer,  5.00f/m_font_reducer);
            glVertex2f( 0.5f/m_font_reducer,  3.00f/m_font_reducer);
            glVertex2f(-0.5f/m_font_reducer,  1.00f/m_font_reducer);
            glVertex2f(-0.5f/m_font_reducer,  3.00f/m_font_reducer);

            glVertex2f( 0.5f/m_font_reducer,  1.00f/m_font_reducer);
            glVertex2f( 0.5f/m_font_reducer, -1.00f/m_font_reducer);
            glVertex2f(-0.5f/m_font_reducer, -3.00f/m_font_reducer);
            glVertex2f(-0.5f/m_font_reducer, -1.00f/m_font_reducer);

            glVertex2f( 0.5f/m_font_reducer, -3.00f/m_font_reducer);
            glVertex2f( 0.5f/m_font_reducer, -5.00f/m_font_reducer);
            glVertex2f(-0.5f/m_font_reducer, -7.00f/m_font_reducer);
            glVertex2f(-0.5f/m_font_reducer, -5.00f/m_font_reducer);
         glEnd();
      glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
   glEndList();

   // Needle used for altimeter.
   glNewList(m_ascii_font[ALTIMETER_NEEDLE],   GL_COMPILE);
      glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
         glBegin(GL_TRIANGLE_FAN);
            glVertex2f( 0.125f/m_font_reducer,  0.5f/m_font_reducer);
            glVertex2f(-0.125f/m_font_reducer,  0.5f/m_font_reducer);
            glVertex2f(-0.416f/m_font_reducer,  0.9f/m_font_reducer);
            glVertex2f(-0.416f/m_font_reducer,  1.8f/m_font_reducer);
            glVertex2f( 0.000f/m_font_reducer,  2.5f/m_font_reducer);
            glVertex2f( 0.416f/m_font_reducer,  1.8f/m_font_reducer);
            glVertex2f( 0.416f/m_font_reducer,  0.9f/m_font_reducer);
         glEnd();
         glBegin(GL_QUADS);
            glVertex2f(-0.125f/m_font_reducer, -5.00f/m_font_reducer);
            glVertex2f(-0.125f/m_font_reducer,  0.75f/m_font_reducer);
            glVertex2f( 0.125f/m_font_reducer,  0.75f/m_font_reducer);
            glVertex2f( 0.125f/m_font_reducer, -5.00f/m_font_reducer);
         glEnd();
      glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
   glEndList();

   // Aircraft symbol on new Honeywell VSI / TAS.
   glNewList(m_ascii_font[VSI_AIRCRAFT_SYMBOL],   GL_COMPILE);
      const float w1 = 8.0f; // extent of airplane
      const float w2 = 1.0f; // cross thickness
      glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);

         glBegin(GL_TRIANGLES);
            glVertex2f(   w1/m_font_reducer,  0.0f/m_font_reducer); // wing
            glVertex2f(  -w1/m_font_reducer,  0.0f/m_font_reducer);
            glVertex2f( 0.0f/m_font_reducer,  w1/2/m_font_reducer);

            glVertex2f(   w1/3*2/m_font_reducer,  -w1/m_font_reducer); // tail
            glVertex2f(  -w1/3*2/m_font_reducer,  -w1/m_font_reducer);
            glVertex2f( 0.0f/m_font_reducer,    -w1/3*2/m_font_reducer);
         glEnd();
         glBegin(GL_QUADS);
            glVertex2f( w2/m_font_reducer,  w1/m_font_reducer);
            glVertex2f( w2/m_font_reducer, -w1/m_font_reducer);
            glVertex2f(-w2/m_font_reducer, -w1/m_font_reducer);
            glVertex2f(-w2/m_font_reducer,  w1/m_font_reducer);
         glEnd();

      glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
   glEndList();

   // Needle used for new Honeywell VSI / TAS.
   glNewList(m_ascii_font[VSI_NEEDLE],   GL_COMPILE);
      glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
         glBegin(GL_TRIANGLES);
            glVertex2f(-10.0f/m_font_reducer,    80.0f/m_font_reducer);
            glVertex2f(  0.0f/m_font_reducer,   120.0f/m_font_reducer);
            glVertex2f( 10.0f/m_font_reducer,    80.0f/m_font_reducer);
         glEnd();
         glBegin(GL_QUADS);
            glVertex2f(-2.1f/m_font_reducer, 100.0f/m_font_reducer);
            glVertex2f(-2.1f/m_font_reducer,   0.0f/m_font_reducer);
            glVertex2f( 2.1f/m_font_reducer,   0.0f/m_font_reducer);
            glVertex2f( 2.1f/m_font_reducer, 100.0f/m_font_reducer);
         glEnd();
      glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
   glEndList();

   // Needle used for ITT, N1, Oil Pressure, Oil Temperature, and Hydraulic Pressure.
   glNewList(m_ascii_font[NOMINAL_NEEDLE],   GL_COMPILE);
         glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
            glBegin(GL_TRIANGLES);
               glVertex2f(-0.325f/m_font_reducer,  1.50f/m_font_reducer);
               glVertex2f( 0.000f/m_font_reducer,  2.25f/m_font_reducer);
               glVertex2f( 0.325f/m_font_reducer,  1.50f/m_font_reducer);
            glEnd();
         glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
         glBegin(GL_QUADS);
            glVertex2f(-0.025f/m_font_reducer,  0.5f/m_font_reducer);
            glVertex2f(-0.025f/m_font_reducer,  1.5f/m_font_reducer);
            glVertex2f( 0.025f/m_font_reducer,  1.5f/m_font_reducer);
            glVertex2f( 0.025f/m_font_reducer,  0.5f/m_font_reducer);
         glEnd();
   glEndList();

   // Needle used for torque.
   glNewList(m_ascii_font[TORQUE_NEEDLE],   GL_COMPILE);
         glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
            glBegin(GL_TRIANGLES);
               glVertex2f(-0.350f/m_font_reducer,  1.5f/m_font_reducer);
               glVertex2f( 0.000f/m_font_reducer,  2.5f/m_font_reducer);
               glVertex2f( 0.350f/m_font_reducer,  1.5f/m_font_reducer);
            glEnd();
         glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
         glBegin(GL_QUADS);
            glVertex2f(-0.025f/m_font_reducer,  0.0f/m_font_reducer);
            glVertex2f(-0.025f/m_font_reducer,  1.5f/m_font_reducer);
            glVertex2f( 0.025f/m_font_reducer,  1.5f/m_font_reducer);
            glVertex2f( 0.025f/m_font_reducer,  0.0f/m_font_reducer);
         glEnd();
   glEndList();

   // Single character depicting:  NEG
   glNewList(m_ascii_font[NEG],   GL_COMPILE);
      glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
         glRGB(255, 255, 0);                                            // Yellow.
         glBegin(GL_QUADS);
            glVertex2f(-4.5f/m_font_reducer, -4.5f/m_font_reducer);
            glVertex2f(-4.5f/m_font_reducer,  4.5f/m_font_reducer);
            glVertex2f( 4.5f/m_font_reducer,  4.5f/m_font_reducer);
            glVertex2f( 4.5f/m_font_reducer, -4.5f/m_font_reducer);
         glEnd();
      glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);

      glRGB(0, 0, 0);                                                   // Black.
      // Draw N.
      glBegin(GL_LINE_STRIP);
         glVertex2f(-3.5f/m_font_reducer,  1.0f/m_font_reducer);
         glVertex2f(-3.5f/m_font_reducer,  4.0f/m_font_reducer);
         glVertex2f(-2.0f/m_font_reducer,  1.0f/m_font_reducer);
         glVertex2f(-2.0f/m_font_reducer,  4.0f/m_font_reducer);
      glEnd();
      // Draw outer part of E.
      glBegin(GL_LINE_STRIP);
         glVertex2f( 1.0f/m_font_reducer, -1.5f/m_font_reducer);
         glVertex2f(-1.0f/m_font_reducer, -1.5f/m_font_reducer);
         glVertex2f(-1.0f/m_font_reducer,  1.5f/m_font_reducer);
         glVertex2f( 1.0f/m_font_reducer,  1.5f/m_font_reducer);
      glEnd();
      // Draw middle arm of E.
      glBegin(GL_LINES);
         glVertex2f(-1.f/m_font_reducer,  0.f/m_font_reducer);
         glVertex2f( 0.f/m_font_reducer,  0.f/m_font_reducer);
      glEnd();
      // Draw G.
      glBegin(GL_LINE_STRIP);
         glVertex2f( 3.5f/m_font_reducer, -1.0f/m_font_reducer);
         glVertex2f( 2.0f/m_font_reducer, -1.0f/m_font_reducer);
         glVertex2f( 2.0f/m_font_reducer, -4.0f/m_font_reducer);
         glVertex2f( 3.5f/m_font_reducer, -4.0f/m_font_reducer);
         glVertex2f( 3.5f/m_font_reducer, -3.0f/m_font_reducer);
         glVertex2f( 2.5f/m_font_reducer, -3.0f/m_font_reducer);
      glEnd();

      glRGB(255, 255, 255);                                             // White.
   glEndList();



   // Airplane
   glNewList(m_ascii_font[THE_PLANE],  GL_COMPILE);
      // Draw aircraft body.
      glBegin(GL_POLYGON);
         glVertex2f( 0.0f/m_font_reducer,  5.0f/m_font_reducer);
         glVertex2f( 1.0f/m_font_reducer,  4.0f/m_font_reducer);
         glVertex2f( 1.0f/m_font_reducer, -3.0f/m_font_reducer);
         glVertex2f( 0.0f/m_font_reducer, -4.0f/m_font_reducer);
         glVertex2f(-1.0f/m_font_reducer, -3.0f/m_font_reducer);
         glVertex2f(-1.0f/m_font_reducer,  4.0f/m_font_reducer);
      glEnd();
      // Draw left wing.
      glBegin(GL_POLYGON);
         glVertex2f(-1.f/m_font_reducer,  0.f/m_font_reducer);
         glVertex2f(-5.f/m_font_reducer, -2.f/m_font_reducer);
         glVertex2f(-5.f/m_font_reducer, -1.f/m_font_reducer);
         glVertex2f(-1.f/m_font_reducer,  2.f/m_font_reducer);
      glEnd();
      // Draw right wing.
      glBegin(GL_POLYGON);
         glVertex2f( 1.f/m_font_reducer,  0.f/m_font_reducer);
         glVertex2f( 5.f/m_font_reducer, -2.f/m_font_reducer);
         glVertex2f( 5.f/m_font_reducer, -1.f/m_font_reducer);
         glVertex2f( 1.f/m_font_reducer,  2.f/m_font_reducer);
      glEnd();
      // Draw tail.
      glBegin(GL_POLYGON);
         glVertex2f(-0.5f/m_font_reducer, -3.5f/m_font_reducer);
         glVertex2f(-2.0f/m_font_reducer, -4.5f/m_font_reducer);
         glVertex2f(-2.0f/m_font_reducer, -5.0f/m_font_reducer);
         glVertex2f( 0.0f/m_font_reducer, -4.0f/m_font_reducer);

         glVertex2f( 2.0f/m_font_reducer, -5.0f/m_font_reducer);
         glVertex2f( 2.0f/m_font_reducer, -4.5f/m_font_reducer);
         glVertex2f( 0.5f/m_font_reducer, -3.5f/m_font_reducer);
      glEnd();
   glEndList();


   // Background cell character
   glNewList(m_ascii_font[BACKGROUND_CELL],  GL_COMPILE);
      glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);                  // Fill in the background of the character cell with the background color.
         glBegin(GL_QUADS);
            glVertex2f(-4.0f/m_font_reducer, -7.0f/m_font_reducer);
            glVertex2f(-4.0f/m_font_reducer,  7.0f/m_font_reducer);
            glVertex2f( 4.0f/m_font_reducer,  7.0f/m_font_reducer);
            glVertex2f( 4.0f/m_font_reducer, -7.0f/m_font_reducer);
         glEnd();
      glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
   glEndList();


   // Minus sign character
   glNewList(m_ascii_font['-'],  GL_COMPILE);
      glBegin(GL_LINE_LOOP);
         glVertex2f(-3.25f/m_font_reducer, -0.05f/m_font_reducer);
         glVertex2f(-3.25f/m_font_reducer,  0.05f/m_font_reducer);
         glVertex2f( 3.25f/m_font_reducer,  0.05f/m_font_reducer);
         glVertex2f( 3.25f/m_font_reducer, -0.05f/m_font_reducer);
      glEnd();
   glEndList();


   // Plus sign character
   glNewList(m_ascii_font['+'],  GL_COMPILE);
      glBegin(GL_LINE_LOOP);
         glVertex2f(-3.5f/m_font_reducer, -0.05f/m_font_reducer);
         glVertex2f(-3.5f/m_font_reducer,  0.05f/m_font_reducer);
         glVertex2f( 3.5f/m_font_reducer,  0.05f/m_font_reducer);
         glVertex2f( 3.5f/m_font_reducer, -0.05f/m_font_reducer);
      glEnd();
      glBegin(GL_LINE_LOOP);
         glVertex2f(-0.05f/m_font_reducer, -3.5f/m_font_reducer);
         glVertex2f( 0.05f/m_font_reducer, -3.5f/m_font_reducer);
         glVertex2f( 0.05f/m_font_reducer,  3.5f/m_font_reducer);
         glVertex2f(-0.05f/m_font_reducer,  3.5f/m_font_reducer);
      glEnd();
   glEndList();


   glNewList(m_ascii_font['0'],   GL_COMPILE);
      glBegin(GL_LINE_LOOP);
         glVertex2f(-1.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f(-2.f/m_font_reducer, -3.f/m_font_reducer);
         glVertex2f(-2.f/m_font_reducer,  3.f/m_font_reducer);
         glVertex2f(-1.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f( 1.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f( 2.f/m_font_reducer,  3.f/m_font_reducer);
         glVertex2f( 2.f/m_font_reducer, -3.f/m_font_reducer);
         glVertex2f( 1.f/m_font_reducer, -4.f/m_font_reducer);
      glEnd();
   glEndList();

   glNewList(m_ascii_font['1'],   GL_COMPILE);
      glBegin(GL_LINE_STRIP);
         glVertex2f(-2.f/m_font_reducer,  2.f/m_font_reducer);
         glVertex2f( 0.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f( 0.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f(-3.f/m_font_reducer, -4.f/m_font_reducer);
      glEnd();
      glBegin(GL_LINE_STRIP);
         glVertex2f( 0.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer, -4.f/m_font_reducer);
      glEnd();
   glEndList();

   glNewList(m_ascii_font['2'],   GL_COMPILE);
      glBegin(GL_LINE_STRIP);
         glVertex2f(-3.f/m_font_reducer,  1.f/m_font_reducer);
         glVertex2f(-2.f/m_font_reducer,  3.f/m_font_reducer);
         glVertex2f( 0.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f( 2.f/m_font_reducer,  3.f/m_font_reducer);
         glVertex2f( 2.f/m_font_reducer,  1.f/m_font_reducer);
         glVertex2f(-3.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f( 2.f/m_font_reducer, -4.f/m_font_reducer);
      glEnd();
   glEndList();

   glNewList(m_ascii_font['3'],   GL_COMPILE);
      glBegin(GL_LINE_STRIP);
         glVertex2f(-2.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f( 2.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer,  3.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer,  1.f/m_font_reducer);
         glVertex2f( 2.f/m_font_reducer,  0.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer, -1.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer, -3.f/m_font_reducer);
         glVertex2f( 2.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f(-2.f/m_font_reducer, -4.f/m_font_reducer);
      glEnd();
      glBegin(GL_LINES);
         glVertex2f(-1.f/m_font_reducer,  0.f/m_font_reducer);
         glVertex2f( 2.f/m_font_reducer,  0.f/m_font_reducer);
      glEnd();
   glEndList();

   glNewList(m_ascii_font['4'],   GL_COMPILE);
      glBegin(GL_LINE_STRIP);
         glVertex2f( 1.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f(-3.f/m_font_reducer, -1.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer, -1.f/m_font_reducer);
      glEnd();
      glBegin(GL_LINES);
         glVertex2f( 1.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f( 1.f/m_font_reducer, -4.f/m_font_reducer);
      glEnd();
   glEndList();

   glNewList(m_ascii_font['5'],   GL_COMPILE);
      glBegin(GL_LINE_STRIP);
         glVertex2f( 3.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f(-2.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f(-3.f/m_font_reducer,  3.f/m_font_reducer);
         glVertex2f(-3.f/m_font_reducer,  0.f/m_font_reducer);
         glVertex2f( 0.f/m_font_reducer,  1.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer,  0.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer, -2.f/m_font_reducer);
         glVertex2f( 2.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f(-2.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f(-3.f/m_font_reducer, -2.f/m_font_reducer);
      glEnd();
   glEndList();

   glNewList(m_ascii_font['6'],   GL_COMPILE);
      glBegin(GL_LINE_STRIP);
         glVertex2f( 3.f/m_font_reducer,  3.f/m_font_reducer);
         glVertex2f( 2.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f(-2.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f(-3.f/m_font_reducer,  3.f/m_font_reducer);
         glVertex2f(-3.f/m_font_reducer, -3.f/m_font_reducer);
         glVertex2f(-2.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f( 2.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer, -3.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer, -1.f/m_font_reducer);
         glVertex2f( 2.f/m_font_reducer,  0.f/m_font_reducer);
         glVertex2f(-3.f/m_font_reducer,  0.f/m_font_reducer);
      glEnd();
   glEndList();

   glNewList(m_ascii_font['7'],   GL_COMPILE);
      glBegin(GL_LINE_STRIP);
         glVertex2f(-2.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f( 2.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f(-1.f/m_font_reducer, -4.f/m_font_reducer);
      glEnd();
   glEndList();

   glNewList(m_ascii_font['8'],   GL_COMPILE);
      glBegin(GL_LINE_STRIP);
         glVertex2f(-2.f/m_font_reducer,  0.f/m_font_reducer);
         glVertex2f(-3.f/m_font_reducer,  1.f/m_font_reducer);
         glVertex2f(-3.f/m_font_reducer,  3.f/m_font_reducer);
         glVertex2f(-2.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f( 2.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer,  3.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer,  1.f/m_font_reducer);
         glVertex2f( 2.f/m_font_reducer,  0.f/m_font_reducer);
         glVertex2f(-2.f/m_font_reducer,  0.f/m_font_reducer);
         glVertex2f(-2.f/m_font_reducer,  0.f/m_font_reducer);
         glVertex2f(-3.f/m_font_reducer, -1.f/m_font_reducer);
         glVertex2f(-3.f/m_font_reducer, -3.f/m_font_reducer);
         glVertex2f(-2.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f( 2.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer, -3.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer, -1.f/m_font_reducer);
         glVertex2f( 2.f/m_font_reducer,  0.f/m_font_reducer);
      glEnd();
   glEndList();

   glNewList(m_ascii_font['9'],   GL_COMPILE);
      glBegin(GL_LINE_STRIP);
         glVertex2f( 3.f/m_font_reducer,  0.f/m_font_reducer);
         glVertex2f(-2.f/m_font_reducer,  0.f/m_font_reducer);
         glVertex2f(-3.f/m_font_reducer,  1.f/m_font_reducer);
         glVertex2f(-3.f/m_font_reducer,  3.f/m_font_reducer);
         glVertex2f(-2.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f( 2.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer,  3.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer, -3.f/m_font_reducer);
         glVertex2f( 2.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f(-2.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f(-3.f/m_font_reducer, -3.f/m_font_reducer);
      glEnd();
   glEndList();



   glNewList(m_ascii_font['A'],   GL_COMPILE);
      glBegin(GL_LINE_STRIP);
         glVertex2f(-3.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f(-2.f/m_font_reducer, -1.f/m_font_reducer);
         glVertex2f( 0.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f( 2.f/m_font_reducer, -1.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer, -4.f/m_font_reducer);
      glEnd();
      glBegin(GL_LINES);
         glVertex2f(-2.f/m_font_reducer, -1.f/m_font_reducer);
         glVertex2f( 2.f/m_font_reducer, -1.f/m_font_reducer);
      glEnd();
   glEndList();

   glNewList(m_ascii_font['B'],   GL_COMPILE);
      glBegin(GL_LINE_LOOP);
         glVertex2f(-3.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f(-3.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f( 2.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer,  3.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer,  1.f/m_font_reducer);
         glVertex2f( 2.f/m_font_reducer,  0.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer, -1.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer, -3.f/m_font_reducer);
         glVertex2f( 2.f/m_font_reducer, -4.f/m_font_reducer);
      glEnd();
      glBegin(GL_LINES);
         glVertex2f(-3.f/m_font_reducer,  0.f/m_font_reducer);
         glVertex2f( 2.f/m_font_reducer,  0.f/m_font_reducer);
      glEnd();
   glEndList();

   glNewList(m_ascii_font['C'],   GL_COMPILE);
      glBegin(GL_LINE_STRIP);
         glVertex2f( 3.f/m_font_reducer,  3.f/m_font_reducer);
         glVertex2f( 2.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f(-2.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f(-3.f/m_font_reducer,  3.f/m_font_reducer);
         glVertex2f(-3.f/m_font_reducer, -3.f/m_font_reducer);
         glVertex2f(-2.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f( 2.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer, -3.f/m_font_reducer);
      glEnd();
   glEndList();

   glNewList(m_ascii_font['D'],   GL_COMPILE);
      glBegin(GL_LINE_LOOP);
         glVertex2f( 2.5f/m_font_reducer,  2.0f/m_font_reducer);
         glVertex2f( 1.0f/m_font_reducer,  4.0f/m_font_reducer);
         glVertex2f(-2.5f/m_font_reducer,  4.0f/m_font_reducer);
         glVertex2f(-2.5f/m_font_reducer, -4.0f/m_font_reducer);
         glVertex2f( 1.0f/m_font_reducer, -4.0f/m_font_reducer);
         glVertex2f( 2.5f/m_font_reducer, -2.0f/m_font_reducer);
      glEnd();
   glEndList();

   glNewList(m_ascii_font['E'],   GL_COMPILE);
      glBegin(GL_LINE_STRIP);
         glVertex2f( 3.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f(-3.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f(-3.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer, -4.f/m_font_reducer);
      glEnd();
      glBegin(GL_LINES);
         glVertex2f(-3.f/m_font_reducer,  0.f/m_font_reducer);
         glVertex2f( 1.f/m_font_reducer,  0.f/m_font_reducer);
      glEnd();
   glEndList();

   glNewList(m_ascii_font['F'],   GL_COMPILE);
      glBegin(GL_LINE_STRIP);
         glVertex2f( 3.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f(-3.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f(-3.f/m_font_reducer, -4.f/m_font_reducer);
      glEnd();
      glBegin(GL_LINES);
         glVertex2f(-3.f/m_font_reducer,  0.f/m_font_reducer);
         glVertex2f( 1.f/m_font_reducer,  0.f/m_font_reducer);
      glEnd();
   glEndList();

   glNewList(m_ascii_font['G'],   GL_COMPILE);
      glBegin(GL_LINE_STRIP);
         glVertex2f( 3.f/m_font_reducer,  3.f/m_font_reducer);
         glVertex2f( 2.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f(-2.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f(-3.f/m_font_reducer,  3.f/m_font_reducer);
         glVertex2f(-3.f/m_font_reducer, -3.f/m_font_reducer);
         glVertex2f(-2.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f( 2.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer, -3.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer, -1.f/m_font_reducer);
         glVertex2f( 1.f/m_font_reducer, -1.f/m_font_reducer);
      glEnd();
   glEndList();

   glNewList(m_ascii_font['H'],   GL_COMPILE);
      glBegin(GL_LINES);
         glVertex2f(-2.5f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f(-2.5f/m_font_reducer, -4.f/m_font_reducer);

         glVertex2f( 2.5f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f( 2.5f/m_font_reducer, -4.f/m_font_reducer);

         glVertex2f(-2.5f/m_font_reducer,  0.f/m_font_reducer);
         glVertex2f( 2.5f/m_font_reducer,  0.f/m_font_reducer);
      glEnd();
   glEndList();

   glNewList(m_ascii_font['I'],   GL_COMPILE);
      glBegin(GL_LINES);
         glVertex2f(-3.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer,  4.f/m_font_reducer);

         glVertex2f(-3.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer, -4.f/m_font_reducer);

         glVertex2f( 0.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f( 0.f/m_font_reducer, -4.f/m_font_reducer);
      glEnd();
   glEndList();

   glNewList(m_ascii_font['J'],   GL_COMPILE);
      glBegin(GL_LINE_STRIP);
         glVertex2f(-3.f/m_font_reducer, -2.f/m_font_reducer);
         glVertex2f(-3.f/m_font_reducer, -3.f/m_font_reducer);
         glVertex2f(-2.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f( 2.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer, -3.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer,  4.f/m_font_reducer);
      glEnd();
   glEndList();

   glNewList(m_ascii_font['K'],   GL_COMPILE);
      glBegin(GL_LINES);
         glVertex2f(-3.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f(-3.f/m_font_reducer, -4.f/m_font_reducer);

         glVertex2f( 3.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f(-3.f/m_font_reducer,  0.f/m_font_reducer);

         glVertex2f(-3.f/m_font_reducer,  0.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer, -4.f/m_font_reducer);
      glEnd();
   glEndList();

   glNewList(m_ascii_font['L'],   GL_COMPILE);
      glBegin(GL_LINE_STRIP);
         glVertex2f(-3.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f(-3.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer, -4.f/m_font_reducer);
      glEnd();
   glEndList();

   glNewList(m_ascii_font['M'],   GL_COMPILE);
      glBegin(GL_LINE_STRIP);
         glVertex2f(-3.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f(-3.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f( 0.f/m_font_reducer,  0.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer, -4.f/m_font_reducer);
      glEnd();
   glEndList();

   glNewList(m_ascii_font['N'],   GL_COMPILE);
      glBegin(GL_LINE_STRIP);
         glVertex2f(-3.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f(-3.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer,  4.f/m_font_reducer);
      glEnd();
   glEndList();

   glNewList(m_ascii_font['O'],   GL_COMPILE);
      glBegin(GL_LINE_LOOP);
         glVertex2f(-1.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f(-3.f/m_font_reducer, -2.f/m_font_reducer);
         glVertex2f(-3.f/m_font_reducer,  2.f/m_font_reducer);
         glVertex2f(-1.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f( 1.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer,  2.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer, -2.f/m_font_reducer);
         glVertex2f( 1.f/m_font_reducer, -4.f/m_font_reducer);
      glEnd();
   glEndList();

   glNewList(m_ascii_font['P'],   GL_COMPILE);
      glBegin(GL_LINE_STRIP);
         glVertex2f(-3.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f(-3.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f( 2.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer,  3.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer,  1.f/m_font_reducer);
         glVertex2f( 2.f/m_font_reducer,  0.f/m_font_reducer);
         glVertex2f(-3.f/m_font_reducer,  0.f/m_font_reducer);
      glEnd();
   glEndList();

   glNewList(m_ascii_font['Q'],   GL_COMPILE);
      glBegin(GL_LINE_LOOP);
         glVertex2f(-1.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f(-3.f/m_font_reducer, -2.f/m_font_reducer);
         glVertex2f(-3.f/m_font_reducer,  2.f/m_font_reducer);
         glVertex2f(-1.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f( 1.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer,  2.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer, -2.f/m_font_reducer);
         glVertex2f( 1.f/m_font_reducer, -4.f/m_font_reducer);
      glEnd();
      glBegin(GL_LINES);
         glVertex2f( 1.f/m_font_reducer, -2.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer, -5.f/m_font_reducer);
      glEnd();
   glEndList();

   glNewList(m_ascii_font['R'],   GL_COMPILE);
      glBegin(GL_LINE_STRIP);
         glVertex2f(-3.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f(-3.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f( 2.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer,  3.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer,  1.f/m_font_reducer);
         glVertex2f( 2.f/m_font_reducer,  0.f/m_font_reducer);
         glVertex2f(-3.f/m_font_reducer,  0.f/m_font_reducer);
      glEnd();
      glBegin(GL_LINES);
         glVertex2f( 0.f/m_font_reducer,  0.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer, -4.f/m_font_reducer);
      glEnd();
   glEndList();

   glNewList(m_ascii_font['S'],   GL_COMPILE);
      glBegin(GL_LINE_STRIP);
         glVertex2f( 3.f/m_font_reducer,  3.f/m_font_reducer);
         glVertex2f( 2.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f(-2.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f(-3.f/m_font_reducer,  3.f/m_font_reducer);
         glVertex2f(-3.f/m_font_reducer,  1.f/m_font_reducer);
         glVertex2f(-2.f/m_font_reducer,  0.f/m_font_reducer);
         glVertex2f( 2.f/m_font_reducer,  0.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer, -1.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer, -3.f/m_font_reducer);
         glVertex2f( 2.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f(-2.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f(-3.f/m_font_reducer, -3.f/m_font_reducer);
      glEnd();
   glEndList();

   glNewList(m_ascii_font['T'],   GL_COMPILE);
      glBegin(GL_LINES);
         glVertex2f(-3.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer,  4.f/m_font_reducer);

         glVertex2f( 0.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f( 0.f/m_font_reducer, -4.f/m_font_reducer);
      glEnd();
   glEndList();

   glNewList(m_ascii_font['U'],   GL_COMPILE);
      glBegin(GL_LINE_STRIP);
         glVertex2f(-3.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f(-3.f/m_font_reducer, -3.f/m_font_reducer);
         glVertex2f(-2.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f( 2.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer, -3.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer,  4.f/m_font_reducer);
      glEnd();
   glEndList();

   glNewList(m_ascii_font['V'],   GL_COMPILE);
      glBegin(GL_LINE_STRIP);
         glVertex2f(-3.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f( 0.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer,  4.f/m_font_reducer);
      glEnd();
   glEndList();

   glNewList(m_ascii_font['W'],   GL_COMPILE);
      glBegin(GL_LINE_STRIP);
         glVertex2f(-3.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f(-3.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f( 0.f/m_font_reducer,  0.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer,  4.f/m_font_reducer);
      glEnd();
   glEndList();

   glNewList(m_ascii_font['X'],   GL_COMPILE);
      glBegin(GL_LINES);
         glVertex2f(-3.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer, -4.f/m_font_reducer);

         glVertex2f( 3.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f(-3.f/m_font_reducer, -4.f/m_font_reducer);
      glEnd();
   glEndList();

   glNewList(m_ascii_font['Y'],   GL_COMPILE);
      glBegin(GL_LINE_STRIP);
         glVertex2f(-3.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f( 0.f/m_font_reducer,  0.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer,  4.f/m_font_reducer);
      glEnd();
      glBegin(GL_LINES);
         glVertex2f( 0.f/m_font_reducer,  0.f/m_font_reducer);
         glVertex2f( 0.f/m_font_reducer, -4.f/m_font_reducer);
      glEnd();
   glEndList();

   glNewList(m_ascii_font['Z'],   GL_COMPILE);
      glBegin(GL_LINE_STRIP);
         glVertex2f(-3.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer,  4.f/m_font_reducer);
         glVertex2f(-3.f/m_font_reducer, -4.f/m_font_reducer);
         glVertex2f( 3.f/m_font_reducer, -4.f/m_font_reducer);
      glEnd();
   glEndList();


   glNewList(m_ascii_font[OMI],   GL_COMPILE);
      glRGB(0, 255, 255);
      glCallList(m_ascii_font['O']);
      glRGB(232, 189, 45);
      glCallList(m_ascii_font['M']);
      glRGB(255, 255, 255);
      glCallList(m_ascii_font['I']);
   glEndList();


   // A filled TAS diamond
   glNewList(m_ascii_font[FILLED_DIAMOND], GL_COMPILE);
      glPushAttrib(GL_POLYGON_BIT);
         glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
         glBegin(GL_QUADS);
            glVertex2f(0.0f,                 -4.f/m_font_reducer);
            glVertex2f(4.f/m_font_reducer,    0.0f);
            glVertex2f(0.0f,                  4.f/m_font_reducer);
            glVertex2f(-4.f/m_font_reducer,   0.0f);
         glEnd();
      glPopAttrib();
   glEndList();

   // A down-arrow symbol
   glNewList(m_ascii_font[DOWNARROW], GL_COMPILE);
      glPushAttrib(GL_POLYGON_BIT);
         glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
         glBegin(GL_TRIANGLES);
            glVertex2f(0.0f,                 -4.f/m_font_reducer);
            glVertex2f(4.f/m_font_reducer,    0.0f);
            glVertex2f(-4.f/m_font_reducer,   0.0f);
         glEnd();
         glBegin(GL_LINES);
            glVertex2f(0.0f,  4.0f/m_font_reducer);
            glVertex2f(0.0f, -4.0f/m_font_reducer);
         glEnd();
      glPopAttrib();
   glEndList();

   // An up-arrow symbol
   glNewList(m_ascii_font[UPARROW], GL_COMPILE);
      glPushAttrib(GL_POLYGON_BIT);
         glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
         glBegin(GL_TRIANGLES);
            //glVertex2f(0.0f,                 -4.f/m_font_reducer);
            glVertex2f(4.f/m_font_reducer,    0.0f);
            glVertex2f(0.0f,                  4.f/m_font_reducer);
            glVertex2f(-4.f/m_font_reducer,   0.0f);
         glEnd();
         glBegin(GL_LINES);
            glVertex2f(0.0f,  4.0f/m_font_reducer);
            glVertex2f(0.0f, -4.0f/m_font_reducer);
         glEnd();
      glPopAttrib();
   glEndList();


   glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
}


void  COpenGLtext::Draw(CString &text, bool horizontal, float angle, float scale, float line_width, bool enclose)
{
   HANDLE hThread = AfxGetThread()->m_hThread;

   if (m_mapLists.find(hThread) == m_mapLists.end())
       return;

   int* m_ascii_font = m_mapLists[hThread];

/*
   int   length         =  text.GetLength();
   char  *text_copy     =  new char[length + 1];                           // Allocate enough room for a copy of the original text plus the NULL.
   char  delimeters[]   =  "\n";
   char  *token;

   strcpy(text_copy, (char *)LPCTSTR(text));                               // Make a working copy of the original text.

   if (scale      == 0.0f)                                                 // Scale of 0.0 makes no sense.
      scale       =  1.0f;

   if (line_width == 0.0f  || scale <= 1.0f)                               // Line width of 0.0 makes no sense, and when the scale is <= 1.0
      line_width  =  1.0f;                                                 // wider lines make text hard to read.

   Text(text);

   // We want the placement of text to be separate from everything else in the scene, (we don't want to rotate or translate anything else), so
   // save off the current coordinate system and don't forget to restore it when finished placing the text.
   glPushMatrix();                                                         
   {
      if (scale != 1.0)
         glScalef(scale, scale, scale);                                          // Apply the scale factor.

      if (line_width != 1.0)
         glLineWidth(line_width);                                                // Apply the line width factor.

      if (enclose)                                                            // If requested,
      {
         float width, height;
         ComputeBoxSize(text, true, width, height);
         DrawBox();                                                           // draw a filled box for the text to fit in.
      }

      glPushMatrix();                                                         
      {
         token =  strtok(text_copy, delimeters);                              // Get the first string.
         while (token)
         {
            int   length   =  strlen(token);                                  // Determine the length of this portion of the string.
            float middle   =  (float)length  /  2.0f;                         // Find the middle of the string (in display units not characters).
            float start;

            // Calculate where the beginning of the string needs to be in order to keep the whole string centered and
            // calculate the corners of a rectangle that encompasses the text.
            if (horizontal)  
               start =  -m_font_width  *  middle   +  m_font_width   /  2.0f; 
            else
               start =  m_font_height  *  middle   -  m_font_height  /  2.0f;

            glPushMatrix();                                                   // We don't want to accumulate rotations or translations when displaying 
            {                                                                 // multiple lines of text, so save the coordinate system.
               if (angle != 0.0)
                  glRotatef(angle, 0.0f, 0.0f, 1.0f);                            // Rotate the text.

               if (m_x_to_y_ratio != 1.0)
                  glScalef(m_x_to_y_ratio, 1.0f, 1.0f);                          // Apply the x_to_y_ratio.

               float x_move_distance   =  0.0f;
               float y_move_distance   =  0.0f;
               if (horizontal)                                                   
               {
                  glTranslatef(start/m_font_reducer, 0.0f, 0.0f);             // Move to where the string needs to start so it will remain centered.
                  x_move_distance   =  m_font_width/m_font_reducer;           // Calculate position of next character.
                  y_move_distance   =  0.0f;                                  // Calculate position of next character.
               }
               else
               {
                  glTranslatef(0.0f, start/m_font_reducer, 0.0f);             // Move to where the string needs to start so it will remain centered.
                  x_move_distance   =  0.0f;                                  // Calculate position of next character.
                  y_move_distance   =  -m_font_height/m_font_reducer;         // Calculate position of next character.
               }

               for (int ii = 0; ii < length; ii++)                            // Go through the string, placing one character at a time.
               {
                  if (m_background_needed)                                    
                  {
                     glRGB(m_background_red, m_background_green, m_background_blue);   // Set background color.
                     glCallList(m_ascii_font[BACKGROUND_CELL]);               // Look up the background cell character and draw it.
                  }

                  glRGB(m_foreground_red, m_foreground_green, m_foreground_blue);   // Set foreground color.
                  glCallList(m_ascii_font[(unsigned char)(token[ii])]);       // Look up the character and draw it.

                  glTranslatef(x_move_distance, y_move_distance, 0.0f);       // Move to next character's position.
               }
            }                                                                 // We're finished displaying a line (row or column) of text, so 
            glPopMatrix();                                                    // restore previous coordinate system.

            if (horizontal)
               glTranslatef(0.0f,   -m_font_height/m_font_reducer, 0.0f);     // Move down a row.
            else
               glTranslatef(m_font_width/m_font_reducer,  0.0f, 0.0f);        // Move over a column.

            token =  strtok(NULL, delimeters);                                // Get the next string.
         }

         if (line_width != 1.0)
            glLineWidth(1.0f);                                                   // Reset the line width back to its default value.
      }
      glPopMatrix();                                                          // Go back to the original coordinate system.
   }
   glPopMatrix();                                                          // Go back to the original coordinate system.

   delete []   text_copy;                                                  // Get rid of the working copy of the text.
*/
   float width, height;
   int   subLength;                                  // Determine the length of this portion of the string.
   float middle;                         // Find the middle of the string (in display units not characters).
   float start;
   float x_move_distance;
   float y_move_distance;
   static float f1OverFontReducer = 1.0f / m_font_reducer;
   float fBackground[4][2] = {{-4.0f * f1OverFontReducer, -7.0f * f1OverFontReducer},
                              {-4.0f * f1OverFontReducer,  7.0f * f1OverFontReducer},
                              {-4.0f * f1OverFontReducer,  7.0f * f1OverFontReducer},
                              {-4.0f * f1OverFontReducer, -7.0f * f1OverFontReducer}};
   static float fFontWidthDivReducer   =  m_font_width  * f1OverFontReducer;
   static float fFontHeightDivReducer  = -m_font_height * f1OverFontReducer;
   int   ii;

   if (scale      == 0.0f)                                                 // Scale of 0.0 makes no sense.
      scale       =  1.0f;

   if (line_width == 0.0f  || scale <= 1.0f)                               // Line width of 0.0 makes no sense, and when the scale is <= 1.0
      line_width  =  1.0f;                                                 // wider lines make text hard to read.

   if (horizontal)                                                   
   {
      x_move_distance   =  fFontWidthDivReducer;      // Calculate position of next character.
      y_move_distance   =  0.0f;                                  // Calculate position of next character.
   }
   else
   {
      x_move_distance   =  0.0f;                                  // Calculate position of next character.
      y_move_distance   =  fFontHeightDivReducer;    // Calculate position of next character.
   }

   Text(text);

   // We want the placement of text to be separate from everything else in the scene, (we don't want to rotate or translate anything else), so
   // save off the current coordinate system and don't forget to restore it when finished placing the text.
   glPushMatrix();                                                         
   {
      if (scale != 1.0f)
        glScalef(scale, scale, scale);                                          // Apply the scale factor.

      if (line_width != 1.0f)
        glLineWidth(line_width);                                                // Apply the line width factor.

      if (enclose)                                                            // If requested,
      {
         ComputeBoxSize(text, true, width, height);
         DrawBox();                                                           // draw a filled box for the text to fit in.
      }

      if (angle != 0.0f)
        glRotatef(angle, 0.0f, 0.0f, 1.0f);                            // Rotate the text.

      if (m_x_to_y_ratio != 1.0f)
        glScalef(m_x_to_y_ratio, 1.0f, 1.0f);                          // Apply the x_to_y_ratio.

      int   length         =  strlen(text);
      char  *text_copy     =  new char[length + 1];                           // Allocate enough room for a copy of the original text plus the NULL.
      char  delimeters[]   =  "\n";
      char  *token;

      strcpy(text_copy, (char *)LPCTSTR(text));                          // Make a working copy of the original text.

      token =  strtok(text_copy, delimeters);                              // Get the first string.

      while (token)
      {
         subLength =  strlen(token);                                  // Determine the length of this portion of the string.
         middle    =  (float)subLength  * 0.5f;                       // Find the middle of the string (in display units not characters).

         // Calculate where the beginning of the string needs to be in order to keep the whole string centered and
         // calculate the corners of a rectangle that encompasses the text.
         if (horizontal)  
            start =  -m_font_width  *  middle   +  m_font_width   * 0.5f; 
         else
            start =  m_font_height  *  middle   -  m_font_height  * 0.5f;
 
         glPushMatrix();                                                   // We don't want to accumulate rotations or translations when displaying 
         {                                                                 // multiple lines of text, so save the coordinate system.
            if (horizontal)                                                   
            {
               glTranslatef(start * f1OverFontReducer, 0.0f, 0.0f);             // Move to where the string needs to start so it will remain centered.
            }
            else
            {
               glTranslatef(0.0f, start * f1OverFontReducer, 0.0f);        // Move to where the string needs to start so it will remain centered.
            }
 
            if (m_background_needed)                                    
            {
               fBackground[2][0] = -4.0f * f1OverFontReducer + 8.0f * subLength * f1OverFontReducer;
               fBackground[3][0] = -4.0f * f1OverFontReducer + 8.0f * subLength * f1OverFontReducer;
 
 
               glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);                  // Fill in the background of the character cell with the background color.
                  glBegin(GL_TRIANGLE_FAN);
                     glRGB(m_background_red, m_background_green, m_background_blue);   // Set background color.
                     glVertex2fv(fBackground[0]);
                     glVertex2fv(fBackground[1]);
                     glVertex2fv(fBackground[2]);
                     glVertex2fv(fBackground[3]);
                  glEnd();
               glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
            }

            glRGB(m_foreground_red, m_foreground_green, m_foreground_blue);   // Set foreground color.
 
            ii = 0;
            while (ii < subLength)                            // Go through the string, placing one character at a time.
            {
               glCallList(m_ascii_font[(unsigned char)(token[ii])]);       // Look up the character and draw it.
 
               ii++;
               if (ii != subLength)
               {
                   glTranslatef(x_move_distance, y_move_distance, 0.0f);       // Move to next character's position.
               }
            }
         }                                                                 // We're finished displaying a line (row or column) of text, so 
         glPopMatrix();                                                    // restore previous coordinate system.
 
         if (subLength != length)
         {
            token =  strtok(NULL, delimeters);                                // Get the next string.
         }
         else
         {
             token = NULL;
         }
 
         if (token)
         {
             if (horizontal)
                glTranslatef(0.0f,   fFontHeightDivReducer, 0.0f);     // Move down a row.
             else
                glTranslatef(fFontWidthDivReducer,  0.0f, 0.0f);        // Move over a column.
         }
 
      }

      delete []   text_copy;                                                  // Get rid of the working copy of the text.

      if (line_width != 1.0f)
        glLineWidth(1.0f);                                                // Apply the line width factor.
   }

   glPopMatrix();                                                          // Go back to the original coordinate system.
}


void  COpenGLtext::ComputeBoxSize(CString &text, bool horizontal, float &width, float &height)
{
/*
   float left           =  0.0f;
   float right          =  0.0f;
   float top            =  0.0f;
   float bottom         =  0.0f;
   int   length         =  text.GetLength();
   char  *text_copy     =  new char[length + 1];                        // Allocate enough room for a copy of the original text plus the NULL.
   char  delimeters[]   =  "\n";
   char  *token;

   strcpy(text_copy, (char *)LPCTSTR(text));                            // Make a working copy of the original text.

   token =  strtok(text_copy, delimeters);                              // Get the first string.
   while (token)
   {
      int   length   =  strlen(token);                                  // Determine the length of this portion of the string.
      float middle   =  (float)length  /  2.0f;                         // Find the middle of the string (in display units not characters).
      float start;

      // Calculate where the beginning of the string needs to be in order to keep the whole string centered and
      // calculate the corners of a rectangle that encompasses the text.
      if (horizontal)  
      {
         start    =  -m_font_width  *  middle   +  m_font_width   /  2.0f; 
         left     =  -m_font_width  *  middle   -  m_font_width   /  2.0f; 
         right    =  m_font_width   *  middle   +  m_font_width   /  2.0f;
         top      =  m_font_height;
         bottom   += -m_font_height;
      }
      else
      {
         start    =  m_font_height  *  middle   -  m_font_height /  2.0f;
         left     =  -m_font_width;
         right    += m_font_width;
         top      =  -m_font_height *  middle   -  m_font_height /  2.0f;
         bottom   =  m_font_height  *  middle   +  m_font_height /  2.0f;
      }
      m_min_left     =  __min(m_min_left,    left);
      m_max_right    =  __max(m_max_right,   right);
      m_min_top      =  __min(m_min_top,     top);
      m_min_bottom   =  __min(m_min_bottom,  bottom);

      token =  strtok(NULL, delimeters);                                   // Get the next string.
   }

   width    =  (m_max_right   -  m_min_left)    /  m_font_reducer;
   height   =  (m_min_top     -  m_min_bottom)  /  m_font_reducer;

   delete []   text_copy;                                                  // Get rid of the working copy of the text.
*/
   // Don't recompute if the size has already been set.
   if (m_bBoxSizeSet == true)
   {
       return;
   }

   m_min_left    =  99999.0f;
   m_max_right   =  -9999.0f;
   m_min_top     =  99999.0f;
   m_min_bottom  =  99999.0f;

   float left           =  0.0f;
   float right          =  0.0f;
   float top            =  0.0f;
   float bottom         =  0.0f;
   int   length         =  strlen(text);

   // Allocate enough room for a copy of the original text plus the NULL.
   char  *text_copy     =  new char[length + 1];
   char  delimeters[]   =  "\n";
   char  *token;

   float fHalfFontWidth = m_font_width * 0.5f;
   float fHalfFontHeight = m_font_height * 0.5f;
   float fFontWidthMid;
   float fFontHeightMid;

   int   subLength;
   float middle;
   float start;

   // Make a working copy of the original text.
   strcpy(text_copy, (char *)LPCTSTR(text));

   // Get the first string.
   token =  strtok(text_copy, delimeters);
   while (token)
   {
      subLength   =  strlen(token);                                  // Determine the length of this portion of the string.
      middle      =  (float)subLength  * 0.5f;                       // Find the middle of the string (in display units not characters).

      // Calculate where the beginning of the string needs to be in order 
      // to keep the whole string centered and calculate the corners of a 
      // rectangle that encompasses the text.
      if (horizontal)  
      {
         fFontWidthMid = m_font_width * middle;
         start    =  -fFontWidthMid   +  fHalfFontWidth; 
         left     =  -fFontWidthMid   -  fHalfFontWidth; 
         right    =   fFontWidthMid   +  fHalfFontWidth;
         top      =   m_font_height;
         bottom  +=  -m_font_height;
      }
      else
      {
         fFontHeightMid = m_font_height  *  middle;
         start    =   fFontHeightMid   -  fHalfFontHeight;
         left     =  -m_font_width;
         right   +=   m_font_width;
         top      =  -fFontHeightMid   -  fHalfFontHeight;
         bottom   =   fFontHeightMid   +  fHalfFontHeight;
      }
      m_min_left     =  __min(m_min_left,    left);
      m_max_right    =  __max(m_max_right,   right);
      m_min_top      =  __min(m_min_top,     top);
      m_min_bottom   =  __min(m_min_bottom,  bottom);

      // If the sublength does not equal the whole length, get the next string.
      // Else, token is null.
      if (subLength != length)
      {
         token =  strtok(NULL, delimeters);
      }
      else
      {
         token = NULL;
      }
   }

   width    =  (m_max_right   -  m_min_left)    /  m_font_reducer;
   height   =  (m_min_top     -  m_min_bottom)  /  m_font_reducer;

   // Get rid of the working copy of the text.
   delete []   text_copy;

   m_bBoxSizeSet = true;
}


void  COpenGLtext::DrawBox()
{
/*
   glRGB(m_box_fill_red, m_box_fill_green, m_box_fill_blue);

   glPolygonMode(GL_BACK, GL_FILL);
      glBegin(GL_POLYGON);
         glVertex2f(m_min_left/m_font_reducer,  m_min_top/m_font_reducer);
         glVertex2f(m_max_right/m_font_reducer, m_min_top/m_font_reducer);
         glVertex2f(m_max_right/m_font_reducer, m_min_bottom/m_font_reducer);
         glVertex2f(m_min_left/m_font_reducer,  m_min_bottom/m_font_reducer);
      glEnd();
   glPolygonMode(GL_BACK, GL_LINE);

   glRGB(m_box_outline_red, m_box_outline_green, m_box_outline_blue);

   glBegin(GL_POLYGON);
      glVertex2f(m_min_left/m_font_reducer,  m_min_top/m_font_reducer);
      glVertex2f(m_max_right/m_font_reducer, m_min_top/m_font_reducer);
      glVertex2f(m_max_right/m_font_reducer, m_min_bottom/m_font_reducer);
      glVertex2f(m_min_left/m_font_reducer,  m_min_bottom/m_font_reducer);
   glEnd();
*/
    float fBox[4][2] = {{m_min_left/m_font_reducer,  m_min_top/m_font_reducer},
                        {m_max_right/m_font_reducer, m_min_top/m_font_reducer},
                        {m_max_right/m_font_reducer, m_min_bottom/m_font_reducer},
                        {m_min_left/m_font_reducer,  m_min_bottom/m_font_reducer}};

   glPolygonMode(GL_BACK, GL_FILL);
      glBegin(GL_TRIANGLE_FAN);
         glRGB(m_box_fill_red, m_box_fill_green, m_box_fill_blue);
         glVertex2fv(fBox[0]);
         glVertex2fv(fBox[1]);
         glVertex2fv(fBox[2]);
         glVertex2fv(fBox[3]);
      glEnd();
   glPolygonMode(GL_BACK, GL_LINE);


   glBegin(GL_LINE_STRIP);
         glRGB(m_box_outline_red, m_box_outline_green, m_box_outline_blue);
         glVertex2fv(fBox[0]);
         glVertex2fv(fBox[1]);
         glVertex2fv(fBox[2]);
         glVertex2fv(fBox[3]);
         glVertex2fv(fBox[0]);
   glEnd();
}


void  COpenGLtext::SetBackgroundColor(bool background_needed, int red, int green, int blue)
{
   m_background_needed  =  background_needed;
   m_background_red     =  red;
   m_background_green   =  green;
   m_background_blue    =  blue;
}


void  COpenGLtext::SetForegroundColor(int red, int green, int blue)
{
   m_foreground_red     =  red;
   m_foreground_green   =  green;
   m_foreground_blue    =  blue;
}

void  COpenGLtext::SetXtoYratio(float ratio)
{
   m_x_to_y_ratio =  ratio;
}

void COpenGLtext::Cleanup()
{
   HANDLE hThread = AfxGetThread()->m_hThread;

   if (m_mapLists.find(hThread) == m_mapLists.end())
       return;

   int* m_ascii_font = m_mapLists[hThread];

   for (int ii = 0; ii < GL_DISP_LIST_SIZE; ii++)
   {
      if (m_ascii_font[ii])
         glDeleteLists(m_ascii_font[ii], 1);
   }

   delete [] m_mapLists[hThread];

   m_mapLists[hThread] = NULL;
}

void  COpenGLtext::SetBoxOutlineColor(int red, int green, int blue)
{
   m_box_outline_red    =  red;
   m_box_outline_green  =  green;
   m_box_outline_blue   =  blue;
}

void  COpenGLtext::SetBoxFillColor(int red, int green, int blue)
{
   m_box_fill_red    =  red;
   m_box_fill_green  =  green;
   m_box_fill_blue   =  blue;
}

//////////////////////////////////////////////////////////////////////
// Accessors
//////////////////////////////////////////////////////////////////////

CString COpenGLtext::Text()
{
    return m_strText;
}

//////////////////////////////////////////////////////////////////////
// Mutators
//////////////////////////////////////////////////////////////////////

void COpenGLtext::Text(const CString& rstrText)
{
    if (m_strText != rstrText)
    {
        m_strText       = rstrText;
        m_bBoxSizeSet   = false;

//        m_listLinesToDraw.clear();
    }
}
