/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : OpenGLCircle.h
//
// Date             : 04 August 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.1 $
//
// Description      : OpenGLCircle.h contains the definition of a class 
//                    for drawing a circle using OpenGL.  Since OpenGL 
//                    does not have circle primitive, this class uses 
//                    the new vertex array funcitonality to create a 
//                    circle with as many vertices as the user wants in 
//                    the xy plane.  The user of this class is 
//                    responsible for positioning the circle in the 
//                    correct position and scaling to get the radius of 
//                    the circle correct.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : OpenGL.
//
// Components Used  : OpenGL vertex arrays, math functions.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3, 4, or 5
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: openglcircle.h $                                                                   //
// Revision 1.1  1999/10/11 20:00:28  billyb                                                                   //
// Initial Revision                                                                   //
/////////////////////////////////////////////////////////////////////////////
#if !defined(_OPENGLCIRCLE_H_)
#define _OPENGLCIRCLE_H_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#ifdef CORE
#define DLLAPI __declspec( dllexport )
#else
#define DLLAPI __declspec( dllimport )
#endif


#include <gl\gl.h>

class DLLAPI COpenGLCircle  
{
protected:
    // Pointer for array of geometry data for the circle in the xy plane.
    GLfloat*                m_vertices;

    // The type of data in m_vertices--points, line_loop, line_strip.
    GLenum                  m_primitive;

    // The number of vertices in m_vertices.
    unsigned long int       m_ulArraySize;

    // Computes the geometry data for a unit circle in the xy plane.
    void InitializeArray();    

public:
	explicit COpenGLCircle();
	virtual ~COpenGLCircle();

    // Copy constructor
    COpenGLCircle(const COpenGLCircle& rOGLCircle);

    // Assignment overload
    COpenGLCircle& operator=(const COpenGLCircle& rOGLCircle);
    
    // Equals overload
    bool operator==(const COpenGLCircle& rOGLCircle);

    // Draws the entire circle.
    void Draw();

    // Draws an arc from start to end where start is less than end
    // and both are less than 360 degrees.
    void DrawArc(const double dStartAngle, const double dEndAngle);

    // Accessors
    unsigned long int ArraySize();
    GLenum Primitive();

    // Mutators
    void ArraySize(const unsigned long int ulArraySize);
    void Primitive(const GLenum primitive);
};

#endif // !defined(_OPENGLCIRCLE_H_)
