#if !defined(_LINKPAGE_H_)
#define _LINKPAGE_H_

#ifdef CORE
#define DLLAPI __declspec( dllexport )
#else
#define DLLAPI __declspec( dllimport )
#endif

#include "resource.h"

#include "..\core\BasePage.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// LinkPage.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CLinkPage dialog

class DLLAPI CLinkPage : public CBasePage
{
private:
    _FSI_STL::list<LV_ITEM*> m_listNameDirectory;
    _FSI_STL::list<LV_ITEM*> m_listNameFile;
    _FSI_STL::string         m_stlStrWorkingDirectory;
    _FSI_STL::string         m_stlStrComponentName;
    _FSI_STL::string         m_stlStrSubComponentName;

    void FillListCtrl(const CString& rstrType);
    void FillComboCtrl(LPSHELLFOLDER lpsf, const CString& rstrNextLevel, 
                       const CString& rstrPath, 
                       unsigned long& ulDirectoryEntry,
                       unsigned char ucIndent);

// Construction
public:
	CLinkPage();
	~CLinkPage();
    static CBasePage* CreateObject();

// Dialog Data
	//{{AFX_DATA(CLinkPage)
	enum { IDD = IDD_CORE_PAGE_LINK };
	CComboBox	m_ctrlFileComponent;
	CString	    m_strFileName;
	CComboBoxEx	m_ctrlFilePath;
	CListCtrl	m_ctrlFileList;
	CComboBox	m_ctrlFileTypesCombo;
	CString	m_strFileCurrent;
	//}}AFX_DATA

// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CLinkPage)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CLinkPage)
	virtual BOOL OnInitDialog();
    virtual BOOL PreTranslateMessage(MSG* pMsg);
	afx_msg void OnSelchangeFileTypesCombo();
	afx_msg void OnClickFileList(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnDblclkFileList(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnSelchangeFileDirectories();
	afx_msg void OnSelchangeFileComponent();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

    virtual void SetProperties(void* pWidget);
    virtual void UpdateProperties(void* pWidget);
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(_LINKPAGE_H_)
