/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : LinkPage.cpp
//
// Date             : 14 November 1998
//
// Engineer         : Billy Baker
//
// Revision         :
//
// Description      : LinkPage.cpp is the implementation file for the 
//                    CLinkPaqe class.  CLinkPage is derived from 
//                    CBasePage and is used as the input mechanism for 
//                    entering a path to a file.  The common file 
//                    dialog resource definition was added to the 
//                    resource file for this library.  Then, code was 
//                    added to handle the file and directory selection. 
//                    Using an example by Nancy Cluts (MFCENUM) from the MSDN 
//                    library, I added the same look as the common file 
//                    dialog of files with icons.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : None.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        Win32 implementation with SHGetFileInfo.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3
//                                          Microsoft Windows NT 5.0
//
//                    Compiler(s) - Visual C++ 5.0 with VisC++ service pack 3
//                                  Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
#include "stdafx.h"
#include "LinkPage.h"

#include "widget.h"
#include "componentinterface.h"

#include <algorithm>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CLinkPage property page

/////////////////////////////////////////////////////////////////////////////
//
// CLinkPage::CLinkPage()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 14 November 1998
//
// Engineer         : Billy Baker
//
// Description      : Default constructor that sets the name of the 
//                    page to "Link" and the current working directory 
//                    to blank.
//
/////////////////////////////////////////////////////////////////////////////
CLinkPage::CLinkPage() : CBasePage(CLinkPage::IDD)
{
	//{{AFX_DATA_INIT(CLinkPage)
	m_strFileCurrent = _T("");
	//}}AFX_DATA_INIT
    m_stlStrPageName = _FSI_STL::string("Link");
    m_stlStrWorkingDirectory = _FSI_STL::string("");
}

/////////////////////////////////////////////////////////////////////////////
//
// CLinkPage::~CLinkPage()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 14 November 1998
//
// Engineer         : Billy Baker
//
// Description      : Default destructor that frees the memory used to 
//                    store the list item structures and the memory 
//                    used for the text of the item.
//
/////////////////////////////////////////////////////////////////////////////
CLinkPage::~CLinkPage()
{
    _FSI_STL::list<LV_ITEM*>::iterator lIt = m_listNameDirectory.begin();
    for (; lIt != m_listNameDirectory.end(); lIt++)
    {
        delete (*lIt)->pszText;
        delete (*lIt);
    }
    m_listNameDirectory.clear();

    lIt = m_listNameFile.begin();
    for (; lIt != m_listNameFile.end(); lIt++)
    {
        delete (*lIt)->pszText;
        delete (*lIt);
    }
    m_listNameFile.clear();
}

void CLinkPage::DoDataExchange(CDataExchange* pDX)
{
	CBasePage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CLinkPage)
	DDX_Control(pDX, IDC_FILE_COMPONENT, m_ctrlFileComponent);
	DDX_Text(pDX, IDC_FILE_NAME, m_strFileName);
	DDX_Control(pDX, IDC_FILE_DIRECTORIES, m_ctrlFilePath);
	DDX_Control(pDX, IDC_FILE_LIST, m_ctrlFileList);
	DDX_Control(pDX, IDC_FILE_TYPES_COMBO, m_ctrlFileTypesCombo);
	DDX_Text(pDX, IDC_FILE_CURRENT, m_strFileCurrent);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CLinkPage, CBasePage)
	//{{AFX_MSG_MAP(CLinkPage)
	ON_CBN_SELCHANGE(IDC_FILE_TYPES_COMBO, OnSelchangeFileTypesCombo)
	ON_NOTIFY(NM_CLICK, IDC_FILE_LIST, OnClickFileList)
	ON_WM_ERASEBKGND()
	ON_NOTIFY(NM_DBLCLK, IDC_FILE_LIST, OnDblclkFileList)
	ON_CBN_SELCHANGE(IDC_FILE_DIRECTORIES, OnSelchangeFileDirectories)
	ON_CBN_SELCHANGE(IDC_FILE_COMPONENT, OnSelchangeFileComponent)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CLinkPage message handlers
CBasePage* CLinkPage::CreateObject()
{
    return new CLinkPage;
}

void CLinkPage::SetProperties(void* pWidget)
{
    char cCurrentPath[MAX_PATH];
    GetCurrentDirectory(MAX_PATH,cCurrentPath);
    m_stlStrWorkingDirectory = _FSI_STL::string(cCurrentPath);

    CXMLWidget* pXMLWidget = ((CWidget*)pWidget)->XMLWidget();
    if (pXMLWidget != NULL)
    {
        CXMLElement* pXMLElement = NULL;
        POSITION pos = NULL;
        if (pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("LINK")) == true)
        {
            m_strFileCurrent = (pXMLElement->ElementValue().c_str());
            m_strFileName = (pXMLElement->ElementValue().c_str());

            STRING2STRING_MAP::iterator s2sIt = NULL;
            if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("COMPONENT")) == true)
            {
                m_stlStrComponentName = (*s2sIt).second;
            }

            if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("SUBCOMPONENT")) == true)
            {
                m_stlStrSubComponentName = (*s2sIt).second;
            }
        }
    }
}

void CLinkPage::UpdateProperties(void* pWidget)
{
    CXMLWidget* pXMLWidget = ((CWidget*)pWidget)->XMLWidget();
    if (pXMLWidget != NULL && GetSafeHwnd() != NULL)
    {
        UpdateData(TRUE);
        CXMLElement* pXMLElement = NULL;
        POSITION pos = NULL;
        if (pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("LINK")) == true)
        {
            pXMLElement->AddElementValue(_FSI_STL::string((LPCTSTR)m_strFileName));
            STRING2STRING_MAP::iterator s2sIt = NULL;
            CString strValue;
            if (m_ctrlFileComponent.GetCurSel() != CB_ERR)
            {
                m_ctrlFileComponent.GetLBText(m_ctrlFileComponent.GetCurSel(), 
                                              strValue);
            }

            if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("COMPONENT")) == true)
            {
                CString strComponent(strValue);
                if (strComponent.Find("-") > -1)
                {
                    strComponent = strComponent.Left(strComponent.Find("-") - 1);
                }

                (*s2sIt).second = _FSI_STL::string((LPCTSTR)strComponent);
            }

            if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("SUBCOMPONENT")) == true)
            {
                CString strSubComponent(strValue);
                if (strSubComponent.Find("-") > -1)
                {
                    strSubComponent = strSubComponent.Mid(strSubComponent.Find("-") + 2);
                }

                (*s2sIt).second = _FSI_STL::string((LPCTSTR)strSubComponent);
            }
        }
    }
}

BOOL CLinkPage::OnInitDialog() 
{
	CBasePage::OnInitDialog();

    // Get the system image list and attach it to the list and comboboxex 
    // controls.
    HIMAGELIST himlSmall;
    SHFILEINFO sfi;
    himlSmall = (HIMAGELIST)::SHGetFileInfo(m_stlStrWorkingDirectory.c_str(),
                                         0, &sfi,
                                         sizeof(SHFILEINFO),
                                         SHGFI_SYSICONINDEX | SHGFI_SMALLICON);

    // ComboBoxEx control
    m_ctrlFilePath.SetImageList(CImageList::FromHandle(himlSmall));

    // List control
    if (himlSmall)
    {
        ::SendMessage(m_ctrlFileList.m_hWnd, LVM_SETIMAGELIST, 
                      (WPARAM)LVSIL_SMALL, (LPARAM)himlSmall);
    }


    // Fill the combo box of possible file types--*.fml and *.*.
    m_ctrlFileTypesCombo.ResetContent();
    m_ctrlFileTypesCombo.AddString("FSI Markup Language Files (*.fml)");
    m_ctrlFileTypesCombo.AddString("Bitmap (*.bmp)");
    m_ctrlFileTypesCombo.AddString("All Files (*.*)");
    m_ctrlFileTypesCombo.SetCurSel(0);

    // Fill the component selection combobox and set the working 
    // directory.
    _FSI_STL::list<void*>::iterator lIt = m_listComponentInterface.begin();
    m_ctrlFileComponent.ResetContent();
    m_ctrlFileComponent.AddString("NONE");
    bool bFound = false;
    for (; lIt != m_listComponentInterface.end(); lIt++)
    {
        CComponentInterface* pCI = (CComponentInterface*)(*lIt);
        if (pCI->OnComponentBar() == true)
        {
            STRING2STRING_MAP* pMap = pCI->Directories();
            STRING2STRING_MAP::iterator mIt = pMap->begin();
            for (; mIt != pMap->end(); mIt++)
            {
                CString strComponentAlias(pCI->ComponentName().c_str());
                strComponentAlias += " - " + CString((*mIt).first.c_str());
                m_ctrlFileComponent.AddString(strComponentAlias);
                if (pCI->ComponentName() == m_stlStrComponentName &&
                    (*mIt).first.c_str() == m_stlStrSubComponentName)
                {
                    m_stlStrWorkingDirectory = (*mIt).second;
                    bFound = true;
                }
            }
        }
    }
    if (bFound == true)
    {
        CString strComponentAlias(m_stlStrComponentName.c_str());
        strComponentAlias += " - " + CString(m_stlStrSubComponentName.c_str());
        m_ctrlFileComponent.SelectString(-1,strComponentAlias);
    }
    else
    {
        m_ctrlFileComponent.SelectString(-1,"NONE");
    }

    // Fill the controls with files and directories.
    FillListCtrl("*.fml");
    unsigned long ulDirectoryEntry = 0;
    FillComboCtrl(NULL, "My Computer", m_stlStrWorkingDirectory.c_str(), 
                  ulDirectoryEntry, 0);
    return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
//
// void CLinkPage::OnSelchangeFileTypesCombo()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 14 November 1998
//
// Engineer         : Billy Baker
//
// Description      : When the file types combobox is changed, the new 
//                    file filter is determined and then passed to 
//                    FillListCtrl to refill the list control with the 
//                    files that meet the filter's criteria.
//
/////////////////////////////////////////////////////////////////////////////
void CLinkPage::OnSelchangeFileTypesCombo() 
{
    UpdateData(TRUE);

    // Get the selected string.
    CString strType;
    if (m_ctrlFileTypesCombo.GetCurSel() != CB_ERR)
    {
	    m_ctrlFileTypesCombo.GetLBText(m_ctrlFileTypesCombo.GetCurSel(), 
                                       strType);
    }

    // Parse the string for the information between the paran's.  "(*.*)" would
    // be "*.*".
    if (strType.Find("(") > -1)
    {
        strType = strType.Mid(strType.Find("(") + 1);
        if (strType.Find(")") > -1)
        {
            strType = strType.Left(strType.Find(")"));
        }
    }

    // Refill the list control.
    FillListCtrl(strType);
}

/////////////////////////////////////////////////////////////////////////////
//
// void CLinkPage::OnClickFileList()
//
// Inputs           : NMHDR* pNMHDR - a pointer to a notification 
//                    message                 header structure.  
//                    LPRESULT* pRestult - a result value.  Not used.
//
// Return Values    : None.
//
// Date             : 14 November 1998
//
// Engineer         : Billy Baker
//
// Description      : When the user single clicks on a file, then the 
//                    edit control is upadated with the new string.
//
/////////////////////////////////////////////////////////////////////////////
void CLinkPage::OnClickFileList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
    NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;

    if (pNMListView->iItem < 0)
        return;

    UpdateData(TRUE);
    CString strSelection = m_ctrlFileList.GetItemText(pNMListView->iItem,0);
    if (m_ctrlFileList.GetItemData(pNMListView->iItem) == 2)
    {
        m_strFileName = strSelection;
    }

    UpdateData(FALSE);
	
	*pResult = 0;
}

/////////////////////////////////////////////////////////////////////////////
//
// BOOL CLinkPage::OnEraseBkgnd()
//
// Inputs           : CDC* pDC - a pointer to a device context.
//
// Return Values    : Success or failure of the background erase.
//
// Date             : 14 November 1998
//
// Engineer         : Billy Baker
//
// Description      : OnEraseBkgnd is overridden so that the property 
//                    page will not blank the property page and cover 
//                    up the list control.  The cover up only happened 
//                    in a few rare instances.
//
/////////////////////////////////////////////////////////////////////////////
BOOL CLinkPage::OnEraseBkgnd(CDC* pDC) 
{
	// TODO: Add your message handler code here and/or call default
	
	return TRUE; //CBasePage::OnEraseBkgnd(pDC);
}

void CLinkPage::OnDblclkFileList(NMHDR* pNMHDR, LRESULT* pResult) 
{
    NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;

    // Make sure that the click was on an iterm
    if (pNMListView->iItem < 0)
        return;

    // Change the current working directory as stored here.
    UpdateData(TRUE);
    CString strSelection = m_ctrlFileList.GetItemText(pNMListView->iItem,0);
    if (m_ctrlFileList.GetItemData(pNMListView->iItem) == 1)
    {
        CString strType;
        if (m_ctrlFileTypesCombo.GetCurSel() != CB_ERR)
        {
	        m_ctrlFileTypesCombo.GetLBText(m_ctrlFileTypesCombo.GetCurSel(), 
                                           strType);
        }

        if (strType.Find("(") > -1)
        {
            strType = strType.Mid(strType.Find("(") + 1);
            if (strType.Find(")") > -1)
            {
                strType = strType.Left(strType.Find(")"));
                if (strSelection == "..")
                {
                    CString strDirectory(m_stlStrWorkingDirectory.c_str());
                    long int lSlashPos = strDirectory.ReverseFind('\\');
                    if ( lSlashPos > -1)
                    {
                        strDirectory = strDirectory.Left(lSlashPos);
                        m_stlStrWorkingDirectory = 
                                            _FSI_STL::string((LPCTSTR)strDirectory);
                    }
                }
                else
                {
                    m_stlStrWorkingDirectory += "\\" + strSelection;
                }
            }
        }

        CString strPath(m_stlStrWorkingDirectory.c_str());
        strPath.MakeUpper();
        CString strAlias;
        bool bDone = false;
        _FSI_STL::list<void*>::iterator lIt = m_listComponentInterface.begin();
        for (; lIt != m_listComponentInterface.end() && bDone == false; lIt++)
        {
            CComponentInterface* pCI = (CComponentInterface*)(*lIt);
            if(pCI->OnComponentBar() == true)
            {
                STRING2STRING_MAP::iterator mIt = pCI->Directories()->begin();
                for (; mIt != pCI->Directories()->end() && bDone == false; 
                       mIt++)
                {
                    CString strPathAlias((*mIt).second.c_str());
                    strPathAlias.MakeUpper();
                    if (strPathAlias == strPath)
                    {
                        strAlias.Format("%s - %s",pCI->ComponentName().c_str(),
                                                  (*mIt).first.c_str());
                        bDone = true;
                    }

                }
            }
        }

        if (bDone == true)
        {
            m_ctrlFileComponent.SelectString(-1,strAlias);
        }
        else
        {
            m_ctrlFileComponent.SelectString(-1,"NONE");
        }


        FillListCtrl(strType);
        unsigned long ulDirectoryEntry = 0;
        FillComboCtrl(NULL, "My Computer", m_stlStrWorkingDirectory.c_str(),
                      ulDirectoryEntry, 0);
    }

    UpdateData(FALSE);
	
	*pResult = 0;
}

void CLinkPage::FillListCtrl(const CString& rstrType)
{
    // Clear the list of files and directories
    m_ctrlFileList.DeleteAllItems();

    // Clear the list of their pointers including the dynamic memory
    // for the text strings.
    _FSI_STL::list<LV_ITEM*>::iterator lIt = m_listNameDirectory.begin();
    for (; lIt != m_listNameDirectory.end(); lIt++)
    {
        delete (*lIt)->pszText;
        delete (*lIt);
    }
    m_listNameDirectory.clear();

    lIt = m_listNameFile.begin();
    for (; lIt != m_listNameFile.end(); lIt++)
    {
        delete (*lIt)->pszText;
        delete (*lIt);
    }
    m_listNameFile.clear();

    // Get all of the subdirectories
    long int lEntryNumber = 0;
    CString strFiles = m_stlStrWorkingDirectory.c_str();
    strFiles += "\\*.*";
    WIN32_FIND_DATA wfd;
    HANDLE hFiles = FindFirstFile((LPCTSTR)strFiles, &wfd);
    if (hFiles != INVALID_HANDLE_VALUE)
    {
        // First subdirectory. Skip "." and "..".
        // Much of the code here is inspired by MFCENUM by Nancy Cluts
        // at Microsoft.  The source is available from 
        // www.microsoft.com/win32dev and was in her book Programming the
        // Windows 95 User Interface which is no longer in print but available
        // in the MSDN library.  
        CString strFile(wfd.cFileName);
        LV_ITEM* pItem = NULL;
        SHFILEINFO sfi;
        CString strFullName;
        if ((wfd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) && 
            !(wfd.dwFileAttributes & FILE_ATTRIBUTE_HIDDEN) && 
            !(wfd.dwFileAttributes & FILE_ATTRIBUTE_SYSTEM) && 
            !(wfd.dwFileAttributes & FILE_ATTRIBUTE_TEMPORARY) && 
            strFile != "." && strFile != "..")
        {
            pItem = new LV_ITEM;
            pItem->mask = LVIF_TEXT | LVIF_IMAGE | LVIF_PARAM;
            pItem->iItem = lEntryNumber++;
            pItem->iSubItem = 0;

            pItem->pszText = new char[strlen(wfd.cFileName) + 1];
            strcpy(pItem->pszText,wfd.cFileName);
            pItem->cchTextMax = strlen(pItem->pszText);

            // Use the shell functions to get the index of the icon
            // for a folder.
            strFullName = CString(m_stlStrWorkingDirectory.c_str()) + "\\" + 
                          strFile;
            SHGetFileInfo((LPCTSTR)strFullName, 0, &sfi, sizeof(SHFILEINFO), 
                          SHGFI_SYSICONINDEX | SHGFI_SMALLICON);
            pItem->iImage = sfi.iIcon;
            pItem->lParam = 1;
            m_listNameDirectory.push_back(pItem);
        }

        // The rest of the subdirectories.
        while (FindNextFile(hFiles, &wfd) != FALSE)
        {
            strFile = wfd.cFileName;
            if ((wfd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) && 
                !(wfd.dwFileAttributes & FILE_ATTRIBUTE_HIDDEN) && 
                !(wfd.dwFileAttributes & FILE_ATTRIBUTE_SYSTEM) && 
                !(wfd.dwFileAttributes & FILE_ATTRIBUTE_TEMPORARY) && 
                strFile != "." && strFile != "..")
            {
                pItem = new LV_ITEM;
                pItem->mask = LVIF_TEXT | LVIF_IMAGE | LVIF_PARAM;
                pItem->iItem = lEntryNumber++;
                pItem->iSubItem = 0;

                pItem->pszText = new char[strlen(wfd.cFileName) + 1];
                strcpy(pItem->pszText,wfd.cFileName);
                pItem->cchTextMax = strlen(pItem->pszText);

                // Use the shell functions to get the index of the icon
                // for a folder.
                strFullName = CString(m_stlStrWorkingDirectory.c_str()) + "\\" + 
                              strFile;
                SHGetFileInfo((LPCTSTR)strFullName, 0, &sfi, sizeof(SHFILEINFO), 
                              SHGFI_SYSICONINDEX | SHGFI_SMALLICON);
                pItem->iImage = sfi.iIcon;
                pItem->lParam = 1;
                m_listNameDirectory.push_back(pItem);
            }
        }
    }
    FindClose(hFiles);

    // Get all of the files that match the filter that was passed.  
    // Directories are excluded.
    strFiles = CString(m_stlStrWorkingDirectory.c_str()) + "\\" + rstrType;
    hFiles = FindFirstFile((LPCTSTR)strFiles, &wfd);
    if (hFiles != INVALID_HANDLE_VALUE)
    {
        LV_ITEM* pItem = NULL;
        SHFILEINFO sfi;
        CString strFullName;
        if (!(wfd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) && 
            !(wfd.dwFileAttributes & FILE_ATTRIBUTE_HIDDEN) && 
            !(wfd.dwFileAttributes & FILE_ATTRIBUTE_SYSTEM) && 
            !(wfd.dwFileAttributes & FILE_ATTRIBUTE_TEMPORARY))
        {
            pItem = new LV_ITEM;
            pItem->mask = LVIF_TEXT | LVIF_IMAGE | LVIF_PARAM;
            pItem->iItem = lEntryNumber++;
            pItem->iSubItem = 0;

            pItem->pszText = new char[strlen(wfd.cFileName) + 1];
            strcpy(pItem->pszText,wfd.cFileName);
            pItem->cchTextMax = strlen(pItem->pszText);

            // Use the shell functions to get the index of the icon
            // for a folder.
            strFullName = CString(m_stlStrWorkingDirectory.c_str()) + "\\" + 
                          wfd.cFileName;
            SHGetFileInfo((LPCTSTR)strFullName, 0, &sfi, sizeof(SHFILEINFO), 
                          SHGFI_SYSICONINDEX | SHGFI_SMALLICON);
            pItem->iImage = sfi.iIcon;
            pItem->lParam = 2;
            m_listNameFile.push_back(pItem);
        }

        while (FindNextFile(hFiles, &wfd) != FALSE)
        {
            if (!(wfd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) && 
                !(wfd.dwFileAttributes & FILE_ATTRIBUTE_HIDDEN) && 
                !(wfd.dwFileAttributes & FILE_ATTRIBUTE_SYSTEM) && 
                !(wfd.dwFileAttributes & FILE_ATTRIBUTE_TEMPORARY))
            {
                pItem = new LV_ITEM;
                pItem->mask = LVIF_TEXT | LVIF_IMAGE | LVIF_PARAM;
                pItem->iItem = lEntryNumber++;
                pItem->iSubItem = 0;

                pItem->pszText = new char[strlen(wfd.cFileName) + 1];
                strcpy(pItem->pszText,wfd.cFileName);
                pItem->cchTextMax = strlen(pItem->pszText);

                // Use the shell functions to get the index of the icon
                // for a folder.
                strFullName = CString(m_stlStrWorkingDirectory.c_str()) + "\\" + 
                              wfd.cFileName;
                SHGetFileInfo((LPCTSTR)strFullName, 0, &sfi, sizeof(SHFILEINFO), 
                              SHGFI_SYSICONINDEX | SHGFI_SMALLICON);
                pItem->iImage = sfi.iIcon;
                pItem->lParam = 2;
                m_listNameFile.push_back(pItem);
            }
        }
    }
    FindClose(hFiles);

    // Fill the list control.
    lIt = m_listNameDirectory.begin();
    for(; lIt != m_listNameDirectory.end(); lIt++)
    {
        m_ctrlFileList.InsertItem((*lIt));
    }

    lIt = m_listNameFile.begin();
    for(; lIt != m_listNameFile.end(); lIt++)
    {
        m_ctrlFileList.InsertItem((*lIt));
    }
}

void CLinkPage::FillComboCtrl(LPSHELLFOLDER lpsf, const CString& rstrNextLevel, 
                              const CString& rstrPath, 
                              unsigned long& ulDirectoryEntry,
                              unsigned char ucIndent)
{
    LPSHELLFOLDER lpsfSub1 = NULL;
    COMBOBOXEXITEM cbei;
    LPENUMIDLIST lpe = NULL;
    LPITEMIDLIST lpi = NULL;
    ULONG ulFetched;
    char cDir[MAX_PATH];
    HRESULT hr = S_OK;
    bool bTop = false;

    if (lpsf == NULL)
    {
        // Get the desktop folder;
        bTop = true;
        m_ctrlFilePath.SetRedraw(FALSE);
        hr = SHGetDesktopFolder(&lpsf);
    }

    if (SUCCEEDED(hr))
    {
        // Clear the combo box.
        CComboBox* pComboBox = m_ctrlFilePath.GetComboBoxCtrl();
        if (pComboBox != NULL && bTop == true)
        {
            pComboBox->ResetContent();
        }

        hr = lpsf->EnumObjects(m_hWnd, SHCONTF_FOLDERS | SHCONTF_NONFOLDERS, 
                               &lpe);

        if (SUCCEEDED(hr))
        {
            SHFILEINFO sfi;
            while (S_OK == lpe->Next(1, &lpi, &ulFetched))
            {
                ULONG ulAttrs = SFGAO_HASSUBFOLDER | SFGAO_FOLDER;
                lpsf->GetAttributesOf(1, (const struct _ITEMIDLIST **)&lpi, 
                                      &ulAttrs);

                if (ulAttrs & (SFGAO_HASSUBFOLDER | SFGAO_FOLDER))
                {
                    if (ulAttrs & SFGAO_FOLDER)
                    {
                        cbei.mask = CBEIF_TEXT | CBEIF_IMAGE | 
                                    CBEIF_SELECTEDIMAGE | CBEIF_INDENT;

                        cbei.iItem = ulDirectoryEntry;

                        SHGetFileInfo((LPCSTR)lpi, 0, &sfi, sizeof(SHFILEINFO), 
                                      SHGFI_PIDL | SHGFI_SYSICONINDEX | 
                                      SHGFI_SMALLICON);
                        cbei.iImage = sfi.iIcon;

                        SHGetFileInfo((LPCSTR)lpi, 0, &sfi, sizeof(SHFILEINFO), 
                                      SHGFI_PIDL | SHGFI_SYSICONINDEX | 
                                      SHGFI_SMALLICON | SHGFI_OPENICON);
                        cbei.iSelectedImage = sfi.iIcon;

                        STRRET strret;
                        lpsf->GetDisplayNameOf(lpi,SHGDN_NORMAL, &strret);

                        switch (strret.uType)
                        {
                        case STRRET_WSTR:
                            {
                                WideCharToMultiByte(CP_ACP, 0, strret.pOleStr,
                                                    -1, cDir, MAX_PATH, NULL, NULL);
                            }
                            break;
                        case STRRET_OFFSET:
                            {
                                strcpy(cDir, (LPSTR)(lpi+strret.uOffset));\
                            }
                            break;
                        case STRRET_CSTR:
                            {
                                strcpy(cDir, (LPSTR)strret.cStr);
                            }
                            break;
                        };
                        cbei.pszText = cDir;
                        cbei.cchTextMax = MAX_PATH;
                        cbei.iIndent = ucIndent;

                        if ((bTop == false) && (strstr(cDir,":") != NULL))
                        {
                            m_ctrlFilePath.InsertItem(&cbei);
                            ulDirectoryEntry++;
                        }

                        if (bTop == true)
                        {
                            CString strNextLevel;
                            CString strNewPath;
                            long int lSlashPos = rstrPath.Find("\\");

                            if (lSlashPos > -1)
                            {
                                strNextLevel = rstrPath.Left(lSlashPos);
                                strNewPath = rstrPath.Mid(lSlashPos+1);
                            }
                            else
                            {
                                strNextLevel = rstrPath;
                                strNewPath = "";
                            }
                            CString strUpperNextLevel(strNextLevel);
                            strUpperNextLevel.MakeUpper();
                            if (strstr(cDir,rstrNextLevel) != NULL)
                            {
                                lpsf->BindToObject(lpi, 0, IID_IShellFolder, 
                                                   (LPVOID*)&lpsfSub1);

                                FillComboCtrl(lpsfSub1, strUpperNextLevel, strNewPath, 
                                              ulDirectoryEntry, ucIndent + 1);
                            }
                        }
                        else
                        {
                            CString strNextLevel;
                            CString strNewPath;
                            long int lSlashPos = rstrPath.Find("\\");
                            if (lSlashPos > -1)
                            {
                                strNextLevel = rstrNextLevel + "\\" + 
                                               rstrPath.Left(lSlashPos);
                                strNewPath = rstrPath.Mid(lSlashPos+1);
                            }
                            else
                            {
                                strNextLevel = rstrNextLevel + "\\" + rstrPath;
                                strNewPath = "";
                            }
                            if (strstr(cDir, rstrNextLevel) != NULL)
                            {
                                long int lLoopStep = 1;
                                bool bDone = false;
                                while (bDone == false)
                                {
                                    WIN32_FIND_DATA wfd;
                                    HANDLE hFiles = FindFirstFile((LPCTSTR)strNextLevel, &wfd);
                                    if (hFiles != INVALID_HANDLE_VALUE)
                                    {
                                        cbei.mask = CBEIF_TEXT | CBEIF_IMAGE | 
                                                    CBEIF_SELECTEDIMAGE | 
                                                    CBEIF_INDENT;

                                        cbei.iItem = ulDirectoryEntry;

                                        strcpy(cDir, wfd.cFileName);
                                        cbei.pszText = cDir;
                                        cbei.cchTextMax = MAX_PATH;

                                        // Use the shell functions to get the index of the icon
                                        // for a folder.

                                        if (strNewPath == "" && bDone == false)
                                        {
                                            SHGetFileInfo((LPCTSTR)strNextLevel, 
                                                          0, &sfi, 
                                                          sizeof(SHFILEINFO), 
                                                          SHGFI_SYSICONINDEX | 
                                                          SHGFI_SMALLICON | SHGFI_OPENICON);
                                        }
                                        else
                                        {
                                            SHGetFileInfo((LPCTSTR)strNextLevel, 
                                                          0, &sfi, 
                                                          sizeof(SHFILEINFO), 
                                                          SHGFI_SYSICONINDEX | 
                                                          SHGFI_SMALLICON);
                                        }
                                        cbei.iImage = sfi.iIcon;
                                        cbei.iSelectedImage = sfi.iIcon;
                                        cbei.iIndent = ucIndent+lLoopStep;

                                        m_ctrlFilePath.InsertItem(&cbei);
                                        ulDirectoryEntry++;
                                    }
                                    FindClose(hFiles);
                                    lSlashPos = strNewPath.Find("\\");
                                    if (lSlashPos > -1)
                                    {
                                        strNextLevel = strNextLevel + "\\" +
                                                       strNewPath.Left(lSlashPos);
                                        strNewPath = strNewPath.Mid(lSlashPos+1);
                                    }
                                    else
                                    {
                                        if (strNewPath == "" && bDone == false) 
                                        {
                                            bDone = true;
                                            pComboBox->SetCurSel(ulDirectoryEntry-1);
                                        }
                                        strNextLevel = strNextLevel + "\\" +
                                                       strNewPath;
                                        strNewPath = "";
                                    }
                                    lLoopStep++;
                                }
                            }
                        }
                    }
                }

                lpi = 0;
            }
        }
        if (bTop == true)
        {
            lpsf->Release();
            m_ctrlFilePath.SetRedraw(TRUE);
            m_ctrlFilePath.Invalidate(FALSE);
            m_ctrlFilePath.UpdateWindow();
        }
    }
}

void CLinkPage::OnSelchangeFileDirectories() 
{
	// TODO: Add your control notification handler code here
    UpdateData(TRUE);
	COMBOBOXEXITEM cbei;
    CComboBox* pComboBox = m_ctrlFilePath.GetComboBoxCtrl();
    long int lDirectoryEntry = -1;
    CString strPath;
    char cDir[MAX_PATH];
    if (pComboBox != NULL)
    {
        lDirectoryEntry = pComboBox->GetCurSel();
    }

    if (lDirectoryEntry > -1)
    {
        cbei.mask = CBEIF_TEXT | CBEIF_INDENT;
        cbei.iItem = lDirectoryEntry;
        cbei.pszText = cDir;
        cbei.cchTextMax = MAX_PATH;
        m_ctrlFilePath.GetItem(&cbei);
        bool bDone = false;
        while (bDone != true)
        {
            if (strstr(cbei.pszText,":") != NULL)
            {
                CString strDrive(cbei.pszText);
                long int lSlashPos = strDrive.Find(":");
                if (lSlashPos > -1)
                {
                    strDrive = strDrive.Mid(lSlashPos-1,2);
                }
                strPath = strDrive + "\\" + strPath;
                bDone = true;
            }
            else
            {
                strPath = CString(cbei.pszText) + "\\" + strPath;
                cbei.iItem -= 1;
                m_ctrlFilePath.GetItem(&cbei);
            }
        }

        // An extra \ gets appended at the end.  Thus, we need to 
        // get rid of it.
        strPath = strPath.Left(strPath.GetLength()-1);
        m_stlStrWorkingDirectory = _FSI_STL::string((LPCTSTR)strPath);

        strPath.MakeUpper();
        CString strAlias;
        bDone = false;
        _FSI_STL::list<void*>::iterator lIt = m_listComponentInterface.begin();
        for (; lIt != m_listComponentInterface.end() && bDone == false; lIt++)
        {
            CComponentInterface* pCI = (CComponentInterface*)(*lIt);
            if(pCI->OnComponentBar() == true)
            {
                STRING2STRING_MAP::iterator mIt = pCI->Directories()->begin();
                for (; mIt != pCI->Directories()->end() && bDone == false; 
                       mIt++)
                {
                    CString strPathAlias((*mIt).second.c_str());
                    strPathAlias.MakeUpper();
                    if (strPathAlias == strPath)
                    {
                        strAlias.Format("%s - %s",pCI->ComponentName().c_str(),
                                                  (*mIt).first.c_str());
                        bDone = true;
                    }

                }
            }
        }

        if (bDone == true)
        {
            m_ctrlFileComponent.SelectString(-1,strAlias);
        }
        else
        {
            m_ctrlFileComponent.SelectString(-1,"NONE");
        }

        unsigned long ulDirectoryEntry = 0;
        CString strType;
        if (m_ctrlFileTypesCombo.GetCurSel() != CB_ERR)
        {
	        m_ctrlFileTypesCombo.GetLBText(m_ctrlFileTypesCombo.GetCurSel(), 
                                       strType);
        }

        if (strType.Find("(") > -1)
        {
            strType = strType.Mid(strType.Find("(") + 1);
            if (strType.Find(")") > -1)
            {
                strType = strType.Left(strType.Find(")"));
            }
        }
        FillListCtrl(strType);
        FillComboCtrl(NULL, "My Computer", m_stlStrWorkingDirectory.c_str(),
                      ulDirectoryEntry, 0);
    }
}

BOOL CLinkPage::PreTranslateMessage(MSG* pMsg)   
{
    // If edit control is visible in tree view control, when you send a
    // WM_KEYDOWN message to the edit control it will dismiss the edit
    // control. When the ENTER key was sent to the edit control, the
    // parent window of the tree view control is responsible for updating
    // the item's label in TVN_ENDLABELEDIT notification code.
    if (pMsg->message == WM_KEYDOWN && pMsg->wParam == VK_RETURN)      
    {
        UpdateData(TRUE);
        CString strLine(m_strFileName);
        CString strType;
        if (m_ctrlFileTypesCombo.GetCurSel())
        {
	        m_ctrlFileTypesCombo.GetLBText(m_ctrlFileTypesCombo.GetCurSel(), 
                                           strType);
        }

        if (strType.Find("(") > -1)
        {
            strType = strType.Mid(strType.Find("(") + 1);
            if (strType.Find(")") > -1)
            {
                strType = strType.Left(strType.Find(")"));
            }
        }

        if (strLine.Find(".") > -1)
        {
            if (strLine.Right(1) == "\\")
            {
                // A path with a trailing \ but somewhere there is a '.'.
                return TRUE;
            }
            else
            {
                // A path.
                if (strLine.ReverseFind('\\') > -1)
                {
                    CString strPath;
                    strPath = strLine.Left(strLine.ReverseFind('\\'));
                    m_stlStrWorkingDirectory = _FSI_STL::string(strPath);
                    strType = strLine.Mid(strLine.ReverseFind('\\') + 1);
                }
                else
                {
                    if (strLine == "..")
                    {
                        CString strDirectory(m_stlStrWorkingDirectory.c_str());
                        long int lSlashPos = strDirectory.ReverseFind('\\');
                        if ( lSlashPos > -1)
                        {
                            strDirectory = strDirectory.Left(lSlashPos);
                            m_stlStrWorkingDirectory = 
                                            _FSI_STL::string((LPCTSTR)strDirectory);
                        }
                    }
                    else
                    {
                        // But without a \.
                        strType = strLine;
                    }
                }
            }
        }
        else
        {
            if (strLine.Right(1) == "\\")
            {
                // A path with a trailing \.
                strLine = strLine.Left(strLine.GetLength() - 1);
                m_stlStrWorkingDirectory = _FSI_STL::string((LPCSTR)strLine);
            }
            else if ( strLine.Right(1) == "*" || strLine.Right(1) == "?")
            {
                // A path with wildcards.
                if (strLine.ReverseFind('\\') > -1)
                {
                    CString strPath;
                    strPath = strLine.Left(strLine.ReverseFind('\\'));
                    m_stlStrWorkingDirectory = _FSI_STL::string(strPath);
                    strType = strLine.Mid(strLine.ReverseFind('\\') + 1);
                }
                else
                {
                    // But no \.
                    strType = strLine;
                }
            }
            else
            {
                // Just a path.
                if (strLine.Find("\\") > -1)
                {
                    m_stlStrWorkingDirectory = _FSI_STL::string((LPCSTR)strLine);
                }
                else
                {
                        m_stlStrWorkingDirectory += "\\" + _FSI_STL::string((LPCSTR)strLine);
                }
            }
        }
        CString strPath(m_stlStrWorkingDirectory.c_str());
        strPath.MakeUpper();
        CString strAlias;
        bool bDone = false;
        _FSI_STL::list<void*>::iterator lIt = m_listComponentInterface.begin();
        for (; lIt != m_listComponentInterface.end() && bDone == false; lIt++)
        {
            CComponentInterface* pCI = (CComponentInterface*)(*lIt);
            if(pCI->OnComponentBar() == true)
            {
                STRING2STRING_MAP::iterator mIt = pCI->Directories()->begin();
                for (; mIt != pCI->Directories()->end() && bDone == false; 
                       mIt++)
                {
                    CString strPathAlias((*mIt).second.c_str());
                    strPathAlias.MakeUpper();
                    if (strPathAlias == strPath)
                    {
                        strAlias.Format("%s - %s",pCI->ComponentName().c_str(),
                                                  (*mIt).first.c_str());
                        bDone = true;
                    }

                }
            }
        }

        if (bDone == true)
        {
            m_ctrlFileComponent.SelectString(-1,strAlias);
        }
        else
        {
            m_ctrlFileComponent.SelectString(-1,"NONE");
        }

        FillListCtrl(strType);
        unsigned long ulDirectoryEntry = 0;
        FillComboCtrl(NULL, "My Computer", m_stlStrWorkingDirectory.c_str(),
                      ulDirectoryEntry, 0);
        return TRUE;         
    }
    // CXxxx can be a CFormView, Cdialog, or CPropertyPage class.
    return CBasePage::PreTranslateMessage(pMsg);   
}

void CLinkPage::OnSelchangeFileComponent() 
{
    UpdateData(TRUE);

    // Get the selected string.
    CString strAlias;
    if (m_ctrlFileComponent.GetCurSel() != CB_ERR)
    {
	    m_ctrlFileComponent.GetLBText(m_ctrlFileComponent.GetCurSel(), strAlias);
    }

    if (strAlias != "NONE")
    {
        m_stlStrComponentName = strAlias.Left(strAlias.Find(" "));
        m_stlStrSubComponentName = strAlias.Mid(strAlias.Find(" ") + 3);

	
        CString strPath(m_stlStrWorkingDirectory.c_str());
        strPath.MakeUpper();
        CString strAlias;
        bool bDone = false;

        _FSI_STL::list<void*>::iterator lIt = m_listComponentInterface.begin();
        for (; lIt != m_listComponentInterface.end() && bDone == false; lIt++)
        {
            CComponentInterface* pCI = (CComponentInterface*)(*lIt);
            if (pCI->ComponentName() == m_stlStrComponentName)
            {
                STRING2STRING_MAP* pMap = pCI->Directories();
                if (pMap->find(m_stlStrSubComponentName) != pMap->end())
                {
                    m_stlStrWorkingDirectory = (*pMap)[m_stlStrSubComponentName];
                }
            }
        }

        unsigned long ulDirectoryEntry = 0;
        CString strType;
        if (m_ctrlFileTypesCombo.GetCurSel() != CB_ERR)
        {
	        m_ctrlFileTypesCombo.GetLBText(m_ctrlFileTypesCombo.GetCurSel(), 
                                           strType);
        }

        if (strType.Find("(") > -1)
        {
            strType = strType.Mid(strType.Find("(") + 1);
            if (strType.Find(")") > -1)
            {
                strType = strType.Left(strType.Find(")"));
            }
        }
        FillListCtrl(strType);
        FillComboCtrl(NULL, "My Computer", m_stlStrWorkingDirectory.c_str(),
                      ulDirectoryEntry, 0);
    }
}
