#include "stdafx.h"
#include "IOActionPage.h"

#include "..\core\Widget.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CIOActionPage property page
CIOActionPage::CIOActionPage() : CBasePage(CIOActionPage::IDD)
{
	//{{AFX_DATA_INIT(CIOActionPage)
	m_strCommVariable = _T("");
	m_strElementVar = _T("");
	m_nReadMode = -1;
	m_bWrite = FALSE;
	m_lElement = 0;
	m_bEntireArray = FALSE;
	//}}AFX_DATA_INIT
    m_stlStrPageName = _FSI_STL::string("Action");
}

void CIOActionPage::DoDataExchange(CDataExchange* pDX)
{
	CBasePage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CIOActionPage)
	DDX_Control(pDX, IDC_COMMS_ACTION_VARS, m_ctrlVariableList);
	DDX_CBString(pDX, IDC_COMMS_ACTION_VARS, m_strCommVariable);
	DDX_CBString(pDX, IDC_COMMS_GRAPHICAL_ELEMENT_VARS, m_strElementVar);
	DDX_Radio(pDX, IDC_COMMS_READ_ALWAYS, m_nReadMode);
	DDX_Check(pDX, IDC_COMMS_WRITE, m_bWrite);
	DDX_Text(pDX, IDC_ARRAY_INDEX, m_lElement);
	DDX_Check(pDX, IDC_ENTIRE_ARRAY, m_bEntireArray);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CIOActionPage, CBasePage)
	//{{AFX_MSG_MAP(CIOActionPage)
	ON_BN_CLICKED(IDC_ENTIRE_ARRAY, OnEntireArray)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CIOActionPage message handlers
CBasePage* CIOActionPage::CreateObject()
{
    return new CIOActionPage;
}

void CIOActionPage::SetProperties(void* pWidget)
{
    CXMLWidget* pXMLWidget = ((CWidget*)pWidget)->XMLWidget();
    if (pXMLWidget != NULL)
    {
        CXMLElement* pXMLElement = NULL;
        POSITION pos = NULL;
		// Get all of the VARIABLES.
        if (pXMLWidget->FindElement(pXMLElement, pos,
                                    _FSI_STL::string("VARIABLE")) == true)
        {
            // Store the simulation alias name.
            m_strCommVariable = CString(pXMLElement->ElementValue().c_str());

            STRING2STRING_MAP::iterator s2sIt = NULL;
            if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("READ_MODE")) == true)
            {
                CString strValue((*s2sIt).second.c_str());
                m_nReadMode = atoi(strValue);
            }

            if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("WRITE_MODE")) == true)
            {
                CString strValue((*s2sIt).second.c_str());
                strValue.MakeUpper();
                if (strValue == "YES")
                {
                    m_bWrite = TRUE;
                }
                else
                {
                    m_bWrite = FALSE;
                }
            }

            if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("ELEMENT_VAR")) == true)
            {
                m_strElementVar = CString((*s2sIt).second.c_str());
            }
            else
            {
                m_strElementVar = "Default";
            }

            if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("ARRAY_ELEMENT")) == true)
            {
                m_lElement = atoi((*s2sIt).second.c_str());
                if (m_lElement == -1)
                {
                    m_bEntireArray = TRUE;
                }
            }
            else
            {
                m_lElement = 0;
            }
        }
    }

    if (((CWidget*)pWidget)->ParentWidget() != NULL)
    {
        m_listGraphicalElementVars = ((CWidget*)pWidget)->ParentWidget()->Vars();
    }
}

void CIOActionPage::UpdateProperties(void* pWidget)
{
    CXMLWidget* pXMLWidget = ((CWidget*)pWidget)->XMLWidget();
    if (pXMLWidget != NULL && GetSafeHwnd() != NULL)
    {
        UpdateData(TRUE);

        CXMLElement* pXMLElement = NULL;
        POSITION pos = NULL;
        if (pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("VARIABLE")) == true)
        {
            pXMLElement->AddElementValue(_FSI_STL::string((LPCTSTR)m_strCommVariable));

            STRING2STRING_MAP::iterator s2sIt = NULL;
            CString strValue;
            if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("READ_MODE")) == true)
            {
                CString strValue;
                strValue.Format("%d",m_nReadMode);
                (*s2sIt).second = _FSI_STL::string((LPCTSTR)strValue);
            }

            if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("WRITE_MODE")) == true)
            {
                if (m_bWrite == TRUE)
                {
                    (*s2sIt).second = _FSI_STL::string("YES");
                }
                else
                {
                    (*s2sIt).second = _FSI_STL::string("NO");
                }
            }

            if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("ELEMENT_VAR")) == true)
            {
                (*s2sIt).second = _FSI_STL::string((LPCTSTR)m_strElementVar);
            }

            if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("ARRAY_ELEMENT")) == true)
            {
                CString strValue;

                if (m_bEntireArray == TRUE)
                {
                    strValue = "-1";
                }
                else
                {
                    strValue.Format("%d",m_lElement);
                }

                (*s2sIt).second = _FSI_STL::string((LPCTSTR)strValue);
            }
        }
    }
}

BOOL CIOActionPage::OnInitDialog() 
{
	CBasePage::OnInitDialog();
	
	// TODO: Add extra initialization here
    CComboBox* pctrlComboBox = (CComboBox*)GetDlgItem(IDC_COMMS_GRAPHICAL_ELEMENT_VARS);
    if (pctrlComboBox != NULL)
    {
        pctrlComboBox->ResetContent();

        STRING_LIST::iterator lIt = m_listGraphicalElementVars.begin();
        for (; lIt != m_listGraphicalElementVars.end(); lIt++)
        {
            pctrlComboBox->AddString(CString((*lIt).c_str()));
        }

        pctrlComboBox->SelectString(-1, m_strElementVar);
    }

    CWnd* pWnd = GetDlgItem(IDC_ARRAY_INDEX);
    pWnd->EnableWindow(!m_bEntireArray);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}


void CIOActionPage::OnEntireArray() 
{
    UpdateData();

    CWnd* pWnd = GetDlgItem(IDC_ARRAY_INDEX);
    pWnd->EnableWindow(!m_bEntireArray);
}
