/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : IOAction.h
//
// Date             : 27 August 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.6 $
//
// Description      : IOAction.h contains the definition of the 
//                    CIOAction class.  The CIOAction class is used to 
//                    access data from a source outside of a CWidget 
//                    dervied class and to pass any changed values 
//                    along to a CWidget derived class.  A CIOAction 
//                    may have write priviledges to change the value in 
//                    the extrenal source as well as a variety of read 
//                    priviledges.  Range information can also be 
//                    associated with CIOAction derived classes.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : Core::CRange, _FSI_STL::string, Core::CVariant,
//                    Core::CXMLWidget, _FSI_STL::vector.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3, 4, or 5
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: IOAction.h $                                                                   //
// Revision 1.6  2000/03/07 07:27:11  billyb                                                                   //
// Removed unused methods.                                                                   //
// Revision 1.4  1999/09/02 20:10:31  billyb                                                                   //
// Added members for data format conversions.                                                                     //
// Removed include for FormatPage.h.                                                                   //
// Corrected Variant() mutator method signature.                                                                   //
// Revision 1.3  1999/08/30 22:16:03  billyb                                                                   //
// Added include for FormatPage.h and member variables for limiting the number of digits after the decimal.                                                                   //
// Revision 1.2  1999/08/27 21:37:01  billyb                                                                   //
// Added comments.  Added accessor and mutator methods for the variable that holds the graphical element's name for a variable.                                                                   //
/////////////////////////////////////////////////////////////////////////////
#if !defined(_IOACTION_H_)
#define _IOACTION_H_

#ifdef CORE
#define DLLAPI __declspec( dllexport )
#else
#define DLLAPI __declspec( dllimport )
#endif

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "XMLWidget.h"
#include "range.h"
#include "Action.h"
#include "Variant.h"

enum
{
    READ_ALWAYS = 0,
    READ_CHANGED = 1,
    READ_NEVER = 2,
    READ_ONCE = 3
};

class DLLAPI CIOAction : public CAction  
{
protected:
    // The name of the external variable.
    _FSI_STL::string            m_stlStrVariableToWatch;

    // The name of the variable that the CWidget derived
    // class desires.
    _FSI_STL::string            m_stlStrElementVar;

    // Points to a representation of the external variable.
    CVariant*                   m_pVariant;

    // XML data for creating a CIOAction derived class.
    CXMLWidget*                 m_pIOActionXMLWidget;

    // Whether write data to the external variable is  allowed.
    bool                        m_bCanWrite;

    // Whether the update that is about to happen is the
    // first update after a CIOAction derived class has been
    // created.
    bool                        m_bInitialRead;

    // Read mode of updating a CWidget derived class only
    // once.
    bool                        m_bReadOnce;

    // Read mode of updating a CWidget dervied class every
    // pass.
    bool                        m_bReadAlways;

    // Read mode of updating a CWidget dervied class only when
    // the variable has changed its value.
    bool                        m_bReadChanged;

    // used for read once initializers.
    bool                        m_bRead;  

    // Array element of a variable to access.
    long int                    m_lElement;

    // Whether any range evaluation should occur.
    bool                        m_bUseRange;

    // Whether to use generic range evaluation
    bool                        m_bUseGenericRange;

    // Whether to use a specific range
    bool                        m_bUseSpecificRange;

    // Points to a specific range when UseSpecificRange is true
    CRange*                     m_pRange;

    // Index in the vector of ranges to assign to m_pRange
    long int                    m_lRangeIndex;

    // Vector of all ranges.
    _FSI_STL::vector<CRange*>   m_vectRanges;

    // Number of digits after the decimal point
    unsigned char               m_ucPrecision;

    // Whether to limit the number of digits after the deimal point.
    bool                        m_bLimitFloating;

    // Name of the data format to convert to.
    _FSI_STL::string            m_stlStrFormatName;

    // Data format value for the format to which the data will be converted.
    long int                    m_lDataFormat;

    // Initial data format of the variant used by an instance of CIOAction
    long int                    m_lInitialDataFormat;

public:
	CIOAction();

    virtual void ResetProperties();

    void AddRange(CRange* pRange);
    void ReadType(unsigned long int ulReadType);

    // Accessor
    _FSI_STL::string            GraphicalElementName();
    _FSI_STL::vector<CRange*>   Ranges();
    _FSI_STL::string            Variable();
    CVariant*                   Variant();
    _FSI_STL::string            DataFormatName();
    long int                    DataFormat();
    long int                    InitialDataFormat();


    // Mutator
    void GraphicalElementName(const _FSI_STL::string& rstlStrGraphicalElementName);
    void Variable(const _FSI_STL::string& rstlStrVariable);
    void Variant(CVariant* pVariant);
    void DataFormatName(const _FSI_STL::string& rstlStrFormatName);
    void DataFormat(const long int lDataFormat);
    void InitialDataFormat(const long int lDataFormat);
};

#endif // !defined(_IOACTION_H_)
