/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : IOAction.cpp
//
// Date             : 27 August 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.9 $
//
// Description      : IOAction.cpp contains the implementation of the 
//                    CIOAction class.  The CIOAction class is used to 
//                    access data from a source outside of a CWidget 
//                    dervied class and to pass any changed values 
//                    along to a CWidget derived class.  A CIOAction 
//                    may have write priviledges to change the value in 
//                    the extrenal source as well as a variety of read 
//                    priviledges.  Range information can also be 
//                    associated with CIOAction derived classes.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : Core::CRange, _FSI_STL::string, Core::CVariant,
//                    Core::CXMLWidget, _FSI_STL::vector.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3, 4, or 5
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: IOAction.cpp $                                                    
// Revision 1.9  2000/03/07 07:28:04  billyb                                                    
// Revision 1.7.1.1  2000/03/07 07:27:45  billyb                                                    
// Removed unused methods.                                                    
// Revision 1.7  1999/11/26 18:55:33  billyb                                                    
// Added code for telling a widget about range data.  This data                                                    
// is only used for ComboWidgets.  It is assumed that the range                                                    
// data for the Combos is of the type a = x = a.                                                     
// Revision 1.6  1999/10/20 18:39:16  billyb                                                    
// Changed AddRange to reflect the changes in CWidget for                                                    
// storing all of the ranges for all of the variables that the                                                    
// widget needs.                                                    
// Revision 1.5  1999/10/14 19:22:31  billyb                                                    
// Fixed wrong conditional when setting the high range value                                                    
// in AddRange.                                                    
// Revision 1.4  1999/09/02 20:12:02  billyb                                                    
// Parsed data for performat data format conversions.                                                    
// Converted range high and low values stored in parent widget.                                                    
// Added accessors and mutators for data format data.                                                    
// Revision 1.3  1999/08/30 22:17:35  billyb                                                    
// Added code for limiting the number of digits after the decimal in range data used for a high and low value.  Made sure precision data was stored in the XML file.                                                    
// Revision 1.2  1999/08/27 21:36:59  billyb                               
// Added comments.  Added accessor and mutator methods for the variable 
// that holds the graphical element's name for a variable.                                                                   //
/////////////////////////////////////////////////////////////////////////////
#include "stdafx.h"
#include "IOAction.h"
#include "Widget.h"

#include "DataConversion.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CIOAction::CIOAction() :
    m_stlStrVariableToWatch("Unknown"),
    m_stlStrElementVar("Default"),
    m_pVariant(NULL),
    m_pIOActionXMLWidget(NULL),
    m_bCanWrite(true),
    m_bInitialRead(true),
    m_bReadOnce(false),
    m_bReadAlways(false),
    m_bReadChanged(true),
    m_bRead(false),
    m_lElement(0),
    m_bUseRange(false),
    m_bUseGenericRange(false),
    m_bUseSpecificRange(false),
    m_pRange(NULL),
    m_ucPrecision(0),
    m_bLimitFloating(false),
    m_lDataFormat(Generic_No_Conversions),
    m_lInitialDataFormat(Generic_No_Conversions)
{
    m_stlStrFormatName          = CDataConversion::FormatName(Generic_No_Conversions);
}

void CIOAction::ResetProperties()
{
    m_vectRanges.clear();

    CXMLElement* pXMLElement = NULL;
    POSITION pos = NULL;
    STRING2STRING_MAP::iterator s2sIt;
    CString strValue;

    // Find the element.
    if (m_pIOActionXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("VARIABLE")) == true)
    {
        Variable(pXMLElement->ElementValue());

        if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("READ_MODE")) == true)
        {
            CString strValue((*s2sIt).second.c_str());
            ReadType(atoi(strValue));
        }
        else
        {
            m_bReadOnce = false;
            m_bReadAlways = false;
            m_bReadChanged = true;
            pXMLElement->AddAttribute(_FSI_STL::string("READ_MODE"),
                                      _FSI_STL::string("1"));
        }

        if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("WRITE_MODE")) == true)
        {
            strValue.Format("%s", (*s2sIt).second.c_str());
            strValue.MakeUpper();
            if (strValue == "YES")
            {
                m_bCanWrite = true;
            }
            else
            {
                m_bCanWrite = false;
            }
        }
        else
        {
            m_bCanWrite = true;
            pXMLElement->AddAttribute(_FSI_STL::string("WRITE_MODE"),
                                      _FSI_STL::string("YES"));
        }

        if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("ELEMENT_VAR")) == true)
        {
            m_stlStrElementVar = (*s2sIt).second;
        }
        else
        {
            m_stlStrElementVar = _FSI_STL::string("Default");
            pXMLElement->AddAttribute(_FSI_STL::string("ELEMENT_VAR"),
                                      _FSI_STL::string("Default"));
        }

        if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("ARRAY_ELEMENT")) == true)
        {
            m_lElement = atoi((*s2sIt).second.c_str());
        }
        else
        {
            m_lElement = 0;
            pXMLElement->AddAttribute(_FSI_STL::string("ARRAY_ELEMENT"),
                                      _FSI_STL::string("0"));
        }
    }
    else
    {
        m_bReadOnce         = false;
        m_bReadAlways       = false;
        m_bReadChanged      = true;
        m_bCanWrite         = true;
        m_lElement          = 0;

        m_pIOActionXMLWidget->AddElement(_FSI_STL::string("VARIABLE"), _FSI_STL::string(""), 
                                 NULL);
        pXMLElement = NULL;
        if (m_pIOActionXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("VARIABLE")) == true)
        {
            pXMLElement->AddAttribute(_FSI_STL::string("READ_MODE"),
                                      _FSI_STL::string("1"));

            pXMLElement->AddAttribute(_FSI_STL::string("WRITE_MODE"),
                                      _FSI_STL::string("YES"));

            pXMLElement->AddAttribute(_FSI_STL::string("ELEMENT_VAR"),
                                      _FSI_STL::string("Default"));

            pXMLElement->AddAttribute(_FSI_STL::string("ARRAY_ELEMENT"),
                                      _FSI_STL::string("0"));
        }
    }

    pXMLElement = NULL;
    if (m_pIOActionXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("FORMAT")) == true)
    {
        m_stlStrFormatName = pXMLElement->ElementValue();

        if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("PRECISION")) == true)
        {
            m_ucPrecision = (unsigned char)atoi((*s2sIt).second.c_str());
        }
        else
        {
            strValue.Format("%d",m_ucPrecision);
            pXMLElement->AddAttribute(_FSI_STL::string("PRECISION"),
                                      _FSI_STL::string((LPCTSTR)strValue));
        }

        if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("LIMIT_PRECISION")) == true)
        {
            strValue.Format("%s", (*s2sIt).second.c_str());
            strValue.MakeUpper();
            if (strValue == "YES")
            {
                m_bLimitFloating = true;
            }
            else
            {
                m_bLimitFloating = false;
            }
        }
        else
        {
            strValue = "NO";
            pXMLElement->AddAttribute(_FSI_STL::string("LIMIT_PRECISION"),
                                      _FSI_STL::string((LPCTSTR)strValue));
        }

        if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("DATA_FORMAT")) == true)
        {
            m_lDataFormat = atoi((*s2sIt).second.c_str());

            if (m_lDataFormat < Generic_No_Conversions ||
                m_lDataFormat >=  Total_Data_Formats)
            {
                m_lDataFormat = Generic_No_Conversions;
            }
        }
        else
        {
            strValue.Format("%d",Generic_No_Conversions);
            pXMLElement->AddAttribute(_FSI_STL::string("DATA_FORMAT"),
                                      _FSI_STL::string((LPCTSTR)strValue));

        }
    }
    else
    {
        m_ucPrecision       = 0;
        m_bLimitFloating    = false;
        m_stlStrFormatName  = CDataConversion::FormatName(Generic_No_Conversions);
        m_lDataFormat       = Generic_No_Conversions;

        m_pIOActionXMLWidget->AddElement(_FSI_STL::string("FORMAT"), m_stlStrFormatName, 
                                 NULL);
        pXMLElement = NULL;
        if (m_pIOActionXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("FORMAT")) == true)
        {
            strValue.Format("%d",m_ucPrecision);
            pXMLElement->AddAttribute(_FSI_STL::string("PRECISION"),
                                      _FSI_STL::string((LPCTSTR)strValue));
            strValue = "NO";
            pXMLElement->AddAttribute(_FSI_STL::string("LIMIT_PRECISION"),
                                      _FSI_STL::string((LPCTSTR)strValue));

            strValue.Format("%d", m_lDataFormat);
            pXMLElement->AddAttribute(_FSI_STL::string("DATA_FORMAT"),
                                      _FSI_STL::string((LPCTSTR)strValue));
        }
    }

    pXMLElement = NULL;
    if (m_pIOActionXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("RANGE_DATA")) == true)
    {
        CString strValue = pXMLElement->ElementValue().c_str();
        strValue.MakeUpper();
        if (strValue == "GENERIC")
        {
            m_bUseRange = true;
            m_bUseGenericRange = true;
            m_bUseSpecificRange = false;
        }
        else if (strValue == "SPECIFIC")
        {
            m_bUseRange = true;
            m_bUseGenericRange = false;
            m_bUseSpecificRange = true;
        }
        else
        {
            m_bUseRange = false;
            m_bUseGenericRange = false;
            m_bUseSpecificRange = false;
        }

        if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("RANGE_NUM")) == true)
        {
            m_lRangeIndex = atoi((*s2sIt).second.c_str());
            if (m_lRangeIndex == -1)
            {
                m_pRange = NULL;
            }
        }
        else
        {
            m_pRange = NULL;
            pXMLElement->AddAttribute(_FSI_STL::string("RANGE_NUM"),
                                      _FSI_STL::string("-1"));
        }
    }
    else
    {
        m_bUseRange = false;
        m_bUseGenericRange = false;
        m_bUseSpecificRange = false;
        m_pRange = NULL;

        m_pIOActionXMLWidget->AddElement(_FSI_STL::string("RANGE_DATA"), _FSI_STL::string("NONE"), 
                                 NULL);
        pXMLElement = NULL;
        if (m_pIOActionXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("RANGE_DATA")) == true)
        {
            pXMLElement->AddAttribute(_FSI_STL::string("RANGE_NUM"),
                                      _FSI_STL::string("-1"));
        }
    }
}

void CIOAction::AddRange(CRange* pRange)
{
    if (pRange == NULL)
    {
        return;
    }

    m_vectRanges.push_back(pRange);
    CWidget* pParentWidget = ((CWidget*)Widget())->ParentWidget();

    if (CWidget::IsValidAddress(pParentWidget) != VALID)
    {
        return;
    }

    if (pRange->ID() == m_lRangeIndex && m_lRangeIndex > -1)
    {
        m_pRange = pRange;
    }

    if (pParentWidget != NULL)
    {
        // Setup the range for the parent widget.
        _FSI_STL::vector<CRange*>::iterator vIt = m_vectRanges.begin();

        CVariant var;

//        if (vIt != m_vectRanges.end())
        {
            // Set the lower value
            var = pRange->Lower();
//            pParentWidget->RangeLow(m_stlStrElementVar, var);

            // Get it back to perform any data conversions and
            // decimal precision work.
//            var = pParentWidget->RangeLow(m_stlStrElementVar);

            if (m_lDataFormat != m_lInitialDataFormat &&
                m_lDataFormat != Generic_No_Conversions)
            {
                var = CDataConversion::Convert(var, 
                                               (DATA_FORMATS)m_lInitialDataFormat,
                                               (DATA_FORMATS)m_lDataFormat);
            }

            var.LimitFloating(m_bLimitFloating);
            var.Precision(m_ucPrecision);

            // Reset the lower value 
            pParentWidget->RangeLow(m_stlStrElementVar, var);

            CVariant varOriginal = pRange->Lower();
            pRange->Lower(var);
            pParentWidget->AddRangeData(pRange, m_stlStrElementVar);
            pRange->Lower(varOriginal);


            // Set the upper value
            var = pRange->Upper();
//            pParentWidget->RangeHigh(m_stlStrElementVar, pRange->Upper());

            // Get it back to perform any data conversions and
            // decimal precision work.
//            var = pParentWidget->RangeHigh(m_stlStrElementVar);

            if (m_lDataFormat != m_lInitialDataFormat &&
                m_lDataFormat != Generic_No_Conversions)
            {
                var = CDataConversion::Convert(var, 
                                               (DATA_FORMATS)m_lInitialDataFormat,
                                               (DATA_FORMATS)m_lDataFormat);
            }

            var.LimitFloating(m_bLimitFloating);
            var.Precision(m_ucPrecision);

            // Reset the lower value.
            pParentWidget->RangeHigh(m_stlStrElementVar, var);
        }

        while (vIt != m_vectRanges.end())
        {
            if ((*vIt)->Lower() < pParentWidget->RangeLow(m_stlStrElementVar))
            {
                var = (*vIt)->Lower();
//                pParentWidget->RangeLow(m_stlStrElementVar, (*vIt)->Lower());

                // Get it back to perform any data conversions and
                // decimal precision work.
//                var = pParentWidget->RangeLow(m_stlStrElementVar);

                if (m_lDataFormat != m_lInitialDataFormat &&
                    m_lDataFormat != Generic_No_Conversions)
                {
                    var = CDataConversion::Convert(var, 
                                                   (DATA_FORMATS)m_lInitialDataFormat,
                                                   (DATA_FORMATS)m_lDataFormat);
                }

                var.LimitFloating(m_bLimitFloating);
                var.Precision(m_ucPrecision);

                pParentWidget->RangeLow(m_stlStrElementVar, var);
            }

            if ((*vIt)->Upper() > pParentWidget->RangeHigh(m_stlStrElementVar))
            {
                var = (*vIt)->Upper();
//                pParentWidget->RangeHigh(m_stlStrElementVar, (*vIt)->Upper());

                // Get it back to perform any data conversions and
                // decimal precision work.
//                var = pParentWidget->RangeHigh(m_stlStrElementVar);

                if (m_lDataFormat != m_lInitialDataFormat &&
                    m_lDataFormat != Generic_No_Conversions)
                {
                    var = CDataConversion::Convert(var, 
                                                   (DATA_FORMATS)m_lInitialDataFormat,
                                                   (DATA_FORMATS)m_lDataFormat);
                }

                var.LimitFloating(m_bLimitFloating);
                var.Precision(m_ucPrecision);

                pParentWidget->RangeHigh(m_stlStrElementVar, var);
            }

            vIt++;
        }
    }
}

void CIOAction::ReadType(unsigned long int ulReadType)
{
    switch (ulReadType)
    {
    case READ_ALWAYS:
        {
            m_bReadOnce = false;
            m_bReadAlways = true;
            m_bReadChanged = false;
        }
        break;
    case READ_CHANGED:
        {
            m_bReadOnce = false;
            m_bReadAlways = false;
            m_bReadChanged = true;
        }
        break;
    case READ_NEVER:
        {
            m_bReadOnce = false;
            m_bReadAlways = false;
            m_bReadChanged = false;
        }
        break;
    case READ_ONCE:
        {
            m_bReadOnce = true;
            m_bReadAlways = false;
            m_bReadChanged = false;
        }
        break;
    default:
        {
            m_bReadOnce = false;
            m_bReadAlways = true;
            m_bReadChanged = false;
        }
        break;
    }
}

//////////////////////////////////////////////////////////////////////
// Accessors
//////////////////////////////////////////////////////////////////////

_FSI_STL::string CIOAction::GraphicalElementName()
{
    return m_stlStrElementVar;
}

_FSI_STL::vector<CRange*> CIOAction::Ranges()
{
    return m_vectRanges;
}

_FSI_STL::string CIOAction::Variable()
{
    return m_stlStrVariableToWatch;
}

CVariant* CIOAction::Variant()
{
    return m_pVariant;
}

_FSI_STL::string CIOAction::DataFormatName()
{
    return m_stlStrFormatName;
}

long int CIOAction::DataFormat()
{
    return m_lDataFormat;
}

long int CIOAction::InitialDataFormat()
{
    return m_lInitialDataFormat;
}

//////////////////////////////////////////////////////////////////////
// Mutators
//////////////////////////////////////////////////////////////////////

void CIOAction::GraphicalElementName(const _FSI_STL::string& rstlStrGraphicalElementName)
{
    m_stlStrElementVar = rstlStrGraphicalElementName;
}

void CIOAction::Variable(const _FSI_STL::string& rstlStrVariable)
{
    m_stlStrVariableToWatch = rstlStrVariable;
}

void CIOAction::Variant(CVariant* pVariant)
{
    // Hmm, would a delete of the previous pointer be needed.  
    // Hopefully, not.  This should only really be called if
    // m_pVariant is null for initialization.
    m_pVariant = pVariant;
}

void CIOAction::DataFormatName(const _FSI_STL::string& rstlStrFormatName)
{
    m_stlStrFormatName = rstlStrFormatName;
}

void CIOAction::DataFormat(const long int lDataFormat)
{
    m_lDataFormat = lDataFormat;
}

void CIOAction::InitialDataFormat(const long int lDataFormat)
{
    m_lInitialDataFormat = lDataFormat;
}
