// HelpPage.cpp : implementation file
//

#include "stdafx.h"
#include "HelpPage.h"

#include "Widget.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CHelpPage property page

CHelpPage::CHelpPage() : CBasePage(CHelpPage::IDD)
{
	//{{AFX_DATA_INIT(CHelpPage)
	m_strHelpKeywords = _T("");
	m_strHelpRelatedTopics = _T("");
	m_strHelpText = _T("");
	//}}AFX_DATA_INIT
    m_stlStrPageName = _FSI_STL::string("Help");
}

void CHelpPage::DoDataExchange(CDataExchange* pDX)
{
	CBasePage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CHelpPage)
	DDX_Text(pDX, IDC_HELP_KEYWORDS, m_strHelpKeywords);
	DDX_Text(pDX, IDC_HELP_RELATEDTOPICS, m_strHelpRelatedTopics);
	DDX_Text(pDX, IDC_HELP_TEXT, m_strHelpText);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CHelpPage, CBasePage)
	//{{AFX_MSG_MAP(CHelpPage)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CHelpPage message handlers
CBasePage* CHelpPage::CreateObject()
{
    return new CHelpPage;
}

void CHelpPage::SetProperties(void* pWidget)
{
    CXMLWidget* pXMLWidget = ((CWidget*)pWidget)->XMLWidget();
    if (pXMLWidget != NULL)
    {
        // Get the help text
        CXMLElement* pXMLElement = NULL;
        POSITION pos = NULL;
        if (pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("HELPTEXT")) == true)
        {
            m_strHelpText = pXMLElement->ElementValue().c_str();
        }

        // Get the help keywords
        pXMLElement = NULL;
        if (pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("HELPKEYWORDS")) == true)
        {
            m_strHelpKeywords = pXMLElement->ElementValue().c_str();
        }

        // Get the related topics
        pXMLElement = NULL;
        if (pXMLWidget->FindElement(pXMLElement, pos, 
                                    _FSI_STL::string("HELPRELATEDTOPICS")) == true)
        {
            m_strHelpRelatedTopics = pXMLElement->ElementValue().c_str();
        }
    }
}

void CHelpPage::UpdateProperties(void* pWidget)
{
    CXMLWidget* pXMLWidget = ((CWidget*)pWidget)->XMLWidget();
    if (pXMLWidget != NULL && GetSafeHwnd() != NULL)
    {
        UpdateData(TRUE);

        // Update the help text
        CXMLElement* pXMLElement = NULL;
        POSITION pos = NULL;
        if (pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("HELPTEXT")) == true)
        {
            pXMLElement->AddElementValue(_FSI_STL::string((LPCTSTR)m_strHelpText));
        }

        // Update the help keywords
        pXMLElement = NULL;
        if (pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("HELPKEYWORDS")) == true)
        {
            pXMLElement->AddElementValue(_FSI_STL::string((LPCTSTR)m_strHelpKeywords));
        }

        // Update the related topics
        pXMLElement = NULL;
        if (pXMLWidget->FindElement(pXMLElement, pos,
                                    _FSI_STL::string("HELPRELATEDTOPICS")) == true)
        {
            pXMLElement->AddElementValue(
                           _FSI_STL::string((LPCTSTR)m_strHelpRelatedTopics));
        }
    }
}
