// GridSnapPage.cpp : implementation file
//

#include "stdafx.h"
#include "GridSnapPage.h"

#include "Widget.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGridSnapPage dialog


CGridSnapPage::CGridSnapPage() : CBasePage(CGridSnapPage::IDD)
{
	//{{AFX_DATA_INIT(CGridSnapPage)
	m_bGridOn = FALSE;
	m_lResX = 0;
	m_lResY = 0;
	m_bSnapAllVertices = FALSE;
	m_bSnapOn = FALSE;
    m_strHelpFile = _T("");
	//}}AFX_DATA_INIT
    m_stlStrPageName = _FSI_STL::string("Grid, Snap, and Help");
}

void CGridSnapPage::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGridSnapPage)
	DDX_Check(pDX, IDC_GRIDON, m_bGridOn);
	DDX_Text(pDX, IDC_GRIDX, m_lResX);
	DDX_Text(pDX, IDC_GRIDY, m_lResY);
	DDX_Check(pDX, IDC_SNAP_ALLVERTICES, m_bSnapAllVertices);
	DDX_Check(pDX, IDC_SNAPON, m_bSnapOn);
	DDX_Text(pDX, IDC_HELPFILE, m_strHelpFile);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CGridSnapPage, CDialog)
	//{{AFX_MSG_MAP(CGridSnapPage)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGridSnapPage message handlers
CBasePage* CGridSnapPage::CreateObject()
{
    return new CGridSnapPage;
}

void CGridSnapPage::SetProperties(void* pWidget)
{
    CXMLWidget* pXMLWidget = ((CWidget*)pWidget)->XMLWidget();
    if (pXMLWidget != NULL)
    {
        CXMLElement* pXMLElement = NULL;
        POSITION pos = NULL;
        STRING2STRING_MAP::iterator s2sIt;
        if (pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("GRID")) == true)
        {
            CString strGridOn(pXMLElement->ElementValue().c_str());
            strGridOn.MakeUpper();
            if (strGridOn == "YES")
            {
                m_bGridOn = true;
            }
            else
            {
                m_bGridOn = false;
            }

            if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("RESX")) == true)
            {
                m_lResX = atoi((*s2sIt).second.c_str());
            }

            if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("RESY")) == true)
            {
                m_lResY = atoi((*s2sIt).second.c_str());
            }

        }

        pXMLElement = NULL;
        if (pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("SNAP")) == true)
        {
            CString strSnapOn(pXMLElement->ElementValue().c_str());
            strSnapOn.MakeUpper();
            if (strSnapOn == "YES")
            {
                m_bSnapOn = true;
            }
            else
            {
                m_bSnapOn = false;
            }

            if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("SNAPALL")) == true)
            {
                CString strSnapAll((*s2sIt).second.c_str());
                strSnapAll.MakeUpper();
                if (strSnapAll == "YES")
                {
                    m_bSnapAllVertices = true;
                }
                else
                {
                    m_bSnapAllVertices = false;
                }
            }

        }

        pXMLElement = NULL;
        if (pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("HLPFILE")) == true)
        {
            m_strHelpFile = pXMLElement->ElementValue().c_str();
        }
    }
}

void CGridSnapPage::UpdateProperties(void* pWidget)
{
    CXMLWidget* pXMLWidget = ((CWidget*)pWidget)->XMLWidget();
    if (pXMLWidget != NULL && GetSafeHwnd() != NULL)
    {
        UpdateData(TRUE);
        CXMLElement* pXMLElement = NULL;
        STRING2STRING_MAP::iterator s2sIt;
        POSITION pos = NULL;
        if (pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("GRID")) == true)
        {
            CString strValue;
            if (m_bGridOn == TRUE)
            {
                strValue = "YES";
            }
            else
            {
                strValue = "NO";
            }
            pXMLElement->AddElementValue(_FSI_STL::string((LPCTSTR)strValue));
            if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("RESX")) == true)
            {
                strValue.Format("%d",m_lResX);
                (*s2sIt).second = _FSI_STL::string((LPCTSTR)strValue);
            }

            if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("RESY")) == true)
            {
                strValue.Format("%d",m_lResY);
                (*s2sIt).second = _FSI_STL::string((LPCTSTR)strValue);
            }
        }

        pXMLElement = NULL;
        if (pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("SNAP")) == true)
        {
            CString strValue;
            if (m_bSnapOn == TRUE)
            {
                strValue = "YES";
            }
            else
            {
                strValue = "NO";
            }
            pXMLElement->AddElementValue(_FSI_STL::string((LPCTSTR)strValue));
            if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("SNAPALL")) == true)
            {
                if (m_bSnapAllVertices == TRUE)
                {
                    strValue = "YES";
                }
                else
                {
                    strValue = "NO";
                }
                (*s2sIt).second = _FSI_STL::string((LPCTSTR)strValue);
            }
        }

        pXMLElement = NULL;
        if (pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("HLPFILE")) == true)
        {
            pXMLElement->AddElementValue(_FSI_STL::string((LPCTSTR)m_strHelpFile));
        }
    }
}
