/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : FormatPage.h
//
// Date             : 26 August 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.4 $
//
// Description      : FormatPage.h contains the definition of the 
//                    CFormatPage class.  This class is used in the page 
//                    editor to enter information about limiting the 
//                    floating point precision used for display as well
//                    as converting the data from one type to another.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : _FSI_STL::string, Core::CBasePage, Core::CXMLElement,
//                    Core::CXMLWidget, Core::CWidget, STRING2STRING_MAP.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3, 4, or 5
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: FormatPage.h $
// Revision 1.4  2000/03/07 07:31:08  billyb
// Removed unused methods.
// Revision 1.3  1999/09/02 19:33:58  billyb
// Added variables for data format conversion selection.
// Revision 1.2  1999/08/30 22:14:49  billyb
// Changed from COMMS to CORE.
/////////////////////////////////////////////////////////////////////////////
#if !defined(_FORMATPAGE_H_)
#define _FORMATPAGE_H_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#ifdef CORE
#define DLLAPI __declspec( dllexport )
#else
#define DLLAPI __declspec( dllimport )
#endif

#include "resource.h"
#include "BasePage.h"

class DLLAPI CFormatPage : public CBasePage
{
// Construction
public:
	CFormatPage();
    static CBasePage* CreateObject();

// Dialog Data
	//{{AFX_DATA(CFormatPage)
	enum { IDD = IDD_CORE_PAGE_FORMATTING };
	CListBox	m_ctrlSupportedConversions;
	short	m_shFloatingPrecision;
	BOOL	m_bLimitFloating;
	CString	m_strInitialDataFormat;
	CString	m_strSelectedConversion;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CFormatPage)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CFormatPage)
	afx_msg void OnLimitFloatingPoint();
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

    virtual void SetProperties(void* pWidget);
    virtual void UpdateProperties(void* pWidget);
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(_VALUEPAGE_H_)
