/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : FormatPage.cpp
//
// Date             : 26 August 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.5 $
//
// Description      : FormatPage.cpp contains the implementation of the 
//                    CFormatPage class.  This class is used in the page 
//                    editor to enter information about limiting the 
//                    floating point precision used for display as well
//                    as converting the data from one type to another.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : _FSI_STL::string, Core::CBasePage, Core::CXMLElement,
//                    Core::CXMLWidget, Core::CWidget, STRING2STRING_MAP.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3, 4, or 5
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: FormatPage.cpp $                                                                   //
// Revision 1.5  2000/03/07 07:31:28  billyb                                                                   //
// Removed unused methods.  Changed calls to                                                                    //
// AddElementValue.                                                                   //
// Revision 1.4  2000/02/11 18:31:39  billyb                                                                   //
// Changed include for stdafx.h.                                                                   //
// Revision 1.3  1999/09/02 19:35:00  billyb                                                                   //
// Added necessary code for parsing data format                                                                    //
// conversion information and displaying it in the controls                                                                   //
// on the property page.                                                                   //
// Revision 1.2  1999/08/30 22:15:13  billyb                                                                   //
// Initialized floating point precision to 0 instead of -1.                                                                   //
/////////////////////////////////////////////////////////////////////////////
#include "stdafx.h"
#include "FormatPage.h"
#include "IOAction.h"
#include "Widget.h"
#include "DataConversion.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CFormatPage::CFormatPage() : CBasePage(CFormatPage::IDD)
{
	//{{AFX_DATA_INIT(CFormatPage)
	m_shFloatingPrecision = 0;
	m_bLimitFloating = FALSE;
	m_strInitialDataFormat = CDataConversion::FormatName(Generic_No_Conversions).c_str();
	m_strSelectedConversion = m_strInitialDataFormat;
	//}}AFX_DATA_INIT
    m_stlStrPageName = _FSI_STL::string("Formatting");
}

void CFormatPage::DoDataExchange(CDataExchange* pDX)
{
	CBasePage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFormatPage)
	DDX_Control(pDX, IDC_SUPPORTED_DATA_CONVERSIONS, m_ctrlSupportedConversions);
	DDX_Text(pDX, IDC_FLOATING_PRECISION, m_shFloatingPrecision);
	DDV_MinMaxInt(pDX, m_shFloatingPrecision, 0, 10);
	DDX_Check(pDX, IDC_LIMIT_FLOATING_POINT, m_bLimitFloating);
	DDX_Text(pDX, IDC_INITIAL_DATA_FORMAT, m_strInitialDataFormat);
	DDX_LBString(pDX, IDC_SUPPORTED_DATA_CONVERSIONS, m_strSelectedConversion);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CFormatPage, CBasePage)
	//{{AFX_MSG_MAP(CFormatPage)
	ON_BN_CLICKED(IDC_LIMIT_FLOATING_POINT, OnLimitFloatingPoint)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFormatPage message handlers
CBasePage* CFormatPage::CreateObject()
{
    return new CFormatPage;
}

void CFormatPage::SetProperties(void* pWidget)
{
    CXMLWidget* pXMLWidget = ((CWidget*)pWidget)->XMLWidget();
    if (pXMLWidget != NULL)
    {
        CXMLElement* pXMLElement = NULL;
        POSITION pos = NULL;
        if (pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("FORMAT")) == true)
        {
            // Get the name of the conversion to apply
            m_strSelectedConversion = pXMLElement->ElementValue().c_str();

            STRING2STRING_MAP::iterator s2sIt = NULL;

            // Get the number of digits after the decimal to display
            if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("PRECISION")) == true)
            {
                m_shFloatingPrecision = (unsigned short)atoi((*s2sIt).second.c_str());
                if (m_shFloatingPrecision < 0)
                {
                    m_shFloatingPrecision = 0;
                }
            }

            // Get whether the digits after the decimal will be limited to the
            // precision value.
            if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("LIMIT_PRECISION")) == true)
            {
                CString strValue((*s2sIt).second.c_str());
                strValue.MakeUpper();
                if (strValue == "YES")
                {
                    m_bLimitFloating = TRUE;
                }
                else
                {
                    m_bLimitFloating = FALSE;
                }
            }

            // The integer value of the data conversion is not needed since the
            // selection in the list box will be made using the string name of
            // the conversion.
        }
    }
}

void CFormatPage::UpdateProperties(void* pWidget)
{
    CXMLWidget* pXMLWidget = ((CWidget*)pWidget)->XMLWidget();
    if (pXMLWidget != NULL && GetSafeHwnd() != NULL)
    {
        UpdateData(TRUE);
        CXMLElement* pXMLElement = NULL;
        POSITION pos = NULL;
        if (pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("FORMAT")) == true)
        {
            // Record the name of the conversion to perform.
            pXMLElement->AddElementValue(_FSI_STL::string((LPCTSTR)m_strSelectedConversion));

            STRING2STRING_MAP::iterator s2sIt = NULL;
            CString strValue;

            // Record the number of digits after the decimal to display.
            if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("PRECISION")) == true)
            {
                strValue.Format("%d",m_shFloatingPrecision);
                (*s2sIt).second = _FSI_STL::string((LPCTSTR)strValue);
            }

            // Record whether the number of digits after the decimal should
            // be limited to the precision number.
            if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("LIMIT_PRECISION")) == true)
            {
                if (m_bLimitFloating == TRUE)
                {
                    (*s2sIt).second = _FSI_STL::string("YES");
                }
                else
                {
                    (*s2sIt).second = _FSI_STL::string("NO");
                }
            }

            // Record the interger value of the conversion to perform.
            if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("DATA_FORMAT")) == true)
            {
                CString strDataFormat;
                if (m_ctrlSupportedConversions.GetCurSel() != LB_ERR)
                {
                    strDataFormat.Format("%d", m_ctrlSupportedConversions.GetItemData(m_ctrlSupportedConversions.GetCurSel()));

                    (*s2sIt).second = _FSI_STL::string((LPCTSTR)strDataFormat);
                }
                else
                {
                    strDataFormat.Format("%d", Generic_No_Conversions);
                    (*s2sIt).second = _FSI_STL::string((LPCTSTR)strDataFormat);
                }
            }
        }
    }
}

/////////////////////////////////////////////////////////////////////////////
//
// void CFormatPage::OnLimitFloatingPoint()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 02 September 1999
//
// Engineer         : Billy Baker
//
// Description      : OnLimitFloatingPoint is a callback for when the 
//                    checkbox that determines whether the precision 
//                    value will be used is clicked.  If the checkbox 
//                    is checked, then the precision edit box is 
//                    enabled.  Otherwise, the precision edit box is disa
//                    bled.
//
/////////////////////////////////////////////////////////////////////////////
void CFormatPage::OnLimitFloatingPoint() 
{
    UpdateData(TRUE);
    CWnd* pWnd = GetDlgItem(IDC_FLOATING_PRECISION);
    if (pWnd == NULL)
    {
        return;
    }

    if (m_bLimitFloating == TRUE)
    {
        pWnd->EnableWindow();
    }
    else
    {
        pWnd->EnableWindow(FALSE);
    }
}

BOOL CFormatPage::OnInitDialog() 
{
	CBasePage::OnInitDialog();

    // Set the static with the name of the initial data format for a variable
    CIOAction* pAction = dynamic_cast<CIOAction*>((CWidget*)m_pWidget);
    long int lInitialDataFormat = Generic_No_Conversions;
    if (pAction != NULL)
    {
        lInitialDataFormat = pAction->InitialDataFormat();
        m_strInitialDataFormat = CDataConversion::FormatName((DATA_FORMATS)lInitialDataFormat).c_str();
    }
	
    // Fill the supported conversion listbox with the possible conversions for m_eDataFormat
    int nIndex = 0;
    m_ctrlSupportedConversions.ResetContent();

    // Add Generic_No_Conversions for every format
    // Make sure to set the item data to the value of the enum for the 
    // format conversion.
    m_ctrlSupportedConversions.AddString(CDataConversion::FormatName(Generic_No_Conversions).c_str());
    m_ctrlSupportedConversions.SetItemData(nIndex, Generic_No_Conversions);
    nIndex++;

    _FSI_STL::map<DATA_FORMATS, ConversionMethod> mapFormats = 
              CDataConversion::PossibleConversions((DATA_FORMATS)lInitialDataFormat);

    if (mapFormats.size() > 0)
    {
        _FSI_STL::map<DATA_FORMATS, ConversionMethod>::iterator mIt = 
                                                            mapFormats.begin();
        for (; mIt != mapFormats.end(); mIt++)
        {
            // Make sure to set the item data to the value of the enum for the 
            // format conversion.
            m_ctrlSupportedConversions.AddString(CDataConversion::FormatName((*mIt).first).c_str());
            m_ctrlSupportedConversions.SetItemData(nIndex, (*mIt).first);
            nIndex++;
        }
    }

    // Enable/Disable the edit box for floating point precision as determined
    // by m_bLimitFloating.
    CWnd* pWnd = GetDlgItem(IDC_FLOATING_PRECISION);
    if (pWnd == NULL)
    {
        return TRUE;
    }

    if (m_bLimitFloating == TRUE)
    {
        pWnd->EnableWindow();
    }
    else
    {
        pWnd->EnableWindow(FALSE);
    }

    UpdateData(FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
