#if !defined(_FONTPAGE_H_)
#define _FONTPAGE_H_

#ifdef CORE
#define DLLAPI __declspec( dllexport )
#else
#define DLLAPI __declspec( dllimport )
#endif

#include "resource.h"

#include "BasePage.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// FontPage.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CFontPage dialog

class DLLAPI CFontPage : public CBasePage
{
private:	
    CFont           m_font;	
    long int        m_lPixelsPerInch;
    CString	        m_strFont;	
    CString	        m_strSize;	
    CString	        m_strStyle;
    CString	        m_strShadowOffset;
    unsigned char   m_ucShadowOffset;
	static int CALLBACK FontEnumProc(ENUMLOGFONTEX *lpelfe, 
                                     NEWTEXTMETRICEX *lpntme, 
		                             int FontType, CFontPage* pFontPage );

    CString         m_strGlobalFont;
    CString         m_strGlobalFontName;
    CString         m_strGlobalSize;
    CString         m_strGlobalStyle;
    CString         m_strGlobalOffset;

// Construction
public:
	void GetCurrentFont(LPLOGFONT lplf);
    explicit CFontPage(LOGFONT* pLogfont = NULL);
	~CFontPage();
    static CBasePage* CreateObject();

// Dialog Data
	//{{AFX_DATA(CFontPage)
	enum { IDD = IDD_CORE_PAGE_FONT };
	CComboBox	m_comboGlobals;
	CComboBox	m_ctrlShadowOffset;
	CComboBox	m_comboFont;
	CComboBox	m_comboSize;
	CComboBox	m_comboStyle;
	CStatic	m_staticSample;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CFontPage)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CFontPage)
	virtual BOOL OnInitDialog();
    afx_msg void OnSelChange();
	afx_msg void OnSelchangeGlobalFonts();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

    virtual void SetProperties(void* pWidget);
    virtual void UpdateProperties(void* pWidget);
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(_FONTPAGE_H_)
