// FontPage.cpp : implementation file
//

#include "stdafx.h"
#include "FontPage.h"

#include "Widget.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFontPage property page

CFontPage::CFontPage(LOGFONT* pLogfont) : CBasePage(CFontPage::IDD)
{
	//{{AFX_DATA_INIT(CFontPage)
	//}}AFX_DATA_INIT
    m_stlStrPageName = _FSI_STL::string("Font");

    LOGFONT logfont;	
    CWindowDC dc(GetDesktopWindow() );

	m_lPixelsPerInch = GetDeviceCaps(dc, LOGPIXELSY);	
    if( pLogfont == NULL )	
    {
		CFont *pfont = dc.GetCurrentFont();		
        pfont->GetLogFont( &logfont );
		pLogfont = &logfont;	
    }	
    
    m_font.CreateFontIndirect( pLogfont );
	m_strFont = pLogfont->lfFaceName;
	m_strSize.Format( "%d", MulDiv(pLogfont->lfHeight, 72, m_lPixelsPerInch) );
	m_strStyle = _T("Regular");	
    if( pLogfont->lfWeight >= 700 && pLogfont->lfItalic)
    {
		m_strStyle = _T("Bold Italic");	
    }
    else if( pLogfont->lfItalic )
    {
		m_strStyle = _T("Italic");	
    }
    else if ( pLogfont->lfWeight >= 700 )
    {
		m_strStyle = _T("Bold");
    }
}

CFontPage::~CFontPage()
{
    m_font.DeleteObject();
}

void CFontPage::DoDataExchange(CDataExchange* pDX)
{
	CBasePage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFontPage)
	DDX_Control(pDX, IDC_GLOBAL_FONTS, m_comboGlobals);
	DDX_Control(pDX, IDC_SHADOW_OFFSET_COMBO, m_ctrlShadowOffset);
	DDX_Control(pDX, IDC_FONT, m_comboFont);
	DDX_Control(pDX, IDC_FONT_SIZE, m_comboSize);
	DDX_Control(pDX, IDC_FONT_STYLE, m_comboStyle);
	DDX_Control(pDX, IDC_SAMPLE, m_staticSample);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CFontPage, CBasePage)
	//{{AFX_MSG_MAP(CFontPage)
    ON_CBN_SELCHANGE(IDC_FONT, OnSelChange)	
	ON_CBN_SELCHANGE(IDC_SHADOW_OFFSET_COMBO, OnSelChange)
    ON_CBN_SELCHANGE(IDC_FONT_STYLE, OnSelChange)
	ON_CBN_SELCHANGE(IDC_FONT_SIZE, OnSelChange)
	ON_CBN_KILLFOCUS(IDC_FONT, OnSelChange)
	ON_CBN_KILLFOCUS(IDC_FONT_STYLE, OnSelChange)
	ON_CBN_KILLFOCUS(IDC_SHADOW_OFFSET_COMBO, OnSelChange)
	ON_CBN_KILLFOCUS(IDC_FONT_SIZE, OnSelChange)
	ON_CBN_SELCHANGE(IDC_GLOBAL_FONTS, OnSelchangeGlobalFonts)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFontPage message handlers
CBasePage* CFontPage::CreateObject()
{
    return new CFontPage;
}

void CFontPage::SetProperties(void* pWidget)
{
    CXMLWidget* pXMLWidget = ((CWidget*)pWidget)->XMLWidget();
    if (pXMLWidget != NULL)
    {
        CXMLElement* pXMLElement = NULL;
        POSITION pos = NULL;
        if (pXMLWidget->FindElement(pXMLElement, pos,_FSI_STL::string("FONT")) == true)
        {
            m_strFont = pXMLElement->ElementValue().c_str();
            STRING2STRING_MAP::iterator s2sIt = NULL;
            CString strValue;
            if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("SIZE")) == true)
            {
                m_strSize = (*s2sIt).second.c_str();
            }

            if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("STYLE")) == true)
            {
                m_strStyle = (*s2sIt).second.c_str();
            }

            if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("SHADOW_OFFSET")) == true)
            {
                m_strShadowOffset = (*s2sIt).second.c_str();
                m_ucShadowOffset = (unsigned char)atoi(m_strShadowOffset);
            }

            if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("GLOBALFONT")) == true)
            {
                m_strGlobalFont = (*s2sIt).second.c_str();

                HKEY hKey;
                RegOpenKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\FlightSafety\\FSISuite\\Settings"), 0, KEY_READ, &hKey);

                CString strFont = "";
                if (hKey != NULL)
                {
		            CString strValue = "";
                    DWORD dwType, dwCount;
                    LONG lResult;


		            lResult = RegQueryValueEx(hKey, (*s2sIt).second.c_str(), 
                                                   NULL, &dwType, NULL, &dwCount);
		            if (lResult == ERROR_SUCCESS)
		            {
			            ASSERT(dwType == REG_SZ);
			            lResult = RegQueryValueEx(hKey, (*s2sIt).second.c_str(), 
                                                  NULL, &dwType,
				                        (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)),
                                                  &dwCount);

			            strValue.ReleaseBuffer();
		            }
                    strFont = strValue;

                    RegCloseKey(hKey);
                }
	            
                CString strFontName = "";
                CString strSize = "";
                CString strStyle = "";
                CString strOffset = "";

                if (strFont.Find(",") > -1)
                {
                    strFontName = strFont.Left(strFont.Find(","));
                    strSize = strFont.Mid(strFont.Find(",") + 1);
                    if (strSize.Find(",") > -1)
                    {
                        strStyle = strSize.Left(strSize.Find(","));
                        strSize = strSize.Mid(strSize.Find(",") + 1);
                        if (strSize.Find(",") > -1)
                        {
                            strOffset = strSize.Mid(strSize.Find(",") + 1);
                            strSize = strSize.Left(strSize.Find(","));
                        }
                    }
                    else
                    {
                        strStyle = strSize;
                        strSize = "8";
                        strOffset = "0";
                    }

                    m_strGlobalStyle = strStyle;
                    m_strGlobalFontName = strFontName;
                    m_strGlobalSize = strSize;
                    m_strGlobalOffset = strOffset;

                    m_strStyle = strStyle;
                    m_strFont = strFontName;
                    m_strSize = strSize;
                    m_strShadowOffset = strOffset;
                }
                else
                {
                    m_strGlobalStyle = "";
                    m_strGlobalFontName = "";
                    m_strGlobalSize = "";
                    m_strGlobalOffset = "";
                }
            }
        }
    }
}

void CFontPage::UpdateProperties(void* pWidget)
{
    CXMLWidget* pXMLWidget = ((CWidget*)pWidget)->XMLWidget();
    if (pXMLWidget != NULL && GetSafeHwnd() != NULL)
    {
        UpdateData(TRUE);
        CXMLElement* pXMLElement = NULL;
        POSITION pos = NULL;
        if (pXMLWidget->FindElement(pXMLElement, pos,_FSI_STL::string("FONT")) == true)
        {
            pXMLElement->AddElementValue(_FSI_STL::string((LPCTSTR)m_strFont));
            STRING2STRING_MAP::iterator s2sIt = NULL;
            CString strValue;
            if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("SIZE")) == true)
            {
                (*s2sIt).second = _FSI_STL::string((LPCTSTR)m_strSize);
            }

            if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("STYLE")) == true)
            {
                (*s2sIt).second = _FSI_STL::string((LPCTSTR)m_strStyle);
            }

            if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("SHADOW_OFFSET")) == 
                                                                          true)
            {
                (*s2sIt).second = _FSI_STL::string((LPCTSTR)m_strShadowOffset);
            }

            CString strSelection("Not Used");
            if (m_comboGlobals.GetCurSel() != CB_ERR)
            {
	            m_comboGlobals.GetLBText(m_comboGlobals.GetCurSel(), strSelection);
            }

            if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("GLOBALFONT")) == 
                                                                          true)
            {
                (*s2sIt).second = _FSI_STL::string((LPCTSTR)strSelection);
            }
        }
    }
}

BOOL CFontPage::OnInitDialog() 
{
	CBasePage::OnInitDialog();
	
	// TODO: Add extra initialization here
	
    CWindowDC dc(this);	
    LOGFONT logfont;	
    logfont.lfCharSet = DEFAULT_CHARSET;
	logfont.lfFaceName[0] = '\0';	
    logfont.lfPitchAndFamily = 0;

    m_comboFont.ResetContent();

	EnumFontFamiliesEx( dc.m_hDC, &logfont, (FONTENUMPROC)FontEnumProc, 
	    		        (LPARAM) this, 0 );		
    
    // Fill Size combobox with "common" sizes
	TCHAR* Defaults[] = { _T("8"), _T("9"), _T("10"), _T("11"), _T("12"),
                          _T("14"), _T("16"), _T("18"), _T("20"), _T("22"), 
                          _T("24"), _T("26"), _T("28"), _T("36"), _T("48") };

    m_comboSize.ResetContent();
	for (int i = 0; i < (sizeof(Defaults)/sizeof(Defaults[0])); i++)
    {
		m_comboSize.AddString(Defaults[i]);
    }

	// Fill Style combobox with "common" styles
    m_comboStyle.ResetContent();
	m_comboStyle.AddString( _T("Regular") );	
    m_comboStyle.AddString( _T("Bold") );
	m_comboStyle.AddString( _T("Italic") );
	m_comboStyle.AddString( _T("Bold Italic") );

    // Fill the shadow offset combobox with a few offset sizes.
    // 0 is no offset.
    m_ctrlShadowOffset.ResetContent();
    m_ctrlShadowOffset.AddString("0");
    m_ctrlShadowOffset.AddString("1");
    m_ctrlShadowOffset.AddString("2");
    m_ctrlShadowOffset.AddString("3");

    long int lFont = m_comboFont.FindString(-1,m_strFont);
    if (lFont != CB_ERR)
    {
        m_comboFont.SetCurSel(lFont);
    }

    long int lSize = m_comboSize.FindString(-1,m_strSize);
    if (lSize != CB_ERR)
    {
        m_comboSize.SetCurSel(lSize);
    }
    else
    {
        bool bDone = false;
        for (int i = 0; i < m_comboSize.GetCount() && bDone == false; i++)
        {
            if (atoi(Defaults[i]) > atoi(m_strSize))
            {
                m_comboSize.InsertString(i,m_strSize);
                bDone = true;
            }
        }
        m_comboSize.SelectString(-1, m_strSize);
    }

    long int lStyle = m_comboStyle.FindString(-1,m_strStyle);
    if (lStyle != CB_ERR)
    {
        m_comboStyle.SetCurSel(lStyle);
    }

    long int lShadow = m_ctrlShadowOffset.FindString(-1,m_strShadowOffset);
    if (lShadow!= CB_ERR)
    {
        m_ctrlShadowOffset.SetCurSel(lShadow);
    }

	m_font.GetLogFont( &logfont );	
    logfont.lfStrikeOut = false;
	logfont.lfUnderline = false;
    int nFaceLength = __min(LF_FACESIZE - 1, m_strFont.GetLength());
	strncpy( logfont.lfFaceName, m_strFont, nFaceLength );
    logfont.lfFaceName[nFaceLength] = '\0';

	logfont.lfHeight = -MulDiv(atoi(m_strSize), m_lPixelsPerInch, 72);	 
	logfont.lfWidth = 0;			
	logfont.lfWeight = 400;			
    //Regular	
    logfont.lfItalic = FALSE;
	if( m_strStyle.Find( _T("Italic") ) != -1 )		
    {
        logfont.lfItalic = TRUE;
    }

	if( m_strStyle.Find( _T("Bold") ) != -1 )		
    {
        logfont.lfWeight = 700;
    }

	m_font.DeleteObject();	
    m_font.CreateFontIndirect( &logfont );
  	m_staticSample.SetFont(&m_font);	

    // Initialize the global font combo control
    m_comboGlobals.ResetContent();
    HKEY hKey;
    RegOpenKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\FlightSafety\\FSISuite\\Settings"), 0, KEY_READ, &hKey);
    if (hKey != NULL)
    {
        long int lGlobalFontCount = 0;
        long int lGlobalFontStep = 1;
        unsigned long int ulData = 0;
        DWORD dwSize = sizeof (unsigned long int);
        RegQueryValueEx(hKey, _T("GlobalFontCount"), NULL, NULL, (BYTE*)&ulData, 
                        &dwSize);
        lGlobalFontCount = ulData;

        CString strGlobalFontXXX;

        for (; lGlobalFontStep <= lGlobalFontCount; lGlobalFontStep++)
        {
            strGlobalFontXXX.Format("GlobalFont%d",lGlobalFontStep);

            // Get the name of the GlobalFont.
		    CString strValue;
		    DWORD dwType, dwCount;
		    LONG lResult = RegQueryValueEx(hKey, (LPCTSTR)strGlobalFontXXX, 
                                           NULL, &dwType, NULL, &dwCount);
		    if (lResult == ERROR_SUCCESS)
		    {
			    ASSERT(dwType == REG_SZ);
			    lResult = RegQueryValueEx(hKey, (LPCTSTR)strGlobalFontXXX, 
                                          NULL, &dwType,
				             (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)),
                                          &dwCount);

			    strValue.ReleaseBuffer();
		    }

            m_comboGlobals.AddString(strValue);
        }

        RegCloseKey(hKey);
    }

    m_comboGlobals.AddString("Not Used");
    m_comboGlobals.SelectString(-1, m_strGlobalFont);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CFontPage::OnSelChange() 
{
	// The selection hasn't changed yet, so change it	
    if( IsChild( GetFocus() ) && 
			GetFocus()->GetParent()->IsKindOf( RUNTIME_CLASS( CComboBox ) ) )	
    {
		CComboBox *cb = (CComboBox *)GetFocus()->GetParent();
        CString sText;

		if( cb->GetCurSel() != CB_ERR )		
        {			
            cb->GetLBText( cb->GetCurSel(), sText );
            cb->SetWindowText( sText );		
        }	
    }	
    
    UpdateData(TRUE);		
    
    if (m_ctrlShadowOffset.GetCurSel() != CB_ERR)
    {
	    m_ctrlShadowOffset.GetLBText(m_ctrlShadowOffset.GetCurSel(), 
                                     m_strShadowOffset);
    }

    m_ucShadowOffset = (unsigned char)atoi(m_strShadowOffset);

    LOGFONT logfont;
	m_font.GetLogFont( &logfont );	
    logfont.lfStrikeOut = false;
	logfont.lfUnderline = false;

    if (m_comboFont.GetCurSel() != CB_ERR)
    {
        m_comboFont.GetLBText(m_comboFont.GetCurSel(),m_strFont);
    }

    int nFaceLength = __min(LF_FACESIZE - 1, m_strFont.GetLength());
	strncpy( logfont.lfFaceName, m_strFont, nFaceLength );
    logfont.lfFaceName[nFaceLength] = '\0';

    if (m_comboSize.GetCurSel() != CB_ERR)
    {
        m_comboSize.GetLBText(m_comboSize.GetCurSel(),m_strSize);
    }

	logfont.lfHeight = -MulDiv(atoi(m_strSize), m_lPixelsPerInch, 72);	 
	logfont.lfWidth = 0;			
	logfont.lfWeight = 400;			
    //Regular	
    logfont.lfItalic = FALSE;

    if (m_comboStyle.GetCurSel() != CB_ERR)
    {
        m_comboStyle.GetLBText(m_comboStyle.GetCurSel(), m_strStyle);
    }

	if( m_strStyle.Find( _T("Italic") ) != -1 )		
    {
        logfont.lfItalic = TRUE;
    }

	if( m_strStyle.Find( _T("Bold") ) != -1 )		
    {
        logfont.lfWeight = 700;
    }

	m_font.DeleteObject();	
    m_font.CreateFontIndirect( &logfont );
 	m_staticSample.SetFont(&m_font);	

    if (m_strGlobalFontName != m_strFont || m_strGlobalStyle != m_strStyle ||
        m_strGlobalSize != m_strSize || m_strGlobalOffset != m_strShadowOffset)
    {
        m_comboGlobals.SelectString(-1,"Not Used");
    }
}

int CALLBACK CFontPage::FontEnumProc(ENUMLOGFONTEX *lpelfe, 
                                     NEWTEXTMETRICEX *lpntme, 
		                             int FontType, CFontPage* pFontPage )
{
    CComboBox* pComboBox = &(pFontPage->m_comboFont);
	if( pComboBox->FindStringExact( 0, (LPCTSTR)lpelfe->elfFullName ) == 
					CB_ERR )	
    {		
        // Add to list
		pComboBox->AddString( (LPCTSTR)lpelfe->elfFullName );	
    } 	

    return 1;
}

void CFontPage::GetCurrentFont(LPLOGFONT lplf)
{	
    m_font.GetLogFont( lplf );
}

void CFontPage::OnSelchangeGlobalFonts() 
{
	// TODO: Add your control notification handler code here
    UpdateData(TRUE);		

    HKEY hKey;
    RegOpenKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\FlightSafety\\FSISuite\\Settings"), 0, KEY_READ, &hKey);

    CString strSelection;
    if (m_comboGlobals.GetCurSel() != CB_ERR)
    {
	    m_comboGlobals.GetLBText(m_comboGlobals.GetCurSel(), 
                                 strSelection);
    }

    CString strFont = "";
    if (hKey != NULL)
    {
		CString strValue = "";
        DWORD dwType, dwCount;
        LONG lResult;


		lResult = RegQueryValueEx(hKey, strSelection, 
                                       NULL, &dwType, NULL, &dwCount);
		if (lResult == ERROR_SUCCESS)
		{
			ASSERT(dwType == REG_SZ);
			lResult = RegQueryValueEx(hKey, strSelection, NULL, 
                                      &dwType,
				            (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)),
                                      &dwCount);

			strValue.ReleaseBuffer();
		}
        strFont = strValue;

        RegCloseKey(hKey);
    }
	
    CString strFontName = "";
    CString strSize = "";
    CString strStyle = "";
    CString strOffset = "";

    if (strFont.Find(",") > -1)
    {
        strFontName = strFont.Left(strFont.Find(","));
        strSize = strFont.Mid(strFont.Find(",") + 1);
        if (strSize.Find(",") > -1)
        {
            strStyle = strSize.Left(strSize.Find(","));
            strSize = strSize.Mid(strSize.Find(",") + 1);
            if (strSize.Find(",") > -1)
            {
                strOffset = strSize.Mid(strSize.Find(",") + 1);
                strSize = strSize.Left(strSize.Find(","));
            }
        }
        else
        {
            strStyle = strSize;
            strSize = "8";
            strOffset = "0";
        }

        m_strGlobalStyle = strStyle;
        m_strGlobalFontName = strFontName;
        m_strGlobalSize = strSize;
        m_strGlobalOffset = strOffset;

        m_comboStyle.SelectString(-1, strStyle);
        m_comboFont.SelectString(-1, strFontName);
        m_comboSize.SelectString(-1, strSize);
        m_ctrlShadowOffset.SelectString(-1, m_strGlobalOffset);

        UpdateData(FALSE);

        OnSelChange();
    }
    else
    {
        m_strGlobalStyle = "";
        m_strGlobalFontName = "";
        m_strGlobalSize = "";
        m_strGlobalOffset = "";
    }

}
