/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : ExtentsPoint.h
//
// Date             : 26 January 2000
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.2 $
//
// Description      : ExtentsPoint.h contains the definition of a helper
//                    class for moving between the XML representation of
//                    a point and the compiler representation of a point.
//                    This is a trivial class with no dynamic memory, no
//                    virtual methods, no virtual base classes.  Thus,
//                    no copy constructor, assignment operator, or
//                    destructor is implemented.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : _FSI_STL::string. POINT, CPoint.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3, 4, or 5
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: ExtentsPoint.h $                                                                   
// Revision 1.2  2000/01/27 00:26:37  billyb                                                                   
// Added comments.  Removed unnecessary methods since                                                                   
// the class is trivial.                                                                   
/////////////////////////////////////////////////////////////////////////////
#ifndef _EXTENTSPOINT_H_
#define _EXTENTSPOINT_H_

#ifdef CORE
#define DLLAPI __declspec( dllexport )
#else
#define DLLAPI __declspec( dllimport )
#endif

#include "STLTypes.h"

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000
    
class DLLAPI CExtentsPoint
{
private:
    long int    m_lX;
    long int    m_lY;
    
protected:
    
public:
    // Constructors
    CExtentsPoint();
    explicit CExtentsPoint(const _FSI_STL::string& rstlStrExtentsPoint);
	explicit CExtentsPoint(const POINT& rPt);
    
    // Equals overload
    bool operator==(const CExtentsPoint& rExtentsPoint);

	// Conversion to CPoint
	operator CPoint();

    // Accessors
    long int X();
    long int Y();

    // Mutators
    void X(const long int& rlX);
    void Y(const long int& rlY);
};

#endif // ifndef _EXTENTSPOINT_H_
