/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : ExtentsPoint.cpp
//
// Date             : 26 January 2000
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.3 $
//
// Description      : ExtentsPoint.cpp contains the implementation of a helper
//                    class for moving between the XML representation of
//                    a point and the compiler representation of a point.
//                    This is a trivial class with no dynamic memory, no
//                    virtual methods, no virtual base classes.  Thus,
//                    no copy constructor, assignment operator, or
//                    destructor is implemented.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : _FSI_STL::string. POINT, CPoint.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3, 4, or 5
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: ExtentsPoint.cpp $                                                                   
// Revision 1.3  2000/03/07 07:23:23  billyb                                                                   
// Changed variable type to eliminate warnings.                                                                   
// Revision 1.2  2000/01/27 00:26:32  billyb                                                                   
// Added comments.  Removed unnecessary methods since                                                                   
// the class is trivial.                                                                   
/////////////////////////////////////////////////////////////////////////////
#include "stdafx.h"
#include "ExtentsPoint.h"


/////////////////////////////////////////////////////////////////////////////
//
// CExtentsPoint::CExtentsPoint()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 26 January 2000
//
// Engineer         : Billy Baker
//
// Description      : Default constructor.
//
/////////////////////////////////////////////////////////////////////////////
CExtentsPoint::CExtentsPoint()
{
    m_lX = 0;
    m_lY = 0;
}

/////////////////////////////////////////////////////////////////////////////
//
// CExtentsPoint::CExtentsPoint()
//
// Inputs           : const _FSI_STL::string& rstlStrExtentsPoint - a string 
//                                            that should contain a point as
//                                            "x,y".
//
// Return Values    : None.
//
// Date             : 26 January 2000
//
// Engineer         : Billy Baker
//
// Description      : Constructor that takes a string and parses it for two
//                    integers separated by a comma.
//
/////////////////////////////////////////////////////////////////////////////
CExtentsPoint::CExtentsPoint(const _FSI_STL::string& rstlStrExtentsPoint)
{
    unsigned int unCommaPos = rstlStrExtentsPoint.find(',');
    if (unCommaPos != rstlStrExtentsPoint.size())
    {
        m_lX = atol(rstlStrExtentsPoint.substr(0,unCommaPos).c_str());
        m_lY = atol(rstlStrExtentsPoint.substr(unCommaPos+1).c_str());
    }
}

/////////////////////////////////////////////////////////////////////////////
//
// CExtentsPoint::CExtentsPoint()
//
// Inputs           : const POINT& rPt - a Windows POINT struct
//
// Return Values    : None.
//
// Date             : 26 January 2000
//
// Engineer         : Billy Baker
//
// Description      : Constructor that uses a POINT strut to initialize the
//                    member variables.
//
/////////////////////////////////////////////////////////////////////////////
CExtentsPoint::CExtentsPoint(const POINT& rPt)
{
    m_lX = rPt.x;
    m_lY = rPt.y;
}

/////////////////////////////////////////////////////////////////////////////
//
// CExtentsPoint::operator ==()
//
// Inputs           : const CExtentsPoint& rExtentsPoint - another 
//                                         CExtentsPoint instance to compare
//                                         this against.
//
// Return Values    : true is equal, otherwise false.
//
// Date             : 26 January 2000
//
// Engineer         : Billy Baker
//
// Description      : Operator for telling if two CExtentsPoints instances are
//                    equal.
//
/////////////////////////////////////////////////////////////////////////////
bool CExtentsPoint::operator ==(const CExtentsPoint& rExtentsPoint)
{
    bool bRetVal = true;

    if (m_lX != rExtentsPoint.m_lX ||
        m_lY != rExtentsPoint.m_lY )
    {
        bRetVal = false;
    }

    return bRetVal;
}

/////////////////////////////////////////////////////////////////////////////
//
// CExtentsPoint::operator CPoint()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 26 January 2000
//
// Engineer         : Billy Baker
//
// Description      : Operator for converting between a CExtentsPoint and an
//                    MFC CPoint.
//
/////////////////////////////////////////////////////////////////////////////
CExtentsPoint::operator CPoint()
{
	return CPoint(m_lX, m_lY);
}

//////////////////////////////////////////////////////////////////////
// Accessors
//////////////////////////////////////////////////////////////////////
long int CExtentsPoint::X()
{
    return m_lX;
}

long int CExtentsPoint::Y()
{
    return m_lY;
}

//////////////////////////////////////////////////////////////////////
// Mutators
//////////////////////////////////////////////////////////////////////
void CExtentsPoint::X(const long int& rlX)
{
    m_lX = rlX;
}

void CExtentsPoint::Y(const long int& rlY)
{
    m_lY = rlY;
}
