// ExtentsPage.cpp : implementation file
//

#include "stdafx.h"
#include "ExtentsPage.h"

#include "Widget.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CExtentsPage property page

CExtentsPage::CExtentsPage() : CBasePage(CExtentsPage::IDD)
{
	//{{AFX_DATA_INIT(CExtentsPage)
	m_lUpperLeftX = 0;
	m_lUpperLeftY = 0;
	m_lHeight = 0;
	m_lWidth = 0;
	m_strWidgetName = _T("");
	//}}AFX_DATA_INIT
    m_stlStrPageName = _FSI_STL::string("Name and Extents");
}

void CExtentsPage::DoDataExchange(CDataExchange* pDX)
{
	CBasePage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CExtentsPage)
	DDX_Text(pDX, IDC_UPPERLEFT_X, m_lUpperLeftX);
	DDV_MinMaxInt(pDX, m_lUpperLeftX, 0, 8192);
	DDX_Text(pDX, IDC_UPPERLEFT_Y, m_lUpperLeftY);
	DDV_MinMaxInt(pDX, m_lUpperLeftY, 0, 8192);
	DDX_Text(pDX, IDC_NAME, m_strWidgetName);
	DDX_Text(pDX, IDC_HEIGHT, m_lHeight);
	DDX_Text(pDX, IDC_WIDTH, m_lWidth);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CExtentsPage, CBasePage)
	//{{AFX_MSG_MAP(CExtentsPage)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CExtentsPage message handlers
CBasePage* CExtentsPage::CreateObject()
{
    return new CExtentsPage;
}

void CExtentsPage::SetProperties(void* pWidget)
{
    CWidget* pParentWidget = reinterpret_cast<CWidget*>(pWidget);

    if (pParentWidget != NULL)
    {
        m_lUpperLeftX   = pParentWidget->UpperLeft().X();
        m_lUpperLeftY   = pParentWidget->UpperLeft().Y();
        m_lLowerRightX  = pParentWidget->LowerRight().X();
        m_lLowerRightY  = pParentWidget->LowerRight().Y();
        m_lWidth        = m_lLowerRightX - m_lUpperLeftX;
        m_lHeight       = m_lLowerRightY - m_lUpperLeftY;
        m_strWidgetName = pParentWidget->Name().c_str();
    }
}

void CExtentsPage::UpdateProperties(void* pWidget)
{
    CWidget* pParentWidget = reinterpret_cast<CWidget*>(pWidget);

    if (pParentWidget != NULL)
    {
        CXMLWidget* pXMLWidget = pParentWidget->XMLWidget();
        if (pXMLWidget != NULL && GetSafeHwnd() != NULL)
        {
            UpdateData(TRUE);
            m_lLowerRightX = m_lUpperLeftX + m_lWidth;
            m_lLowerRightY = m_lUpperLeftY + m_lHeight;

            CString strValue;
            CXMLElement* pXMLElement = NULL;
            POSITION pos = NULL;
            if (pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("POINT")) == true)
            {
                strValue.Format("%d,%d",m_lUpperLeftX,m_lUpperLeftY);
                pXMLElement->AddElementValue(_FSI_STL::string((LPCTSTR)strValue));
            }

            // Don't reset pXMLElement here because you will get the previous point
            // back.
            if (pXMLWidget->FindElement(pXMLElement, pos,_FSI_STL::string("POINT")) == true)
            {
                strValue.Format("%d,%d",m_lLowerRightX,m_lLowerRightY);
                pXMLElement->AddElementValue(_FSI_STL::string((LPCTSTR)strValue));
            }

            CRect rect(m_lUpperLeftX, m_lUpperLeftY, 
                       m_lLowerRightX, m_lLowerRightY);

            if (pParentWidget->Wnd() != NULL)
            {
                pParentWidget->Wnd()->MoveWindow(rect);
            }

            pXMLElement = NULL;
            if (pXMLWidget->FindElement(pXMLElement, pos,_FSI_STL::string("NAME")) == true)
            {
                pXMLElement->AddElementValue(_FSI_STL::string((LPCTSTR)m_strWidgetName));
            } 
        }
    }
}

void CExtentsPage::OnWidgetPosChanged(WPARAM wParam, LPARAM lParam)
{
    CWidget* pParentWidget = reinterpret_cast<CWidget*>(lParam);

    if (pParentWidget != NULL)
    {
        SetProperties(pParentWidget);
        if (GetSafeHwnd() != NULL)
        {
            UpdateData(FALSE);
        }
    }
}

