// CoreCommsSystemInterface.h: interface for the CCoreCommsSystemInterface class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(_CORECOMMSSYSTEMINTERFACE_H_)
#define _CORECOMMSSYSTEMINTERFACE_H_

#ifdef CORE
#define DLLAPI __declspec( dllexport )
#else
#define DLLAPI __declspec( dllimport )
#endif

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "variant.h"
#include "ioaction.h"
#include "xmlpage.h"
#include "variabledata.h"

#include <string>

class DLLAPI CCoreCommsSystemInterface  
{
protected:
    // Is the comms system interface started.
    bool    m_bStarted;

    // For comms systems that use an XML page, a pointer is provided.
    CXMLPage*                           m_pXMLVariablesPage;

    _FSI_STL::list<CXMLWidget*>         m_listXMLWidgetsPersist;
    IXMLDOMDocument *                   m_pXMLDoc;

protected:
	CCoreCommsSystemInterface();

public:
	virtual ~CCoreCommsSystemInterface();

    // Accessor
    bool Started();
    
    // Mutator
    void Started(bool bStarted);

    virtual void LoadVariables(const _FSI_STL::string& rstlStrVariablesFile);
    virtual void WriteData(CVariant* pVariant, CVariableData* pVarData);
    virtual void Start();
    virtual void Stop();
};

#endif // !defined(_CORECOMMSSYSTEMINTERFACE_H_)
