// CoreCommsSystemInterface.cpp: implementation of the CCoreCommsSystemInterface class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "CoreCommsSystemInterface.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CCoreCommsSystemInterface::CCoreCommsSystemInterface()
{
    CoInitialize(NULL);
    //
    // Create an empty XML document
    //
    if (CoCreateInstance(CLSID_DOMDocument, NULL, CLSCTX_INPROC_SERVER,
                                IID_IXMLDOMDocument, (void**)&m_pXMLDoc) != S_OK)
    {
        m_pXMLDoc->Release(); 
        m_pXMLDoc = NULL;
        CoUninitialize();
    }

    VARIANT_BOOL vb = VARIANT_FALSE;

    if (m_pXMLDoc->put_validateOnParse(vb) != S_OK)
    {
        m_pXMLDoc->Release(); 
        m_pXMLDoc = NULL;
        CoUninitialize();
    }

    if (m_pXMLDoc->put_resolveExternals(vb) != S_OK)
    {
        m_pXMLDoc->Release(); 
        m_pXMLDoc = NULL;
        CoUninitialize();
    }

    if (m_pXMLDoc->put_async(vb) != S_OK)
    {
        m_pXMLDoc->Release(); 
        m_pXMLDoc = NULL;
        CoUninitialize();
    }
}

CCoreCommsSystemInterface::~CCoreCommsSystemInterface()
{
    _FSI_STL::list<CXMLWidget*>::iterator lIt = m_listXMLWidgetsPersist.begin();
    for (; lIt != m_listXMLWidgetsPersist.end(); lIt++)
    {
        delete (*lIt);
    }
    m_listXMLWidgetsPersist.clear();

    if (m_pXMLDoc != NULL)
    {
        m_pXMLDoc->Release(); 
        m_pXMLDoc = NULL;
        CoUninitialize();
    }
}


/////////////////////////////////////////////////////////////////////////////
//
// bool CCoreCommsSystemInterface::Started()
//
// Inputs           : None.
//
// Return Values    : true - the comms system is started
//                    false - the comms system is stopped
//
// Date             : 09 February 1999
//
// Engineer         : Billy Baker
//
// Description      : Started() is an accessor method to get whether 
//                    the comms system is started.
//
/////////////////////////////////////////////////////////////////////////////
bool CCoreCommsSystemInterface::Started()
{
    return m_bStarted;
}

/////////////////////////////////////////////////////////////////////////////
//
// void CCoreCommsSystemInterface::Started()
//
// Inputs           : bool bStarted - a new value for the running state of the
//                                    comms system.
//
// Return Values    : None.
//
// Date             : 09 February 1999
//
// Engineer         : Billy Baker
//
// Description      : Started() is a mutator method to set whether 
//                    the comms system is started.
//
/////////////////////////////////////////////////////////////////////////////
void CCoreCommsSystemInterface::Started(bool bStarted)
{
    m_bStarted = bStarted;
}

void CCoreCommsSystemInterface::LoadVariables(const _FSI_STL::string& rstlStrVariablesFile) 
{
}

void CCoreCommsSystemInterface::WriteData(CVariant* pVariant, CVariableData* pVarData) 
{
}

void CCoreCommsSystemInterface::Start() 
{
}

void CCoreCommsSystemInterface::Stop() {
}
