// ComponentPathAliasPage.cpp : implementation file
//

#include "stdafx.h"
#include "ComponentPathAliasPage.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CComponentPathAliasPage property page

CComponentPathAliasPage::CComponentPathAliasPage() : 
                                        CBasePage(CComponentPathAliasPage::IDD)
{
	//{{AFX_DATA_INIT(CComponentPathAliasPage)
	m_strAlias = _T("");
	m_strPathAlias = _T("");
	//}}AFX_DATA_INIT
    m_stlStrPageName = _FSI_STL::string("Component Path Aliases");
}

void CComponentPathAliasPage::DoDataExchange(CDataExchange* pDX)
{
	CBasePage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CComponentPathAliasPage)
	DDX_Control(pDX, IDC_ALIASES_LIST, m_ctrlAliasList);
	DDX_Text(pDX, IDC_ALIAS, m_strAlias);
	DDX_Text(pDX, IDC_PATH_ALIAS, m_strPathAlias);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CComponentPathAliasPage, CBasePage)
	//{{AFX_MSG_MAP(CComponentPathAliasPage)
	ON_BN_CLICKED(IDC_ADD_ALIAS_BUTTON, OnAddAlias)
	ON_BN_CLICKED(IDC_CHANGE_ALIAS_BUTTON, OnChangeAlias)
	ON_BN_CLICKED(IDC_DELETE_ALIAS_BUTTON, OnDeleteAlias)
	ON_NOTIFY(NM_CLICK, IDC_ALIASES_LIST, OnClickAliasesList)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CComponentPathAliasPage message handlers
CBasePage* CComponentPathAliasPage::CreateObject()
{
    return new CComponentPathAliasPage;
}

void CComponentPathAliasPage::SetProperties(void* pWidget)
{
    CString strComponentName = CString((char *)pWidget);
    HKEY hKey;
    RegOpenKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\FlightSafety\\FSISuite\\") + strComponentName, 0, KEY_READ, &hKey);
    if (hKey != NULL)
    {
        long int lAliasCount = 0;
        long int lAliasStep = 1;
        unsigned long int ulData = 0;
        DWORD dwSize = sizeof (unsigned long int);
        RegQueryValueEx(hKey, _T("AliasCount"), NULL, NULL, (BYTE*)&ulData, 
                        &dwSize);
        lAliasCount = ulData;

        CString strAliasXXX;
        CString strAliasPath;
        CString strAliasName;

        for (; lAliasStep <= lAliasCount; lAliasStep++)
        {
            strAliasXXX.Format("Alias%d",lAliasStep);

            // Get the name of the alias.
		    CString strValue;
		    DWORD dwType, dwCount;
		    LONG lResult = RegQueryValueEx(hKey, (LPCTSTR)strAliasXXX, 
                                           NULL, &dwType, NULL, &dwCount);
		    if (lResult == ERROR_SUCCESS)
		    {
			    ASSERT(dwType == REG_SZ);
			    lResult = RegQueryValueEx(hKey, (LPCTSTR)strAliasXXX, NULL, 
                                          &dwType,
				                (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)),
                                          &dwCount);

			    strValue.ReleaseBuffer();
		    }

            strAliasName = strValue;

            // Get the path for the alias
            if (strAliasName != "")
            {
                // Code copied from GetProfileString() in CWinApp 
                // implementation.
		        lResult = RegQueryValueEx(hKey, (LPCTSTR)strAliasName, 
                                               NULL, &dwType, NULL, &dwCount);
		        if (lResult == ERROR_SUCCESS)
		        {
			        ASSERT(dwType == REG_SZ);
			        lResult = RegQueryValueEx(hKey, (LPCTSTR)strAliasName, 
                                              NULL, &dwType,
				             (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)),
                                              &dwCount);

			        strValue.ReleaseBuffer();
		        }

                strAliasPath = strValue;

                m_mapAliasToPath[(LPCTSTR)strAliasName] = 
                                            _FSI_STL::string((LPCTSTR)strAliasPath);
            }

        }

        RegCloseKey(hKey);
    }
}

void CComponentPathAliasPage::UpdateProperties(void* pWidget)
{
    if (GetSafeHwnd() == NULL)
    {
        return;
    }

    CString strComponentName = CString((char *)pWidget);
    HKEY hKey;
    DWORD dw;
    RegCreateKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\FlightSafety\\FSISuite\\") + strComponentName,
                 0, NULL, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey, &dw);

    if (hKey != NULL)
    {
        UpdateData(TRUE);
        long int lAliasCount = m_ctrlAliasList.GetItemCount();
        long int lAliasStep = 0;
        unsigned long int ulData = lAliasCount;
        DWORD dwSize = sizeof (unsigned long int);
        RegSetValueEx(hKey, _T("AliasCount"), NULL, REG_DWORD, (BYTE*)&ulData, 
                        dwSize);

        CString strAliasXXX;
        CString strAliasPath;
        CString strAliasName;

        for (; lAliasStep < lAliasCount; lAliasStep++)
        {
            strAliasXXX.Format("Alias%d",lAliasStep+1);
            strAliasName = m_ctrlAliasList.GetItemText(lAliasStep,0);

            RegSetValueEx(hKey, (LPCTSTR)strAliasXXX, NULL, REG_SZ, 
                            (BYTE*)(LPCTSTR)strAliasName, 
                            strAliasName.GetLength() + 1);

            strAliasPath = m_ctrlAliasList.GetItemText(lAliasStep,1);

            RegSetValueEx(hKey, (LPCTSTR)strAliasName, NULL, REG_SZ, 
                            (BYTE*)(LPCTSTR)strAliasPath, 
                            strAliasPath.GetLength() + 1);
        }

        RegCloseKey(hKey);
    }
}

BOOL CComponentPathAliasPage::OnInitDialog() 
{
	CBasePage::OnInitDialog();

    m_ctrlAliasList.SetExtendedStyle(m_ctrlAliasList.GetExtendedStyle() & 
                                     LVS_EX_FULLROWSELECT);

    m_ctrlAliasList.InsertColumn(0,"Alias", LVCFMT_LEFT, 100);
    m_ctrlAliasList.InsertColumn(1, "Path", LVCFMT_LEFT, 500);
	
	// TODO: Add extra initialization here
    STRING2STRING_MAP::iterator mIt = m_mapAliasToPath.begin();
    long int lAliasStep = 0;
    for (; mIt != m_mapAliasToPath.end(); mIt++, lAliasStep++)
    {
        m_ctrlAliasList.InsertItem(lAliasStep, (*mIt).first.c_str());
        m_ctrlAliasList.SetItemText(lAliasStep, 1, (*mIt).second.c_str());
    }

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CComponentPathAliasPage::OnAddAlias() 
{
	// TODO: Add your control notification handler code here
    UpdateData(TRUE);
    
    if (m_strAlias.GetLength() > 0)
    {
        LVFINDINFO lvfi;
        lvfi.flags = LVFI_STRING;
        lvfi.psz = (LPCTSTR)m_strAlias;
        if (m_ctrlAliasList.FindItem(&lvfi,-1) == -1)
        {
            long int lItemCount = m_ctrlAliasList.GetItemCount();
            lItemCount = m_ctrlAliasList.InsertItem(lItemCount, 
													(LPCTSTR)m_strAlias);
            m_ctrlAliasList.SetItemText(lItemCount, 1, 
										(LPCTSTR)m_strPathAlias);
        }
        else
        {
            ::MessageBox(GetSafeHwnd(), 
                         _T("Duplicate string encountered for alias name."),
                         _T("Error"), 
                         MB_OK);
        }
    }
    else
    {
        ::MessageBox(GetSafeHwnd(),
                     _T("Null string encountered for alias name."),
                     _T("Error"),
                     MB_OK);
    }
}

void CComponentPathAliasPage::OnChangeAlias() 
{
	// TODO: Add your control notification handler code here
    UpdateData(TRUE);

    if (m_strAlias.GetLength() > 0)
    {
        LVFINDINFO lvfi;
        lvfi.flags = LVFI_STRING;
        lvfi.psz = (LPCTSTR)m_strAlias;
        long int lAliasIndex = m_ctrlAliasList.FindItem(&lvfi,-1);
        if (lAliasIndex > -1)
        {
            m_ctrlAliasList.SetItemText(lAliasIndex, 1, m_strPathAlias);
        }
        else
        {
            ::MessageBox(GetSafeHwnd(), 
                         _T("Alias name could not be found to change path data."),
                         _T("Error"), 
                         MB_OK);
            return;
        }
    }
    else
    {
        ::MessageBox(GetSafeHwnd(),
                     _T("Null string encountered for alias name."),
                     _T("Error"),
                     MB_OK);
    }
}

void CComponentPathAliasPage::OnDeleteAlias() 
{
	// TODO: Add your control notification handler code here
    UpdateData(TRUE);

    if (m_strAlias.GetLength() > 0)
    {
        LVFINDINFO lvfi;
        lvfi.flags = LVFI_STRING;
        lvfi.psz = (LPCTSTR)m_strAlias;
        long int lAliasIndex = m_ctrlAliasList.FindItem(&lvfi,-1);
        if (lAliasIndex > -1)
        {
            m_ctrlAliasList.DeleteItem(lAliasIndex);
        }
        else
        {
            ::MessageBox(GetSafeHwnd(), 
                         _T("Alias name could not be found to delete alias "
                            "and path data."),
                         _T("Error"), 
                         MB_OK);
            return;
        }
    }
    else
    {
        ::MessageBox(GetSafeHwnd(),
                     _T("Null string encountered for alias name."),
                     _T("Error"),
                     MB_OK);
    }
}

void CComponentPathAliasPage::OnClickAliasesList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
    POSITION pos = m_ctrlAliasList.GetFirstSelectedItemPosition();
    if (pos != NULL)
    {
        long int lSelectedIndex = m_ctrlAliasList.GetNextSelectedItem(pos);
        CString strAliasName = m_ctrlAliasList.GetItemText(lSelectedIndex, 0);
        CString strPathAlias = m_ctrlAliasList.GetItemText(lSelectedIndex, 1);

        m_strAlias = strAliasName;
        m_strPathAlias = strPathAlias;

        UpdateData(FALSE);
    }

	*pResult = 0;
}
