/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : ComponentInterface.h
//
// Date             : 13 September 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.4 $
//
// Description      : ComponentInterface.h contains the definition of 
//                    the CComponentInterface class.  Each component 
//                    DLL that is loaded into the FSISuite application 
//                    must implement a class derived from 
//                    CComponentInterface in order for the DLL to be 
//                    loaded.  The purpose of this class is to allow 
//                    the FSISuite application to determine what 
//                    widgets, actions, and property pages are 
//                    implemented in the DLL.  Also, any per component 
//                    setup information that is stored in the registry 
//                    is available from the CComponentInterface class.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : _FSI_STL::string, _FSI_STL::list, CBitmap, 
//                    Core::CWidget, Core::CBasePage, STRING2STRING_MAP.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3, 4, or 5
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: ComponentInterface.h $                                                                   
// Revision 1.4  2000/06/08 06:44:35  billyb                                                                   
// Added InitComplete for after all DLLs have been loaded.                                                                   
// Revision 1.3  2000/05/04 16:47:31  billyb                                                                   
// Added support for different bottom collars for the same                                                                    
// component when running in multimonitor mode.                                                                   
// Revision 1.2  1999/09/13 17:01:45  billyb                                                                   
// Added comments.  Changed the way that the main and                                                                   
// secondary component specific files are handled.  The                                                                   
// name of the file is return now instead of a CXMLPage*.                                                                   
// The mainframe will now parse the file wihenever it                                                                   
// needs to display the files.                                                                   
/////////////////////////////////////////////////////////////////////////////
#ifndef _COMPONENTINTERFACE_H_
#define _COMPONENTINTERFACE_H_

#ifdef CORE
#define DLLAPI __declspec( dllexport )
#else
#define DLLAPI __declspec( dllimport )
#endif

#include "STLTypes.h"
#include "Action.h"
#include "Widget.h"
#include "BasePage.h"
#include "XMLPage.h"

// A typedef to streamline the data structures.  This typedef is for the
// method that creates a new widget.
typedef CWidget* (*CreateObject)();         
typedef CBasePage* (*CreatePage)();         
typedef CWidget* (*CreateAction)();
typedef void (*AfterInitCallback)();

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class DLLAPI CComponentInterface  
{
private:
    HINSTANCE            m_hDll;

protected:
    _FSI_STL::string                m_stlStrComponentName;
    _FSI_STL::string                m_stlStrPathName;
    _FSI_STL::string                m_stlStrVersion;
    _FSI_STL::string                m_stlStrDate;
    STRING2STRING_MAP               m_mapDirectories;
    _FSI_STL::list<CreateAction>    m_listActions;
    _FSI_STL::list<CreatePage>      m_listPropPages;
    _FSI_STL::list<CreateObject>    m_listWidgetCtrls;
    _FSI_STL::list<CBitmap*>        m_listWidgetImages;
    _FSI_STL::list<CBitmap*>        m_listActionImages;
    STRING_LIST                     m_listAvailableWidgets;

    bool                            m_bOnEditBar;
    bool                            m_bOnComponentBar;
    _FSI_STL::string                m_stlStrMainPageFile;
    _FSI_STL::map<int, _FSI_STL::string> m_mapComponentSpecificPages;
    _FSI_STL::map<int, _FSI_STL::string> m_mapSecondaryPages;
    _FSI_STL::map<int, _FSI_STL::string> m_mapMainPages;

    virtual void        InitializeComponentConfig();

public:
    explicit CComponentInterface(const _FSI_STL::string& rstlStrComponentName = 
                                                   _FSI_STL::string("Unknown"),
                                 const _FSI_STL::string& rstlStrPathName =
                                                   _FSI_STL::string("Unknown"));
    virtual  ~CComponentInterface();

	virtual _FSI_STL::list<CreateAction>* Actions();
	virtual _FSI_STL::list<CreatePage>* PropPages();
	virtual _FSI_STL::list<CreateObject>* WidgetCtrls();
    virtual _FSI_STL::list<CBitmap*>* WidgetImages();
    virtual _FSI_STL::list<CBitmap*>* ActionImages();

    // Accessor
    _FSI_STL::string ComponentName();
    _FSI_STL::string PathName();
    _FSI_STL::string Version();
    HINSTANCE DLLHandle();
    _FSI_STL::string RevisionDate();
    bool OnEditBar();
    bool OnComponentBar();
    _FSI_STL::string MainPageFile(const unsigned char ucWindowNumber);
    _FSI_STL::string ComponentSpecificPage(const unsigned char ucWindowNumber);
    _FSI_STL::string SecondaryComponentSpecificPage(const unsigned char ucWindowNumber);
    STRING2STRING_MAP* Directories();


    // Mutator
    void PathName(const _FSI_STL::string& rstlStrPathName);
    void DLLHandle(const HINSTANCE rhDLL);
    void OnEditBar (const bool bOnEditBar);
    void OnComponentBar(const bool bOnBar);
    void MainPageFile(const _FSI_STL::string& rstlStrMainPageFile);

    virtual bool EditPageMode();
    void LoadComponentConfig();
    void AddAvailableWidget(const _FSI_STL::string rstlStrWidget);

    virtual void CleanComponentResources();
    virtual void InitComplete();

    virtual void AfterInitComplete();
};

typedef _FSI_STL::map<_FSI_STL::string,CComponentInterface*> STRING2CI_MAP;

#endif // #ifndef _COMPONENTINTERFACE_H_
