/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : ComponentInterface.cpp
//
// Date             : 13 September 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.5 $
//
// Description      : ComponentInterface.cpp contains the implementation of 
//                    the CComponentInterface class.  Each component 
//                    DLL that is loaded into the FSISuite application 
//                    must implement a class derived from 
//                    CComponentInterface in order for the DLL to be 
//                    loaded.  The purpose of this class is to allow 
//                    the FSISuite application to determine what 
//                    widgets, actions, and property pages are 
//                    implemented in the DLL.  Also, any per component 
//                    setup information that is stored in the registry 
//                    is available from the CComponentInterface class.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : _FSI_STL::string, _FSI_STL::list, CBitmap, 
//                    Core::CWidget, Core::CBasePage, STRING2STRING_MAP.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3, 4, or 5
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: ComponentInterface.cpp $                                                                   
// Revision 1.5  2000/06/08 06:44:24  billyb                                                                   
// Added InitComplete for after all DLLs have been loaded.                                                                   
// Revision 1.4  2000/05/04 16:47:31  billyb                                                                   
// Added support for different bottom collars for the same                                                                    
// component when running in multimonitor mode.                                                                   
// Revision 1.3  1999/10/14 19:20:45  billyb                                                                   
// Removed unneeded include of XMLParser5.h.                                                                   
// Revision 1.2  1999/09/13 17:01:43  billyb                                                                   
// Added comments.  Changed the way that the main and                                                                   
// secondary component specific files are handled.  The                                                                   
// name of the file is return now instead of a CXMLPage*.                                                                   
// The mainframe will now parse the file wihenever it                                                                   
// needs to display the files.                                                                   
/////////////////////////////////////////////////////////////////////////////
#include "stdafx.h"
#include "ComponentInterface.h"

#include "ComponentConfigPage.h"
#include "ComponentPathAliasPage.h"

#include "StringSplit.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CComponentInterface::CComponentInterface(
                                       const _FSI_STL::string& rstlStrComponentName,
                                       const _FSI_STL::string& rstlStrPathName)
{
    m_stlStrComponentName           = rstlStrComponentName;
    m_stlStrVersion                 = _FSI_STL::string("-1.0");
    m_stlStrPathName                = rstlStrPathName;
    m_stlStrDate                    = _FSI_STL::string(__DATE__);
    m_bOnEditBar                    = false;
    m_bOnComponentBar               = false;
    m_listPropPages.push_back(CComponentConfigPage::CreateObject);
    m_listPropPages.push_back(CComponentPathAliasPage::CreateObject);
}

CComponentInterface::~CComponentInterface()
{
    m_mapDirectories.clear();
    m_listPropPages.clear();
    m_listWidgetCtrls.clear();
    m_listActions.clear();

    _FSI_STL::list<CBitmap*>::iterator bmpIt = m_listWidgetImages.begin();
    for (; bmpIt != m_listWidgetImages.end(); bmpIt++)
    {
        delete *bmpIt;
    }
    m_listWidgetImages.clear();

    bmpIt = m_listActionImages.begin();
    for (; bmpIt != m_listActionImages.end(); bmpIt++)
    {
        delete *bmpIt;
    }
    m_listActionImages.clear();
}

_FSI_STL::string CComponentInterface::ComponentName()
{
    return m_stlStrComponentName;
}

HINSTANCE CComponentInterface::DLLHandle()
{
    return m_hDll;
}

void CComponentInterface::DLLHandle(const HINSTANCE rhDLL)
{
    m_hDll = (HINSTANCE)rhDLL;
}

_FSI_STL::string CComponentInterface::PathName()
{
    return m_stlStrPathName;
}

void CComponentInterface::PathName(const _FSI_STL::string& rstlStrPathName)
{
    m_stlStrPathName = rstlStrPathName;
}

_FSI_STL::string CComponentInterface::Version()
{
    return m_stlStrVersion;
}

_FSI_STL::string CComponentInterface::RevisionDate()
{
    return m_stlStrDate;
}

/////////////////////////////////////////////////////////////////////////////
//
// _FSI_STL::list<CreatePage>* CComponentInterface::PropPages()
//
// Inputs           : None.
//
// Return Values    : A memory location for a list of pointers to option pages.
//
// Date             : 19 October 1998
//
// Engineer         : Billy Baker
//
// Description      : PropPages creates a list of pointers to option 
//                    pages and returns a pointer to this list.
//
/////////////////////////////////////////////////////////////////////////////
_FSI_STL::list<CreatePage>* CComponentInterface::PropPages()
{
	return &m_listPropPages;
}

/////////////////////////////////////////////////////////////////////////////
//
// _FSI_STL::list<CreateObject>* CComponentInterface::WidgetCtrls()
//
// Inputs           : None.
//
// Return Values    : A memory location for a list of pointers.
//
// Date             : 19 October 1998
//
// Engineer         : Billy Baker
//
// Description      : WidgetCtrls returns a pointer to a list.
//
/////////////////////////////////////////////////////////////////////////////
_FSI_STL::list<CreateObject>* CComponentInterface::WidgetCtrls()
{
	return &m_listWidgetCtrls;
}

/////////////////////////////////////////////////////////////////////////////
//
// _FSI_STL::list<CreateAction>* CComponentInterface::Actions()
//
// Inputs           : None.
//
// Return Values    : A memory location for a list of pointers.
//
// Date             : 10 December 1998
//
// Engineer         : Billy Baker
//
// Description      : Actions returns a pointer to a list pointers to create
//                    actions implemented in the library.
//
/////////////////////////////////////////////////////////////////////////////
_FSI_STL::list<CreateAction>* CComponentInterface::Actions()
{
	return &m_listActions;
}

_FSI_STL::list<CBitmap*>* CComponentInterface::ActionImages()
{
    return &m_listActionImages;
}

_FSI_STL::list<CBitmap*>* CComponentInterface::WidgetImages()
{
    return &m_listWidgetImages;
}

bool CComponentInterface::OnEditBar()
{
    return m_bOnEditBar;
}

bool CComponentInterface::OnComponentBar()
{
    return m_bOnComponentBar;
}

_FSI_STL::string CComponentInterface::MainPageFile(const unsigned char ucWindowNumber)
{
    return m_mapMainPages[ucWindowNumber];
}

STRING2STRING_MAP* CComponentInterface::Directories()
{
    return &m_mapDirectories;
}

void CComponentInterface::OnEditBar(const bool bOnEditBar)
{
    m_bOnEditBar = bOnEditBar;
}

void CComponentInterface::OnComponentBar(const bool bOnBar)
{
    m_bOnComponentBar = bOnBar;
}

void CComponentInterface::MainPageFile(const _FSI_STL::string& rstlStrMainPageFile)
{
    m_stlStrMainPageFile = rstlStrMainPageFile;
}

bool CComponentInterface::EditPageMode()
{
    return false;
}

void CComponentInterface::CleanComponentResources()
{
}

void CComponentInterface::InitializeComponentConfig()
{
   HKEY hKey;
   RegOpenKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\FlightSafety\\FSISuite\\") + CString(m_stlStrComponentName.c_str()), 0, KEY_READ, &hKey);

   if (hKey != NULL)
   {
      unsigned long int ulData   =  0;
      DWORD dwSize   =  sizeof (unsigned long int);
      RegQueryValueEx(hKey, _T("OnEditBar"), NULL, NULL, (BYTE*)&ulData, &dwSize);
      if (ulData  == 0)
         m_bOnEditBar = false;
      else
         m_bOnEditBar = true;


      ulData   =  0;
      RegQueryValueEx(hKey, _T("OnComponentBar"), NULL, NULL, (BYTE*)&ulData, &dwSize);
      if (ulData  == 0)
         m_bOnComponentBar = false;
      else
         m_bOnComponentBar = true;


      CString  strValue;
      DWORD    dwType, dwCount;
      LONG     lResult;

      strValue = "";
      long int lMainPageCount =  0;
      long int lMainPageStep  =  1;
      ulData   =  0;
      dwSize   =  sizeof (unsigned long int);
      RegQueryValueEx(hKey, _T("MainPageCount"), NULL, NULL, (BYTE*)&ulData, &dwSize);
      lMainPageCount  =  ulData;
      CString  strMainPageXXX;

      while (lMainPageStep  <= lMainPageCount)
      {
         strMainPageXXX.Format("MainPage%d",lMainPageStep);

         // Get the name of the GlobalFont.
         DWORD dwType, dwCount;
         LONG  lResult  =  RegQueryValueEx(hKey, (LPCTSTR)strMainPageXXX, NULL, &dwType, NULL, &dwCount);

         if (lResult == ERROR_SUCCESS)
         {
            ASSERT(dwType == REG_SZ);
            lResult = RegQueryValueEx(hKey, (LPCTSTR)strMainPageXXX, NULL, &dwType, (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)), &dwCount);
            strValue.ReleaseBuffer();
         }

         if (strValue.Find(",") > -1)
         {
            int   nScreen  =  atoi(strValue.Left(strValue.Find(",")));
            strValue       =  strValue.Mid(strValue.Find(",") + 1);
            m_mapMainPages[nScreen] =  _FSI_STL::string((LPCTSTR)strValue);
         }

         lMainPageStep++;
      }



      lResult  =  RegQueryValueEx(hKey, _T("ComponentSpecificPageFile"), NULL, &dwType, NULL, &dwCount);
      if (lResult == ERROR_SUCCESS)
      {
         ASSERT(dwType  == REG_SZ);
         lResult  =  RegQueryValueEx(hKey, _T("ComponentSpecificPageFile"), NULL, &dwType, (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)), &dwCount);
         strValue.ReleaseBuffer();
      }

      _FSI_STL::string vCollar0 ((LPCTSTR)strValue);
      m_mapComponentSpecificPages[0]  =  vCollar0;

      if (!vCollar0.empty())
      {
         _FSI_STL::vector<_FSI_STL::string> vCollars;  // We're putting the two left collars on the same config place,
         StringSplit(vCollars, vCollar0, ";");         // separated by semicolons.  For instance "left.fml;left1.fml".
                                                       // So, split the string and send the config to each of the
                                                       // left collars. -MFL 3/14/2014
         for (int k=0;k<vCollars.size();k++)
         {
            m_mapComponentSpecificPages[k] = vCollars[k];
         }

         if (m_mapComponentSpecificPages[1].empty())       // Supply missing 2nd left collar if not specified in the config.
         {                                                 // This is a patch for ECP-153.  -MFL 3/14/2014
            _FSI_STL::string vCollar1 (vCollar0);
            for (int j=0;j<4;j++) vCollar1.pop_back();     //    remove ".fml"
            vCollar1 += "1.fml";                           //    append "1" and restore the ".fml"
            m_mapComponentSpecificPages[1] = vCollar1;
         }
      }

      strValue = "";
      long int lHorizontalCollarCount  =  0;
      long int lHorizontalCollarStep   =  1;
      ulData   =  0;
      dwSize   =  sizeof (unsigned long int);
      RegQueryValueEx(hKey, _T("HorizontalCollarCount"), NULL, NULL, (BYTE*)&ulData, &dwSize);
      lHorizontalCollarCount  =  ulData;
      CString  strHCollarXXX;

      while (lHorizontalCollarStep  <= lHorizontalCollarCount)
      {
         strHCollarXXX.Format("HorizontalCollar%d",lHorizontalCollarStep);

         // Get the name of the GlobalFont.
         DWORD dwType, dwCount;
         LONG  lResult  =  RegQueryValueEx(hKey, (LPCTSTR)strHCollarXXX, NULL, &dwType, NULL, &dwCount);

         if (lResult == ERROR_SUCCESS)
         {
            ASSERT(dwType == REG_SZ);
            lResult = RegQueryValueEx(hKey, (LPCTSTR)strHCollarXXX, NULL, &dwType, (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)), &dwCount);
            strValue.ReleaseBuffer();
         }

         if (strValue.Find(",") > -1)
         {
            int   nScreen  =  atoi(strValue.Left(strValue.Find(",")));
            strValue       =  strValue.Mid(strValue.Find(",") + 1);
            m_mapSecondaryPages[nScreen]  =  _FSI_STL::string((LPCTSTR)strValue);
         }

         lHorizontalCollarStep++;
      }


      long int lAliasCount =  0;
      long int lAliasStep  =  1;
      ulData   =  0;
      dwSize   =  sizeof (unsigned long int);
      RegQueryValueEx(hKey, _T("AliasCount"), NULL, NULL, (BYTE*)&ulData, &dwSize);
      lAliasCount =  ulData;

      CString  strAliasXXX;
      CString  strAliasPath;
      CString  strAliasName;
      m_mapDirectories.clear();

      for (; lAliasStep <= lAliasCount; lAliasStep++)
      {
         strValue =  "";
         strAliasXXX.Format("Alias%d", lAliasStep);

         // Get the name of the alias.
         lResult  =  RegQueryValueEx(hKey, (LPCTSTR)strAliasXXX, NULL, &dwType, NULL, &dwCount);
         if (lResult == ERROR_SUCCESS)
         {
            ASSERT(dwType == REG_SZ);
            lResult  =  RegQueryValueEx(hKey, (LPCTSTR)strAliasXXX, NULL, &dwType, (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)), &dwCount);
            strValue.ReleaseBuffer();
         }
         strAliasName   =  strValue;

         // Get the path for the alias
         if (strAliasName  != "")
         {
            strValue = "";

            // Code copied from GetProfileString() in CWinApp implementation.
	         lResult  =  RegQueryValueEx(hKey, (LPCTSTR)strAliasName, NULL, &dwType, NULL, &dwCount);
            if (lResult == ERROR_SUCCESS)
            {
               ASSERT(dwType == REG_SZ);
               lResult  =  RegQueryValueEx(hKey, (LPCTSTR)strAliasName, NULL, &dwType, (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)), &dwCount);
               strValue.ReleaseBuffer();
            }
            strAliasPath   =  strValue;

            m_mapDirectories[(LPCTSTR)strAliasName]   =  _FSI_STL::string((LPCTSTR)strAliasPath);
         }
      }

      RegCloseKey(hKey);
   }
}

void CComponentInterface::LoadComponentConfig()
{
    InitializeComponentConfig();
}

void CComponentInterface::InitComplete()
{
}

_FSI_STL::string CComponentInterface::ComponentSpecificPage(const unsigned char ucWindowNumber)
{
   return m_mapComponentSpecificPages[ucWindowNumber];
}

_FSI_STL::string CComponentInterface::SecondaryComponentSpecificPage(const unsigned char ucWindowNumber)
{
    return m_mapSecondaryPages[ucWindowNumber];
}

void CComponentInterface::AddAvailableWidget(const _FSI_STL::string stlStrWidget)
{
    m_listAvailableWidgets.push_back(stlStrWidget);
}

void CComponentInterface::AfterInitComplete()
{
}
