// ComponentConfigPage.cpp : implementation file
//

#include "stdafx.h"
#include "ComponentConfigPage.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CComponentConfigPage property page

CComponentConfigPage::CComponentConfigPage() : CBasePage(CComponentConfigPage::IDD)
{
	//{{AFX_DATA_INIT(CComponentConfigPage)
	m_strComponentSpecificPageFile = _T("");
	m_strMainPageFile = _T("");
	m_bOnComponentBar = FALSE;
	m_bOnEditBar = FALSE;
	m_strHorizontalCollar = _T("");
	m_strScreenHCollar = _T("");
	m_strScreenMainPage = _T("");
	//}}AFX_DATA_INIT
    m_stlStrPageName = _FSI_STL::string("Component Config");
}

void CComponentConfigPage::DoDataExchange(CDataExchange* pDX)
{
	CBasePage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CComponentConfigPage)
	DDX_Control(pDX, IDC_LIST_MAINPAGE, m_MainPageListCtrl);
	DDX_Control(pDX, IDC_LIST_HCOLLAR, m_HCollarListCtrl);
	DDX_Text(pDX, IDC_COMPONENTPAGEFILE, m_strComponentSpecificPageFile);
	DDX_Text(pDX, IDC_MAINPAGEFILE, m_strMainPageFile);
	DDX_Check(pDX, IDC_ONCOMPONENTBAR, m_bOnComponentBar);
	DDX_Check(pDX, IDC_ONEDITBAR, m_bOnEditBar);
	DDX_Text(pDX, IDC_HORIZONTAL_COMPONENTPAGEFILE, m_strHorizontalCollar);
	DDX_Text(pDX, IDC_SCREEN_HCOLLAR, m_strScreenHCollar);
	DDX_Text(pDX, IDC_SCREEN_PAGE, m_strScreenMainPage);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CComponentConfigPage, CBasePage)
	//{{AFX_MSG_MAP(CComponentConfigPage)
	ON_BN_CLICKED(IDC_ADD_HCOLLAR_BUTTON, OnAddHCollar)
	ON_BN_CLICKED(IDC_CHANGE_HCOLLAR_BUTTON, OnChangeHCollar)
	ON_BN_CLICKED(IDC_DELETE_HCOLLAR_BUTTON, OnDeleteHCollar)
	ON_NOTIFY(NM_CLICK, IDC_LIST_HCOLLAR, OnClickListHcollar)
	ON_BN_CLICKED(IDC_ADD_MAINPAGE_BUTTON, OnAddMainpageButton)
	ON_BN_CLICKED(IDC_CHANGE_MAINPAGE_BUTTON, OnChangeMainpageButton)
	ON_BN_CLICKED(IDC_DELETE_MAINPAGE_BUTTON, OnDeleteMainpageButton)
	ON_NOTIFY(NM_CLICK, IDC_LIST_MAINPAGE, OnClickListMainpage)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CComponentConfigPage message handlers
CBasePage* CComponentConfigPage::CreateObject()
{
    return new CComponentConfigPage;
}

void CComponentConfigPage::SetProperties(void* pWidget)
{
   CString strComponentName = CString((char *)pWidget);
   HKEY hKey;
   RegOpenKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\FlightSafety\\FSISuite\\") + strComponentName, 0, KEY_READ, &hKey);

   if (hKey != NULL)
   {
      unsigned long int ulData = 0;
      DWORD dwSize = sizeof (unsigned long int);
      RegQueryValueEx(hKey, _T("OnEditBar"), NULL, NULL, (BYTE*)&ulData, &dwSize);
      if (ulData == 0)
         m_bOnEditBar = false;
      else
         m_bOnEditBar = true;

      ulData = 0;
      RegQueryValueEx(hKey, _T("OnComponentBar"), NULL, NULL, (BYTE*)&ulData, &dwSize);
      if (ulData == 0)
         m_bOnComponentBar = false;
      else
         m_bOnComponentBar = true;


      CString  strValue;
      DWORD    dwType,  dwCount;
      LONG     lResult;

      strValue =  "";
		lResult  =  RegQueryValueEx(hKey, _T("ComponentSpecificPageFile"), NULL, &dwType, NULL, &dwCount);
		if (lResult == ERROR_SUCCESS)
		{
			ASSERT(dwType == REG_SZ);
         lResult = RegQueryValueEx(hKey, _T("ComponentSpecificPageFile"), NULL, &dwType, (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)), &dwCount);
			strValue.ReleaseBuffer();
		}
      m_strComponentSpecificPageFile = strValue;

      strValue = "";
      long int lHorizontalCollarCount  =  0;
      long int lHorizontalCollarStep   =  1;
      ulData   =  0;
      dwSize   =  sizeof (unsigned long int);
      RegQueryValueEx(hKey, _T("HorizontalCollarCount"), NULL, NULL, (BYTE*)&ulData, &dwSize);
      lHorizontalCollarCount  =  ulData;

      CString  strHCollarXXX;
      m_mapScreenToHorizontalCollar.clear();

      while (lHorizontalCollarStep  <= lHorizontalCollarCount)
      {
         strHCollarXXX.Format("HorizontalCollar%d",   lHorizontalCollarStep);

         DWORD dwType, dwCount;
         LONG  lResult  =  RegQueryValueEx(hKey, (LPCTSTR)strHCollarXXX, NULL, &dwType, NULL, &dwCount);

         if (lResult == ERROR_SUCCESS)
         {
            ASSERT(dwType == REG_SZ);
            lResult = RegQueryValueEx(hKey, (LPCTSTR)strHCollarXXX, NULL, &dwType, (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)), &dwCount);
            strValue.ReleaseBuffer();
         }

         if (strValue.Find(",") > -1)
         {
            int nScreen = atoi(strValue.Left(strValue.Find(",")));
            strValue = strValue.Mid(strValue.Find(",") + 1);
            m_mapScreenToHorizontalCollar[nScreen] = _FSI_STL::string((LPCTSTR)strValue);
         }
         lHorizontalCollarStep++;
      }

      long int lMainPageCount = 0;
      long int lMainPageStep  = 1;
      ulData   = 0;
      dwSize   = sizeof (unsigned long int);
      RegQueryValueEx(hKey, _T("MainPageCount"), NULL, NULL, (BYTE*)&ulData, &dwSize);
      lMainPageCount =  ulData;

      CString  strMainPageXXX;
      m_mapScreenToMainPage.clear();

      while (lMainPageStep <= lMainPageCount)
      {
         strMainPageXXX.Format("MainPage%d", lMainPageStep);

         DWORD dwType,  dwCount;
         LONG  lResult  =  RegQueryValueEx(hKey, (LPCTSTR)strMainPageXXX, NULL, &dwType, NULL, &dwCount);

         if (lResult == ERROR_SUCCESS)
         {
            ASSERT(dwType  == REG_SZ);
            lResult  =  RegQueryValueEx(hKey, (LPCTSTR)strMainPageXXX, NULL, &dwType, (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)), &dwCount);
            strValue.ReleaseBuffer();
         }

         if (strValue.Find(",")  >  -1)
         {
            int   nScreen  =  atoi(strValue.Left(strValue.Find(",")));
            strValue       =  strValue.Mid(strValue.Find(",") + 1);
            m_mapScreenToMainPage[nScreen]   =  _FSI_STL::string((LPCTSTR)strValue);
         }
         lMainPageStep++;
      }

      RegCloseKey(hKey);
   }
}

void CComponentConfigPage::UpdateProperties(void* pWidget)
{
   if (GetSafeHwnd() == NULL)
   {
      return;
   }

   CString strComponentName = CString((char *)pWidget);
   HKEY hKey;
   DWORD dw;
   RegCreateKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\FlightSafety\\FSISuite\\") + strComponentName, 0, NULL, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey, &dw);

   if (hKey != NULL)
   {
      UpdateData(TRUE);
      unsigned long int ulData = 0;
      DWORD dwSize = sizeof (unsigned long int);
      if (m_bOnEditBar == false)
         ulData = 0;
      else
         ulData = 1;

      RegSetValueEx(hKey, _T("OnEditBar"), NULL, REG_DWORD, (BYTE*)&ulData, dwSize);

      
      if (m_bOnComponentBar == false)
         ulData = 0;
      else
         ulData = 1;

      RegSetValueEx(hKey, _T("OnComponentBar"), NULL, REG_DWORD, (BYTE*)&ulData, dwSize);


      RegSetValueEx(hKey, _T("ComponentSpecificPageFile"), NULL, REG_SZ, (BYTE*)(LPCTSTR)m_strComponentSpecificPageFile, m_strComponentSpecificPageFile.GetLength() + 1);


      long int lHCollarCount  =  m_HCollarListCtrl.GetItemCount();
      long int lHCollarStep   =  0;
      ulData   =  lHCollarCount;
      dwSize   =  sizeof (unsigned long int);
      RegSetValueEx(hKey, _T("HorizontalCollarCount"), NULL, REG_DWORD, (BYTE*)&ulData, dwSize);

      CString  strHCollarXXX;
      CString  strHCollarName;
      while (lHCollarStep  <  lHCollarCount)
      {
         strHCollarXXX.Format("HorizontalCollar%d",   lHCollarStep   +  1);
         strHCollarName =  m_HCollarListCtrl.GetItemText(lHCollarStep,  0) +  ","   +  m_HCollarListCtrl.GetItemText(lHCollarStep,  1);
         RegSetValueEx(hKey,  (LPCTSTR)strHCollarXXX, NULL, REG_SZ,  (BYTE*)(LPCTSTR)strHCollarName,  strHCollarName.GetLength() +  1);
         lHCollarStep++;
      }


      long int lMainPageCount =  m_MainPageListCtrl.GetItemCount();
      long int lMainPageStep  =  0;
      ulData   =  lMainPageCount;
      dwSize   =  sizeof (unsigned long int);
      RegSetValueEx(hKey,  _T("MainPageCount"), NULL, REG_DWORD,  (BYTE*)&ulData,   dwSize);

      CString  strMainPageXXX;
      CString  strMainPageName;
      while (lMainPageStep <  lMainPageCount)
      {
         strMainPageXXX.Format("MainPage%d", lMainPageStep  +  1);
         strMainPageName   =  m_MainPageListCtrl.GetItemText(lMainPageStep,   0) +  ","   +  m_MainPageListCtrl.GetItemText(lMainPageStep,   1);
         RegSetValueEx(hKey,  (LPCTSTR)strMainPageXXX,   NULL, REG_SZ,  (BYTE*)(LPCTSTR)strMainPageName, strMainPageName.GetLength()   +  1);
         lMainPageStep++;
      }

      RegCloseKey(hKey);
   }
}


void CComponentConfigPage::OnAddHCollar() 
{
    UpdateData(TRUE);
    
    if (m_strScreenHCollar.GetLength() > 0)
    {
        LVFINDINFO lvfi;
        lvfi.flags = LVFI_STRING;
        lvfi.psz = (LPCTSTR)m_strScreenHCollar;
        if (m_HCollarListCtrl.FindItem(&lvfi,-1) == -1)
        {
            long int lItemCount = m_HCollarListCtrl.GetItemCount();
            lItemCount = m_HCollarListCtrl.InsertItem(lItemCount, 
													(LPCTSTR)m_strScreenHCollar);

            m_HCollarListCtrl.SetItemText(lItemCount, 1, m_strHorizontalCollar);
        }
        else
        {
            ::MessageBox(GetSafeHwnd(), _T("Screen already has a horizontal collar."), _T("Error"), MB_OK);
        }
    }
    else
    {
        ::MessageBox(GetSafeHwnd(), _T("Null string encountered for screen number."), _T("Error"), MB_OK);
    }
}

void CComponentConfigPage::OnChangeHCollar() 
{
   UpdateData(TRUE);

   if (m_strScreenHCollar.GetLength() > 0)
   {
      LVFINDINFO lvfi;
      lvfi.flags = LVFI_STRING;
      lvfi.psz = (LPCTSTR)m_strScreenHCollar;
      long int lScreenIndex = m_HCollarListCtrl.FindItem(&lvfi,-1);
      if (lScreenIndex  >  -1)
      {
         m_HCollarListCtrl.SetItemText(lScreenIndex, 1, m_strHorizontalCollar);
      }
      else
      {
         ::MessageBox(GetSafeHwnd(), _T("Screen could not be found to change horizontal collar data."), _T("Error"), MB_OK);
         return;
      }
   }
   else
   {
      ::MessageBox(GetSafeHwnd(), _T("Null string encountered for screen number."), _T("Error"), MB_OK);
   }
}

void CComponentConfigPage::OnDeleteHCollar() 
{
   UpdateData(TRUE);

   if (m_strScreenHCollar.GetLength() > 0)
   {
      LVFINDINFO lvfi;
      lvfi.flags = LVFI_STRING;
      lvfi.psz = (LPCTSTR)m_strScreenHCollar;
      long int lScreenIndex = m_HCollarListCtrl.FindItem(&lvfi,-1);
      if (lScreenIndex  >  -1)
      {
         m_HCollarListCtrl.DeleteItem(lScreenIndex);
      }
      else
      {
         ::MessageBox(GetSafeHwnd(), _T("Screen could not be found to delete horizontal collar data."), _T("Error"), MB_OK);
         return;
      }
   }
   else
   {
      ::MessageBox(GetSafeHwnd(), _T("Null string encountered for screen number."), _T("Error"), MB_OK);
   }
}

BOOL CComponentConfigPage::OnInitDialog() 
{
	CBasePage::OnInitDialog();

   m_HCollarListCtrl.SetExtendedStyle(m_HCollarListCtrl.GetExtendedStyle() & LVS_EX_FULLROWSELECT);
   m_HCollarListCtrl.InsertColumn(0,  "Screen",   LVCFMT_LEFT,   48);
   m_HCollarListCtrl.InsertColumn(1,  "Collar",   LVCFMT_LEFT,   200);

   m_HCollarListCtrl.DeleteAllItems();
   _FSI_STL::map<int, _FSI_STL::string>::iterator mIt = m_mapScreenToHorizontalCollar.begin();
   long int lItemCount;
   CString strValue;
   while (mIt != m_mapScreenToHorizontalCollar.end())
   {
      strValue.Format("%d", (*mIt).first);

      lItemCount = m_HCollarListCtrl.GetItemCount();
      lItemCount = m_HCollarListCtrl.InsertItem(lItemCount, (LPCTSTR)strValue);

      m_HCollarListCtrl.SetItemText(lItemCount, 1, (*mIt).second.c_str());

      mIt++;
   }


   m_MainPageListCtrl.SetExtendedStyle(m_MainPageListCtrl.GetExtendedStyle() & LVS_EX_FULLROWSELECT);

   m_MainPageListCtrl.InsertColumn(0,  "Screen",   LVCFMT_LEFT,   48);
   m_MainPageListCtrl.InsertColumn(1,  "Page",     LVCFMT_LEFT,   200);

   m_MainPageListCtrl.DeleteAllItems();
   mIt   =  m_mapScreenToMainPage.begin();
   while (mIt != m_mapScreenToMainPage.end())
   {
      strValue.Format("%d", (*mIt).first);

      lItemCount = m_MainPageListCtrl.GetItemCount();
      lItemCount = m_MainPageListCtrl.InsertItem(lItemCount, (LPCTSTR)strValue);

      m_MainPageListCtrl.SetItemText(lItemCount, 1, (*mIt).second.c_str());

      mIt++;
   }

   return   TRUE;
}

void CComponentConfigPage::OnClickListHcollar(NMHDR* pNMHDR, LRESULT* pResult) 
{
	UpdateData(TRUE);
   POSITION pos = m_HCollarListCtrl.GetFirstSelectedItemPosition();
   if (pos != NULL)
   {
      long int lSelectedIndex =  m_HCollarListCtrl.GetNextSelectedItem(pos);
      m_strScreenHCollar      =  m_HCollarListCtrl.GetItemText(lSelectedIndex, 0);
      m_strHorizontalCollar   =  m_HCollarListCtrl.GetItemText(lSelectedIndex, 1);
      UpdateData(FALSE);
   }

	*pResult = 0;
}


void CComponentConfigPage::OnAddMainpageButton() 
{
   UpdateData(TRUE);

   if (m_strScreenMainPage.GetLength() > 0)
   {
      LVFINDINFO lvfi;
      lvfi.flags = LVFI_STRING;
      lvfi.psz = (LPCTSTR)m_strScreenMainPage;
      if (m_MainPageListCtrl.FindItem(&lvfi,-1) == -1)
      {
         long int lItemCount = m_MainPageListCtrl.GetItemCount();
         lItemCount = m_MainPageListCtrl.InsertItem(lItemCount, (LPCTSTR)m_strScreenMainPage);
         m_MainPageListCtrl.SetItemText(lItemCount, 1, m_strMainPageFile);
      }
      else
      {
         ::MessageBox(GetSafeHwnd(), _T("Screen already has a main page."), _T("Error"), MB_OK);
      }
   }
   else
   {
      ::MessageBox(GetSafeHwnd(), _T("Null string encountered for screen number."), _T("Error"), MB_OK);
   }
}

void CComponentConfigPage::OnChangeMainpageButton() 
{
   UpdateData(TRUE);

   if (m_strScreenMainPage.GetLength() > 0)
   {
      LVFINDINFO  lvfi;
      lvfi.flags  =  LVFI_STRING;
      lvfi.psz    =  (LPCTSTR)m_strScreenMainPage;
      long  int   lScreenIndex   =  m_MainPageListCtrl.FindItem(&lvfi,  -1);
      if (lScreenIndex  >  -1)
      {
         m_MainPageListCtrl.SetItemText(lScreenIndex, 1, m_strMainPageFile);
      }
      else
      {
         ::MessageBox(GetSafeHwnd(), _T("Screen could not be found to change main page data."), _T("Error"), MB_OK);
         return;
      }
   }
   else
   {
      ::MessageBox(GetSafeHwnd(), _T("Null string encountered for screen number."), _T("Error"), MB_OK);
   }
}

void CComponentConfigPage::OnDeleteMainpageButton() 
{
   UpdateData(TRUE);

   if (m_strScreenMainPage.GetLength()   >  0)
   {
      LVFINDINFO  lvfi;
      lvfi.flags  =  LVFI_STRING;
      lvfi.psz    =  (LPCTSTR)m_strScreenMainPage;
      long  int   lScreenIndex   =  m_MainPageListCtrl.FindItem(&lvfi,  -1);
      if (lScreenIndex  >  -1)
      {
         m_MainPageListCtrl.DeleteItem(lScreenIndex);
      }
      else
      {
         ::MessageBox(GetSafeHwnd(), _T("Screen could not be found to delete main page data."), _T("Error"), MB_OK);
         return;
      }
   }
   else
   {
      ::MessageBox(GetSafeHwnd(), _T("Null string encountered for screen number."), _T("Error"), MB_OK);
   }
}

void CComponentConfigPage::OnClickListMainpage(NMHDR* pNMHDR, LRESULT* pResult) 
{
   UpdateData(TRUE);
   POSITION pos = m_MainPageListCtrl.GetFirstSelectedItemPosition();
   if (pos != NULL)
   {
      long int lSelectedIndex =  m_MainPageListCtrl.GetNextSelectedItem(pos);
      m_strScreenMainPage     =  m_MainPageListCtrl.GetItemText(lSelectedIndex, 0);
      m_strMainPageFile       =  m_MainPageListCtrl.GetItemText(lSelectedIndex, 1);
      UpdateData(FALSE);
   }
   
   *pResult = 0;
}
