/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : ColorPage.h
//
// Date             : 11 November 1998
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.3 $
//
// Description      : ColorPage.h contains the definition of both 
//                    the CColorStatic and CColorPage classes.  
//                    Normally, two classes would not occupy the same 
//                    files.  However, the CColorStatic class is 
//                    special and should only be used with the 
//                    CColorPage class.  To use the CColorStatic class 
//                    with another class, the OnClicked method would 
//                    most likely need to be changed.
//                    
//                    The CColorStatic class is derived from CStatic 
//                    and is used to show a color and changes 
//                    custom/new color in the CColorPage class.
//                    
//                    The CColorPage class is derived from CBasePage is 
//                    serves as the color property page for any widget 
//                    that needs to change a color of some aspect of 
//                    the widget.  
//
// Classification   : UNCLASSIFIED
//
// Requirements     : CBasePage is required for CColorPage.  Both 
//                    CBasePage and CStatic, the base of CColorStatic, 
//                    are either a part of MFC or rely on MFC.  
//                    Likewise, CColorStatic and CColorPage make use of 
//                    the CColor class.
//
// Components Used  : _FSI_STL::string, _FSI_STL::map, Core::CColor,
//                    Core::CBasePage, 
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        CColorStatic::OnClicked relies on CColorPage.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3
//                                          Microsoft Windows NT 5.0
//
//                    Compiler(s) - Visual C++ 5.0 with VisC++ service pack 3
//                                  Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: ColorPage.h $
// Revision 1.3  2000/03/07 07:20:45  billyb
// Removed unused methods.
// Revision 1.2  1999/09/07 19:17:17  billyb
// Added comments. Added struct for keeping track of each
// attributes color information while editing a widget. Removed
// specific variables for front and back color information and
// added a data structure to keep track of that information for
// all attributes
/////////////////////////////////////////////////////////////////////////////
#if !defined(_COLORPAGE_H_)
#define _COLORPAGE_H_

#ifdef CORE
#define DLLAPI __declspec( dllexport )
#else
#define DLLAPI __declspec( dllimport )
#endif

#include <string>
#include <map>
#include "resource.h"
#include "Color.h"
#include "BasePage.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

static const unsigned char NUMBUTTONS = 48;

static UINT m_unIDs[NUMBUTTONS] = { IDC_COLOR_BOX_1, IDC_COLOR_BOX_2,
                             IDC_COLOR_BOX_3, IDC_COLOR_BOX_4,
                             IDC_COLOR_BOX_5, IDC_COLOR_BOX_6,
                             IDC_COLOR_BOX_7, IDC_COLOR_BOX_8,
                             IDC_COLOR_BOX_9, IDC_COLOR_BOX_10,
                             IDC_COLOR_BOX_11, IDC_COLOR_BOX_12,
                             IDC_COLOR_BOX_13, IDC_COLOR_BOX_14,
                             IDC_COLOR_BOX_15, IDC_COLOR_BOX_16,
                             IDC_COLOR_BOX_17, IDC_COLOR_BOX_18,
                             IDC_COLOR_BOX_19, IDC_COLOR_BOX_20,
                             IDC_COLOR_BOX_21, IDC_COLOR_BOX_22,
                             IDC_COLOR_BOX_23, IDC_COLOR_BOX_24,
                             IDC_COLOR_BOX_25, IDC_COLOR_BOX_26,
                             IDC_COLOR_BOX_27, IDC_COLOR_BOX_28,
                             IDC_COLOR_BOX_29, IDC_COLOR_BOX_30,
                             IDC_COLOR_BOX_31, IDC_COLOR_BOX_32,
                             IDC_COLOR_BOX_33, IDC_COLOR_BOX_34,
                             IDC_COLOR_BOX_35, IDC_COLOR_BOX_36,
                             IDC_COLOR_BOX_37, IDC_COLOR_BOX_38,
                             IDC_COLOR_BOX_39, IDC_COLOR_BOX_40,
                             IDC_COLOR_BOX_41, IDC_COLOR_BOX_42,
                             IDC_COLOR_BOX_43, IDC_COLOR_BOX_44,
                             IDC_COLOR_BOX_45, IDC_COLOR_BOX_46,
                             IDC_COLOR_BOX_47, IDC_COLOR_BOX_48 };

static COLORREF m_clrefColors[NUMBUTTONS] = { RGB(255,128,128), RGB(255,255,128),
                                       RGB(128,255,128), RGB(0,255,128),
                                       RGB(128,255,255), RGB(0,128,255),
                                       RGB(255,128,192), RGB(255,128,255),
                                       RGB(255,0,0),     RGB(255,255,0),
                                       RGB(128,255,0),   RGB(0,255,64),
                                       RGB(0,255,255),   RGB(0,128,192),
                                       RGB(128,128,192), RGB(255,0,255),
                                       RGB(128,64,64),   RGB(255,128,64),
                                       RGB(0,255,0),     RGB(0,128,128),
                                       RGB(0,64,128),    RGB(128,128,255),
                                       RGB(128,0,64),    RGB(255,0,128),
                                       RGB(128,0,0),     RGB(255,128,0),
                                       RGB(0,128,0),     RGB(0,128,64),
                                       RGB(0,0,255),     RGB(0,0,160),
                                       RGB(128,0,128),   RGB(128,0,255),
                                       RGB(64,0,0),      RGB(128,64,0),
                                       RGB(0,64,0),      RGB(0,64,64),
                                       RGB(0,0,128),     RGB(0,0,64),
                                       RGB(64,0,64),     RGB(64,0,128),
                                       RGB(0,0,0),       RGB(128,128,0),
                                       RGB(128,128,64),  RGB(128,128,128),
                                       RGB(64,128,128),  RGB(192,192,192),
                                       RGB(64,0,64),     RGB(255,255,255) };

// For each attribute in the list of color selectable attributes
// for a widget, the name of the global color and a CColor are
// needed.
struct ColorSelectableAttribute
{
    _FSI_STL::string        s_stlStrGlobal;
    CColor                  s_colorGlobal;
    CColor                  s_colorCustom;
    CColor                  s_colorCurrent;
};

/////////////////////////////////////////////////////////////////////////////
// CColorPage dialog

class DLLAPI CColorStatic : public CStatic
{
private:
    CColor      m_color;
    CBrush      m_brush;

public:
    CColorStatic();
    virtual ~CColorStatic();

    //Accessor
    CColor Color();
    
    // Mutator
    void Color(const CColor& rColor);

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CColorStatic)
	afx_msg void OnClicked();
	afx_msg HBRUSH CtlColor(CDC* pDC, UINT nCtlColor);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};

class CColorPage : public CBasePage
{
private:
    CColorStatic        m_ctrlColorBoxes[NUMBUTTONS];
    CColorStatic        m_ctrlColorCurrent;
    CColorStatic        m_ctrlColorCustom;

    CString             m_strFocusFace;
    _FSI_STL::map<_FSI_STL::string, ColorSelectableAttribute> m_mapColorAttributes;

// Construction
public:
	CColorPage();
    static CBasePage* CreateObject();

    // Mutators
    void CurrentColor(const CColor& rColor);
    void CustomColor(const CColor& rColor);

// Dialog Data
	//{{AFX_DATA(CColorPage)
	enum { IDD = IDD_CORE_PAGE_COLOR };
	CComboBox	m_comboGlobals;
	CComboBox	m_ctrlFaceCombo;
	CScrollBar	m_ctrlRedBar;
	CScrollBar	m_ctrlGreenBar;
	CScrollBar	m_ctrlBlueBar;
	CString	m_strRedValue;
	CString	m_strGreenValue;
	CString	m_strBlueValue;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CColorPage)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CColorPage)
	virtual BOOL OnInitDialog();
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnSelchangeColorFace();
	afx_msg void OnSelchangeGlobalColors();
	afx_msg void OnSetfocusColorFaceCombo();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

    virtual void SetProperties(void* pWidget);
    virtual void UpdateProperties(void* pWidget);

};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(_COLORPAGE_H_)
