/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// Copyright 1998 FlightSafety International
//
// The information contained herein is the property of FLIGHTSAFETY
// INTERNATIONAL Simulation Systems Division and shall not be copied, in
// part or in whole, or disclosed to others in any manner without the
// express written authorization of the FLIGHTSAFETY INTERNATIONAL
// Simulation Systems Division.
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : Color.h
//
// Date             : 29 August 1998
//
// Author           : Billy Baker
//
// Description      : CColor is a simple class that represents any 
//                    color values for an object in the .  The 
//                    private data members m_ucRed, m_ucGreen, and 
//                    m_ucBlue are accessible/mutable using Red(), 
//                    Green(), Blue(), Red(const unsigned char ucRed), 
//                    Green(const unsigned char ucGreen), and 
//                    Blue(const unsigned char ucBlue).
//                    
//                    Four constructors are avaiable--one to set 
//                    everything to black (default) or to the passed in 
//                    components.  The second to parse a CString for 
//                    rgb components.  This second constructor should 
//                    be passed and should parse a string in the color 
//                    format specified in the DTD.  The third is a 
//                    conversion of a Microsoft COLORREF to a CColor.  
//                    And finally, the fourth is a copy constructor.
//                    
//                    An assignment operator is provided as is a conversion
//                    method to allow a CColor to be used where a COLORREF 
//                    is expected.  Two friend I/O operators are also 
//                    provided for sending a CColor to a CArchive and 
//                    for reading a CColor from a CArchive.  The input 
//                    operator will most likely never be used since an XML 
//                    parse will be used to read in a file.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : None.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        Since the COLORREF structure and the CArchive class
//                        are used, a Win32 platform is expected.
//                    Design dependencies/restrictions
//                        The constructor accepting a CString is dependent on
//                        the format of a color specified in the DTD.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        A Standard C++ compiler is required.
//                    Other condtions for proper execution
//                        None.
//
// Envrionment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service packs 3 or 4
//                                          Microsoft Windows NT 5.0
//
//                    Compiler(s) - Visual C++ 5.0
//                                  Visual C++ 5.0 with VisC++ service pack 3
//                                  Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              Revision History
//
/////////////////////////////////////////////////////////////////////////////
//
// Date             : 29 August 1998
//
// Author           : Billy Baker
//
// Description      : This revision was made to update the structure of the 
//                    class to match the C++ coding document.  Changes 
//                    included reordering some of the body of the class, 
//                    changing the Visual C++ #if !defined() line to fit 
//                    into 80 columns, name changes, and the use of namespace
//                    and explicit.
//
/////////////////////////////////////////////////////////////////////////////
//
// Date             : 29 August 1998
//
// Author           : Billy Baker
//
// Description      : The addition of the namespace FSISuite caused 
//                    problems with the friend functions/methods.  
//                    Further research showed that the implementation
//                    of the friend functions/methods needed to be
//                    surrounded by the same namespace 'string' {}
//                    syntax as the class containing the prototypes.
//
/////////////////////////////////////////////////////////////////////////////
//
// Date             : 31 August 1998
//
// Author           : Billy Baker
//
// Description      : Deleted the explicit keyword from the copy 
//                    constructor.  Changed the copy constructor to use 
//                    the assingment operator for copying data.
//
/////////////////////////////////////////////////////////////////////////////
//
// Date             : 31 August 1998
//
// Author           : Billy Baker
//
// Description      : Moved #ifndef outside of namespace block so that 
//                    STL headers could be #included after the #ifndef 
//                    but before the namespace block.
//
/////////////////////////////////////////////////////////////////////////////
#ifndef _COLOR_H_
#define _COLOR_H_

#ifdef CORE
#define DLLAPI __declspec( dllexport )
#else
#define DLLAPI __declspec( dllimport )
#endif

#include <string>
#include <map>

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

static const unsigned char HLSMAX = 240; /* H,L, and S vary over 0-HLSMAX */
static const unsigned char RGBMAX = 255; /* R,G, and B vary over 0-RGBMAX */
                                         /* HLSMAX BEST IF DIVISIBLE BY 6 */
                                         /* RGBMAX, HLSMAX must each fit  */
                                         /* in a byte. */

/* Hue is undefined if Saturation is 0 (grey-scale) */
/* This value determines where the Hue scrollbar is */
/* initially set for achromatic colors */
static const unsigned char UNDEFINED = (HLSMAX*2/3);

class DLLAPI CColor
{

    private:
	    unsigned char	m_ucRed;		// red component of an rgb tuple
	    unsigned char	m_ucGreen;		// green component of an rgb tuple
	    unsigned char	m_ucBlue;		// blue component of an rgb tuple

        static _FSI_STL::map<_FSI_STL::string, _FSI_STL::string> m_mapGlobalColors;

    public:
	    // CArchive I/O
        friend CArchive& operator<<(CArchive& rArchive, 
                                    const CColor& rColor);
        friend CArchive& operator>>(CArchive& rArchive, CColor& rColor);

	    // Constructors
	    CColor(const unsigned char ucRed=0, const unsigned char ucGreen=0, 
	 	               const unsigned char ucBlue=0);
	    explicit CColor(const CString& rStrColor);
	    explicit CColor(const COLORREF& rColorRef);

        // Equals overload
        bool operator==(const CColor& rColor);

	    // Conversion to COLORREF
	    operator COLORREF();

        void RGBtoHLS(unsigned char& rucH, unsigned char& rucL,
                      unsigned char& rucS);
        WORD HueToRGB(WORD n1, WORD n2, WORD hue);
        CColor HLStoRGB(WORD hue, WORD lum, WORD sat);
        CColor DarkColor();
        CColor HighlightColor();
        static CColor GlobalColor(const CString& rstrGlobalColor);

        static void ResetColors();

	    // Accessors
	    unsigned char Red();
	    unsigned char Green();
	    unsigned char Blue();

	    // Mutators
	    void Red(const unsigned char ucRed);
	    void Green(const unsigned char ucGreen);
	    void Blue(const unsigned char ucBlue);
    };

#endif // ifndef _COLOR_H_
