/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : ChangeValue.h
//
// Date             : 26 August 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.3 $
//
// Description      : ChangeValue.h contains the defintion of the 
//                    CChangeValue class.  A pointer to a CChangeValue 
//                    instance is passed to a instance of a CWidget 
//                    derived class via the ChangeValue method.  This 
//                    class contains information about a variable that 
//                    the instance of the CWidget derived class is 
//                    interested using for display.  Among the 
//                    information is the actual new value in a 
//                    CVariant, range data from evalutating any ranges 
//                    associated with the variable in question, and 
//                    formatting information.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : 
//
// Components Used  : Core::CVariant, _FSI_STL::string, Core::CColor.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3, 4, or 5
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: ChangeValue.h $                                                                   //
// Revision 1.3  2000/03/07 15:45:50  billyb                                                                   //
// Removed unused methods.                                                                   //
// Revision 1.2  1999/08/30 20:18:26  billyb                                                                   //
// Added comments.                                                                   //
/////////////////////////////////////////////////////////////////////////////
#if !defined(_CHANGEVALUE_H_)
#define _CHANGEVALUE_H_

#ifdef CORE
#define DLLAPI __declspec( dllexport )
#else
#define DLLAPI __declspec( dllimport )
#endif

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <string>

#include "Variant.h"
#include "Color.h"

class DLLAPI CChangeValue  
{
protected:
    // Pointer to a variant that was created in the COMMS DLL
    CVariant*               m_pVariant;

    // background color from range data
    CColor                  m_colorBackground;

    // foreground color from range data
    CColor                  m_colorForeground;

    // text value from range data
    _FSI_STL::string        m_stlStrText;

    // whether to use use the range data
    bool                    m_bUseRange;

    // whether the range data came from a true conditional or
    // from a false conditional
    bool                    m_bTrueOrFalseValue;

public:
	CChangeValue();

    // Accessors
    CVariant*           Variant();
    CColor              Background();
    CColor              Foreground();
    _FSI_STL::string    Text();
    bool                UseRange();
    bool                TrueOrFalseValue();

    // Mutators
    void        Variant(const CVariant* pVariant);
    void        Background(const CColor& rColor);
    void        Foreground(const CColor& rColor);
    void        Text(const _FSI_STL::string& rstlStrText);
    void        UseRange(const bool bUseRange);
    void        TrueOrFalseValue(const bool bTrueOrFalseValue);
};

#endif // !defined(_CHANGEVALUE_H_)
