/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : ChangeValue.cpp
//
// Date             : 26 August 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.3 $
//
// Description      : ChangeValue.cpp contains the implementation of the 
//                    CChangeValue class.  A pointer to a CChangeValue 
//                    instance is passed to a instance of a CWidget 
//                    derived class via the ChangeValue method.  This 
//                    class contains information about a variable that 
//                    the instance of the CWidget derived class is 
//                    interested using for display.  Among the 
//                    information is the actual new value in a 
//                    CVariant, range data from evalutating any ranges 
//                    associated with the variable in question, and 
//                    formatting information.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : 
//
// Components Used  : Core::CVariant, _FSI_STL::string, Core::CColor.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3, 4, or 5
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: ChangeValue.cpp $                                                                   //
// Revision 1.3  2000/03/07 15:46:01  billyb                                                                   //
// Removed unused methods.                                                                   //
// Revision 1.2  1999/08/30 20:18:07  billyb                                                                   //
// Added comments.  Removed duplicated code.                                                                   //
/////////////////////////////////////////////////////////////////////////////
#include "stdafx.h"
#include "ChangeValue.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CChangeValue::CChangeValue() :
    m_pVariant(NULL),
    m_stlStrText(""),
    m_bUseRange(false),
    m_bTrueOrFalseValue(true)
{
}

//////////////////////////////////////////////////////////////////////
// Accessors
//////////////////////////////////////////////////////////////////////

CVariant* CChangeValue::Variant()
{
    return m_pVariant;
}

CColor CChangeValue::Background()
{
    return m_colorBackground;
}

CColor CChangeValue::Foreground()
{
    return m_colorForeground;
}

_FSI_STL::string CChangeValue::Text()
{
    return m_stlStrText;
}

bool CChangeValue::UseRange()
{
    return m_bUseRange;
}

bool CChangeValue::TrueOrFalseValue()
{
    return m_bTrueOrFalseValue;
}

//////////////////////////////////////////////////////////////////////
// Mutators
//////////////////////////////////////////////////////////////////////

void CChangeValue::Variant(const CVariant* pVariant)
{
    m_pVariant = (CVariant*)pVariant;
}

void CChangeValue::Background(const CColor& rColor)
{
    m_colorBackground = rColor;
}

void CChangeValue::Foreground(const CColor& rColor)
{
    m_colorForeground = rColor;
}

void CChangeValue::Text(const _FSI_STL::string& rstlStrText)
{
    m_stlStrText = rstlStrText;
}

void CChangeValue::UseRange(const bool bUseRange)
{
    m_bUseRange = bUseRange;
}

void CChangeValue::TrueOrFalseValue(const bool bTrueOrFalseValue)
{
    m_bTrueOrFalseValue = bTrueOrFalseValue;
}