/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : BasePage.h
//
// Date             : 19 October 1998
//
// Engineer         : Billy Baker
//
// Revision         :
//
// Description      : BasePage.h contains the definition of the 
//                    CBasePage class.  CBasePage is the base class 
//                    from which all other option page and Widget property 
//                    pages classes should derive.  CBasePage derives from 
//                    CPropertyPage.  The normal method for using a 
//                    CBaseProp derived class is to instaniate the class.  
//                    Next, Create() should be called passing a pointer to the 
//                    CWnd that will be the parent of the CBaseProp derived 
//                    class.  Since each derived class will have a different 
//                    dialog ID, a protected member is provided to act as a 
//                    common interface for getting the dialog ID.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : None.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3
//                                          Microsoft Windows NT 5.0
//
//                    Compiler(s) - Visual C++ 5.0 with VisC++ service pack 3
//                                  Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
#ifndef _BASEPAGE_H_
#define _BASEPAGE_H_

#ifdef CORE
#define DLLAPI __declspec( dllexport )
#else
#define DLLAPI __declspec( dllimport )
#endif

#include "STLTypes.h"

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

class DLLAPI CBasePage : public CPropertyPage
{
    DECLARE_DYNAMIC(CBasePage)
private:

protected:
    unsigned int                m_unDialogID;
    void*                       m_pWidget;

    _FSI_STL::string            m_stlStrPageName;
    _FSI_STL::list<void*>       m_listComponentInterface;

    // Constructors
    explicit CBasePage(UINT unIDTemplate = 0);

public:
    // CArchive I/O
//        friend CArchive& operator<<(CArchive& rArchive, 
//            const CBaseProp& rBaseProp) = 0;
//        friend CArchive& operator>>(CArchive& rArchive, CBaseProp& rBaseProp) = 0;


    // Destructor
    virtual ~CBasePage();

    // Accessors
    _FSI_STL::string PageName();
    void* Widget();

    // Mutators
    void ComponentInterfaces(_FSI_STL::list<void*>& rlistCI);
    void Widget(const void* pWidget);

    virtual void SetProperties(void* pWidget);
    virtual void UpdateProperties(void* pWidget);

};

#endif // ifndef _BASEPAGE_H_

