/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : BasePage.cpp
//
// Date             : 19 October 1998
//
// Engineer         : Billy Baker
//
// Revision         :
//
// Description      : 
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : None.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3
//                                          Microsoft Windows NT 5.0
//
//                    Compiler(s) - Visual C++ 5.0 with VisC++ service pack 3
//                                  Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
#include "stdafx.h"

#include "BasePage.h"

IMPLEMENT_DYNAMIC(CBasePage, CPropertyPage)

/////////////////////////////////////////////////////////////////////////////
//
// CBasePage::CBasePage()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 19 October 1998
//
// Engineer         : Billy Baker
//
// Description      : Default constructor.  Initializes the rectangular 
//                    boundary to the upper left pixel, sets the 
//                    pointer to a map of options to NULL, and sets the 
//                    dialog ID to 0.
//
/////////////////////////////////////////////////////////////////////////////
CBasePage::CBasePage(UINT unIDTemplate) : CPropertyPage(unIDTemplate)
{
    m_unDialogID = unIDTemplate;
    m_pWidget     = NULL;
}

/////////////////////////////////////////////////////////////////////////////
//
// CBasePage::~CBasePage()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 19 October 1998
//
// Engineer         : Billy Baker
//
// Description      : Default destructor.
//
/////////////////////////////////////////////////////////////////////////////
CBasePage::~CBasePage()
{
    m_listComponentInterface.clear();
}

_FSI_STL::string CBasePage::PageName()
{
    return m_stlStrPageName;
}

void CBasePage::SetProperties(void* pWidget)
{
}

void CBasePage::UpdateProperties(void* pWidget)
{
}

void CBasePage::ComponentInterfaces(_FSI_STL::list<void*>& rlistCI)
{
    _FSI_STL::list<void*>::iterator lIt = rlistCI.begin();
    for (; lIt != rlistCI.end(); lIt++)
    {
        m_listComponentInterface.push_back(*lIt);
    }
}
//////////////////////////////////////////////////////////////////////
// Accessors
//////////////////////////////////////////////////////////////////////

void* CBasePage::Widget()
{
    return m_pWidget;
}

//////////////////////////////////////////////////////////////////////
// Mutators
//////////////////////////////////////////////////////////////////////

void CBasePage::Widget(const void* pWidget)
{
    m_pWidget = (void*)pWidget;
}
