// Action.h: interface for the CAction class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(_ACTION_H_)
#define _ACTION_H_

#ifdef CORE
#define DLLAPI __declspec( dllexport )
#else
#define DLLAPI __declspec( dllimport )
#endif

#include "STLTypes.h"
#include "Variant.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "ChangeValue.h"

enum LButtonUpReturn
{
    LBU_OK,
    LBU_NOT_IN_RANGE,
    LBU_CAN_NOT_WRITE,
    LBU_NO_COMMS
};

class DLLAPI CAction  
{
protected:
    CChangeValue    m_ChangeValue;
    void*           m_pWidget;  // A real action will descend from
                                // both CAction and CWidget.  But,
                                // a CAction pointer will have to
                                // be converted to a CWidget using
                                // this void pointer.

public:
    explicit CAction();

    // Accessors
    void* Widget();

    // Mutators

	virtual void OnLoad();
	virtual void OnUnload();
	virtual void OnUpdate();
	virtual enum LButtonUpReturn OnLButtonUp();
};

#endif // !defined(_ACTION_H__B34F8230_9041_11D2_92F1_00600814A909_)
