/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : ZCTCommsSystemInterface.h
//
// Date             : 10 February 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.2 $
//
// Description      : ZCTCommsSystemInterface.h contains the 
//                    definition of the CZCTCommsSystemInterface.  
//                    This class is derived from CCommsSystemInterface 
//                    and is used to communicate with simulators using 
//                    the ZCT comms protocol.  To do this, all of the 
//                    code from the ZCT IOS was incorporated into the 
//                    COMMS DLL.  Some of the code had to be changed to 
//                    account for different enums for variable type and 
//                    to access a new data structur for symbol lookup.  
//                    Also, the local reading and writing was commented 
//                    out.  Unlike the ZCT IOS where each page will 
//                    delete all of the variables and then add in the 
//                    variables for that page, all of the symbols are 
//                    passed every time.  
//                    
//                    In implementing this class, I found that a large 
//                    amount of data is sent to initialize the host 
//                    comms structures for which variables may be read 
//                    or written to.  After that, 12 bytes are sent to 
//                    simulation.  This is processed on the simulation 
//                    side and two 8 byte values are received followed 
//                    by all of the read data.  Also, unlike the ZCT 
//                    IOS where the same value can be sent more than 
//                    once from host to IOS, each value is only sent 
//                    once per step.
//                    
//                    At present (10 Feb 1999), writing and arrays are 
//                    not implemented and this protocol should only be 
//                    used for testing.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : CIosComms, CIosCommsObject, CIosCommsSocket, 
//                    CCommsSystemInterface, map, string, 
//                    CVariabledata, CFile, iterator, CCriticalSection.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3
//                                          Microsoft Windows NT 5.0
//
//                    Compiler(s) - Visual C++ 5.0 with VisC++ service pack 3
//                                  Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: ZCTCommsSystemInterface.h $
// Revision 1.2  2000/03/06 16:03:56  billyb
// Changed two function signatures to eliminate warnings.
// Revision 1.1  1999/08/24 18:25:04  billyb
// Initial Revision
// Revision 1.3  1999/04/02 19:41:33  billyb
// Revision 1.2  1999/04/02 19:41:33  billyb
// Revision 1.1  1999/04/02 19:41:32  billyb
// Revision 1.2  1999/04/02 04:31:03  billyb
// Testing the use of the Revision and Log keywords.
#if !defined(_ZCTCOMMSSYSTEMINTERFACE_H_)
#define _ZCTCOMMSSYSTEMINTERFACE_H_

#include <string>
#include "ioscomms.h"
#include "ioscommsobject.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "FSISuiteCommsSystemInterface.h"

class CZCTCommsSystemInterface  : public CFSISuiteCommsSystemInterface
{
protected:
    void    Cleanup();
    static UINT                   ThreadFunc(LPVOID lParam);

public:
	CZCTCommsSystemInterface();
	virtual ~CZCTCommsSystemInterface();

    virtual void LoadVariables(const _FSI_STL::string& rstlStrVariablesFile);

    static CCommsSystemInterface* CreateComms();

    static void ReadData();

    virtual void WriteData(CVariant* pVariant, CVariableData* pVarData);
    virtual void Start();
    virtual void Stop();

    static CIosComms* commsComms;
    static _FSI_STL::map<_FSI_STL::string, CIosCommsObject*>    m_mapVarName2CommsObject;
};

#endif // !defined(_ZCTCOMMSSYSTEMINTERFACE_H_)
