/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : ZCTCommsSystemInterface.cpp
//
// Date             : 10 February 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.3 $
//
// Description      : ZCTCommsSystemInterface.cpp contains the 
//                    implementation of the CZCTCommsSystemInterface.  
//                    This class is derived from CCommsSystemInterface 
//                    and is used to communicate with simulators using 
//                    the ZCT comms protocol.  To do this, all of the 
//                    code from the ZCT IOS was incorporated into the 
//                    COMMS DLL.  Some of the code had to be changed to 
//                    account for different enums for variable type and 
//                    to access a new data structur for symbol lookup.  
//                    Also, the local reading and writing was commented 
//                    out.  Unlike the ZCT IOS where each page will 
//                    delete all of the variables and then add in the 
//                    variables for that page, all of the symbols are 
//                    passed every time.  
//                    
//                    In implementing this class, I found that a large 
//                    amount of data is sent to initialize the host 
//                    comms structures for which variables may be read 
//                    or written to.  After that, 12 bytes are sent to 
//                    simulation.  This is processed on the simulation 
//                    side and two 8 byte values are received followed 
//                    by all of the read data.  Also, unlike the ZCT 
//                    IOS where the same value can be sent more than 
//                    once from host to IOS, each value is only sent 
//                    once per step.
//                    
//                    At present (10 Feb 1999), writing and arrays are 
//                    not implemented and this protocol should only be 
//                    used for testing.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : CIosComms, CIosCommsObject, CIosCommsSocket, 
//                    CCommsSystemInterface, map, string, 
//                    CVariabledata, CFile, iterator, CCriticalSection.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3
//                                          Microsoft Windows NT 5.0
//
//                    Compiler(s) - Visual C++ 5.0 with VisC++ service pack 3
//                                  Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: ZCTCommsSystemInterface.cpp $
// Revision 1.3  2000/03/06 16:04:27  billyb
// Changed two function signatures to eliminate warnings.
// Revision 1.2  2000/01/27 07:55:34  billyb
// Added comments about array support not being implemented.
// Revision 1.1  1999/08/24 18:25:03  billyb
// Initial Revision
// Revision 1.1  1999/04/02 19:41:32  billyb
// Revision 1.2  1999/04/02 04:31:00  billyb
// Testing the use of the Revision and Log keywords.
#include "..\core\stdafx.h"
#include "ZCTCommsSystemInterface.h"
#include "CommsAction.h"
#include "..\core\VariableData.h"
#include "ioshostcomms.h"

#include <mmsystem.h>

#include <winsock2.h>

CIosComms* CZCTCommsSystemInterface::commsComms = NULL;
_FSI_STL::map<_FSI_STL::string, CIosCommsObject*> 
                            CZCTCommsSystemInterface::m_mapVarName2CommsObject;

/////////////////////////////////////////////////////////////////////////////
//
// CZCTCommsSystemInterface::CZCTCommsSystemInterface()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 09 February 1999
//
// Engineer         : Billy Baker
//
// Description      : Default constructor.  Creates a ZCT CIosComms object used
//                    to communicate with the ZCT IOS Host Comms.
//
/////////////////////////////////////////////////////////////////////////////
CZCTCommsSystemInterface::CZCTCommsSystemInterface() : 
                                            CFSISuiteCommsSystemInterface()
{
}

/////////////////////////////////////////////////////////////////////////////
//
// CZCTCommsSystemInterface::~CZCTCommsSystemInterface()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 09 February 1999
//
// Engineer         : Billy Baker
//
// Description      : Default destructor.  Deletes a ZCT CIosComms object used
//                    to communicate with the ZCT IOS Host Comms.
//
/////////////////////////////////////////////////////////////////////////////
CZCTCommsSystemInterface::~CZCTCommsSystemInterface()
{
}

/////////////////////////////////////////////////////////////////////////////
//
// CCommsSystemInterface* CZCTCommsSystemInterface::CreateComms()
//
// Inputs           : None.
//
// Return Values    : address of a new instance of 
//                    CFISSuiteCommsSystemInterface.
//
// Date             : 09 February 1999
//
// Engineer         : Billy Baker
//
// Description      : CreateComms() creates a new instance of
//                    CZCTCommsSystemInterface.  Each CCommsSystemInterface
//                    derived class must implement CreateComms so that the
//                    comms protocol can be dynamically changed during 
//                    operation.  A name, like ZCT, is associated with
//                    a pointer to this method.  By storing pointers to 
//                    CreateComms methods, a large switch statement is not
//                    needed.
//
/////////////////////////////////////////////////////////////////////////////
CCommsSystemInterface* CZCTCommsSystemInterface::CreateComms()
{
    return new CZCTCommsSystemInterface;
}

/////////////////////////////////////////////////////////////////////////////
//
// void CZCTCommsSystemInterface::LoadVariables()
//                    
//
// Inputs           : string& rstlStrVariablesFile - the name of the file
//                                                   to read.
//
// Return Values    : None.
//
// Date             : 10 February 1999
//
// Engineer         : Billy Baker
//
// Description      : LoadVariables() is a abstract virtual method 
//                    defined in CCommsSystemInterface.  Its purpose is 
//                    to read a data file(s) to obtain information 
//                    about the variables on the simulation side.  For 
//                    the ZCT comms system interface, a binary symbol
//                    data file is read.  This code is modified from the
//                    ZCT IOS.  Since symbol data is used, 
//                    CSymbolVarialbeData is used because of its added
//                    address member.  Other data that 
//                    might be used include variable ID, variable type, 
//                    simulation variable name, alias name, and range 
//                    information.  A CIosCommsObject is also created for
//                    each variable in the symbol table.  Because of this,
//                    commsComms must be initialized.  Note: the VarName
//                    stored in the CVariableData is the same as the
//                    VarName used in the maps (VarName2Data) because no
//                    fml file is used to create aliases for the actual
//                    symbol names.
//
/////////////////////////////////////////////////////////////////////////////
void CZCTCommsSystemInterface::LoadVariables(const _FSI_STL::string& rstlStrVariablesFile)
{
    if (commsComms != NULL)
    {
        delete commsComms;
    }

    commsComms = new CIosComms;
    commsComms->m_strMachineName = CString(m_stlStrMachineName.c_str());
    commsComms->m_ulPort = m_ulPort;

    CFSISuiteCommsSystemInterface::LoadVariables(rstlStrVariablesFile);
    m_ulDebriefBufferSize = 0;
    CVariant variant;

    FILE*   fpFile;
    if (m_stlStrSecondaryFile != _FSI_STL::string(""))
    {
		if (GetFileAttributes(m_stlStrSecondaryFile.c_str()) != 0xFFFFFFFF)
		{
			if((fpFile = fopen(m_stlStrSecondaryFile.c_str(), "rb")) == NULL)
			{
				// Error, cannot open file.
				// Convert the the timestamp into a displayable date and time.
				//
				struct tm* sTime;
				time_t now;
				time(&now);
				sTime=localtime(&now);
				CString strDateTime;
				strDateTime.Format("%02d/%02d %02d:%02d:%02d",
									sTime->tm_mon+1, sTime->tm_mday, sTime->tm_hour,
									sTime->tm_min, sTime->tm_sec);
//				pApp->m_listLog.AddTail(new CIosLogData(CString(strDateTime + 
//																"\tSymbol File Not Found:\t \t" + 
//																CString(m_stlStrSecondaryFile.c_str())),
//														IDB_ERROR));

                Cleanup();
				return;
			}
		}
		else
		{
				// Error, cannot open file.
				// Convert the the timestamp into a displayable date and time.
				//
				struct tm* sTime;
				time_t now;
				time(&now);
				sTime=localtime(&now);
				CString strDateTime;
				strDateTime.Format("%02d/%02d %02d:%02d:%02d",
									sTime->tm_mon+1, sTime->tm_mday, sTime->tm_hour,
									sTime->tm_min, sTime->tm_sec);
//				pApp->m_listLog.AddTail(new CIosLogData(CString(strDateTime + 
//																"\tSymbol File Not Found:\t \t" + 
//																CString(m_stlStrSecondaryFile.c_str())),
//														IDB_ERROR));

                Cleanup();
				return;
		}
	}
	else
	{
		// Error, no path name.
		// Convert the the timestamp into a displayable date and time.
		//
		struct tm* sTime;
		time_t now;
		time(&now);
		sTime=localtime(&now);
		CString strDateTime;
		strDateTime.Format("%02d/%02d %02d:%02d:%02d",
							sTime->tm_mon+1, sTime->tm_mday, sTime->tm_hour,
							sTime->tm_min, sTime->tm_sec);
//		pApp->m_listLog.AddTail(new CIosLogData(CString(strDateTime + 
//														"\tNo Symbol File Name:"),
//												IDB_ERROR));

        Cleanup();
		return;
	}

	if(fseek(fpFile, 0, SEEK_END))
	{
		// Error, cannot seek end of file.
		// Convert the the timestamp into a displayable date and time.
		//
		struct tm* sTime;
		time_t now;
		time(&now);
		sTime=localtime(&now);
		CString strDateTime;
		strDateTime.Format("%02d/%02d %02d:%02d:%02d",
							sTime->tm_mon+1, sTime->tm_mday, sTime->tm_hour,
							sTime->tm_min, sTime->tm_sec);
//		pApp->m_listLog.AddTail(new CIosLogData(CString(strDateTime + 
//														"\tCould Not Seek to End of Symbol File:\t \t" + 
//														CString(m_stlStrSecondaryFile.c_str())),
//												IDB_ERROR));

		fclose(fpFile);
        Cleanup();
		return;
	}

	unsigned int nFileSize;
	if((nFileSize = ftell(fpFile)) == -1)
	{
		// Error, cannot obtain file position.
		// Convert the the timestamp into a displayable date and time.
		//
		struct tm* sTime;
		time_t now;
		time(&now);
		sTime=localtime(&now);
		CString strDateTime;
		strDateTime.Format("%02d/%02d %02d:%02d:%02d",
							sTime->tm_mon+1, sTime->tm_mday, sTime->tm_hour,
							sTime->tm_min, sTime->tm_sec);
//		pApp->m_listLog.AddTail(new CIosLogData(CString(strDateTime + 
//														"\tCould Not Obtain Symbol File Position:\t \t" + 
//														CString(m_stlStrSecondaryFile.c_str())),
//												IDB_ERROR));

		fclose(fpFile);
        Cleanup();
		return;
	}

	if(fseek(fpFile, 0, SEEK_SET))
	{
		// Error, cannot seek beginning of file.
		// Convert the the timestamp into a displayable date and time.
		//
		struct tm* sTime;
		time_t now;
		time(&now);
		sTime=localtime(&now);
		CString strDateTime;
		strDateTime.Format("%02d/%02d %02d:%02d:%02d",
							sTime->tm_mon+1, sTime->tm_mday, sTime->tm_hour,
							sTime->tm_min, sTime->tm_sec);
//		pApp->m_listLog.AddTail(new CIosLogData(CString(strDateTime + 
//														"\tCould Not Seek to Beginning of Symbol File:\t \t" + 
//														CString(m_stlStrSecondaryFile.c_str())),
//												IDB_ERROR));

		fclose(fpFile);
        Cleanup();
		return;
	}

	ios_symbols_hdr * ios_symbols;
	if((ios_symbols = (ios_symbols_hdr *)malloc(nFileSize)) == NULL)
	{
		// Error, cannot allocate enough memory to load file.
		// Convert the the timestamp into a displayable date and time.
		//
		struct tm* sTime;
		time_t now;
		time(&now);
		sTime=localtime(&now);
		CString strDateTime;
		strDateTime.Format("%02d/%02d %02d:%02d:%02d",
							sTime->tm_mon+1, sTime->tm_mday, sTime->tm_hour,
							sTime->tm_min, sTime->tm_sec);
//		pApp->m_listLog.AddTail(new CIosLogData(CString(strDateTime + 
//														"\tCould Not Allocate Enough Memory for Symbols:\t \t" + 
//														CString(m_stlStrSecondaryFile.c_str())),
//												IDB_ERROR));

		fclose(fpFile);
        Cleanup();
		return;
	}

	if((fread((char *)ios_symbols, nFileSize, 1, fpFile)) != 1)
	{
		// Error, cannot read file.
		// Convert the the timestamp into a displayable date and time.
		//
		struct tm* sTime;
		time_t now;
		time(&now);
		sTime=localtime(&now);
		CString strDateTime;
		strDateTime.Format("%02d/%02d %02d:%02d:%02d",
							sTime->tm_mon+1, sTime->tm_mday, sTime->tm_hour,
							sTime->tm_min, sTime->tm_sec);
//		pApp->m_listLog.AddTail(new CIosLogData(CString(strDateTime + 
//														"\tCould Not Read Symbol File:\t \t" + 
//														CString(m_stlStrSecondaryFile.c_str())),
//												IDB_ERROR));

		free(ios_symbols);
		fclose(fpFile);
        Cleanup();
		return;
	}

	fclose(fpFile);

	// Validate the symbol count.

	int	nSymbolCount = ntohl(ios_symbols->nCount);

	// Read the symbols.

	ios_symbol_entry *	pSymbolEntries = (ios_symbol_entry *)((char *)ios_symbols + sizeof(ios_symbols_hdr));
	char *				pSymbolNames = (char *)((char *)pSymbolEntries + (nSymbolCount * sizeof(ios_symbol_entry)));
	unsigned int		pSymbolNamesSize = nFileSize - (sizeof(ios_symbols_hdr) + (nSymbolCount * sizeof(ios_symbol_entry)));
    char chName[MAX_SYMBOL_NAME_LENGTH];
    long int lSymbolCount = 0;

	for(lSymbolCount = 0; lSymbolCount < nSymbolCount; lSymbolCount++)
	{
        CVariableData* pVarData = new CVariableData;

        if (pVarData != NULL)
        {
            pVarData->ID(lSymbolCount);

		    // Set the iosRt symbol name.
		    unsigned int nNameOffset = ntohl(pSymbolEntries[lSymbolCount].nNameOffset);

            chName[0] = '\0';
		    if(nNameOffset < (unsigned int)pSymbolNamesSize)
            {
			    strncpy(chName, pSymbolNames + nNameOffset, sizeof(chName));
            }
            pVarData->SimVarName(_FSI_STL::string(chName));

		    // Convert the FSI symbol type to CVariant type.
            pVarData->Type(ntohl(pSymbolEntries[lSymbolCount].nType) & 15L);
		    switch(pVarData->Type())
		    {
			    case IOS_INTEGER:
			    {
				    pVarData->Type(VAR_LONG_INT);
			    }
			    break;

			    case IOS_FLOAT:
			    {
				    pVarData->Type(VAR_FLOAT);
			    }
			    break;

			    case IOS_DOUBLE:
			    {
				    pVarData->Type(VAR_DOUBLE);
			    }
			    break;

			    case IOS_LOGICAL:
			    {
				    pVarData->Type(VAR_BOOL);
			    }
			    break;

			    case IOS_SHORT:
			    {
				    pVarData->Type(VAR_SHORT_INT);
			    }
			    break;

			    case IOS_USHORT:
			    {
				    pVarData->Type(VAR_UNSIGNED_SHORT_INT);
			    }
			    break;

			    case IOS_CHAR:
			    {
				    pVarData->Type(VAR_CHAR);
			    }
			    break;

			    default:
			    {
				    pVarData->Type(VAR_LONG_INT);
			    }
			    break;
		    }

		    // Set the iosRt symbol offset.
            pVarData->Address(ntohl(pSymbolEntries[lSymbolCount].nValue));
            pVarData->AddressValid(true);

		    // Add the new symbol to the symbol list.
            if (m_mapVarName2Data.find(pVarData->SimVarName()) != m_mapVarName2Data.end())
            {
                CVariableData* pOldData = (*(m_mapVarName2Data.find(pVarData->SimVarName()))).second;
                pVarData->Debrief(pOldData->Debrief());
                pVarData->ListSize(pOldData->ListSize());
                pVarData->Persist(pOldData->Persist());
                pVarData->ReadMode(pOldData->ReadMode());
                delete pOldData;

                // If the parent load variables call added a debrief
                // variable, then replace it with the new pVarData.
                if (m_mapVarName2Debrief.find(pVarData->SimVarName()) !=
                                                    m_mapVarName2Debrief.end())
                {
                    m_mapVarName2Debrief[pVarData->SimVarName()] = pVarData;
                    m_ulDebriefBufferSize += variant.Size(pVarData->Type());

                }

                m_mapVarName2Data[pVarData->SimVarName()] = pVarData;

                CIosCommsObject* pCommsObject = new CIosCommsObject;
                pCommsObject->Initialize(pVarData->SimVarName().c_str(), COMMS_READ_WRITE );

                m_mapVarName2CommsObject[pVarData->SimVarName()] = pCommsObject;
            }
            else
            {
                delete pVarData;
            }
        }
	}

    Cleanup();

    if (m_mapVarName2Debrief.size() > 0)
    {
        delete m_pcDebriefData;
        m_fileDebrief.Close();

        m_pcDebriefData = new char[m_ulDebriefBufferSize];
        memset(m_pcDebriefData, 0, m_ulDebriefBufferSize);
        m_fileDebrief.Open("debrief.dat", CFile::modeCreate | 
                                          CFile::modeWrite | 
                                          CFile::typeBinary);
    }
	// Free the symbols memory.

	free(ios_symbols);

}


UINT CZCTCommsSystemInterface::ThreadFunc(LPVOID lParam)
{
    DWORD dwData = 0;
    DWORD dwBytesRead;
    DWORD dwBytesLeft;
    DWORD dwBytesLeftMsg;

    unsigned long int ulRate = (unsigned long int)lParam;

    while (1)
    {
        PeekNamedPipe(m_hPipeRead, &dwData, sizeof(dwData), &dwBytesRead, &dwBytesLeft, &dwBytesLeftMsg);

        if (dwData == 1)
        {
            CloseHandle(m_hPipeRead);
            break;
        }

        ReadData();
        Sleep(1000 / ulRate);
    }

    return 0;
}

/////////////////////////////////////////////////////////////////////////////
//
// void CZCTCommsSystemInterface::ReadData()
//
// Inputs           : HWND hWnd - timer callback specific
//                    UINT uiMsg - timer callback specific
//                    UINT idEvent - timer callback specific
//                    DWORD dwTime - timer callback specific
//
// Return Values    : None.
//
// Date             : 09 February 1999
//
// Engineer         : Billy Baker
//
// Description      : ReadData() is a generic name used for a timer callback
//                    function.  Each comms system interface derived class
//                    should have a method used for passing data from 
//                    simulation on to the CVariants.  Then UpdateComms should
//                    be called to get the CCommsActions to update the
//                    graphical elements.  Be sure to use the CCriticalSection
//                    m_sync with Lock and Unlock to prevent a page change from
//                    deleting memory that needs to be written to. For ZCT, a
//                    call is made to CIosComms::Update() which will update all
//                    of the CIosCommsObjects.  Then, the values in the
//                    CIosCommsObjects are placed in CVariants.  Finally,
//                    UpdateComms() is called.
//
/////////////////////////////////////////////////////////////////////////////
void CZCTCommsSystemInterface::ReadData()
{
    // Read all of the data.
    m_sync.Lock();

    // Add any comms actions that have been marked for Adding.
    if (m_listCommsActionsToAdd.size() > 0)
    {
        m_syncCommsAdd.Lock();

        _FSI_STL::list<CCommsAction*>::iterator lIt = 
                                            m_listCommsActionsToAdd.begin();
        for (; lIt != m_listCommsActionsToAdd.end(); lIt++)
        {
            AddComms((CIOAction*)(*lIt));
        }

        m_listCommsActionsToAdd.clear();

        m_syncCommsAdd.Unlock();
    }

    // Remove any comms actions that have been marked for deleting.
    if (m_listCommsActionsToDelete.size() > 0)
    {
        m_syncCommsDelete.Lock();

        _FSI_STL::list<CCommsAction*>::iterator lIt = 
                                            m_listCommsActionsToDelete.begin();
        for (; lIt != m_listCommsActionsToDelete.end(); lIt++)
        {
            DeleteComms((CIOAction*)(*lIt));
        }

        m_listCommsActionsToDelete.clear();

        m_syncCommsDelete.Unlock();
    }

    commsComms->Update();

    char* pPos = m_pcDebriefData;
    CVariableData* pVarData = NULL;
    CVariant variant;

    _FSI_STL::map<_FSI_STL::string, CVariant*>::iterator mvIt = NULL;
    _FSI_STL::map<_FSI_STL::string, CVariableData*>::iterator mIt = NULL;

    // Step through only the CVariants and give the value
    // from simulation to the CVariant.
    mvIt = m_mapVarName2Variant.begin();
    for (; mvIt != m_mapVarName2Variant.end(); mvIt++)
    {
        pVarData = m_mapVarName2Data[(*mvIt).first];
        // Make sure that the variant is not null.
        if ((*mvIt).second != NULL)
        {
            // Get the memory for the value.
            // May no longer work with changes to CVariant. !!!!!
            void *pValue = (*mvIt).second->CreateVar();

            // Based on the type, call the correct CIosCommsObject 
            // read method.
            if (pVarData->Type() == VAR_DOUBLE)
            {
                m_mapVarName2CommsObject[pVarData->SimVarName()]->Read((double*)pValue);
            }
            else if (pVarData->Type() == VAR_FLOAT)
            {
                m_mapVarName2CommsObject[pVarData->SimVarName()]->Read((float*)pValue);
            }
            else
            {
                m_mapVarName2CommsObject[pVarData->SimVarName()]->Read((int*)pValue);
            }

            // Set the value of the variant.
            (*mvIt).second->Value(pVarData->Type(), pValue);

            if ((*mvIt).second->List() == true)
            {
                (*mvIt).second->AddValue((*mvIt).second);
            }
        }
    }


    // If this is a pass that should record debrief data,
    // then step though the list of debrief variables and 
    // place each simulation variable into the data block to
    // be recorded.
    if (m_ucDebriefUpdatePass >= m_ucDebriefRatio && 
        m_mapVarName2Debrief.size() > 0)
    {
        mIt = m_mapVarName2Debrief.begin();
        for (; mIt != m_mapVarName2Debrief.end(); mIt++)
        {
            pVarData = (*mIt).second;

            // Get the memory for the value.
            // May no longer work with changes to CVariant. !!!!!
            void *pValue = variant.CreateVar();

            // Based on the type, call the correct CIosCommsObject 
            // read method.
            if (pVarData->Type() == VAR_DOUBLE)
            {
                m_mapVarName2CommsObject[pVarData->SimVarName()]->Read((double*)pValue);
            }
            else if (pVarData->Type() == VAR_FLOAT)
            {
                m_mapVarName2CommsObject[pVarData->SimVarName()]->Read((float*)pValue);
            }
            else
            {
                m_mapVarName2CommsObject[pVarData->SimVarName()]->Read((int*)pValue);
            }

            // Set the value of the variant.
            variant.Value(pVarData->Type(), pValue);

            // May no longer work with changes to CVariant. !!!!!
            memcpy(pPos, variant.CreateVar(), 
                   variant.Size(pVarData->Type()));
            pPos += variant.Size(pVarData->Type());
        }

        if (m_fileDebrief.m_hFile != CFile::hFileNull)
        {
            m_fileDebrief.Write(m_pcDebriefData, m_ulDebriefBufferSize);
        }

        m_ucDebriefUpdatePass = 1;
    }
    else
    {
        m_ucDebriefUpdatePass++;
    }

    UpdateComms();
    m_sync.Unlock();
}

/////////////////////////////////////////////////////////////////////////////
//
// void CZCTCommsSystemInterface::WriteData()
//
// Inputs           : CVariant* pVariant - the value to write to simulation.
//                    CVariableData* pVarData - the variable data from the
//                                              comms data file.
//
// Return Values    : None.
//
// Date             : 09 February 1999
//
// Engineer         : Billy Baker
//
// Description      : WriteData() will be called from 
//                    CCommsAction::OnLButtonUp() which is called whenever a
//                    user action is performed on a graphical element--mouse
//                    click, space bar press, enter key press, etc.
//
/////////////////////////////////////////////////////////////////////////////
void CZCTCommsSystemInterface::WriteData(CVariant* pVariant, 
                                         CVariableData* pVarData)
{
    if (pVariant == NULL || pVarData == NULL)
    {
        return;
    }


    // Get the memory for the value.
    // May no longer work with changes to CVariant. !!!!!
    void *pValue = pVariant->CreateVar();

    // Based on the type, call the correct CIosCommsObject 
    // read method.
    if (pVarData->Type() == VAR_DOUBLE)
    {
        m_mapVarName2CommsObject[pVarData->SimVarName()]->Write((double*)pValue);
    }
    else if (pVarData->Type() == VAR_FLOAT)
    {
        m_mapVarName2CommsObject[pVarData->SimVarName()]->Write((float*)pValue);
    }
    else
    {
        m_mapVarName2CommsObject[pVarData->SimVarName()]->Write((int*)pValue);
    }
}

/////////////////////////////////////////////////////////////////////////////
//
// void CZCTCommsSystemInterface::Start()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 09 February 1999
//
// Engineer         : Billy Baker
//
// Description      : Start() can be called at any time but must be 
//                    called after the loading of variables.  The call will
//                    be made when the first CCommsAction is created or prior
//                    to that when the COMMS DLL is loaded and initialized.
//                    Start() is responsible for setting up the mechanism for
//                    reading and writing.  Here, this means creating a timer
//                    which will call CIosComms::Update() when popped.
//
/////////////////////////////////////////////////////////////////////////////
void CZCTCommsSystemInterface::Start()
{
    CCommsSystemInterface::Start();

    m_pCommsThread = AfxBeginThread(ThreadFunc, 
                                    (LPVOID)m_ulRate,
                                    THREAD_PRIORITY_TIME_CRITICAL,
                                    0, CREATE_SUSPENDED);

    CreatePipe(&m_hPipeRead, &m_hPipeWrite, NULL, 0);

    if (m_pCommsThread != NULL)
    {
        m_pCommsThread->m_bAutoDelete = false;

        m_pCommsThread->ResumeThread();

        m_bStarted = true;
    }
}

/////////////////////////////////////////////////////////////////////////////
//
// void CZCTCommsSystemInterface::Stop()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 09 February 1999
//
// Engineer         : Billy Baker
//
// Description      : Stop() can be called at any time but must be 
//                    called before the current instance of a comms 
//                    system interface derived class is deleted. The base
//                    class must be called after making sure that no addtional
//                    data will be read and have to be processed.  ZCT 
//                    cleanup is also needed here which means deleting the
//                    CIosComms instance and deleting all of the 
//                    CIosCommsObjects.
//
/////////////////////////////////////////////////////////////////////////////
void CZCTCommsSystemInterface::Stop()
{
    // Stop listening/reading.
    if (m_pCommsThread != NULL)
    {

        // The comms thread will not auto delete itself because it should
        // run until the comms library is unloaded.  Thus, the comms thread
        // must be deleted.
        DWORD dwData = 1;
        DWORD dwBytesWritten;
        WriteFile(m_hPipeWrite, &dwData, sizeof(dwData), &dwBytesWritten, NULL);
        CloseHandle(m_hPipeWrite);

        WaitForSingleObject(m_pCommsThread->m_hThread, INFINITE);
        delete m_pCommsThread;
    }

    delete commsComms;
    commsComms = NULL;

    _FSI_STL::map<_FSI_STL::string, CIosCommsObject*>::iterator mIt = 
                                             m_mapVarName2CommsObject.begin();
    for (; mIt != m_mapVarName2CommsObject.end(); mIt++)
    {
        delete (*mIt).second;
    }
    m_mapVarName2CommsObject.clear();

    CCommsSystemInterface::Stop();

    m_bStarted = false;
}

void CZCTCommsSystemInterface::Cleanup()
{
    _FSI_STL::map<_FSI_STL::string, CVariableData*>::iterator mIt;
    mIt = m_mapVarName2Data.begin();
    while ( mIt != m_mapVarName2Data.end())
    {
        if ((*mIt).second->AddressValid() == false)
        {
            delete (*mIt).second;

            // Reset tht pointer to NULL.  This will allow
            // the CCommsAction deletes later.
            (*mIt).second = NULL;

            // Remove any debrief reference.
            if (m_mapVarName2Debrief.find((*mIt).first) !=
                   m_mapVarName2Debrief.end())
            {
                m_mapVarName2Debrief.erase(m_mapVarName2Debrief.find((*mIt).first));
            }

            // Remove any global variants and CCommsActions.
            if (m_mapVarName2Variant.find((*mIt).first) !=
                   m_mapVarName2Variant.end())
            {
                delete (*(m_mapVarName2Variant.find((*mIt).first))).second;
                m_mapVarName2Variant.erase(m_mapVarName2Variant.find((*mIt).first));
            }

            _FSI_STL::map<_FSI_STL::string, _FSI_STL::list<CCommsAction*> >::iterator caIt = NULL;
            caIt = m_mapVarName2Comms.find((*mIt).first);
            if (caIt != m_mapVarName2Comms.end())
            {
                _FSI_STL::list<CCommsAction*>::iterator lIt = (*caIt).second.begin();
                for (; lIt != (*caIt).second.end(); lIt++)
                {
                    (*lIt)->Deleting(true);
                }
                (*caIt).second.clear();
                m_mapVarName2Comms.erase(caIt);
            }

            // Remove any ranges.
            _FSI_STL::map<_FSI_STL::string, _FSI_STL::list<CRange*> >::iterator mrIt = NULL;
            mrIt = m_mapVarName2Ranges.find((*mIt).first);
            _FSI_STL::list<CRange*>::iterator lrIt = NULL;
            if (mrIt != m_mapVarName2Ranges.end())
            {
                lrIt = (*mrIt).second.begin();
                for (; lrIt != (*mrIt).second.end(); lrIt++)
                {
                    delete (*lrIt);
                }
                (*mrIt).second.clear();
                m_mapVarName2Ranges.erase(mrIt);
            }
        }

        mIt++;
    }

    mIt = m_mapVarName2Data.begin();
    while (mIt != m_mapVarName2Data.end())
    {
        if ((*mIt).second == NULL)
        {
            m_mapVarName2Data.erase(mIt);
            mIt = m_mapVarName2Data.begin();
        }
        else
        {
            mIt++;
        }
    }
}